/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.jna;

import com.sun.cldc.jna.Pointer;
import com.sun.squawk.Address;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.VM;
import java.util.Stack;

public class TaskExecutor {
    public static final int TASK_PRIORITY_HI = 1;
    public static final int TASK_PRIORITY_MED = 2;
    public static final int TASK_PRIORITY_LOW = 3;
    public static final int MAX_NUM_CACHABLE_TASK_EXECUTORS = 8;
    private static int cachedTECount;
    protected Address te;

    private TaskExecutor() {
        this.te = Address.zero();
    }

    public TaskExecutor(String name, int priority, int stacksize) {
        if (priority < 1 || priority > 3) {
            throw new IllegalArgumentException("priority");
        }
        if (stacksize < 0) {
            throw new IllegalArgumentException("stacksize");
        }
        Pointer name0 = Pointer.NULL();
        if (name != null) {
            name0 = Pointer.createStringBuffer(name);
        }
        this.te = NativeUnsafe.createTaskExecutor(name0.address(), priority, stacksize);
    }

    public TaskExecutor(String name) {
        this(name, 2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TaskExecutor getCachedTaskExecutor() {
        Stack cache;
        TaskExecutor te = null;
        Stack stack = cache = VM.getTaskCache();
        synchronized (stack) {
            if (!cache.isEmpty()) {
                te = (TaskExecutor)cache.pop();
            }
        }
        if (te == null) {
            te = new DefaultTaskExecutor();
        }
        te.checkTaskExecutor();
        return te;
    }

    void cleanup() {
    }

    public void cancelTaskExecutor() {
        this.checkTaskExecutor();
        NativeUnsafe.cancelTaskExecutor(this.te);
    }

    public int deleteTaskExecutor() {
        this.checkTaskExecutor();
        int result = NativeUnsafe.deleteTaskExecutor(this.te);
        if (result == 0) {
            this.te = Address.zero();
        }
        return result;
    }

    final void checkTaskExecutor() {
        if (this.te.isZero()) {
            throw new IllegalStateException("TaskExecutor has been closed");
        }
    }

    Address runBlockingFunction(Address fptr, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) {
        this.checkTaskExecutor();
        return NativeUnsafe.runBlockingFunctionOn(this.te, fptr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    public void stopTaskExecutor() {
        this.cancelTaskExecutor();
        while (this.deleteTaskExecutor() != 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static class DefaultTaskExecutor
    extends TaskExecutor {
        DefaultTaskExecutor() {
            super("cached TaskExecutor " + cachedTECount++);
        }

        Address runBlockingFunction(Address fptr, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) {
            this.checkTaskExecutor();
            return NativeUnsafe.runBlockingFunctionOn(this.te, fptr, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() {
            Stack cache = VM.getTaskCache();
            boolean kill = false;
            Stack stack = cache;
            synchronized (stack) {
                if (cache.size() > 8) {
                    kill = true;
                } else {
                    cache.push(this);
                }
            }
            if (kill) {
                this.stopTaskExecutor();
            }
        }
    }
}

