/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.util.j2me;

import com.sun.cldc.util.TimeZoneImplementation;
import java.util.TimeZone;
import java.util.Vector;

public class TimeZoneImpl
extends TimeZoneImplementation {
    public static String HOME_ID = null;
    private static final String DEFAULT_ID = "PST";
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    private static boolean need_to_init = true;
    private static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;
    private String ID;
    private boolean isCustom;
    static String[] ids = null;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private static final int millisPerDay = 86400000;
    private static final byte[] staticMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int startMode;
    private int endMode;
    private int dstSavings;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    static TimeZoneImpl[] zones = new TimeZoneImpl[]{new TimeZoneImpl(0, "GMT"), new TimeZoneImpl(0, "UTC"), new TimeZoneImpl(-36000000, "HST"), new TimeZoneImpl(-32400000, "AST", 2, 2, 1, 0x6DDD00, 10, 1, -1, 0x6DDD00, 3600000), new TimeZoneImpl(-28800000, "PST", 2, 2, 1, 0x6DDD00, 10, 1, -1, 0x6DDD00, 3600000), new TimeZoneImpl(-25200000, "MST", 2, 2, 1, 0x6DDD00, 10, 1, -1, 0x6DDD00, 3600000), new TimeZoneImpl(-21600000, "CST", 2, 2, 1, 0x6DDD00, 10, 1, -1, 0x6DDD00, 3600000), new TimeZoneImpl(-18000000, "EST", 2, 2, 1, 0x6DDD00, 10, 1, -1, 0x6DDD00, 3600000)};

    public TimeZoneImpl() {
    }

    private TimeZoneImpl(int rawOffset, String ID) {
        this.rawOffset = rawOffset;
        this.ID = ID;
        this.dstSavings = 3600000;
    }

    private TimeZoneImpl(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime, int dstSavings) {
        this.ID = ID;
        this.rawOffset = rawOffset;
        this.startMonth = startMonth;
        this.startDay = startDay;
        this.startDayOfWeek = startDayOfWeek;
        this.startTime = startTime;
        this.endMonth = endMonth;
        this.endDay = endDay;
        this.endDayOfWeek = endDayOfWeek;
        this.endTime = endTime;
        this.dstSavings = dstSavings;
        this.decodeRules();
        if (dstSavings <= 0) {
            throw new IllegalArgumentException("Illegal DST savings");
        }
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Illegal month");
        }
        return this.getOffset(era, year, month, day, dayOfWeek, millis, staticMonthLength[month]);
    }

    private int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis, int monthLength) {
        if (era != 0 && era != 1 || month < 0 || month > 11 || day < 1 || day > monthLength || dayOfWeek < 1 || dayOfWeek > 7 || millis < 0 || millis >= 86400000 || monthLength < 28 || monthLength > 31) {
            throw new IllegalArgumentException("Illegal date");
        }
        int result = this.rawOffset;
        if (!this.useDaylight || year < this.startYear || era != 1) {
            return result;
        }
        boolean southern = this.startMonth > this.endMonth;
        int startCompare = TimeZoneImpl.compareToRule(month, monthLength, day, dayOfWeek, millis, this.startMode, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int endCompare = 0;
        if (southern != startCompare >= 0) {
            millis += this.dstSavings;
            while (millis >= 86400000) {
                millis -= 86400000;
                dayOfWeek = 1 + dayOfWeek % 7;
                if (++day <= monthLength) continue;
                day = 1;
                ++month;
            }
            endCompare = TimeZoneImpl.compareToRule(month, monthLength, day, dayOfWeek, millis, this.endMode, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        }
        if (!southern && startCompare >= 0 && endCompare < 0 || southern && (startCompare >= 0 || endCompare < 0)) {
            result += this.dstSavings;
        }
        return result;
    }

    private static int compareToRule(int month, int monthLen, int dayOfMonth, int dayOfWeek, int millis, int ruleMode, int ruleMonth, int ruleDayOfWeek, int ruleDay, int ruleMillis) {
        if (month < ruleMonth) {
            return -1;
        }
        if (month > ruleMonth) {
            return 1;
        }
        int ruleDayOfMonth = 0;
        switch (ruleMode) {
            case 1: {
                ruleDayOfMonth = ruleDay;
                break;
            }
            case 2: {
                if (ruleDay > 0) {
                    ruleDayOfMonth = 1 + (ruleDay - 1) * 7 + (7 + ruleDayOfWeek - (dayOfWeek - dayOfMonth + 1)) % 7;
                    break;
                }
                ruleDayOfMonth = monthLen + (ruleDay + 1) * 7 - (7 + (dayOfWeek + monthLen - dayOfMonth) - ruleDayOfWeek) % 7;
                break;
            }
            case 3: {
                ruleDayOfMonth = ruleDay + (49 + ruleDayOfWeek - ruleDay - dayOfWeek + dayOfMonth) % 7;
                break;
            }
            case 4: {
                ruleDayOfMonth = ruleDay - (49 - ruleDayOfWeek + ruleDay + dayOfWeek - dayOfMonth) % 7;
            }
        }
        if (dayOfMonth < ruleDayOfMonth) {
            return -1;
        }
        if (dayOfMonth > ruleDayOfMonth) {
            return 1;
        }
        if (millis < ruleMillis) {
            return -1;
        }
        if (millis > ruleMillis) {
            return 1;
        }
        return 0;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public String getID() {
        if (!this.isCustom) {
            return this.ID;
        }
        StringBuffer result = new StringBuffer(9);
        int offset = this.getRawOffset();
        int minutes = offset / 60000;
        minutes = minutes < 0 ? -minutes : minutes;
        int hours = minutes / 60;
        minutes %= 60;
        result.append(GMT_ID);
        if (offset < 0) {
            result.append('-');
        } else {
            result.append('+');
        }
        TimeZoneImpl.appendTwoDigits(result, hours);
        result.append(":");
        TimeZoneImpl.appendTwoDigits(result, minutes);
        return result.toString();
    }

    private static final void appendTwoDigits(StringBuffer sb, int number) {
        if (number < 10) {
            sb.append('0');
        }
        sb.append(number);
    }

    private static TimeZoneImpl parseTimeZone(String str) {
        int i = str.indexOf(61);
        if (i < 1) {
            return null;
        }
        String name = str.substring(0, i).trim();
        if (name.length() < 1) {
            return null;
        }
        int dst = str.indexOf(44, i + 1);
        if (dst < 0) {
            int gmtOffset = TimeZoneImpl.parseGMToffset(str, i + 1, str.length());
            return gmtOffset == -1 ? null : new TimeZoneImpl(gmtOffset, name);
        }
        int gmtOffset = TimeZoneImpl.parseGMToffset(str, i + 1, dst);
        if (gmtOffset == -1) {
            return null;
        }
        int[] index = new int[]{dst + 1};
        int startMonth = TimeZoneImpl.parseInt(str, index);
        if (startMonth == -999) {
            return null;
        }
        int startDay = TimeZoneImpl.parseInt(str, index);
        if (startDay == -999) {
            return null;
        }
        int startDayOfWeek = TimeZoneImpl.parseInt(str, index);
        if (startDayOfWeek == -999) {
            return null;
        }
        i = str.indexOf(44, index[0] + 1);
        int startTime = TimeZoneImpl.parseGMToffset(str, index[0], i);
        if (startTime == -1) {
            return null;
        }
        index[0] = i + 1;
        int endMonth = TimeZoneImpl.parseInt(str, index);
        if (endMonth == -999) {
            return null;
        }
        int endDay = TimeZoneImpl.parseInt(str, index);
        if (endDay == -999) {
            return null;
        }
        int endDayOfWeek = TimeZoneImpl.parseInt(str, index);
        if (endDayOfWeek == -999) {
            return null;
        }
        i = str.indexOf(44, index[0] + 1);
        int endTime = TimeZoneImpl.parseGMToffset(str, index[0], i);
        if (endTime == -1) {
            return null;
        }
        int dstSavings = TimeZoneImpl.parseGMToffset(str, i + 1, str.length());
        if (dstSavings == -1) {
            return null;
        }
        return new TimeZoneImpl(gmtOffset, name, startMonth, startDay, startDayOfWeek, startTime, endMonth, endDay, endDayOfWeek, endTime, dstSavings);
    }

    private static int parseInt(String str, int[] index) {
        int i = index[0];
        int length = str.length();
        if (i >= length) {
            return -999;
        }
        boolean negative = false;
        char c = str.charAt(i);
        if (c == '-') {
            negative = true;
            ++i;
        } else if (c == '+') {
            ++i;
        }
        if (i >= length) {
            return -999;
        }
        if ((c = str.charAt(i++)) < '0' || c > '9') {
            return -999;
        }
        int num = c - 48;
        while (i < length && (c = str.charAt(i++)) != ',') {
            if (c < '0' || c > '9') {
                return -999;
            }
            num = num * 10 + (c - 48);
        }
        if (i >= length) {
            return -999;
        }
        index[0] = i;
        return negative ? -num : num;
    }

    private static void init() {
        need_to_init = false;
        String tzDefs = System.getProperty("com.sun.cldc.util.j2me.TimeZoneImpl.additionaltimezones");
        if (tzDefs != null) {
            Vector newZones = new Vector();
            int fromIndex = 0;
            while (fromIndex < tzDefs.length()) {
                TimeZoneImpl tz = null;
                int j = tzDefs.indexOf(59, fromIndex);
                if (j < 0) {
                    tz = TimeZoneImpl.parseTimeZone(tzDefs.substring(fromIndex));
                    fromIndex = tzDefs.length();
                } else {
                    tz = TimeZoneImpl.parseTimeZone(tzDefs.substring(fromIndex, j));
                    fromIndex = j + 1;
                }
                if (tz == null) continue;
                newZones.addElement(tz);
            }
            for (int i = 0; i < zones.length; ++i) {
                newZones.addElement(zones[i]);
            }
            zones = new TimeZoneImpl[newZones.size()];
            newZones.copyInto(zones);
        }
    }

    public synchronized TimeZone getInstance(String ID) {
        if (need_to_init) {
            TimeZoneImpl.init();
        }
        if (ID == null) {
            if (HOME_ID == null && (HOME_ID = System.getProperty("com.sun.cldc.util.j2me.TimeZoneImpl.timezone")) == null) {
                HOME_ID = DEFAULT_ID;
            }
            ID = HOME_ID;
        }
        for (int i = 0; i < zones.length; ++i) {
            TimeZoneImpl tzi = zones[i];
            if (!tzi.ID.equals(ID)) continue;
            return zones[i];
        }
        return TimeZoneImpl.parseCustomTimeZone(ID);
    }

    private static final TimeZoneImpl parseCustomTimeZone(String id) {
        if (id.length() < 5 || id.indexOf(GMT_ID) != 0) {
            return null;
        }
        char c = id.charAt(3);
        if (c != '-' && c != '+') {
            return null;
        }
        int gmtOffset = TimeZoneImpl.parseGMToffset(id, 3, id.length());
        if (gmtOffset == -1) {
            return null;
        }
        TimeZoneImpl custom = new TimeZoneImpl(gmtOffset, id);
        custom.isCustom = true;
        return custom;
    }

    private static int parseGMToffset(String offStr, int index, int end) {
        boolean negative = false;
        char c = offStr.charAt(index);
        if (c == '-') {
            negative = true;
            ++index;
        } else if (c == '+') {
            ++index;
        }
        int hours = 0;
        int num = 0;
        int countDelim = 0;
        int len = 0;
        while (index < end) {
            if ((c = offStr.charAt(index++)) == ':') {
                if (countDelim > 0) {
                    return -1;
                }
                if (len > 2) {
                    return -1;
                }
                hours = num;
                ++countDelim;
                num = 0;
                len = 0;
                continue;
            }
            if (c < '0' || c > '9') {
                return -1;
            }
            num = num * 10 + (c - 48);
            ++len;
        }
        if (index != end) {
            return -1;
        }
        if (countDelim == 0) {
            if (len <= 2) {
                hours = num;
                num = 0;
            } else {
                hours = num / 100;
                num %= 100;
            }
        } else if (len != 2) {
            return -1;
        }
        if (len > 4) {
            return -1;
        }
        if (hours > 23 || num > 59) {
            return -1;
        }
        int gmtOffset = hours * 60 + num;
        gmtOffset *= 60000;
        if (negative) {
            gmtOffset = -gmtOffset;
        }
        return gmtOffset;
    }

    public synchronized String[] getIDs() {
        if (need_to_init) {
            TimeZoneImpl.init();
        }
        if (ids == null) {
            ids = new String[zones.length];
            for (int i = 0; i < zones.length; ++i) {
                TimeZoneImpl tzi = zones[i];
                TimeZoneImpl.ids[i] = tzi.ID;
            }
        }
        return ids;
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            if (this.startMonth < 0 || this.startMonth > 11) {
                throw new IllegalArgumentException("Illegal start month " + this.startMonth);
            }
            if (this.startTime < 0 || this.startTime > 86400000) {
                throw new IllegalArgumentException("Illegal start time " + this.startTime);
            }
            if (this.startDayOfWeek == 0) {
                this.startMode = 1;
            } else {
                if (this.startDayOfWeek > 0) {
                    this.startMode = 2;
                } else {
                    this.startDayOfWeek = -this.startDayOfWeek;
                    if (this.startDay > 0) {
                        this.startMode = 3;
                    } else {
                        this.startDay = -this.startDay;
                        this.startMode = 4;
                    }
                }
                if (this.startDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal start day of week " + this.startDayOfWeek);
                }
            }
            if (this.startMode == 2) {
                if (this.startDay < -5 || this.startDay > 5) {
                    throw new IllegalArgumentException("Illegal start day of week in month " + this.startDay);
                }
            } else if (this.startDay > staticMonthLength[this.startMonth]) {
                throw new IllegalArgumentException("Illegal start day " + this.startDay);
            }
        }
    }

    private void decodeEndRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            if (this.endMonth < 0 || this.endMonth > 11) {
                throw new IllegalArgumentException("Illegal end month " + this.endMonth);
            }
            if (this.endTime < 0 || this.endTime > 86400000) {
                throw new IllegalArgumentException("Illegal end time " + this.endTime);
            }
            if (this.endDayOfWeek == 0) {
                this.endMode = 1;
            } else {
                if (this.endDayOfWeek > 0) {
                    this.endMode = 2;
                } else {
                    this.endDayOfWeek = -this.endDayOfWeek;
                    if (this.endDay > 0) {
                        this.endMode = 3;
                    } else {
                        this.endDay = -this.endDay;
                        this.endMode = 4;
                    }
                }
                if (this.endDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal end day of week " + this.endDayOfWeek);
                }
            }
            if (this.endMode == 2) {
                if (this.endDay < -5 || this.endDay > 5) {
                    throw new IllegalArgumentException("Illegal end day of week in month " + this.endDay);
                }
            } else if (this.endDay > staticMonthLength[this.endMonth]) {
                throw new IllegalArgumentException("Illegal end day " + this.endDay);
            }
        }
    }

    public boolean equals(Object object) {
        boolean retValue;
        if (!(object instanceof TimeZoneImpl)) {
            return false;
        }
        TimeZoneImpl obj = (TimeZoneImpl)object;
        boolean bl = retValue = this.getID().equals(obj.getID()) && this.rawOffset == obj.rawOffset && this.useDaylight == obj.useDaylight;
        if (this.useDaylight && retValue) {
            retValue = this.startMonth == obj.startMonth && this.startDay == obj.startDay && this.startDayOfWeek == obj.startDayOfWeek && this.startTime == obj.startTime && this.endMonth == obj.endMonth && this.endDay == obj.endDay && this.endDayOfWeek == obj.endDayOfWeek && this.endTime == obj.endTime && this.dstSavings == obj.dstSavings;
        }
        return retValue;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

