/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.NativeUnsafe;

public final class ByteBufferEncoder {
    protected int count;
    protected byte[] buffer = new byte[32];

    public void reset() {
        this.count = 0;
    }

    protected final void ensure(int needed) {
        int remain = this.buffer.length - this.count;
        if (remain < needed) {
            int newCapacity = this.count + needed + 32;
            byte[] newData = new byte[newCapacity];
            System.arraycopy(this.buffer, 0, newData, 0, this.count);
            this.buffer = newData;
        }
    }

    public final void addUnencodedByte(int value) {
        this.ensure(1);
        this.buffer[this.count++] = (byte)value;
    }

    public final void addUnsignedByte(int value) {
        this.addUnencodedByte(value);
    }

    public final void addUnsignedShort(int value) {
        this.addUnsignedInt(value);
    }

    void addUnsignedInt(int value) {
        if (value < 128) {
            this.ensure(1);
            this.buffer[this.count++] = (byte)value;
        } else if (value < 16384) {
            this.ensure(2);
            this.buffer[this.count++] = (byte)(value >> 0 & 0x7F | 0x80);
            this.buffer[this.count++] = (byte)(value >> 7);
        } else if (value < 0x200000) {
            this.ensure(3);
            this.buffer[this.count++] = (byte)(value >> 0 & 0x7F | 0x80);
            this.buffer[this.count++] = (byte)(value >> 7 & 0x7F | 0x80);
            this.buffer[this.count++] = (byte)(value >> 14);
        } else {
            this.ensure(4);
            this.buffer[this.count++] = (byte)(value >> 0 & 0x7F | 0x80);
            this.buffer[this.count++] = (byte)(value >> 7 & 0x7F | 0x80);
            this.buffer[this.count++] = (byte)(value >> 14 & 0x7F | 0x80);
            this.buffer[this.count++] = (byte)(value >> 21);
        }
    }

    private boolean equalsUtf8(String s, int pos) {
        return true;
    }

    public void addUtf8(String s) {
        int strlen;
        int max = strlen = s.length();
        int start = this.count;
        this.addUnsignedShort(strlen);
        if (max > 0) {
            this.ensure(max);
            for (int i = 0; i < strlen; ++i) {
                char c = s.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    this.buffer[this.count++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    this.ensure(max += 3);
                    this.buffer[this.count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.buffer[this.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.buffer[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                this.ensure(max += 2);
                this.buffer[this.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buffer[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
        }
    }

    public void add(ByteBufferEncoder buf) {
        int bufcount = buf.count;
        byte[] bufbuffer = buf.buffer;
        this.addUnsignedInt(bufcount);
        this.ensure(bufcount);
        for (int i = 0; i < bufcount; ++i) {
            this.addUnsignedByte(bufbuffer[i] & 0xFF);
        }
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buffer, 0, newbuf, 0, this.count);
        return newbuf;
    }

    int getSize() {
        return this.count;
    }

    void writeToVMMemory(Object oop, int offset) {
        for (int i = 0; i < this.count; ++i) {
            NativeUnsafe.setByte(oop, offset + i, this.buffer[i]);
        }
    }
}

