/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.ByteBufferEncoder;
import com.sun.squawk.DoBlock;
import com.sun.squawk.GarbageCollector;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.Lisp2GenerationalCollector;
import com.sun.squawk.Method;
import com.sun.squawk.MethodBody;
import com.sun.squawk.Monitor;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectAssociation;
import com.sun.squawk.ObjectMemory;
import com.sun.squawk.ObjectMemorySerializer;
import com.sun.squawk.Offset;
import com.sun.squawk.Suite;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import com.sun.squawk.pragma.ForceInlinedPragma;
import com.sun.squawk.pragma.GlobalStaticFields;
import com.sun.squawk.pragma.HostedPragma;
import com.sun.squawk.pragma.NotInlinedPragma;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkHashtable;
import com.sun.squawk.vm.CS;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;

public class GC
implements GlobalStaticFields {
    private static GarbageCollector collector;
    private static int fullCollectionCount;
    private static int partialCollectionCount;
    private static boolean collecting;
    private static boolean excessiveGC;
    private static int monitorExitCount;
    private static int monitorReleaseCount;
    static final boolean GC_TRACING_SUPPORTED = false;
    static final int TRACE_BASIC = 1;
    static final int TRACE_ALLOCATION = 2;
    static final int TRACE_COLLECTION = 4;
    static final int TRACE_OBJECT_GRAPH_COPYING = 8;
    static final int TRACE_HEAP_BEFORE_GC = 16;
    static final int TRACE_HEAP_AFTER_GC = 32;
    static final int TRACE_HEAP_CONTENTS = 64;
    private static int traceFlags;
    private static int traceThreshold;
    private static ObjectMemory[] readOnlyObjectMemories;
    private static Address nvmStart;
    private static Address nvmEnd;
    private static Address nvmAllocationPointer;
    private static boolean allocationEnabled;
    private static boolean gcEnabled;
    private static Address ramStart;
    private static Address ramEnd;
    private static Address heapStart;
    private static Address heapEnd;
    private static Address allocStart;
    private static Address allocTop;
    private static Address allocEnd;
    private static SquawkHashtable heapstats;
    private static final String DYNAMIC_CLASSES = "Any dynamically created class, such as array classes";

    private GC() {
    }

    public static GarbageCollector getCollector() {
        return collector;
    }

    static void setExcessiveGC(boolean value) {
        excessiveGC = value;
    }

    static boolean getExcessiveGC() {
        return excessiveGC;
    }

    public static int roundUpToWord(int value) throws ForceInlinedPragma {
        return value + 3 & 0xFFFFFFFC;
    }

    static int roundUp(int value, int alignment) {
        return value + (alignment - 1) & ~(alignment - 1);
    }

    static int roundDownToWord(int value) throws ForceInlinedPragma {
        return value & 0xFFFFFFFC;
    }

    static int roundDown(int value, int alignment) {
        return value & ~(alignment - 1);
    }

    static boolean isTracing(int option) {
        return (traceFlags & option & 1) != 0;
    }

    static void setTraceThreshold(int threshold) {
        traceThreshold = threshold;
    }

    static int getTraceThreshold() {
        return traceThreshold;
    }

    static ObjectMemory lookupReadOnlyObjectMemoryBySourceURI(String uri) {
        if (readOnlyObjectMemories != null) {
            for (int i = 0; i != readOnlyObjectMemories.length; ++i) {
                ObjectMemory om = readOnlyObjectMemories[i];
                if (!om.getURI().equals(uri)) continue;
                return om;
            }
        }
        return null;
    }

    static ObjectMemory lookupReadOnlyObjectMemoryByRoot(Object root) {
        if (readOnlyObjectMemories != null) {
            for (int i = 0; i != readOnlyObjectMemories.length; ++i) {
                ObjectMemory om = readOnlyObjectMemories[i];
                if (om.getRoot() != root) continue;
                return om;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerReadOnlyObjectMemory(ObjectMemory om) {
        ObjectMemory[] current = readOnlyObjectMemories;
        ObjectMemory[] arr = new ObjectMemory[current.length + 1];
        System.arraycopy(current, 0, arr, 0, current.length);
        arr[current.length] = om;
        readOnlyObjectMemories = arr;
        if (VM.isVeryVerbose()) {
            PrintStream out = null;
            try {
                out = new PrintStream(Connector.openOutputStream("file://squawk.reloc"));
                for (int i = 0; i != readOnlyObjectMemories.length; ++i) {
                    om = readOnlyObjectMemories[i];
                    out.println(om.getURI() + "=" + om.getStart().toUWord().toPrimitive());
                }
                System.out.println("[wrote/updated relocation info for read-only object memories to 'squawk.reloc']");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    static void unRegisterReadOnlyObjectMemory(ObjectMemory om) {
        ObjectMemory[] current = readOnlyObjectMemories;
        int index = -1;
        for (int i = 0; i < readOnlyObjectMemories.length; ++i) {
            if (readOnlyObjectMemories[i] != om) continue;
            index = i;
            break;
        }
        ObjectMemory[] arr = new ObjectMemory[current.length - 1];
        System.arraycopy(current, 0, arr, 0, index);
        System.arraycopy(current, index + 1, arr, index, current.length - index - 1);
        readOnlyObjectMemories = arr;
        if (VM.isVeryVerbose()) {
            System.out.println("[removed read only object memory: " + om.getURI() + "]");
        }
    }

    static Suite[] getSuites() {
        if (readOnlyObjectMemories == null) {
            return null;
        }
        int suiteCount = 0;
        for (int i = 0; i != readOnlyObjectMemories.length; ++i) {
            ObjectMemory om = readOnlyObjectMemories[i];
            if (!(om.getRoot() instanceof Suite)) continue;
            ++suiteCount;
        }
        Suite[] result = new Suite[suiteCount];
        suiteCount = 0;
        for (int i = 0; i != readOnlyObjectMemories.length; ++i) {
            ObjectMemory om = readOnlyObjectMemories[i];
            if (!(om.getRoot() instanceof Suite)) continue;
            result[suiteCount++] = (Suite)om.getRoot();
        }
        return result;
    }

    static Address allocateNvmBuffer(int size) {
        Address block = nvmAllocationPointer;
        Address next = nvmAllocationPointer.add(size);
        if (VM.isHosted()) {
            nvmEnd = next;
        } else if (next.hi(nvmEnd)) {
            throw VM.getOutOfMemoryError();
        }
        nvmAllocationPointer = next;
        return block;
    }

    static int getNvmSize() {
        return nvmEnd.diff(nvmStart).toInt();
    }

    static boolean inNvm(Address object) {
        return object.hi(nvmStart) && object.loeq(nvmEnd);
    }

    static Offset getOffsetInNvm(Address object) {
        return object.diff(nvmStart);
    }

    static Address getObjectInNvm(Offset offset) {
        return nvmStart.addOffset(offset);
    }

    static void initialize() throws HostedPragma {
        ramStart = Address.zero();
        ramEnd = Address.zero();
        nvmStart = Address.zero();
        nvmEnd = Address.zero();
        nvmAllocationPointer = nvmStart;
        Assert.always(ramStart.eq(ramStart.roundUpToWord()), "RAM limit is not word aligned", "GC.java", 536);
        Assert.always(ramEnd.eq(ramEnd.roundDownToWord()), "RAM limit is not word aligned", "GC.java", 537);
        GC.setAllocationParameters(ramStart, ramStart, ramEnd, ramEnd);
        GC.setAllocationEnabled(true);
        readOnlyObjectMemories = new ObjectMemory[0];
    }

    static void initialize(Suite bootstrapSuite) {
        Assert.always(ramStart.eq(ramStart.roundUpToWord()), "RAM limit is not word aligned", "GC.java", 555);
        Assert.always(ramEnd.eq(ramEnd.roundDownToWord()), "RAM limit is not word aligned", "GC.java", 556);
        GC.setAllocationParameters(ramStart, ramStart, ramEnd, ramEnd);
        GC.setAllocationEnabled(true);
        Lisp2GenerationalCollector newcollector = new Lisp2GenerationalCollector(ramStart, ramEnd);
        ((GarbageCollector)newcollector).initialize(ramStart, allocTop, ramEnd);
        readOnlyObjectMemories = new ObjectMemory[]{ObjectMemory.createBootstrapObjectMemory(bootstrapSuite)};
        collector = newcollector;
        gcEnabled = true;
    }

    static void setAllocationParameters(Address heapStart, Address allocStart, Address allocEnd, Address heapEnd) {
        GC.heapStart = heapStart;
        allocTop = GC.allocStart = allocStart;
        GC.allocEnd = allocEnd;
        GC.heapEnd = heapEnd;
    }

    static void setAllocTop(Address address) throws HostedPragma {
        allocTop = address;
    }

    public static int getBytesAllocatedSinceLastGC() {
        return allocTop.diff(allocStart).toInt();
    }

    static int countObjectsInRamAllocationSpace() {
        Address end = allocTop;
        int count = 0;
        Address block = heapStart;
        while (block.lo(end)) {
            ++count;
            Address object = GC.blockToOop(block);
            Klass klass = GC.getKlass(object.toObject());
            block = object.add(GC.getBodySize(klass, object));
        }
        return count;
    }

    static Offset getOffsetInRam(Address object) {
        return object.diff(ramStart);
    }

    static boolean inRamHosted(Object object) throws HostedPragma {
        return !(object instanceof Address);
    }

    public static boolean inRam(Object object) throws ForceInlinedPragma {
        if (VM.isHosted()) {
            return GC.inRamHosted(object);
        }
        Address ptr = Address.fromObject(object);
        if (ptr.loeq(ramStart)) {
            return false;
        }
        return !ptr.hi(ramEnd);
    }

    private static boolean inRange(Address ptr, Address start, Address end) {
        if (ptr.loeq(ramStart)) {
            return false;
        }
        return !ptr.hi(ramEnd);
    }

    public static boolean inRam(Address start, Address end) {
        Offset userRangeSize = end.diff(start);
        Assert.always(userRangeSize.ge(Offset.zero()), "GC.java", 682);
        return userRangeSize.ge(ramEnd.diff(ramStart)) ? GC.inRange(ramStart, start, end) || GC.inRange(ramEnd, start, end) : GC.inRange(start, ramStart, ramEnd) || GC.inRange(end, ramStart, ramEnd);
    }

    static boolean setAllocationEnabled(boolean newState) {
        boolean oldState = allocationEnabled;
        allocationEnabled = newState;
        return oldState;
    }

    public static boolean setGCEnabled(boolean newState) {
        boolean oldState = gcEnabled;
        gcEnabled = newState;
        return oldState;
    }

    public static boolean isGCEnabled() {
        return gcEnabled;
    }

    public static boolean isSafeToSwitchThreads() {
        return allocationEnabled;
    }

    private static Object allocatePrimHosted(int size, Object klass, int arrayLength) throws HostedPragma {
        Object res;
        boolean isArray = arrayLength != -1;
        int headerSize = isArray ? 8 : 4;
        UWord encodedArrayLength = GC.encodeLengthWord(arrayLength);
        VM.extendsEnabled = false;
        Address block = allocTop;
        Offset available = allocEnd.diff(block);
        if (size < 0 || available.lt(Offset.fromPrimitive(size))) {
            res = null;
        } else {
            Address oop = block.add(headerSize);
            NativeUnsafe.setObject(oop, -1, klass);
            if (isArray) {
                NativeUnsafe.setUWord(oop, -2, encodedArrayLength);
            }
            allocTop = block.add(size);
            VM.zeroWords(oop, allocTop);
            res = oop.toObject();
        }
        VM.extendsEnabled = true;
        return res;
    }

    private static Object allocatePrim(int size, Object klass, int arrayLength) {
        if (VM.isHosted()) {
            allocEnd = allocTop.add(size);
            NativeUnsafe.setMemorySize(allocTop.toUWord().toOffset().add(size).toInt());
            return GC.allocatePrimHosted(size, klass, arrayLength);
        }
        Object oop = VM.allocate(size, klass, arrayLength);
        if (oop != null) {
            // empty if block
        }
        return oop;
    }

    private static Object allocate(int size, Object klass, int arrayLength) {
        Object oop;
        Object object = oop = excessiveGC && !VMThread.currentThread().isServiceThread() ? null : GC.allocatePrim(size, klass, arrayLength);
        if (oop == null) {
            Assert.always(VM.isThreadingInitialized(), "insufficient memory to start VM", "GC.java", 854);
            if (gcEnabled) {
                VM.collectGarbage(false);
                oop = GC.allocatePrim(size, klass, arrayLength);
                if (oop == null) {
                    VM.collectGarbage(true);
                    oop = GC.allocatePrim(size, klass, arrayLength);
                }
            } else {
                VM.println("ALLOCATION WHILE GC is DISABLED!");
            }
            if (oop == null) {
                throw VM.getOutOfMemoryError();
            }
        }
        return oop;
    }

    static void collectGarbage(boolean forceFullGC) {
        long free = GC.freeMemory();
        VM.pruneIsolateList();
        VM.invalidateClassStateCache();
        Assert.always(!collecting, "GC.java", 907);
        collecting = true;
        boolean oldState = GC.setAllocationEnabled(false);
        if (!oldState) {
            VM.fatalVMError();
        }
        boolean fullCollection = collector.collectGarbage(allocTop, forceFullGC);
        collecting = false;
        collector.postCollection();
        GC.setAllocationEnabled(true);
        if (GC.isTracing(1)) {
            long afterFree = GC.freeMemory();
            if (fullCollection) {
                VM.print("[Full GC ");
            } else {
                VM.print("[GC ");
            }
            VM.print(free);
            VM.print("->");
            VM.print(afterFree);
            VM.print("(");
            VM.print(GC.totalMemory());
            VM.print("), ");
            VM.print(collector.getLastGCTime());
            VM.print("ms)");
            collector.verbose();
            VM.println();
        }
        if (fullCollection) {
            ++fullCollectionCount;
        } else {
            ++partialCollectionCount;
        }
        Assert.always(VM.invalidateClassStateCache(), "GC.java", 963);
    }

    public static int calculateOopMapSizeInBytes(int size) {
        return (size / 4 + 7) / 8;
    }

    static void copyObjectGraph(Address object, ObjectMemorySerializer.ControlBlock cb) {
        Assert.always(!collecting, "GC.java", 1000);
        collecting = true;
        Address copiedObjects = collector.copyObjectGraph(object, cb, allocTop);
        collecting = false;
        Assert.always(copiedObjects.isZero() || !cb.start.isZero(), "collector must have recorded base address for internal pointers in copied object graph", "GC.java", 1011);
        cb.memory = (byte[])copiedObjects.toObject();
    }

    private static void encodeLengthWordError() throws NotInlinedPragma {
        VM.println("encodeLengthWord");
        throw VM.getOutOfMemoryError();
    }

    private static UWord encodeLengthWord(int length) throws ForceInlinedPragma {
        if (length > 0x3FFFFFF) {
            GC.encodeLengthWordError();
        }
        return UWord.fromPrimitive(length << 2 | 1);
    }

    static int decodeLengthWord(UWord word) throws ForceInlinedPragma {
        return word.toPrimitive() >>> 2;
    }

    static void setHeaderClass(Address oop, Object klass) throws ForceInlinedPragma {
        NativeUnsafe.setAddress(oop, -1, klass);
    }

    static void setHeaderLength(Address oop, int length) throws ForceInlinedPragma {
        NativeUnsafe.setUWord(oop, -2, GC.encodeLengthWord(length));
    }

    public static Klass getKlass(Object object) throws ForceInlinedPragma {
        Address classOrAssociation = NativeUnsafe.getAddress(object, -1);
        Object klass = NativeUnsafe.getObject(classOrAssociation, 0);
        return VM.asKlass(klass);
    }

    static int getArrayLengthNoCheck(Object array) throws ForceInlinedPragma {
        return GC.decodeLengthWord(NativeUnsafe.getUWord(array, -2));
    }

    public static int getArrayLength(Object array) throws ForceInlinedPragma {
        return GC.getArrayLengthNoCheck(array);
    }

    static Object newInstance(Klass klass) {
        Object oop = GC.allocate(klass.getInstanceSize() * 4 + 4, klass, -1);
        return oop;
    }

    private static Object newArray(Object klass, int length, int dataSize) {
        int bodySize = length * dataSize;
        if (bodySize < 0) {
            VM.println("newArray neg size");
            throw VM.getOutOfMemoryError();
        }
        int size = GC.roundUpToWord(8 + bodySize);
        return GC.allocate(size, klass, length);
    }

    static Object newArray(Klass klass, int length) {
        if (length < 0) {
            throw new NegativeArraySizeException();
        }
        Klass componentType = klass.getComponentType();
        int componentSize = componentType.getDataSize();
        Object result = GC.newArray(klass, length, componentSize);
        return result;
    }

    static Object newStack(int length, VMThread owner) {
        int size = GC.roundUpToWord(8 + length * Klass.LOCAL.getDataSize());
        Object stack = GC.allocatePrim(size, Klass.LOCAL_ARRAY, length);
        if (stack != null) {
            NativeUnsafe.setObject(stack, 1, owner);
            collector.registerStackChunks(stack);
        }
        return stack;
    }

    static void stackCopy(Object srcChunk, Object dstChunk) {
        Address src = Address.fromObject(srcChunk);
        Address dst = Address.fromObject(dstChunk);
        int srcSize = GC.getArrayLength(src) * 4;
        int dstSize = GC.getArrayLength(dst) * 4;
        int extra = dstSize - srcSize;
        Address srcLastFP = NativeUnsafe.getAddress(src, 2);
        Address dstLastFP = dst.addOffset(srcLastFP.diff(src)).add(extra);
        NativeUnsafe.setAddress(dst, 1, NativeUnsafe.getAddress(src, 1));
        NativeUnsafe.setAddress(dst, 2, NativeUnsafe.getAddress(src, 2));
        NativeUnsafe.setUWord(dst, 3, NativeUnsafe.getUWord(src, 3));
        Assert.always(NativeUnsafe.getAddress(src, 4).isZero(), "GC.java", 1280);
        Address srcEnd = src.add(srcSize);
        int srcUsedSize = srcEnd.diff(srcLastFP).toInt();
        VM.copyBytes(srcLastFP, 0, dstLastFP, 0, srcUsedSize, false);
        NativeUnsafe.setAddress(dst, 2, dstLastFP);
        Address srcFP = srcLastFP;
        Address dstFP = dstLastFP;
        int fpCount = 0;
        while (!srcFP.isZero()) {
            Address srcReturnFP = NativeUnsafe.getAddress(srcFP, 1);
            Offset delta = srcReturnFP.diff(srcFP);
            srcFP = srcReturnFP;
            Address dstReturnFP = srcFP.isZero() ? Address.zero() : dstFP.addOffset(delta);
            NativeUnsafe.setAddress(dstFP, 1, dstReturnFP);
            dstFP = dstReturnFP;
            ++fpCount;
        }
        collector.deregisterStackChunk(src.toObject());
    }

    static void checkSC(Address scAddress) throws ForceInlinedPragma {
    }

    static void checkSC(Object sc) throws ForceInlinedPragma {
    }

    static void checkSC(VMThread thr) throws ForceInlinedPragma {
    }

    static Object newMethod(Object definingClass, MethodBody body) {
        boolean isHosted = VM.isHosted();
        ByteBufferEncoder enc = new ByteBufferEncoder();
        body.encodeHeader(enc);
        int roundup = GC.roundUpToWord(enc.getSize());
        int padding = roundup - enc.getSize();
        int hsize = enc.getSize() + padding + 8 + 4 + 4;
        int hsizeInWords = hsize / 4;
        int bsize = body.getCodeSize();
        UWord bsizeEncoded = GC.encodeLengthWord(bsize);
        int totalSize = GC.roundUpToWord(hsize + bsize);
        Object oop = GC.allocate(totalSize, Klass.BYTE_ARRAY, totalSize - 8);
        Klass BYTECODE_ARRAY = Klass.BYTECODE_ARRAY;
        VM.extendsEnabled = false;
        Address block = Address.fromObject(oop).sub(8);
        Address methodOopAsAddress = block.add(hsize);
        NativeUnsafe.setAddress(methodOopAsAddress, -1, BYTECODE_ARRAY);
        NativeUnsafe.setUWord(methodOopAsAddress, -2, bsizeEncoded);
        UWord headerWord = UWord.fromPrimitive(hsizeInWords << 2 | 3);
        NativeUnsafe.setUWord(block, 0, headerWord);
        if (isHosted) {
            NativeUnsafe.clearObject(block, 1);
        } else {
            for (int i = 0; i < padding; ++i) {
                NativeUnsafe.setByte(block, i + 4, 0);
            }
        }
        oop = methodOopAsAddress.toObject();
        block = methodOopAsAddress = Address.zero();
        VM.extendsEnabled = true;
        NativeUnsafe.setObject(oop, -3, definingClass);
        enc.writeToVMMemory(oop, 0 - hsize + 4 + padding);
        body.writeToVMMemory(oop);
        if (isHosted || VM.isVerbose()) {
            Method method = body.getDefiningMethod();
            String name = method.toString();
            String file = body.getDefiningClass().getSourceFilePath();
            String lnt = Method.lineNumberTableAsString(method.getLineNumberTable());
            int old = VM.setStream(2);
            VM.print("METHOD.");
            VM.printAddress(oop);
            VM.print(".NAME=");
            VM.println(name);
            VM.print("METHOD.");
            VM.printAddress(oop);
            VM.print(".FILE=");
            VM.println(file);
            VM.print("METHOD.");
            VM.printAddress(oop);
            VM.print(".LINETABLE=");
            VM.println(lnt);
            VM.setStream(old);
        }
        return oop;
    }

    public static void arraycopy(Object src, int srcPos, Object dst, int dstPos, int lth) {
        int itemLength = Klass.getComponentType(GC.getKlass(src)).getDataSize();
        VM.copyBytes(Address.fromObject(src), srcPos * itemLength, Address.fromObject(dst), dstPos * itemLength, lth * itemLength, false);
    }

    private static int getStringOperandSize(Object string) {
        switch (GC.getKlass(string).getSystemID()) {
            case 2: 
            case 20: {
                return 2;
            }
            case 19: 
            case 26: {
                return 1;
            }
        }
        VM.fatalVMError();
        return 0;
    }

    public static void stringcopy(Object src, int srcPos, Object dst, int dstPos, int lth) {
        int srcsize = GC.getStringOperandSize(src);
        if (srcsize == GC.getStringOperandSize(dst)) {
            VM.copyBytes(Address.fromObject(src), srcPos * srcsize, Address.fromObject(dst), dstPos * srcsize, lth * srcsize, false);
        } else if (srcsize == 1) {
            for (int i = 0; i < lth; ++i) {
                int ch = NativeUnsafe.getByte(src, srcPos++) & 0xFF;
                NativeUnsafe.setChar(dst, dstPos++, ch);
            }
        } else {
            for (int i = 0; i < lth; ++i) {
                int ch = NativeUnsafe.getChar(src, srcPos++) & 0xFF;
                NativeUnsafe.setByte(dst, dstPos++, ch);
            }
        }
    }

    public static String makeEightBitString(Object oop) {
        NativeUnsafe.setAddress(oop, -1, Klass.STRING_OF_BYTES);
        return (String)oop;
    }

    public static String makeSixteenBitString(Object oop) {
        NativeUnsafe.setAddress(oop, -1, Klass.STRING);
        return (String)oop;
    }

    static String convertCString(Address cstring) {
        int ch;
        int size = 0;
        int i = 0;
        while ((ch = NativeUnsafe.getByte(cstring, i) & 0xFF) != 0) {
            ++size;
            ++i;
        }
        char[] chars = new char[size];
        for (int i2 = 0; i2 != size; ++i2) {
            int ch2 = NativeUnsafe.getByte(cstring, i2) & 0xFF;
            chars[i2] = (char)ch2;
        }
        return new String(chars);
    }

    static void copyCStringArray(Address cstringArray, String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = GC.convertCString(NativeUnsafe.getAddress(cstringArray, i));
        }
    }

    public static int getHashCode(Object object) {
        if (GC.inRam(object)) {
            return GC.getObjectAssociation(object).getHashCode();
        }
        return VM.hashcode(object);
    }

    static Monitor getMonitor(Object object) {
        if (GC.inRam(object)) {
            ObjectAssociation assn = GC.getObjectAssociation(object);
            Monitor monitor = assn.getMonitor();
            if (monitor == null) {
                monitor = new Monitor(object);
                assn.setMonitor(monitor);
            }
            return monitor;
        }
        SquawkHashtable monitorTable = VM.getCurrentIsolate().getMonitorHashtable();
        Monitor monitor = (Monitor)monitorTable.get(object);
        if (monitor == null) {
            monitor = new Monitor(object);
            monitorTable.put(object, monitor);
        }
        return monitor;
    }

    static void removeMonitor(Object object, boolean cond) {
        ++monitorExitCount;
        if (cond) {
            if (GC.inRam(object)) {
                ObjectAssociation assn = GC.lookupObjectAssociation(object);
                if (!assn.hashCodeInUse()) {
                    NativeUnsafe.setObject(object, -1, GC.getKlass(object));
                    ++monitorReleaseCount;
                }
            } else {
                SquawkHashtable monitorTable = VM.getCurrentIsolate().getMonitorHashtable();
                monitorTable.remove(object);
                ++monitorReleaseCount;
            }
        }
    }

    static boolean hasRealMonitor(Object object) {
        Monitor monitor = null;
        if (GC.inRam(object)) {
            Klass klass;
            Object something = NativeUnsafe.getObject(object, -1);
            if (something == (klass = GC.getKlass(object))) {
                return false;
            }
            monitor = ((ObjectAssociation)something).getMonitor();
        } else {
            SquawkHashtable monitorTable = VM.getCurrentIsolate().getMonitorHashtable();
            monitor = (Monitor)monitorTable.get(object);
        }
        return monitor != null;
    }

    private static ObjectAssociation getObjectAssociation(Object object) throws ForceInlinedPragma {
        Object klass;
        Object classOrAssociation = NativeUnsafe.getObject(object, -1);
        if (classOrAssociation != (klass = NativeUnsafe.getObject(classOrAssociation, 0))) {
            return (ObjectAssociation)classOrAssociation;
        }
        return GC.createObjectAssociation(object, VM.asKlass(klass));
    }

    private static ObjectAssociation lookupObjectAssociation(Object object) throws ForceInlinedPragma {
        Object classOrAssociation = NativeUnsafe.getObject(object, -1);
        return (ObjectAssociation)classOrAssociation;
    }

    private static ObjectAssociation createObjectAssociation(Object object, Klass klass) {
        ObjectAssociation assn = new ObjectAssociation(klass);
        NativeUnsafe.setObject(object, -1, assn);
        return assn;
    }

    public static long freeMemory() {
        return collector.freeMemory(allocTop);
    }

    public static long totalMemory() {
        return collector.totalMemory();
    }

    public static int getPartialCount() {
        return partialCollectionCount;
    }

    public static int getFullCount() {
        return fullCollectionCount;
    }

    public static int getTotalCount() {
        return fullCollectionCount + partialCollectionCount;
    }

    static Object newClassState(Klass klass, Klass klassGlobalArray) {
        Object res = GC.newArray(klassGlobalArray, 2 + klass.getStaticFieldsSize(), 4);
        NativeUnsafe.setObject(res, 0, klass);
        CS.check(res);
        return res;
    }

    static Object newClassState(Klass klass) {
        return GC.newClassState(klass, Klass.GLOBAL_ARRAY);
    }

    static Address blockToOop(Address block) {
        UWord taggedWord = NativeUnsafe.getAsUWord(block, 0);
        switch (taggedWord.and(UWord.fromPrimitive(3)).toInt()) {
            case 0: {
                return block.add(4);
            }
            case 1: {
                return block.add(8);
            }
            case 3: {
                return block.add(GC.decodeLengthWord(taggedWord) * 4);
            }
        }
        VM.fatalVMError();
        return null;
    }

    static Address oopToBlock(Klass klass, Address object) {
        if (Klass.isSquawkArray(klass)) {
            if (Klass.getSystemID(klass) == 33) {
                return MethodBody.oopToBlock(object);
            }
            return object.sub(8);
        }
        return object.sub(4);
    }

    static int getBodySize(Klass klass, Address object) {
        if (Klass.isSquawkArray(klass)) {
            int length = GC.getArrayLengthNoCheck(object);
            int elementSize = Klass.getSquawkArrayComponentDataSize(klass);
            return GC.roundUpToWord(length * elementSize);
        }
        return Klass.getInstanceSize(klass) * 4;
    }

    static void traceMemory(Address start, Address end, boolean toString) {
    }

    static String findInRomString(String string) {
        Isolate isolate = VM.getCurrentIsolate();
        Suite suite = isolate.getLeafSuite();
        ObjectMemory parent = null;
        while (parent == null) {
            parent = suite.getReadOnlyObjectMemory();
            if ((suite = suite.getParent()) != null) continue;
            return null;
        }
        boolean percent = false;
        while (parent != null) {
            Address end = parent.getStart().add(parent.getSize());
            Address block = parent.getStart();
            while (block.lo(end)) {
                Address object = GC.blockToOop(block);
                if (object.toObject() instanceof String && object.toObject().equals(string)) {
                    return (String)object.toObject();
                }
                block = object.add(GC.getBodySize(GC.getKlass(object), object));
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static void initHeapStats() {
        if (heapstats == null) {
            heapstats = new SquawkHashtable(500);
            Suite[] suites = GC.getSuites();
            for (int i = 0; i < suites.length; ++i) {
                Suite s = suites[i];
                int classCount = s.getClassCount();
                for (int j = 0; j < classCount; ++j) {
                    Klass k = s.getKlass(j);
                    if (!k.isInstantiable()) continue;
                    Assert.always(heapstats.get(s.getKlass(j)) == null, "GC.java", 2058);
                    heapstats.put(s.getKlass(j), new ClassStat());
                }
            }
            heapstats.put(DYNAMIC_CLASSES, new ClassStat());
        }
    }

    static void clearHeapStats() {
        heapstats = null;
    }

    static void printObject(Object obj, Klass klass, int size) {
        if (obj instanceof String) {
            VM.print("String size: ");
            VM.print(size);
            VM.print(", ");
            VM.print((String)obj);
        } else if (obj instanceof StringBuffer) {
            StringBuffer sb = (StringBuffer)obj;
            VM.print("StringBuffer size: ");
            VM.print(size);
            VM.print(", ");
            for (int i = 0; i < sb.length(); ++i) {
                VM.print(sb.charAt(i));
            }
        } else if (klass.isArray()) {
            VM.print(klass.getInternalName());
            VM.print(" size: ");
            VM.print(size);
            VM.print(", length: ");
            VM.print(GC.getArrayLength(obj));
            if (Klass.getSystemID(klass) == 20) {
                char[] cha = (char[])obj;
                VM.print(", ");
                for (int i = 0; i < cha.length; ++i) {
                    VM.print(cha[i]);
                }
            } else if (Klass.getSystemID(klass) == 30) {
                VM.print("Static variables for ");
                Klass owner = VM.asKlass(NativeUnsafe.getObject(obj, 0));
                VM.print(owner.getInternalName());
            } else if (Klass.getSystemID(klass) == 29) {
                VM.print("Local variables ");
            } else {
                VM.print(" @");
                VM.printAddress(obj);
            }
        } else if (obj instanceof Monitor) {
            Monitor mon = (Monitor)obj;
            VM.print("Monitor for ");
            GC.printObject(mon.object);
        } else {
            VM.print(klass.getInternalName());
            VM.print(" size: ");
            VM.print(size);
            VM.print(", @");
            VM.printAddress(obj);
        }
        VM.println();
    }

    static void printObject(Object obj) {
        Klass klass = GC.getKlass(obj);
        int blkSize = GC.getBodySize(klass, Address.fromObject(obj));
        int objSize = blkSize + (klass.isArray() ? 8 : 4);
        GC.printObject(obj, klass, objSize);
    }

    static int getObjectBytes(Object object) {
        Klass klass = GC.getKlass(object);
        int blkSize = GC.getBodySize(klass, Address.fromObject(object));
        return blkSize + (klass.isArray() ? 8 : 4);
    }

    static int getObjectBytes(Klass klass) {
        int size = klass.getInstanceSize() << 2;
        return size += 4;
    }

    public static void allObjectsFromDo(Object startObj, DoBlock doBlock) {
        Address start;
        if (startObj == null) {
            start = heapStart;
        } else {
            if (!GC.inRam(startObj)) {
                throw new IllegalArgumentException();
            }
            start = GC.oopToBlock(GC.getKlass(startObj), Address.fromObject(startObj));
        }
        int oldPartialCollectionCount = partialCollectionCount;
        int oldFullCollectionCount = fullCollectionCount;
        Address end = allocTop;
        Address block = start;
        while (block.lo(end)) {
            Address object = GC.blockToOop(block);
            Klass klass = GC.getKlass(object);
            int blkSize = GC.getBodySize(klass, object);
            doBlock.value(object.toObject());
            if (oldPartialCollectionCount != partialCollectionCount || oldFullCollectionCount != fullCollectionCount) {
                throw new IllegalStateException("GC during heap walk");
            }
            block = object.add(blkSize);
        }
    }

    static void collectHeapStats(Object startObj, Object endObject, boolean printInstances) {
        Address end;
        Address start;
        if (startObj == null) {
            start = heapStart;
        } else {
            if (!GC.inRam(startObj)) {
                throw new IllegalArgumentException();
            }
            start = GC.oopToBlock(GC.getKlass(startObj), Address.fromObject(startObj));
        }
        if (endObject == null) {
            end = allocTop;
        } else {
            if (!GC.inRam(endObject)) {
                throw new IllegalArgumentException();
            }
            end = GC.oopToBlock(GC.getKlass(endObject), Address.fromObject(endObject));
        }
        int oldPartialCollectionCount = partialCollectionCount;
        int oldFullCollectionCount = fullCollectionCount;
        Address block = start;
        while (block.lo(end)) {
            Address object = GC.blockToOop(block);
            Klass klass = GC.getKlass(object);
            int blkSize = GC.getBodySize(klass, object);
            int objSize = blkSize + (klass.isArray() ? 8 : 4);
            ClassStat cs = (ClassStat)heapstats.get(klass);
            if (cs == null) {
                cs = (ClassStat)heapstats.get(DYNAMIC_CLASSES);
                if (!klass.isArray()) {
                    VM.print("collectHeapStats - unknown class: ");
                    VM.println(klass.getInternalName());
                }
            } else if (printInstances) {
                GC.printObject(object.toObject(), klass, objSize);
            }
            cs.update(objSize);
            if (oldPartialCollectionCount != partialCollectionCount || oldFullCollectionCount != fullCollectionCount) {
                throw new IllegalStateException("GC during heap walk");
            }
            block = object.add(blkSize);
        }
    }

    private static void print1Stat(String key, int count, int size) {
        System.out.print(key);
        System.out.print(": \t");
        System.out.print(count);
        System.out.print(" \t");
        System.out.print(size);
        System.out.println();
    }

    public static void printHeapStats(Object startObj, boolean printInstances) {
        Object endObjectMarker = new Object();
        GC.initHeapStats();
        Enumeration e = heapstats.elements();
        while (e.hasMoreElements()) {
            ClassStat cs = (ClassStat)e.nextElement();
            cs.clear();
        }
        if (printInstances) {
            VM.println("Instances in heap:");
        }
        GC.collectHeapStats(startObj, endObjectMarker, printInstances);
        VM.println("Class:\t Count: \t Bytes:");
        e = heapstats.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ClassStat cs = (ClassStat)heapstats.get(key);
            if (cs.count <= 0) continue;
            GC.print1Stat(key.toString(), cs.count, cs.size);
        }
        heapstats = null;
    }

    public static class ClassStat {
        public int count;
        public int size;

        public final void clear() {
            this.count = 0;
            this.size = 0;
        }

        public final void update(int objSize) {
            ++this.count;
            this.size += objSize;
        }
    }
}

