/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.Klass;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectMemorySerializer;
import com.sun.squawk.Ref;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.pragma.GlobalStaticFields;
import java.io.PrintStream;

public abstract class GarbageCollector
implements GlobalStaticFields {
    public static final boolean NATIVE_GC_ONLY = true;
    private long lastCollectionTime;
    private long maxFullCollectionTime;
    private long maxPartialCollectionTime;
    private long totalFullCollectionTime;
    private long totalPartialCollectionTime;
    protected long numBytesLastScanned;
    private long numBytesLastFreed;
    private long numBytesFreedTotal;
    private long totalBytesAllocatedCheckPoint;
    private boolean interpGC = !this.hasNativeImplementation();
    private boolean useMicrosecondTimer;
    protected Ref references;
    static final boolean HEAP_TRACE = false;

    GarbageCollector() {
    }

    abstract void initialize(Address var1, Address var2, Address var3);

    final boolean collectGarbage(Address allocTop, boolean forceFullGC) {
        long freeBeforeGC = GC.freeMemory();
        long bytesAllocated = GC.getBytesAllocatedSinceLastGC();
        long start = VM.getTimeMillis();
        boolean didFull = this.collectGarbageInC(allocTop, forceFullGC);
        this.lastCollectionTime = VM.getTimeMillis() - start;
        if (didFull) {
            this.totalFullCollectionTime += this.lastCollectionTime;
            if (this.maxFullCollectionTime < this.lastCollectionTime) {
                this.maxFullCollectionTime = this.lastCollectionTime;
            }
        } else {
            this.totalPartialCollectionTime += this.lastCollectionTime;
            if (this.maxPartialCollectionTime < this.lastCollectionTime) {
                this.maxPartialCollectionTime = this.lastCollectionTime;
            }
        }
        this.numBytesLastFreed = GC.freeMemory() - freeBeforeGC;
        this.numBytesFreedTotal += this.numBytesLastFreed;
        this.totalBytesAllocatedCheckPoint += bytesAllocated;
        return didFull;
    }

    public final long getLastGCTime() {
        return this.lastCollectionTime;
    }

    public final long getMaxFullGCTime() {
        return this.maxFullCollectionTime;
    }

    public final long getMaxPartialGCTime() {
        return this.maxPartialCollectionTime;
    }

    public final long getMaxGCTime() {
        return Math.max(this.getMaxFullGCTime(), this.getMaxPartialGCTime());
    }

    public final long getTotalGCTime() {
        return this.totalFullCollectionTime + this.totalPartialCollectionTime;
    }

    public final long getTotalFullGCTime() {
        return this.totalFullCollectionTime;
    }

    public final long getTotalPartialGCTime() {
        return this.totalPartialCollectionTime;
    }

    public final long getBytesLastFreed() {
        return this.numBytesLastFreed;
    }

    public final long getBytesLastScanned() {
        return this.numBytesLastScanned;
    }

    public final long getBytesFreedTotal() {
        return this.numBytesFreedTotal;
    }

    final long getTotalBytesAllocatedCheckPoint() {
        return this.totalBytesAllocatedCheckPoint;
    }

    public int getBytesAllocatedSinceLastGC() {
        return GC.getBytesAllocatedSinceLastGC();
    }

    public long getBytesAllocatedTotal() {
        return this.getTotalBytesAllocatedCheckPoint() + (long)this.getBytesAllocatedSinceLastGC();
    }

    final native boolean hasNativeImplementation();

    final native boolean collectGarbageInC(Address var1, boolean var2);

    abstract boolean collectGarbageInJava(Address var1, boolean var2);

    abstract void postCollection();

    final Address copyObjectGraph(Address object, ObjectMemorySerializer.ControlBlock cb, Address allocTop) {
        Address result = this.copyObjectGraphInC(object, cb, allocTop);
        return result;
    }

    final native Address copyObjectGraphInC(Address var1, ObjectMemorySerializer.ControlBlock var2, Address var3);

    abstract Address copyObjectGraphInJava(Address var1, ObjectMemorySerializer.ControlBlock var2, Address var3);

    abstract void dumpTimings(PrintStream var1);

    abstract long freeMemory(Address var1);

    abstract long totalMemory();

    final long now() {
        return this.useMicrosecondTimer ? VM.getTimeMicros() : VM.getTimeMillis();
    }

    final String timerUnitSuffix() {
        return this.useMicrosecondTimer ? "usec" : "ms";
    }

    boolean processCommandLineOption(String arg) {
        if (arg.equals("-nativegc")) {
            if (!this.hasNativeImplementation()) {
                System.out.println("Warning: unsupported -nativegc switch ignored");
            } else {
                this.interpGC = false;
            }
            return true;
        }
        if (arg.equals("-usecgctimer")) {
            this.useMicrosecondTimer = true;
            return true;
        }
        return false;
    }

    void usage(PrintStream out) {
        if (this.hasNativeImplementation()) {
            // empty if block
        }
        out.println("    -usecgctimer          use microsecond (not millisecond) timer for GC");
    }

    void verbose() {
    }

    void registerStackChunks(Object chunk) {
    }

    void deregisterStackChunk(Object chunk) {
    }

    final void addWeakReference(Ref reference) {
        reference.next = this.references;
        this.references = reference;
    }

    final void traceVariable(String name, Address value) {
        VM.print("    ");
        VM.print(name);
        VM.print(" = ");
        VM.printAddress(value);
        VM.println();
    }

    final void traceVariable(String name, int value) {
        VM.print("    ");
        VM.print(name);
        VM.print(" = ");
        VM.print(value);
        if (value > 0x100000) {
            VM.print(" [");
            VM.print(value / 0x100000);
            VM.print(".");
            int rem = value % 0x100000 / 104857;
            VM.print(rem);
            VM.print("M]");
        } else if (value > 1024) {
            VM.print(" [");
            VM.print(value / 1024);
            VM.print(".");
            int rem = value % 1024 / 102;
            VM.print(rem);
            VM.print("K]");
        }
        VM.println();
    }

    abstract void traceHeap(String var1, Address var2);

    void traceHeapInitialize(Address start, Address end) {
        VM.print("*HEAP*:initialize:");
        VM.printAddress(start);
        VM.print(":");
        VM.printAddress(end);
        VM.println();
    }

    final void traceHeapStart(String description, long freeMemory, long totalMemory) {
        VM.print("*HEAP*:start:");
        VM.print(VM.branchCount());
        VM.print(":");
        VM.print(freeMemory);
        VM.print(":");
        VM.print(totalMemory);
        VM.print(":");
        VM.println(description);
    }

    final void traceHeapEnd() {
        VM.println("*HEAP*:end");
    }

    final void traceHeapSegment(String label, Address start, int size) {
        if (size > 0) {
            VM.print("*HEAP*:segment:");
            VM.printAddress(start);
            VM.print(":");
            VM.printAddress(start.add(size));
            VM.print(":");
            VM.println(label);
        }
    }

    final void traceHeapSegment(String label, Address start, Address end) {
        this.traceHeapSegment(label, start, end.diff(start).toInt());
    }

    final void traceHeapObject(Address start, Address oop, Klass klass, int size) {
        VM.print("*HEAP*:");
        VM.printAddress(start);
        VM.print(":");
        while (start.lo(oop)) {
            VM.printUWord(NativeUnsafe.getAsUWord(start, 0));
            VM.print(":");
            start = start.add(4);
        }
        VM.print("oop:");
        if (size != 0) {
            UWord last = NativeUnsafe.getAsUWord(oop, 0);
            VM.printUWord(last);
            VM.print(":");
            int repeats = 0;
            for (int i = 1; i != size; ++i) {
                UWord word = NativeUnsafe.getAsUWord(oop, i);
                if (word.eq(last)) {
                    ++repeats;
                    continue;
                }
                if (repeats != 0) {
                    VM.print("*");
                    VM.print(repeats);
                    VM.print(":");
                    repeats = 0;
                }
                VM.printUWord(word);
                VM.print(":");
                last = word;
            }
            if (repeats != 0) {
                VM.print("*");
                VM.print(repeats);
                VM.print(":");
            }
        }
        VM.println(Klass.getInternalName(klass));
    }
}

