/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.ClassFileField;
import com.sun.squawk.ClassFileMethod;
import com.sun.squawk.Klass;
import com.sun.squawk.MethodMetadata;
import com.sun.squawk.Suite;
import com.sun.squawk.SymbolParser;
import com.sun.squawk.VM;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkVector;

public class KlassMetadata {
    private final Klass definedClass;
    protected byte[] symbols;
    protected Klass[] classTable;

    private KlassMetadata(Klass definedClass) {
        this.definedClass = definedClass;
    }

    KlassMetadata(Klass definedClass, byte[] symbols, Klass[] classTable) {
        this.definedClass = definedClass;
        this.symbols = symbols;
        this.classTable = classTable;
    }

    static int addSignatureType(SquawkVector types, Klass type) {
        int systemID = type.getSystemID();
        if (systemID >= 0) {
            return systemID << 1;
        }
        int index = types.indexOf(type);
        if (index == -1) {
            index = types.size();
            types.addElement(type);
        }
        return index << 1 | 1;
    }

    static Klass getSignatureType(Klass[] types, int typeID) {
        if ((typeID & 1) == 0) {
            int systemID = typeID >>> 1;
            return VM.getCurrentIsolate().getBootstrapSuite().getKlass(systemID);
        }
        int index = typeID >>> 1;
        return types[index];
    }

    void setMethodMetadata(boolean isStatic, int index, MethodMetadata metadata) {
        Assert.shouldNotReachHere("Adding method metadata", "KlassMetadata.java", 236);
    }

    final MethodMetadata getMethodMetadata(boolean isStatic, int index) {
        Object[] methodArray;
        MethodMetadata[] methods = this.geMethodMetadata(isStatic);
        if (methods == null) {
            return null;
        }
        Object[] objectArray = methodArray = isStatic ? this.definedClass.getStaticMethods() : this.definedClass.getVirtualMethods();
        if (methodArray.length == methods.length) {
            return methods[index];
        }
        int realIndex = MethodMetadata.binarySearch(methods, index);
        if (realIndex >= 0) {
            return methods[realIndex];
        }
        return null;
    }

    final Klass getDefinedClass() {
        return this.definedClass;
    }

    String getSourceFileName() {
        return null;
    }

    MethodMetadata[] geMethodMetadata(boolean isStatic) {
        return null;
    }

    SymbolParser getSymbolParser() {
        return SymbolParser.create(this.symbols, this.classTable);
    }

    SymbolParser getSymbolParser(int memberID) {
        return SymbolParser.create(this.symbols, this.classTable, memberID);
    }

    int getSize() {
        return this.symbols.length;
    }

    static void flush() {
        SymbolParser.flush();
    }

    public static KlassMetadata create(byte[] symbols, Klass[] classTable, KlassMetadata original, int type) {
        String srcFile = type == 3 ? original.getSourceFileName() : null;
        MethodMetadata[] staticMethodsMetadata = MethodMetadata.strip(original.geMethodMetadata(true));
        MethodMetadata[] virtualMethodsMetadata = MethodMetadata.strip(original.geMethodMetadata(false));
        if (srcFile != null || staticMethodsMetadata != null || virtualMethodsMetadata != null) {
            return new Full(original.definedClass, symbols, classTable, srcFile, virtualMethodsMetadata, staticMethodsMetadata);
        }
        return new KlassMetadata(original.definedClass, symbols, classTable);
    }

    static KlassMetadata[] strip(Suite suite, KlassMetadata[] metadatas, int type) {
        if (metadatas == null) {
            return null;
        }
        if (type == 0) {
            return null;
        }
        KlassMetadata[] newMetadatas = new KlassMetadata[metadatas.length];
        block5: for (int i = 0; i != metadatas.length; ++i) {
            KlassMetadata metadata = metadatas[i];
            if (metadata == null) continue;
            switch (type) {
                case 3: {
                    newMetadatas[i] = KlassMetadata.create(metadata.symbols, metadata.classTable, metadata, type);
                    continue block5;
                }
                case 0: {
                    newMetadatas[i] = KlassMetadata.create(null, null, metadata, type);
                    continue block5;
                }
                case 1: 
                case 2: {
                    newMetadatas[i] = metadata.strip(type);
                    continue block5;
                }
                default: {
                    VM.fatalVMError();
                }
            }
        }
        return newMetadatas;
    }

    private KlassMetadata strip(int type) {
        if (VM.stripSymbols(this.definedClass)) {
            return null;
        }
        SquawkVector types = new SquawkVector(this.classTable.length);
        byte[] newSymbols = this.getSymbolParser().strip(this.definedClass, type, types);
        Object[] newClassTable = new Klass[types.size()];
        types.copyInto(newClassTable);
        return KlassMetadata.create(newSymbols, (Klass[])newClassTable, this, type);
    }

    static final class Full
    extends KlassMetadata {
        private final MethodMetadata[] virtualMethodsMetadata;
        private final MethodMetadata[] staticMethodsMetadata;
        private final String sourceFile;

        Full(Klass definedClass, ClassFileMethod[] virtualMethods, ClassFileMethod[] staticMethods, ClassFileField[] instanceFields, ClassFileField[] staticFields, String sourceFile, int vtableSize, int stableSize) {
            super(definedClass);
            SquawkVector types = new SquawkVector();
            this.symbols = SymbolParser.createSymbols(virtualMethods, staticMethods, instanceFields, staticFields, types);
            this.sourceFile = sourceFile;
            this.virtualMethodsMetadata = new MethodMetadata[vtableSize];
            this.staticMethodsMetadata = new MethodMetadata[stableSize];
            this.classTable = new Klass[types.size()];
            types.copyInto(this.classTable);
        }

        Full(Klass definedClass, byte[] symbols, Klass[] classTable, String srcFile, MethodMetadata[] virtualMethodsMetadata, MethodMetadata[] staticMethodsMetadata) {
            super(definedClass, symbols, classTable);
            this.sourceFile = srcFile;
            this.staticMethodsMetadata = staticMethodsMetadata;
            this.virtualMethodsMetadata = virtualMethodsMetadata;
        }

        final String getSourceFileName() {
            return this.sourceFile;
        }

        final MethodMetadata[] geMethodMetadata(boolean isStatic) {
            return isStatic ? this.staticMethodsMetadata : this.virtualMethodsMetadata;
        }

        final void setMethodMetadata(boolean isStatic, int index, MethodMetadata metadata) {
            if (metadata != null) {
                if (isStatic) {
                    this.staticMethodsMetadata[index] = metadata;
                } else {
                    this.virtualMethodsMetadata[index] = metadata;
                }
            }
        }
    }
}

