/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectMemory;
import com.sun.squawk.ObjectMemoryEndianessSwapper;
import com.sun.squawk.ObjectMemoryFile;
import com.sun.squawk.ObjectMemoryReader;
import com.sun.squawk.VM;
import com.sun.squawk.pragma.HostedPragma;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.BitSet;
import com.sun.squawk.util.StringTokenizer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;

public class ObjectMemoryLoader {
    final ObjectMemoryReader reader;
    private final boolean loadIntoReadOnlyMemory;
    private boolean requiresEndianSwap;
    private boolean tracing;
    static String filePathelements;

    protected int getHash(byte[] arr) {
        return ObjectMemoryLoader.hash(arr);
    }

    public static int hash(byte[] arr) {
        int hash = arr.length;
        for (int i = 0; i != arr.length; ++i) {
            hash += arr[i];
        }
        return hash;
    }

    ObjectMemoryLoader(ObjectMemoryReader reader, boolean loadIntoReadOnlyMemory) {
        this.reader = reader;
        this.loadIntoReadOnlyMemory = loadIntoReadOnlyMemory;
    }

    public static ObjectMemoryFile loadHeader(DataInputStream dis, String uri) {
        return ObjectMemoryLoader.load0(dis, uri, false, true);
    }

    public static ObjectMemoryFile load(DataInputStream dis, String uri, boolean loadIntoReadOnlyMemory) {
        try {
            return ObjectMemoryLoader.load0(dis, uri, loadIntoReadOnlyMemory, false);
        }
        catch (ObjectMemory.GCDuringRelocationError e) {
            throw new OutOfMemoryError("garbage collection occured while loading object memory from " + uri);
        }
    }

    public static ObjectMemoryFile load(String uri, boolean loadIntoReadOnlyMemory) throws IOException {
        String url = VM.isHosted() ? ObjectMemoryLoader.convertURIHosted(uri) : uri;
        if (url.startsWith("file://") && filePathelements != null) {
            url = url + ";" + filePathelements;
        }
        try {
            DataInputStream dis = Connector.openDataInputStream(url);
            ObjectMemoryFile result = ObjectMemoryLoader.load(dis, uri, loadIntoReadOnlyMemory);
            dis.close();
            return result;
        }
        catch (ConnectionNotFoundException e) {
            System.out.println("filePathelements=" + filePathelements);
            throw e;
        }
    }

    private static ObjectMemoryFile load0(DataInputStream dis, String uri, boolean loadIntoReadOnlyMemory, boolean headerOnly) {
        ObjectMemoryReader reader = new ObjectMemoryReader(dis, uri);
        ObjectMemoryLoader loader = new ObjectMemoryLoader(reader, loadIntoReadOnlyMemory);
        ObjectMemoryFile omf = loader.load(headerOnly);
        if (VM.isVerbose()) {
            VM.print("[loaded object memory from '");
            VM.print(uri);
            VM.println("']");
        }
        if (loadIntoReadOnlyMemory) {
            GC.registerReadOnlyObjectMemory(omf.objectMemory);
        }
        return omf;
    }

    private ObjectMemoryFile load(boolean headerOnly) {
        ObjectMemory parent;
        boolean isBigEndian;
        int magic = this.reader.readInt("magic");
        if (magic != -559038737) {
            throw new Error("invalid magic file identifier: expected 0xdeadbeef, received 0x" + Integer.toHexString(magic));
        }
        int minor = this.reader.readShort("minor_version");
        int major = this.reader.readShort("major_version");
        int attributes = this.reader.readInt("attributes");
        boolean hasTypemap = (attributes & 1) != 0;
        boolean is32Bit = (attributes & 2) != 0;
        boolean bl = isBigEndian = (attributes & 4) != 0;
        if (!is32Bit) {
            throw new Error("invalid word size in object memory: expected " + (is32Bit ? "32 bit" : "64 bit") + ", received " + (is32Bit ? "64 bit" : "32 bit"));
        }
        this.requiresEndianSwap = VM.isBigEndian() != isBigEndian;
        int parentHash = this.reader.readInt("parent_hash");
        String parentURI = this.reader.readUTF("parent_uri");
        if (headerOnly) {
            return new ObjectMemoryFile(minor, major, attributes, parentHash, parentURI, null);
        }
        if (parentURI.length() == 0) {
            Assert.always(VM.isHosted(), "ObjectMemoryLoader.java", 342);
            parent = null;
        } else {
            parent = this.loadParent(parentHash, parentURI);
        }
        ObjectMemory om = this.loadThis(parent, hasTypemap);
        return new ObjectMemoryFile(minor, major, attributes, parentHash, parentURI, om);
    }

    static int getUTF8Length(String s) {
        OutputStreamSink oss = new OutputStreamSink();
        DataOutputStream dos = new DataOutputStream(oss);
        try {
            dos.writeUTF(s);
        }
        catch (IOException ioe) {
            Assert.shouldNotReachHere("ObjectMemoryLoader.java", 387);
        }
        return oss.getLength();
    }

    static int calculateMemoryPadding(String parentURI, int memorySize) {
        int sizeSoFar = 16 + ObjectMemoryLoader.getUTF8Length(parentURI) + 4 + 4 + GC.calculateOopMapSizeInBytes(memorySize);
        int pad = sizeSoFar % 4;
        if (pad != 0) {
            pad = 4 - pad;
        }
        return pad;
    }

    protected void skipMemoryPadding(String parentURI, int memorySize) {
        int pad = ObjectMemoryLoader.calculateMemoryPadding(parentURI, memorySize);
        this.reader.skip(pad, "padding");
    }

    private ObjectMemory loadThis(ObjectMemory parent, boolean hasTypemap) {
        String url = this.reader.getFileName();
        int root = this.reader.readInt("root");
        int size = this.reader.readInt("size");
        BitSet oopMap = this.loadOopMap(size);
        this.skipMemoryPadding(parent == null ? "" : parent.getURI(), size);
        byte[] buffer = this.loadMemory(size);
        int hash = this.getHash(buffer);
        if (!VM.isHosted()) {
            VM.collectGarbage(true);
        }
        Address relocatedBuffer = this.relocateMemory(parent, buffer, oopMap);
        if (!VM.isHosted() && !this.loadIntoReadOnlyMemory && buffer != relocatedBuffer.toObject()) {
            throw new ObjectMemory.GCDuringRelocationError();
        }
        Object rootObject = relocatedBuffer.add(root).toObject();
        if (hasTypemap) {
            // empty if block
        }
        ObjectMemory om = new ObjectMemory(relocatedBuffer, size, url, rootObject, hash, parent);
        return om;
    }

    public static void addFilePath(String path) {
        if (path == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        if (filePathelements != null) {
            buffer.append(filePathelements);
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "" + VM.getPathSeparatorChar());
        while (tokenizer.hasMoreTokens()) {
            if (buffer.length() > 0) {
                buffer.append(';');
            }
            buffer.append("pathelement=");
            buffer.append(tokenizer.nextToken());
        }
        filePathelements = buffer.toString();
    }

    public static void setFilePath(String path) {
        if (path == null) {
            filePathelements = null;
            return;
        }
        StringBuffer buffer = new StringBuffer(path.length());
        StringTokenizer tokenizer = new StringTokenizer(path, "" + VM.getPathSeparatorChar());
        while (tokenizer.hasMoreTokens()) {
            if (buffer.length() > 0) {
                buffer.append(';');
            }
            buffer.append("pathelement=");
            buffer.append(tokenizer.nextToken());
        }
        filePathelements = buffer.toString();
    }

    private static String convertURIHosted(String uri) throws HostedPragma {
        String result = uri;
        if (uri.equals("memory:bootstrap") && (result = System.getProperty("bootstrap.suite.url")) == null) {
            result = "file://squawk.suite";
        }
        return result;
    }

    private ObjectMemory loadParent(int hash, String uri) {
        ObjectMemory parent = GC.lookupReadOnlyObjectMemoryBySourceURI(uri);
        if (parent == null) {
            try {
                parent = ObjectMemoryLoader.load((String)uri, (boolean)this.loadIntoReadOnlyMemory).objectMemory;
            }
            catch (IOException e) {
                throw new Error("IO error loading object memory from '" + uri + "': " + e);
            }
        }
        if (parent.getHash() != hash) {
            String helpText = "";
            throw new Error(helpText + "invalid hash for parent (" + parent.getURI() + "): expected " + hash + ", received " + parent.getHash());
        }
        return parent;
    }

    protected BitSet loadOopMap(int size) {
        byte[] bits = new byte[GC.calculateOopMapSizeInBytes(size)];
        this.reader.readFully(bits, "oopmap");
        BitSet oopMap = new BitSet(bits);
        return oopMap;
    }

    protected byte[] loadMemory(int size) {
        byte[] buffer = new byte[size];
        this.reader.readFully(buffer, "memory");
        return buffer;
    }

    protected Address relocateMemory(ObjectMemory parent, byte[] buffer, BitSet oopMap) {
        Address relocatedBufferAddress;
        Address canonicalStart;
        String url = this.reader.getFileName();
        int size = buffer.length;
        Address address = canonicalStart = parent == null ? Address.zero() : parent.getCanonicalEnd();
        if (VM.isHosted()) {
            NativeUnsafe.initialize(buffer, oopMap, parent != null);
        }
        Address bufferAddress = VM.isHosted() ? canonicalStart : Address.fromObject(buffer);
        Address address2 = relocatedBufferAddress = this.loadIntoReadOnlyMemory ? GC.allocateNvmBuffer(size) : bufferAddress;
        if (VM.isHosted() || this.loadIntoReadOnlyMemory) {
            buffer = null;
        }
        ObjectMemory.relocateParents(url, buffer, bufferAddress, oopMap, parent, false, this.requiresEndianSwap, this.tracing);
        ObjectMemory.relocate(url, buffer, bufferAddress, oopMap, relocatedBufferAddress, canonicalStart, size, false, this.requiresEndianSwap, this.tracing, true);
        Assert.always(oopMap.cardinality() == 0, "some pointers were not relocated", "ObjectMemoryLoader.java", 658);
        if (this.requiresEndianSwap) {
            ObjectMemory om = new ObjectMemory(bufferAddress, size, "", null, 0, parent);
            ObjectMemoryEndianessSwapper.swap(om, true, false);
        }
        if (this.loadIntoReadOnlyMemory) {
            VM.copyBytes(bufferAddress, 0, relocatedBufferAddress, 0, size, true);
        }
        if (!this.loadIntoReadOnlyMemory && !VM.isHosted()) {
            GC.setHeaderLength(Address.fromObject(buffer), 0);
        }
        return relocatedBufferAddress;
    }

    static final class OutputStreamSink
    extends OutputStream {
        private int length;

        OutputStreamSink() {
        }

        public int getLength() {
            return this.length;
        }

        public void write(int b) throws IOException {
            ++this.length;
        }
    }
}

