/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.UWord;
import com.sun.squawk.pragma.HostedPragma;
import com.sun.squawk.pragma.NativePragma;
import com.sun.squawk.util.IntHashtable;

public final class Offset {
    private final int value;
    private static IntHashtable pool;

    public static Offset fromPrimitive(int value) throws NativePragma {
        return Offset.get(value);
    }

    public int toPrimitive() throws NativePragma {
        return this.value;
    }

    public int toInt() throws NativePragma {
        return this.value;
    }

    public UWord toUWord() throws NativePragma {
        return UWord.fromPrimitive(this.value);
    }

    public static Offset zero() throws NativePragma {
        return Offset.get(0);
    }

    public Offset add(int delta) throws NativePragma {
        return Offset.get(this.value + delta);
    }

    public Offset sub(int delta) throws NativePragma {
        return Offset.get(this.value - delta);
    }

    public Offset wordsToBytes() throws NativePragma {
        return Offset.get(this.value << 2);
    }

    public Offset bytesToWords() throws NativePragma {
        return Offset.get(this.value >> 2);
    }

    public boolean isZero() throws NativePragma {
        return this == Offset.zero();
    }

    public boolean eq(Offset offset2) throws NativePragma {
        return this == offset2;
    }

    public boolean ne(Offset offset2) throws NativePragma {
        return this != offset2;
    }

    public boolean lt(Offset offset2) throws NativePragma {
        return this.value < offset2.value;
    }

    public boolean le(Offset offset2) throws NativePragma {
        return this == offset2 || this.lt(offset2);
    }

    public boolean gt(Offset offset2) throws NativePragma {
        return offset2.lt(this);
    }

    public boolean ge(Offset offset2) throws NativePragma {
        return offset2.le(this);
    }

    public int hashCode() throws HostedPragma {
        return this.value;
    }

    public String toString() throws HostedPragma {
        return "" + this.value;
    }

    private static Offset get(int value) throws HostedPragma {
        Offset instance;
        if (pool == null) {
            pool = new IntHashtable();
        }
        if ((instance = (Offset)pool.get(value)) == null) {
            instance = new Offset(value);
            try {
                pool.put(value, instance);
            }
            catch (OutOfMemoryError e) {
                throw new OutOfMemoryError("Failed to grow instance pool when adding " + value);
            }
        }
        return instance;
    }

    private Offset(int value) throws HostedPragma {
        this.value = value;
    }
}

