/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

public final class ResourceFile {
    public final String name;
    public byte[] data;
    protected boolean isNew;
    protected boolean isPersistent;
    protected int length;

    public ResourceFile(String name, boolean isPersistent) {
        this.name = name;
        this.data = new byte[0];
        this.isPersistent = isPersistent;
        this.isNew = true;
    }

    public ResourceFile(String name, byte[] data) {
        this.name = name;
        this.data = data;
        this.isNew = false;
        this.length = data.length;
    }

    public void close() {
        if (!this.isNew) {
            return;
        }
        if (this.data.length == this.length) {
            return;
        }
        byte[] newData = new byte[this.length];
        System.arraycopy(this.data, 0, newData, 0, this.length);
        this.data = newData;
    }

    public byte[] getData() {
        return this.data;
    }

    public void write(int index, byte byt) {
        if (!this.isNew) {
            throw new RuntimeException("Cannot write to a file resource that is not new");
        }
        if (index >= this.data.length) {
            byte[] newData = new byte[this.data.length + 1024];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[index] = byt;
        if (index >= this.length) {
            this.length = index + 1;
        }
    }
}

