/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Concrete1;
import com.sun.squawk.GC;
import com.sun.squawk.Klass;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.Ref;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Vector;

public class Test {
    private static int two;
    static int x39count;
    static int x40count;
    static int x45count;
    static int threadcounter;
    static WeakReference[] permRefs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.print("Running: com.sun.squawk.Test");
        for (int i = 0; i < args.length; ++i) {
            System.out.print(" " + args[i]);
        }
        System.out.println();
        try {
            Test.runXTests();
        }
        finally {
            System.out.println("runXTests() returned!");
        }
    }

    public static void runXTests() {
        two = 2;
        Test.x2_1();
        Test.x2_2();
        Test.x2_3();
        Test.x2_4();
        Test.x2_5();
        Test.x2_6();
        Test.x2_7();
        Test.x2_8();
        Test.x3();
        Test.x4();
        Test.x5(2);
        Test.x6(2);
        Test.x7(2);
        Test.x8(2);
        Test.x9(2);
        Test.x10();
        Test.x11();
        Test.x12();
        Test.x13();
        Test.x14();
        Test.x15();
        Test.x16();
        Test.x20();
        Test.x30();
        Test.x31();
        Test.x32();
        Test.x33();
        Test.x34();
        Test.x35();
        Test.x36();
        Test.x37();
        Test.x38();
        Test.x39();
        Test.x40();
        Test.x41(null, 123);
        Test.x42();
        Test.x43();
        Test.x44();
        Test.x45();
        Test.x47();
        Test.x48();
        Test.x49();
        Test.x50();
        Test.x51();
        Test.x52();
        Test.randomTimeTest();
        VMThread.yield();
        VM.print("Finished tests\n");
        System.exit(12345);
    }

    static void passed(String name) {
        if (VM.isVerbose()) {
            VM.print("Test ");
            VM.print(name);
            VM.print(" passed\n");
        }
    }

    static void failed(String name) {
        VM.print("Test ");
        VM.print(name);
        VM.print(" failed\n");
        System.exit(54321);
    }

    static void result(String name, boolean b) {
        if (b) {
            Test.passed(name);
        } else {
            Test.failed(name);
        }
    }

    static void x2_1() {
        Test.result("x2_1", Integer.toString(2).equals("2"));
    }

    static void x2_2() {
        Test.result("x2_2", Long.toString(2L).equals("2"));
    }

    static void x2_3() {
        Test.result("x2_3", String.valueOf(true).equals("true"));
    }

    static void x2_4() {
        Test.result("x2_4", String.valueOf('2').equals("2"));
    }

    static void x2_5() {
        Test.result("x2_5", Double.toString(2.0).equals("2.0"));
    }

    static void x2_6() {
        Test.result("x2_6", Float.toString(2.0f).equals("2.0"));
    }

    static void x2_7() {
        Test.result("x2_7", Double.toString(12345.0).equals("12345.0"));
    }

    static void x2_8() {
        Test.result("x2_8", Float.toString(12345.0f).equals("12345.0"));
    }

    static void x3() {
        int four = 4;
        Test.result("x3", -four == -4);
    }

    static void x4() {
        Test.passed("x4");
    }

    static void x5(int n) {
        boolean res = false;
        if (n == 2) {
            res = true;
        }
        Test.result("x5", res);
    }

    static void x6(int n) {
        Test.result("x5", n == 2);
    }

    static void x7(int n) {
        Test.result("x7", 5 + n == 7);
    }

    static void x8(int n) {
        Test.result("x8", 5 * n == 10);
    }

    static void x9(int n) {
        Test.result("x9", -5 * n == -10);
    }

    static void x10() {
        Test.result("x10", -5 * two == -10);
    }

    static void x11() {
        for (int i = 0; i < 10; ++i) {
            VM.collectGarbage(false);
        }
        Test.passed("x11");
    }

    static void x12() {
        Test.result("x12", Test.fib(20) == 10946);
    }

    public static int fib(int n) {
        if (n == 0) {
            VM.collectGarbage(false);
        }
        if (n < 2) {
            return 1;
        }
        int x = Test.fib(n / 2 - 1);
        int y = Test.fib(n / 2);
        if (n % 2 == 0) {
            return x * x + y * y;
        }
        return (x + x + y) * y;
    }

    static void x13() {
        Test.result("x13", !(null instanceof Test));
    }

    static void x14() {
        Test.result("x14", "a string" instanceof String);
    }

    static void x15() {
        boolean res = true;
        try {
            Klass c = null;
        }
        catch (Throwable t) {
            res = false;
        }
        Test.result("x15", res);
    }

    static void x16() {
        boolean res = true;
        try {
            (new String[3])[1] = null;
        }
        catch (Throwable t) {
            res = false;
        }
        Test.result("x16", res);
    }

    static void x20() {
        Test t = new Test();
        Test.result("x20", t != null);
    }

    static void x30() {
        Object[] o = new Object[1];
        Test.result("x30", o != null);
    }

    static void x31() {
        Object[] o;
        o[0] = o = new Object[1];
        Test.result("x31", o[0] == o);
    }

    static void x32() {
        Object[] o1 = new Object[1];
        Object[] o2 = new Object[1];
        o1[0] = o1;
        System.arraycopy(o1, 0, o2, 0, 1);
        Test.result("x32", o2[0] == o1);
    }

    static void x33() {
        Object[] o1 = new Object[2];
        Object[] o2 = new Object[2];
        o1[0] = o1;
        o1[1] = o2;
        System.arraycopy(o1, 0, o2, 0, 2);
        Test.result("x33", o2[0] == o1 && o2[1] == o2);
    }

    static void x34() {
        Object[] o1 = new Object[2];
        String[] o2 = new String[2];
        o1[0] = "Hello";
        o1[1] = "World";
        System.arraycopy(o1, 0, o2, 0, 2);
        Test.result("x34", o2[0].equals("Hello") && o2[1].equals("World"));
    }

    static void x35() {
        Throwable o = new Throwable();
        Test.result("x35", o != null);
    }

    static void x36() {
        long l = 255L;
        int i = 255;
        Test.result("x36", l << 32 == 0xFF00000000L && (long)i << 32 == 0xFF00000000L);
    }

    static void x37() {
        byte[] o1 = new byte[2];
        o1[0] = -3;
        Test.result("x37", o1[0] == -3 && o1[1] == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void x38() {
        Object x = null;
        Object o = new Object();
        Vector v1 = new Vector();
        v1.addElement(v1);
        Vector v2 = new Vector();
        v2.addElement(v2);
        for (int i = 0; i < 1000; ++i) {
            Object object = o;
            synchronized (object) {
                Vector vector = v2;
                synchronized (vector) {
                    x = v1.elementAt(0);
                }
                vector = v1;
                synchronized (vector) {
                    x = v2.elementAt(0);
                }
            }
        }
        Test.result("x38", true);
    }

    static void x39() {
        boolean res = false;
        try {
            Test.x39prim();
        }
        catch (OutOfMemoryError ex) {
            res = true;
            System.out.println("x39 count = " + x39count);
        }
        Test.result("x39", res && x39count == 1);
    }

    static void x39prim() {
        System.gc();
        int freeWords = (int)GC.freeMemory() / 4;
        int length = freeWords / 2;
        Object[] last = new Object[length];
        while (true) {
            ++x39count;
            Object[] next = new Object[length];
            next[0] = last;
            last = next;
        }
    }

    static void x40() {
        boolean res = false;
        try {
            Test.recursiveCall();
        }
        catch (OutOfMemoryError ex) {
            res = true;
            System.out.println("x40 recursion level = " + x40count);
        }
        Test.result("x40", res);
    }

    static void recursiveCall() {
        ++x40count;
        Test.recursiveCall();
    }

    static void x41(Object obj, int val) {
        switch (val) {
            default: 
        }
        if (++val == 123) {
            Test.x41(obj, 3);
        }
        Test.result("x41", true);
    }

    static void x42() {
        int res = 0;
        FOO foo = new FOO();
        Throwable thro = null;
        try {
            foo.foo(123L, 456L);
        }
        catch (ClassCastException ex) {
            thro = ex;
            res = 1;
        }
        catch (Exception ex) {
            thro = ex;
            res = 2;
        }
        catch (Error ex) {
            thro = ex;
            res = 3;
        }
        if (thro != null) {
            System.out.println("x42 printStackTrace - this should be a java.lang.NullPointerException");
            thro.printStackTrace();
        }
        Test.result("x42", res == 2);
    }

    static void x43() {
        try {
            throw new Throwable("foo");
        }
        catch (Throwable throwable) {
            Test.result("x43", true);
            return;
        }
    }

    static void x44() {
        Object arr = null;
        if (arr != null) {
            arr[0].concat("should not reach here");
        }
        Test.result("x44", true);
    }

    static void x45() {
        VMThread t;
        for (int i = 0; i != 200 && (t = Test.x45Thread(i)) != null; ++i) {
            try {
                t.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (x45count != 200) {
            System.out.println("x45 count = " + x45count);
        }
        Test.result("x45", x45count == 200);
    }

    static VMThread x45Thread(int stackSize) {
        try {
            Thread r = new Thread("x45Thread-" + threadcounter++){

                public void run() {
                    this.f();
                }

                private void f() {
                    ++x45count;
                }
            };
            VMThread t = VMThread.asVMThread(r);
            NativeUnsafe.setInt(t, 4, Math.max(stackSize, 78));
            r.start();
            return t;
        }
        catch (OutOfMemoryError e) {
            System.out.println("x45 out of memory creating/starting thread with stack size = " + stackSize);
            return null;
        }
    }

    static void x46Prim(int stackSize) {
        Thread r = new Thread(){

            public void run() {
            }
        };
        VMThread t = VMThread.asVMThread(r);
        NativeUnsafe.setInt(t, 4, Math.max(stackSize, 78));
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void x46() {
        int delta = -50;
        while (true) {
            int stackSize = 0;
            try {
                VM.collectGarbage(false);
                stackSize = (int)GC.freeMemory() / 4 + delta;
                Test.x46Prim(stackSize);
                if (VM.isVerbose()) {
                    VM.print("stackSize = ");
                    VM.println(stackSize);
                }
                ++delta;
            }
            catch (OutOfMemoryError oome) {
                Test.result("x46", true);
                return;
            }
        }
    }

    static void randomTimeTest() {
        long start = System.currentTimeMillis();
        long iterations = start & 0xFFL;
        iterations = iterations * iterations * iterations;
        VM.print("random time test (" + iterations + " empty loop iterations)... ");
        while (iterations-- > 0L) {
            --iterations;
        }
        VM.println(System.currentTimeMillis() - start + "ms");
    }

    static void x47() {
        System.gc();
        int initialRefs = Test.x47countRefs();
        boolean result = Test.x47Prim();
        System.gc();
        result = result && Test.x47countRefs() - initialRefs == 2;
        permRefs = null;
        System.gc();
        result = result && Test.x47countRefs() - initialRefs == 0;
        Test.result("x47", result);
    }

    static int x47countRefs() {
        Ref ref = GC.getCollector().references;
        int count = 0;
        while (ref != null) {
            ref = ref.next;
            ++count;
        }
        return count;
    }

    static boolean x47Prim() {
        String C = new String("C");
        String F = new String("F");
        WeakReference refA = new WeakReference(new String("A"));
        WeakReference refB = new WeakReference("B");
        WeakReference refC = new WeakReference(C);
        WeakReference refD = new WeakReference(new String("D"));
        WeakReference refE = new WeakReference("E");
        WeakReference refF = new WeakReference(F);
        System.gc();
        VMThread.yield();
        if (refA.get() != null) {
            return false;
        }
        if (refB.get() == null) {
            return false;
        }
        if (refC.get() == null) {
            return false;
        }
        if (refD.get() != null) {
            return false;
        }
        if (refE.get() == null) {
            return false;
        }
        if (refF.get() == null) {
            return false;
        }
        permRefs = new WeakReference[]{refB, refE};
        return true;
    }

    static void x48() {
        System.gc();
        int freeWords = ((int)GC.freeMemory() - 8) / 4;
        Object[] obj = new Object[freeWords - 4];
        for (int i = 0; i != 3; ++i) {
            Object object = new Object();
        }
        Test.result("x48", true);
    }

    static void x49() {
        System.out.println("Date: " + new Date());
        Test.result("x49", true);
    }

    static void testEmptyLoop(int len) {
        int COUNT = 1000000;
        int sum = 0;
        for (int i = 0; i < 1000000; ++i) {
            for (int j = 0; j < len; ++j) {
                sum += 3;
            }
        }
    }

    static void callInt(int i) {
    }

    static void callLong(long l) {
    }

    static void callException(int x) {
        if (x == 789632476) {
            try {
                if (x != Integer.parseInt(Integer.toString(x))) {
                    throw new RuntimeException("It didn't happen");
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
    }

    static void x50() {
        int i;
        int COUNT = 1000000;
        int len = 16;
        int sum = 0;
        long start = System.currentTimeMillis();
        System.gc();
        System.gc();
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            for (int j = 0; j < 16; ++j) {
                sum += 3;
            }
        }
        long delta = System.currentTimeMillis() - start;
        System.out.println("Empty loop timings per 16000000 = " + delta + "ms");
        System.gc();
        start = System.currentTimeMillis();
        Test.testEmptyLoop(16);
        delta = System.currentTimeMillis() - start;
        System.out.println("Empty loop timings(2) per 16000000 = " + delta + "ms");
        System.gc();
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            Test.callInt(2);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("Empty simple call per 1000000 = " + delta + "ms");
        System.gc();
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            Test.callLong(2L);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("Empty long call per 1000000 = " + delta + "ms");
        System.gc();
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            Test.callException(2);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("Empty exception calls per 1000000 = " + delta + "ms");
    }

    static IDictionary getElements(boolean deepCopy) {
        IDictionary dictThis = null;
        dictThis = deepCopy ? new HD() : new AD();
        if (dictThis == null) {
            return null;
        }
        return dictThis;
    }

    static void x51() {
        Test.result("x51: getElements(true)", Test.getElements(true) instanceof IDictionary);
        Test.result("x51: getElements(false)", Test.getElements(false) instanceof IDictionary);
    }

    static void x52() {
        Concrete1 r = new Concrete1();
        r.run();
    }

    static {
        x40count = 0;
        threadcounter = 0;
    }

    static class AD
    implements IDictionary {
        AD() {
        }
    }

    static class HD
    implements IDictionary {
        HD() {
        }
    }

    public static interface IDictionary {
    }

    static class FOO {
        FOO xxx = null;

        FOO() {
        }

        int foo(long a, long b) {
            final FOO printme = this;
            new Runnable(){

                public void run() {
                    System.out.println("This will never print: " + printme.toString());
                }
            }.run();
            return (int)(a + b);
        }

        public String toString() {
            this.xxx.xxx();
            return "should never happen";
        }

        void xxx() {
        }

        protected void finalize() throws Throwable {
            System.out.println("FOO::finalize()");
        }
    }
}

