/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.cldc.jna.TaskExecutor;
import com.sun.squawk.Address;
import com.sun.squawk.CallbackManager;
import com.sun.squawk.Debugger;
import com.sun.squawk.ExecutionPoint;
import com.sun.squawk.GC;
import com.sun.squawk.GarbageCollector;
import com.sun.squawk.HitBreakpoint;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.Lisp2Bitmap;
import com.sun.squawk.Member;
import com.sun.squawk.MethodBody;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectMemory;
import com.sun.squawk.ObjectMemorySerializer;
import com.sun.squawk.Offset;
import com.sun.squawk.Ref;
import com.sun.squawk.ServiceOperation;
import com.sun.squawk.Suite;
import com.sun.squawk.UWord;
import com.sun.squawk.VMBufferDecoder;
import com.sun.squawk.VMThread;
import com.sun.squawk.io.mailboxes.Mailbox;
import com.sun.squawk.peripheral.PeripheralRegistry;
import com.sun.squawk.platform.SystemEvents;
import com.sun.squawk.pragma.AllowInlinedPragma;
import com.sun.squawk.pragma.GlobalStaticFields;
import com.sun.squawk.pragma.InterpreterInvokedPragma;
import com.sun.squawk.pragma.NotInlinedPragma;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.BitSet;
import com.sun.squawk.util.IntHashtable;
import com.sun.squawk.util.SquawkHashtable;
import com.sun.squawk.util.SquawkVector;
import com.sun.squawk.vm.Global;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class VM
implements GlobalStaticFields {
    private static Address romStart;
    private static Address romEnd;
    private static Address bootstrapStart;
    private static Address bootstrapEnd;
    private static int bootstrapHash;
    private static int verboseLevel;
    private static boolean synchronizationEnabled;
    private static boolean exceptionsEnabled;
    private static OutOfMemoryError outOfMemoryError;
    private static VMBufferDecoder vmbufferDecoder;
    private static Isolate currentIsolate;
    private static int nextHashcode;
    private static boolean allowUserGC;
    static boolean extendsEnabled;
    private static boolean usingTypeMap;
    private static Address argv;
    private static int argc;
    private static boolean isFirstIsolateInitialized;
    private static String isolateInitializer;
    private static SquawkHashtable registeredMailboxes;
    private static PeripheralRegistry peripheralRegistry;
    private static int reportedIndex;
    private static Object reportedArray;
    private static CallbackManager shutdownHooks;
    private static int throwCount;
    private static boolean safePrintToVM;
    private static Stack taskCache;
    private static int nextIsolateID;
    private static WeakIsolateListEntry isolates;
    private static Hashtable commandLineProperties;
    public static final int STREAM_STDOUT = 0;
    public static final int STREAM_STDERR = 1;
    static final int STREAM_SYMBOLS = 2;
    public static final int MAX_SYS_PRIORITY = 12;
    static boolean executingHooks;
    private static Object keyedGlobalsMutex;
    private static IntHashtable keyeGlobals;

    private VM() {
    }

    static void startup(Suite bootstrapSuite) throws InterpreterInvokedPragma {
        allowUserGC = true;
        GC.initialize(bootstrapSuite);
        vmbufferDecoder = new VMBufferDecoder();
        outOfMemoryError = new OutOfMemoryError();
        String[] args = new String[argc];
        currentIsolate = new Isolate("com.sun.squawk.JavaApplicationManager", args, bootstrapSuite);
        currentIsolate.initializeClassKlass();
        VMThread.initializeThreading();
        synchronizationEnabled = true;
        GC.copyCStringArray(argv, args);
        taskCache = new Stack();
        try {
            exceptionsEnabled = true;
            shutdownHooks = new CallbackManager(true);
            currentIsolate.primitiveThreadStart();
            VMThread.initializeThreading2();
            ServiceOperation.execute();
        }
        catch (Throwable ex) {
            VM.fatalVMError();
        }
    }

    static void undefinedNativeMethod(int id) throws InterpreterInvokedPragma {
        throw new Error("Undefined native method: " + id);
    }

    static void callRun() throws InterpreterInvokedPragma {
        VMThread.currentThread().callRun();
    }

    static Object getStaticOop(Klass klass, int offset) throws InterpreterInvokedPragma {
        Object ks = currentIsolate.getClassStateForStaticVariableAccess(klass, offset);
        return NativeUnsafe.getObject(ks, offset);
    }

    static int getStaticInt(Klass klass, int offset) throws InterpreterInvokedPragma {
        Object ks = currentIsolate.getClassStateForStaticVariableAccess(klass, offset);
        return NativeUnsafe.getUWord(ks, offset).toPrimitive();
    }

    static long getStaticLong(Klass klass, int offset) throws InterpreterInvokedPragma {
        Object ks = currentIsolate.getClassStateForStaticVariableAccess(klass, offset);
        return NativeUnsafe.getLongAtWord(ks, offset);
    }

    static void putStaticOop(Object value, Klass klass, int offset) throws InterpreterInvokedPragma {
        Object ks = currentIsolate.getClassStateForStaticVariableAccess(klass, offset);
        NativeUnsafe.setObject(ks, offset, value);
    }

    static void putStaticInt(int value, Klass klass, int offset) throws InterpreterInvokedPragma {
        Object ks = currentIsolate.getClassStateForStaticVariableAccess(klass, offset);
        NativeUnsafe.setUWord(ks, offset, UWord.fromPrimitive(value));
    }

    static void putStaticLong(long value, Klass klass, int offset) throws InterpreterInvokedPragma {
        Object ks = currentIsolate.getClassStateForStaticVariableAccess(klass, offset);
        NativeUnsafe.setLongAtWord(ks, offset, value);
    }

    static void yield() throws InterpreterInvokedPragma {
        VMThread.yield();
    }

    static void nullPointerException() throws InterpreterInvokedPragma {
        throw new NullPointerException();
    }

    static void arrayIndexOutOfBoundsException() throws InterpreterInvokedPragma {
        if (reportedArray != null) {
            Object array = reportedArray;
            reportedArray = null;
            throw new ArrayIndexOutOfBoundsException("on " + GC.getKlass(array).getInternalName() + " of length " + GC.getArrayLength(array) + " with index " + reportedIndex);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    static void arithmeticException() throws InterpreterInvokedPragma {
        throw new ArithmeticException();
    }

    static void abstractMethodError() throws InterpreterInvokedPragma {
        throw new Error("AbstractMethodError");
    }

    static void arrayOopStore(Object array, int index, Object value) throws InterpreterInvokedPragma {
        Klass arrayKlass = GC.getKlass(array);
        Klass componentType = arrayKlass.getComponentType();
        if (synchronizationEnabled && !componentType.isAssignableFrom(GC.getKlass(value))) {
            throw new ArrayStoreException();
        }
        NativeUnsafe.setObject(array, index, value);
    }

    static int findSlot(Object obj, Klass iklass, int islot) throws InterpreterInvokedPragma {
        throw new Error("AbstractMethodError");
    }

    static void monitorenter(Object oop) throws InterpreterInvokedPragma {
        if (synchronizationEnabled) {
            VMThread.monitorEnter(oop);
        }
    }

    static void monitorexit(Object oop) throws InterpreterInvokedPragma {
        if (synchronizationEnabled) {
            VMThread.monitorExit(oop);
        }
    }

    static boolean _instanceof(Object obj, Klass klass) throws InterpreterInvokedPragma {
        return klass.isAssignableFrom(GC.getKlass(obj));
    }

    static Object checkcast(Object obj, Klass klass) throws InterpreterInvokedPragma {
        if (!klass.isAssignableFrom(GC.getKlass(obj))) {
            VM.println("=== temp extra debugging info ===");
            VM.print("target class: ");
            VM.printAddress(klass);
            VM.println();
            Klass srcKlass = GC.getKlass(obj);
            VM.print("source class: ");
            VM.printAddress(srcKlass);
            VM.println();
            Klass[] interfaces = srcKlass.getInterfaces();
            if (interfaces != null) {
                VM.println("implements interfaces:");
                for (int i = 0; i < interfaces.length; ++i) {
                    VM.print("    ");
                    VM.print(interfaces[i].toString());
                    VM.print("    ");
                    VM.printAddress(interfaces[i]);
                    VM.println();
                }
            }
            throw new ClassCastException("Expected object of type " + klass + " but got object of type " + GC.getKlass(obj));
        }
        return obj;
    }

    static int lookup_b(int key, byte[] array) throws NotInlinedPragma {
        int low = 0;
        int high = array.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            byte val = array[mid];
            if (key < val) {
                high = mid - 1;
                continue;
            }
            if (key > val) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    static int lookup_s(int key, short[] array) throws NotInlinedPragma {
        int low = 0;
        int high = array.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            short val = array[mid];
            if (key < val) {
                high = mid - 1;
                continue;
            }
            if (key > val) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    static int lookup_i(int key, int[] array) throws NotInlinedPragma {
        int low = 0;
        int high = array.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int val = array[mid];
            if (key < val) {
                high = mid - 1;
                continue;
            }
            if (key > val) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    static void class_clinit(Klass klass) throws InterpreterInvokedPragma {
        klass.initialiseClass();
    }

    static Object _new(Klass klass) throws InterpreterInvokedPragma {
        klass.initialiseClass();
        return GC.newInstance(klass);
    }

    static Object newarray(int size, Klass klass) throws InterpreterInvokedPragma {
        return GC.newArray(klass, size);
    }

    static Object newdimension(Object[] array, int length) throws InterpreterInvokedPragma {
        return VM.newdimensionPrim(array, length);
    }

    static int _lcmp(long value1, long value2) throws InterpreterInvokedPragma {
        if (value1 > value2) {
            return 1;
        }
        if (value1 == value2) {
            return 0;
        }
        return -1;
    }

    static void reportException() throws Throwable, InterpreterInvokedPragma {
        VMThread thread = VMThread.currentThread();
        thread.reportException(VM.getCurrentIsolate().getDebugger());
    }

    static void reportBreakpoint(Offset hitFO, Offset hitBCI) throws InterpreterInvokedPragma {
        VMThread thread = VMThread.currentThread();
        Debugger debugger = VM.getCurrentIsolate().getDebugger();
        Assert.always(debugger != null, "VM.java", 743);
        try {
            thread.reportBreakpoint(hitFO, hitBCI, debugger);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static void reportStepEvent(Offset fo, Offset bci) throws InterpreterInvokedPragma {
        VMThread thread = VMThread.currentThread();
        thread.reportStepEvent(fo, bci);
    }

    private static Object newdimensionPrim(Object[] array, int length) {
        Klass arrayClass = GC.getKlass(array);
        Klass elementClass = arrayClass.getComponentType();
        if (length < 0) {
            throw new NegativeArraySizeException();
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                array[i] = GC.newArray(elementClass, length);
                continue;
            }
            VM.newdimensionPrim((Object[])array[i], length);
        }
        return array;
    }

    static int allocateIsolateID() {
        if (nextIsolateID < Integer.MAX_VALUE) {
            return nextIsolateID++;
        }
        VM.println("exhausted isolate identifiers");
        VM.fatalVMError();
        return -1;
    }

    static void registerIsolate(Isolate isolate) {
        if (isolates == null || !isolates.contains(isolate)) {
            isolates = new WeakIsolateListEntry(isolate, isolates);
        }
    }

    static void copyIsolatesInto(SquawkVector set) {
        VM.pruneIsolateList();
        isolates.copyInto(set);
    }

    static void pruneIsolateList() {
        Assert.always(isolates != null, "VM.java", 883);
        WeakIsolateListEntry head = null;
        WeakIsolateListEntry last = null;
        WeakIsolateListEntry entry = isolates;
        isolates = null;
        while (entry != null) {
            if (entry.get() != null) {
                if (head == null) {
                    head = last = entry;
                } else {
                    last.nextIsolateRef = entry;
                    last = entry;
                }
            }
            entry = entry.nextIsolateRef;
        }
        Assert.always(last != null, "VM.java", 913);
        last.nextIsolateRef = null;
        isolates = head;
    }

    static Hashtable getCommandLineProperties() {
        if (commandLineProperties == null) {
            commandLineProperties = new Hashtable();
        }
        return commandLineProperties;
    }

    public static ExecutionPoint[] reifyCurrentStack(int count) {
        if (!VMThread.currentThread().isAlive()) {
            return new ExecutionPoint[0];
        }
        return VM.reifyStack0(VMThread.currentThread(), VM.getFP(), count);
    }

    private static boolean insaneFP(Object stack, Address fp) {
        Offset fpOffset = fp.diff(Address.fromObject(stack));
        int size = GC.getArrayLengthNoCheck(stack) * 4;
        if (fpOffset.ge(Offset.zero()) && fpOffset.lt(Offset.fromPrimitive(size))) {
            return false;
        }
        VM.print("Illegal frame pointer during stack decoding: ");
        VM.print(fpOffset.toPrimitive());
        VM.println();
        return true;
    }

    private static ExecutionPoint[] reifyStack0(VMThread thread, Address fpBase, int count) {
        Object stack = thread.getStack();
        if (fpBase.isZero() || VM.insaneFP(stack, fpBase)) {
            return new ExecutionPoint[0];
        }
        Assert.always(stack != null, "VM.java", 1000);
        Offset fpBaseOffset = fpBase.diff(Address.fromObject(stack));
        int frames = 0;
        Address fp = fpBase;
        fp = VM.getPreviousFP(fp);
        while (!fp.isZero()) {
            ++frames;
            fp = VM.getPreviousFP(fp);
        }
        fpBase = Address.zero();
        fp = Address.zero();
        if (count >= 0 && count < frames) {
            frames = count;
        }
        if (frames <= 0) {
            return new ExecutionPoint[0];
        }
        ExecutionPoint[] trace = new ExecutionPoint[frames];
        fp = Address.fromObject(stack).addOffset(fpBaseOffset);
        for (int i = 0; i != frames; ++i) {
            Address ip = VM.getPreviousIP(fp);
            if (VM.insaneFP(stack, fp = VM.getPreviousFP(fp))) {
                return trace;
            }
            Object mp = VM.getMP(fp);
            Offset bci = ip.diff(Address.fromObject(mp));
            Offset fpOffset = fp.diff(Address.fromObject(stack));
            fp = Address.zero();
            trace[i] = new ExecutionPoint(fpOffset, bci, mp);
            fp = Address.fromObject(stack).addOffset(fpOffset);
        }
        return trace;
    }

    static ExecutionPoint[] reifyStack(VMThread thread, int count) {
        if (thread == VMThread.currentThread()) {
            return VM.reifyCurrentStack(count);
        }
        if (!thread.isAlive()) {
            return new ExecutionPoint[0];
        }
        Object stack = thread.getStack();
        Address fp = NativeUnsafe.getAddress(stack, 2);
        return VM.reifyStack0(thread, fp, count);
    }

    static void throwException(Throwable exception) {
        Object throwingStack = VMThread.getOtherThreadStack();
        VMThread throwingThread = VMThread.getOtherThread();
        if (exceptionsEnabled) {
            exceptionsEnabled = false;
        } else {
            Assert.shouldNotReachHere("do_throw called recursively", "VM.java", 1107);
        }
        ++throwCount;
        boolean oldState = GC.setAllocationEnabled(false);
        Klass exceptionKlass = GC.getKlass(exception);
        HitBreakpoint hbp = throwingThread.getHitBreakpoint();
        if (hbp != null && hbp.getState() == 5) {
            NativeUnsafe.setAddress(throwingStack, 2, throwingThread.frameOffsetAsPointer(hbp.catchFO));
            NativeUnsafe.setUWord(throwingStack, 3, hbp.catchBCI.toUWord());
            ServiceOperation.pendingException = exception;
            throwingThread.clearBreakpoint();
            exceptionsEnabled = true;
            GC.setAllocationEnabled(oldState);
            return;
        }
        Address fp = NativeUnsafe.getAddress(throwingStack, 2);
        UWord bci = NativeUnsafe.getUWord(throwingStack, 3);
        Object mp = VM.getMP(fp);
        Klass klass = (Klass)NativeUnsafe.getObject(mp, -3);
        Object throwMP = mp;
        Offset throwFO = throwingThread.framePointerAsOffset(fp);
        Offset throwBCI = NativeUnsafe.getUWord(throwingStack, 3).toOffset();
        throwBCI = throwBCI.sub(1);
        while (true) {
            int size = MethodBody.decodeExceptionTableSize(mp);
            int offset = MethodBody.decodeExceptionTableOffset(mp);
            vmbufferDecoder.reset(mp, offset);
            int end = offset + size;
            while (vmbufferDecoder.getOffset() < end) {
                Klass handlerKlass;
                UWord start_bci = UWord.fromPrimitive(vmbufferDecoder.readUnsignedInt());
                UWord end_bci = UWord.fromPrimitive(vmbufferDecoder.readUnsignedInt());
                UWord handler_bci = UWord.fromPrimitive(vmbufferDecoder.readUnsignedInt());
                int handler = vmbufferDecoder.readUnsignedShort();
                if (!bci.hi(start_bci) || !bci.loeq(end_bci) || exceptionKlass != (handlerKlass = (Klass)klass.getObject(handler)) && handlerKlass != Klass.THROWABLE && !handlerKlass.isAssignableFrom(exceptionKlass)) continue;
                GC.setAllocationEnabled(oldState);
                exceptionsEnabled = true;
                if (VM.isThreadingInitialized() && exception != outOfMemoryError && hbp == null && VM.getCurrentIsolate().getDebugger() != null) {
                    throwingThread.recordExceptionToReport(throwFO, throwBCI, exception, throwingThread.framePointerAsOffset(fp), handler_bci.toOffset());
                    ServiceOperation.pendingException = null;
                    return;
                }
                NativeUnsafe.setAddress(throwingStack, 2, fp);
                NativeUnsafe.setUWord(throwingStack, 3, handler_bci);
                return;
            }
            Address ip = VM.getPreviousIP(fp);
            fp = VM.getPreviousFP(fp);
            mp = VM.getMP(fp);
            klass = (Klass)NativeUnsafe.getObject(mp, -3);
            bci = ip.diff(Address.fromObject(mp)).toUWord();
        }
    }

    public static native double math(int var0, double var1, double var3);

    public static native int floatToIntBits(float var0);

    public static native long doubleToLongBits(double var0);

    public static native float intBitsToFloat(int var0);

    public static native double longBitsToDouble(long var0);

    public static boolean isHosted() throws AllowInlinedPragma {
        return false;
    }

    public static native boolean isBigEndian();

    public static void setProperty(String name, String value) {
        Isolate.currentIsolate().setProperty(name, value);
    }

    static native Address getFP();

    static native Object getMP(Address var0);

    static native Address getPreviousFP(Address var0) throws AllowInlinedPragma;

    static native Address getPreviousIP(Address var0) throws AllowInlinedPragma;

    static native void setPreviousFP(Address var0, Address var1);

    static native void setPreviousIP(Address var0, Address var1);

    static native Klass asKlass(Object var0);

    static native int hashcode(Object var0);

    static native void addToClassStateCache(Klass var0, Object var1);

    static native boolean invalidateClassStateCache();

    static native Object removeVirtualMonitorObject();

    static native boolean hasVirtualMonitorObject(Object var0);

    static Klass asKlass(Address object) {
        return VM.asKlass(object.toObject());
    }

    static native int getGlobalIntCount();

    static native int getGlobalInt(int var0);

    static native void setGlobalInt(int var0, int var1);

    static native int getGlobalAddrCount();

    static native Address getGlobalAddr(int var0);

    static native void setGlobalAddr(Address var0, int var1);

    static native int getGlobalOopCount();

    static native Object getGlobalOop(int var0);

    static native void setGlobalOop(Object var0, int var1);

    static native Address getGlobalOopTable();

    public static int setStream(int stream) {
        Assert.always(stream >= 0 && stream <= 2, "invalid stream specifier", "VM.java", 1649);
        return VM.setStream0(stream);
    }

    private static int setStream0(int stream) {
        return VM.execSyncIO(1000, stream);
    }

    static void printChar(char ch) {
        VM.execSyncIO(1002, ch);
    }

    static void printInt(int val) {
        VM.execSyncIO(1004, val);
    }

    static void printLong(long val) {
        int i1 = (int)(val >>> 32);
        int i2 = (int)val;
        VM.execSyncIO(1009, i1, i2);
    }

    public static void printUWord(UWord val) {
        int i1 = val.toPrimitive() >> 32;
        int i2 = val.toPrimitive();
        VM.execSyncIO(1007, i1, i2);
    }

    public static void printOffset(Offset val) {
        int i1 = val.toPrimitive() >> 32;
        int i2 = val.toPrimitive();
        VM.execSyncIO(1008, i1, i2);
    }

    static void printString(String str) {
        VM.executeCIO(-1, 1003, -1, 0, 0, 0, 0, 0, 0, str, null);
    }

    static void printFloat(float val) {
        VM.execSyncIO(1005, (int)val);
    }

    static void printDouble(double dval) {
        long val = (long)dval;
        int i1 = (int)(val >>> 32);
        int i2 = (int)val;
        VM.execSyncIO(1006, i1, i2);
    }

    public static void printAddress(Object val) {
        VM.executeCIO(-1, 1010, -1, 0, 0, 0, 0, 0, 0, val, null);
    }

    public static void printAddress(Address val) {
        VM.printAddress(val.toObject());
    }

    public static void printBytes(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        VM.executeCIO(-1, 1015, -1, off, len, 0, 0, 0, 0, b, null);
    }

    static void printGlobalOopName(int index) {
        VM.execSyncIO(1017, index);
    }

    static void printGlobals() {
        VM.execSyncIO(1018, 0);
    }

    static void printConfiguration() {
        VM.execSyncIO(1016, 0);
    }

    public static void printObject(Object obj) {
        VM.print(String.valueOf(obj));
    }

    public static void print(char x) {
        VM.printChar(x);
    }

    public static void print(String x) {
        VM.printString(x);
    }

    public static void print(int x) {
        VM.printInt(x);
    }

    public static void print(long x) {
        VM.printLong(x);
    }

    public static void print(float x) {
        VM.printFloat(x);
    }

    public static void print(double x) {
        VM.printDouble(x);
    }

    public static void print(boolean b) throws NotInlinedPragma {
        VM.print(b ? "true" : "false");
    }

    public static void println(char x) {
        VM.printChar(x);
        VM.println();
    }

    public static void println(String x) throws NotInlinedPragma {
        VM.printString(x);
        VM.println();
    }

    public static void println(int x) throws NotInlinedPragma {
        VM.printInt(x);
        VM.println();
    }

    public static void println(boolean x) throws NotInlinedPragma {
        VM.print(x);
        VM.println();
    }

    public static void println(long x) throws NotInlinedPragma {
        VM.printLong(x);
        VM.println();
    }

    public static void println(float x) throws NotInlinedPragma {
        VM.printFloat(x);
        VM.println();
    }

    public static void println(double x) throws NotInlinedPragma {
        VM.printDouble(x);
        VM.println();
    }

    public static void println() throws NotInlinedPragma {
        VM.print("\n");
    }

    public static native void finalize(Object var0);

    static void undefinedNativeMethod() {
        throw new Error("Undefined native method");
    }

    public static Address getRomStart() {
        return romStart;
    }

    static Address getRomEnd() {
        return romEnd;
    }

    static boolean inRom(Address object) {
        return object.hi(romStart) && object.loeq(romEnd);
    }

    static Offset getOffsetInRom(Address object) {
        return object.diff(romStart);
    }

    static Address getObjectInRom(Offset offset) {
        return romStart.addOffset(offset);
    }

    public static Address getBootstrapStart() {
        return bootstrapStart;
    }

    public static Address getBootstrapEnd() {
        return bootstrapEnd;
    }

    public static int getBootstrapHash() {
        return bootstrapHash;
    }

    public static char getPathSeparatorChar() {
        return (char)VM.execSyncIO(1020, 0);
    }

    public static char getFileSeparatorChar() {
        return (char)VM.execSyncIO(1021, 0);
    }

    public static native void fatalVMError();

    static native void threadSwitch();

    private static native void executeGC(boolean var0);

    private static native void executeCOG(Object var0, ObjectMemorySerializer.ControlBlock var1);

    public static native long getBranchCount();

    public static long branchCount() {
        return VM.getBranchCount();
    }

    public static void startTracing() {
        VM.setGlobalInt(1, Global.getOffset(Global.tracing));
    }

    public static boolean isVerbose() {
        return verboseLevel > 0;
    }

    public static boolean isVeryVerbose() {
        return verboseLevel > 1;
    }

    static void setVerboseLevel(int level) {
        verboseLevel = level;
    }

    static int createChannelContext(byte[] hibernatedContext) {
        return VM.execSyncIO(1, 0, 0, 0, 0, 0, 0, hibernatedContext, null);
    }

    static void deleteChannelContext(int context) {
        VM.execSyncIO(context, 5, 0, 0);
    }

    static byte[] hibernateChannelContext(int context) throws IOException {
        int bufferSize = VM.execSyncIO(context, 6, 0, 0);
        if (bufferSize < 0) {
            VM.raiseChannelException(context);
        }
        try {
            byte[] cioData = new byte[bufferSize];
            int result = VM.execSyncIO(context, 7, 0, cioData.length, 0, 0, 0, 0, null, cioData);
            if (result != 0) {
                if (result == -2) {
                    VM.raiseChannelException(context);
                }
                throw new IOException("Bad result from hibernateChannelContext " + result);
            }
            return cioData;
        }
        catch (OutOfMemoryError e) {
            throw new IOException("insufficient memory to serialize IO state");
        }
    }

    public static long getTimeMicros() {
        long high = VM.execSyncIO(1013, 0);
        long low = VM.execSyncIO(1011, 0);
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public static long getTimeMillis() {
        long high = VM.execSyncIO(1012, 0);
        long low = VM.execSyncIO(1011, 0);
        return high << 32 | low & 0xFFFFFFFFL;
    }

    static int getEvent() {
        return VM.execSyncIO(2, 0);
    }

    static void waitForEvent(long time) {
        int low = (int)time;
        int high = (int)(time >> 32);
        VM.execSyncIO(4, high, low);
    }

    public static void collectGarbage(boolean forceFullGC) throws NotInlinedPragma {
        VM.executeGC(forceFullGC);
    }

    static ObjectMemorySerializer.ControlBlock copyObjectGraph(Object object) {
        Assert.always(GC.inRam(object), "VM.java", 2377);
        VM.collectGarbage(true);
        ObjectMemorySerializer.ControlBlock cb = new ObjectMemorySerializer.ControlBlock();
        int graphSize = (int)(GC.totalMemory() - GC.freeMemory());
        byte[] bits = new byte[GC.calculateOopMapSizeInBytes(graphSize)];
        cb.oopMap = new BitSet(bits);
        VM.executeCOG(object, cb);
        if (cb.memory == null) {
            throw VM.getOutOfMemoryError();
        }
        byte[] memory = cb.memory;
        byte[] newBits = new byte[GC.calculateOopMapSizeInBytes(memory.length)];
        GC.arraycopy(bits, 0, newBits, 0, newBits.length);
        cb.oopMap = new BitSet(newBits);
        return cb;
    }

    private static void cleanupTaskExecutors() {
        TaskExecutor te;
        int i;
        for (i = 0; i < taskCache.size(); ++i) {
            te = (TaskExecutor)taskCache.elementAt(i);
            te.cancelTaskExecutor();
        }
        while (!taskCache.isEmpty()) {
            i = 0;
            while (i < taskCache.size()) {
                te = (TaskExecutor)taskCache.elementAt(i);
                if (te.deleteTaskExecutor() == 0) {
                    taskCache.removeElementAt(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public static void stopVM(int code) {
        if (executingHooks) {
            return;
        }
        executingHooks = true;
        if (VM.isVerbose()) {
            System.out.println("Running top-level shutdown hooks:");
        }
        shutdownHooks.runHooks();
        VM.cleanupTaskExecutors();
        if (VM.isVerbose()) {
            System.out.println("Done running top-level shutdown hooks.");
        }
        VM.haltVM(code);
    }

    public static void haltVM(int code) {
        VM.execSyncIO(1014, code);
        Assert.shouldNotReachHere("VM.java", 2458);
    }

    public static void addShutdownHook(Isolate iso, Runnable hook) {
        if (executingHooks) {
            throw new IllegalStateException("Shutdown in progress");
        }
        shutdownHooks.add(iso, hook);
    }

    public static boolean removeShutdownHook(Isolate iso, Runnable hook) {
        if (executingHooks) {
            throw new IllegalStateException("Shutdown in progress");
        }
        return shutdownHooks.remove(iso, hook);
    }

    public static void addShutdownHook(Thread hook) {
        if (executingHooks) {
            throw new IllegalStateException("Shutdown in progress");
        }
        shutdownHooks.add(VMThread.asVMThread(hook).getIsolate(), hook);
    }

    public static boolean removeShutdownHook(Thread hook) {
        if (executingHooks) {
            throw new IllegalStateException("Shutdown in progress");
        }
        return shutdownHooks.remove(VMThread.asVMThread(hook).getIsolate(), hook);
    }

    public static Stack getTaskCache() {
        return taskCache;
    }

    public static native void copyBytes(Address var0, int var1, Address var2, int var3, int var4, boolean var5);

    public static native void setBytes(Address var0, byte var1, int var2);

    private static void arraycopy0(Object src, int src_position, Object dst, int dst_position, int totalLength, int dataSize) {
        int MAXMOVE = 4096;
        int max = 4096;
        switch (dataSize) {
            case 1: {
                max = 16384;
                break;
            }
            case 2: {
                max = 8192;
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                max = 2048;
                break;
            }
            default: {
                Assert.shouldNotReachHere("VM.java", 2797);
            }
        }
        while (totalLength != 0) {
            int length = Math.min(totalLength, max);
            GC.arraycopy(src, src_position, dst, dst_position, length);
            if ((totalLength -= length) == 0) break;
            src_position += length;
            dst_position += length;
            VMThread.yield();
        }
    }

    public static void arraycopyPrimitive0(Object src, int src_position, Object dst, int dst_position, int totalLength, int dataSize) {
        VM.arraycopy0(src, src_position, dst, dst_position, totalLength, dataSize);
    }

    public static void arraycopyObject0(Object src, int src_position, Object dst, int dst_position, int length) {
        if (length > 0) {
            Lisp2Bitmap.updateWriteBarrierForPointerArraycopy(dst, dst_position, length);
        }
        VM.arraycopy0(src, src_position, dst, dst_position, length, 4);
    }

    public static void getData(Address src, int boffset, Object dst, int low, int number, int elementSize) {
        if (dst == null) {
            throw new NullPointerException();
        }
        if (low < 0) {
            throw new ArrayIndexOutOfBoundsException(low);
        }
        if (number < 0) {
            throw new ArrayIndexOutOfBoundsException(number);
        }
        if (low > GC.getArrayLength(dst) - number) {
            throw new ArrayIndexOutOfBoundsException(low + number);
        }
        VM.copyBytes(src, boffset, Address.fromObject(dst), low * elementSize, number * elementSize, false);
    }

    public static void setData(Address dst, int boffset, Object src, int low, int number, int elementSize) {
        if (low < 0) {
            throw new ArrayIndexOutOfBoundsException(low);
        }
        if (number < 0) {
            throw new ArrayIndexOutOfBoundsException(number);
        }
        if (src == null) {
            throw new NullPointerException();
        }
        if (low > GC.getArrayLength(src) - number) {
            throw new ArrayIndexOutOfBoundsException(low + number);
        }
        VM.copyBytes(Address.fromObject(src), low * elementSize, dst, boffset, number * elementSize, false);
    }

    static native Object allocate(int var0, Object var1, int var2);

    static native void zeroWords(Address var0, Address var1);

    static native void deadbeef(Address var0, Address var1);

    public static Object shallowCopy(Object original) {
        Object copy;
        Klass klass = GC.getKlass(original);
        if (klass.isArray()) {
            int length = GC.getArrayLength(original);
            copy = GC.newArray(klass, length);
            System.arraycopy(original, 0, copy, 0, length);
        } else {
            copy = GC.newInstance(klass);
            VM.copyBytes(Address.fromObject(original), 0, Address.fromObject(copy), 0, klass.getInstanceSize() * 4, false);
        }
        return copy;
    }

    static native void callStaticNoParm(Klass var0, int var1);

    static native void callStaticOneParm(Klass var0, int var1, Object var2);

    public static OutOfMemoryError getOutOfMemoryError() {
        return outOfMemoryError;
    }

    public static void printThread(VMThread thr) {
        if (thr == null) {
            VM.print("(thr == null)");
            return;
        }
        try {
            String thrName = thr.getName();
            if (thrName != null) {
                VM.print(thrName);
                return;
            }
        }
        catch (OutOfMemoryError e) {
            VM.print("Uncaught out of memory error while printing thread name ");
        }
        catch (Throwable exc2) {
            VM.print("Uncaught exception while printing thread name ");
        }
        VM.print("Thread-");
        VM.print(thr.getThreadNumber());
    }

    public static void outPrintThread(VMThread thr) {
        if (thr == null) {
            VM.outPrint("(thr == null)");
            return;
        }
        try {
            String thrName = thr.getName();
            if (thrName != null) {
                VM.outPrint(thrName);
                return;
            }
        }
        catch (OutOfMemoryError e) {
            VM.print("Uncaught out of memory error while printing thread name ");
        }
        catch (Throwable exc2) {
            VM.print("Uncaught exception while printing thread name ");
        }
        VM.outPrint("Thread-");
        VM.outPrint(thr.getThreadNumber());
    }

    public static void outPrintBC() {
        long bc = VM.branchCount();
        if (bc >= 0L) {
            VM.outPrint("after ");
            VM.outPrint(bc);
            VM.outPrint(" branches ");
        }
    }

    static void printVMStackTrace(Throwable exc, String origExcName, String message) {
        VM.print(origExcName);
        if (message != null) {
            VM.print(": ");
            VM.println(message);
        }
        ExecutionPoint[] trace = (ExecutionPoint[])NativeUnsafe.getObject(exc, 1);
        if (exc != VM.getOutOfMemoryError() && trace != null) {
            for (int i = 0; i != trace.length; ++i) {
                VM.print("    ");
                if (trace[i] != null) {
                    trace[i].printToVM();
                    continue;
                }
                VM.print("undecipherable");
            }
        }
    }

    public static Throwable printExceptionAndTrace(Throwable exc, String msg) {
        return VM.printExceptionAndTrace(exc, msg, true);
    }

    public static void outPrint(PrintStream stream, String str) {
        if (!safePrintToVM && stream != null) {
            try {
                stream.print(str);
                return;
            }
            catch (Throwable t) {
                safePrintToVM = true;
            }
        }
        VM.print(str);
    }

    public static void outPrintln(PrintStream stream, String str) {
        VM.outPrint(stream, str);
        VM.outPrintln(stream);
    }

    public static void outPrintln(PrintStream stream) {
        VM.outPrint(stream, "\n");
    }

    public static void outPrint(PrintStream stream, long val) {
        if (!safePrintToVM && stream != null) {
            try {
                stream.print(val);
                return;
            }
            catch (Throwable t) {
                safePrintToVM = true;
            }
        }
        VM.print(val);
    }

    public static void outPrint(String str) {
        VM.outPrint(System.err, str);
    }

    public static void outPrintln(String str) {
        VM.outPrintln(System.err, str);
    }

    public static void outPrintln() {
        VM.outPrintln(System.err);
    }

    public static void outPrint(long val) {
        VM.outPrint(System.err, val);
    }

    public static Throwable printExceptionAndTrace(Throwable exc, String msg, boolean printUsingThrowable) {
        String origExcName = "unknown";
        try {
            VM.outPrintln(msg);
            VM.outPrint("    ");
            VM.outPrintBC();
            VM.outPrint("on thread ");
            VM.outPrintThread(VMThread.currentThread());
            VM.outPrintln();
            origExcName = GC.getKlass(exc).getInternalName();
        }
        catch (Throwable e) {
            VM.println("Error in VM.printExceptionAndTrace");
            VM.fatalVMError();
        }
        try {
            String excMesg = "error calling Throwable.getMessage()";
            try {
                excMesg = exc.getMessage();
                if (printUsingThrowable) {
                    exc.printStackTrace();
                } else {
                    VM.printVMStackTrace(exc, origExcName, excMesg);
                }
                return null;
            }
            catch (OutOfMemoryError exc2) {
                VM.println("Uncaught out of memory error while printing stack trace ");
                VM.print("    original exception: ");
                VM.printVMStackTrace(exc, origExcName, excMesg);
                return exc2;
            }
            catch (Throwable exc2) {
                VM.println("Uncaught exception while printing stack trace ");
                VM.print("    original exception: ");
                VM.printVMStackTrace(exc, origExcName, excMesg);
                VM.print("    secondary exception: ");
                VM.printVMStackTrace(exc2, GC.getKlass(exc2).getInternalName(), null);
                return exc2;
            }
        }
        catch (OutOfMemoryError exc2) {
            VM.println("Uncaught out of memory error while VM.printing stack trace ");
            VM.print("    original exception: ");
            VM.println(origExcName);
            return exc2;
        }
        catch (Throwable exc2) {
            VM.println("Uncaught exception while VM.printing stack trace ");
            VM.print("    original exception: ");
            VM.println(origExcName);
            VM.print("    original msg: ");
            VM.println(msg);
            VM.print("    secondary exception: ");
            VM.println(GC.getKlass(exc2).getInternalName());
            return exc2;
        }
    }

    private static native void executeCIO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Object var9, Object var10);

    private static native int serviceResult();

    private static native Address addressResult();

    private static void checkOpcode(int opcode) {
    }

    public static int execSyncIO(int op, int i1, int i2, int i3, int i4, int i5, int i6, Object send, Object receive) {
        VM.checkOpcode(op);
        VM.executeCIO(-1, op, -1, i1, i2, i3, i4, i5, i6, send, receive);
        return VM.serviceResult();
    }

    public static int execSyncIO(int context, int op, int i1, int i2, int i3, int i4, int i5, int i6, Object send, Object receive) {
        VM.checkOpcode(op);
        VM.executeCIO(context, op, -1, i1, i2, i3, i4, i5, i6, send, receive);
        return VM.serviceResult();
    }

    public static int execSyncIO(int op, int i1) {
        VM.checkOpcode(op);
        VM.executeCIO(-1, op, -1, i1, 0, 0, 0, 0, 0, null, null);
        return VM.serviceResult();
    }

    static int execSyncIO(int op, int i1, int i2) {
        VM.checkOpcode(op);
        VM.executeCIO(-1, op, -1, i1, i2, 0, 0, 0, 0, null, null);
        return VM.serviceResult();
    }

    static int execSyncIO(int context, int op, int i1, int i2) {
        VM.checkOpcode(op);
        VM.executeCIO(context, op, -1, i1, i2, 0, 0, 0, 0, null, null);
        return VM.serviceResult();
    }

    private static String getExceptionMessage(int context) {
        StringBuffer sb = new StringBuffer();
        char ch;
        while ((ch = (char)VM.execSyncIO(context, 12, 0, 0)) != '\u0000') {
            sb.append(ch);
        }
        return sb.toString();
    }

    private static void raiseChannelException(int context) throws IOException {
        String name = VM.getExceptionMessage(context);
        throw new IOException("Channel Exception: " + name);
    }

    public static int execIO(int op, int channel, int i1, int i2, int i3, int i4, int i5, int i6, Object send, Object receive) throws IOException {
        int context = currentIsolate.getChannelContext();
        if (context == 0) {
            throw new IOException("No native I/O peer for isolate");
        }
        VM.checkOpcode(op);
        while (true) {
            VM.executeCIO(context, op, channel, i1, i2, i3, i4, i5, i6, send, receive);
            int result = VM.serviceResult();
            if (result == 0) {
                return VM.execSyncIO(context, 10, 0, 0);
            }
            if (result < 0) {
                if (result == -2) {
                    VM.raiseChannelException(context);
                }
                throw new IOException("Bad result from cioExecute " + result);
            }
            VMThread.waitForEvent(result);
            context = currentIsolate.getChannelContext();
        }
    }

    public static long execIOLong(int op, int channel, int i1, int i2, int i3, int i4, int i5, int i6, Object send, Object receive) throws IOException {
        long low = VM.execIO(op, channel, i1, i2, i3, i4, i5, i6, send, receive);
        int context = currentIsolate.getChannelContext();
        long high = VM.execSyncIO(context, 11, 0, 0);
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public static int execGraphicsIO(int op, int i1, int i2, int i3, int i4, int i5, int i6, Object send, Object receive) {
        try {
            int chan = currentIsolate.getGuiOutputChannel();
            return VM.execIO(op, chan, i1, i2, i3, i4, i5, i6, send, receive);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error executing graphics channel: " + ex);
        }
    }

    public static long getGUIEvent() {
        try {
            int channel = currentIsolate.getGuiInputChannel();
            return VM.execIOLong(22, channel, 0, 0, 0, 0, 0, 0, null, null);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error executing event channel: " + ex);
        }
    }

    public static void setAsDaemonThread(Thread t) {
        VMThread.asVMThread(t).setDaemon(true);
    }

    public static void setSystemThreadPriority(Thread t, int level) {
        VMThread.asVMThread(t).setSystemPriority(level);
    }

    public static int getChannel(int type) throws IOException {
        int context = currentIsolate.getChannelContext();
        if (context == 0) {
            throw new IOException("no native I/O peer for isolate");
        }
        return VM.execSyncIO(context, 8, type, 0);
    }

    public static void freeChannel(int channel) throws IOException {
        int context = currentIsolate.getChannelContext();
        if (context == 0) {
            throw new IOException("no native I/O peer for isolate");
        }
        VM.executeCIO(context, 9, channel, 0, 0, 0, 0, 0, 0, null, null);
    }

    public static void setMaxSelectWait(long max) {
        SystemEvents sysEvents = VMThread.getSystemEvents();
        if (sysEvents == null) {
            throw new IllegalStateException();
        }
        sysEvents.setMaxWait(max);
    }

    public static void setMaxSystemWait(long max) {
        VMThread.setMaxSystemWait(max);
    }

    public static void allowUserGC(boolean value) {
        allowUserGC = value;
    }

    public static boolean userGCAllowed() {
        return allowUserGC;
    }

    public static boolean usingTypeMap() {
        return usingTypeMap;
    }

    public static int getNextHashcode() {
        while (++nextHashcode == 0) {
        }
        return nextHashcode;
    }

    public static Isolate getCurrentIsolate() {
        return currentIsolate;
    }

    public static Enumeration getManifestPropertyNames() {
        Hashtable names = new Hashtable();
        for (Suite suite = VM.getCurrentIsolate().getLeafSuite(); suite != null; suite = suite.getParent()) {
            Enumeration additions = suite.getManifestPropertyNames();
            while (additions.hasMoreElements()) {
                Object propertyName = additions.nextElement();
                names.put(propertyName, propertyName);
            }
        }
        return names.keys();
    }

    public static String getManifestProperty(String name) {
        for (Suite suite = VM.getCurrentIsolate().getLeafSuite(); suite != null; suite = suite.getParent()) {
            String value = suite.getManifestProperty(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static Hashtable getManifestPropertiesOfSuite(String uri) {
        Hashtable properties = new Hashtable();
        Suite suite = Suite.getSuite(uri);
        Enumeration additions = suite.getManifestPropertyNames();
        while (additions.hasMoreElements()) {
            String propertyName = (String)additions.nextElement();
            properties.put(propertyName, suite.getManifestProperty(propertyName));
        }
        return properties;
    }

    public static void unregisterSuite(String uri) {
        ObjectMemory objectMemory = GC.lookupReadOnlyObjectMemoryBySourceURI(uri);
        if (objectMemory != null) {
            GC.unRegisterReadOnlyObjectMemory(objectMemory);
        }
    }

    public static boolean isCurrentIsolateInitialized() {
        return currentIsolate != null && currentIsolate.isClassKlassInitialized();
    }

    public static boolean isThreadingInitialized() {
        return synchronizationEnabled;
    }

    static void setCurrentIsolate(Isolate isolate) {
        currentIsolate = isolate;
    }

    static boolean isLinkableNativeMethod(String name) {
        return VM.lookupNative(name) != -1;
    }

    public static int lookupNative(String name) {
        return -1;
    }

    public static boolean stripSymbols(Klass klass) {
        return false;
    }

    public static boolean stripSymbols(Member member) {
        return false;
    }

    public static boolean isInternal(Member member) {
        return false;
    }

    public static boolean isInternal(Klass klass) {
        return false;
    }

    public static Object getClass(Object object) {
        return GC.getKlass(object);
    }

    public static boolean isArray(Object o) {
        return GC.getKlass(o).isArray();
    }

    static boolean isFirstIsolateInitialized() {
        return isFirstIsolateInitialized;
    }

    static String getIsolateInitializerClassName() {
        return isolateInitializer;
    }

    static void setFirstIsolateInitialized(boolean initialized) {
        isFirstIsolateInitialized = initialized;
    }

    static void setIsolateInitializerClassName(String initializer) {
        isolateInitializer = initializer;
    }

    public static boolean registerMailbox(String name, Mailbox mailbox) {
        if (registeredMailboxes == null) {
            registeredMailboxes = new SquawkHashtable();
        } else if (registeredMailboxes.get(name) != null) {
            return false;
        }
        registeredMailboxes.put(name, mailbox);
        return true;
    }

    public static void unregisterMailbox(String name, Mailbox mailbox) {
        if (registeredMailboxes == null || registeredMailboxes.get(name) == null) {
            throw new IllegalStateException("Mailbox " + name + " is not registered");
        }
        registeredMailboxes.remove(name);
    }

    public static Mailbox lookupMailbox(String name) {
        if (registeredMailboxes != null) {
            return (Mailbox)registeredMailboxes.get(name);
        }
        return null;
    }

    public static long getTimeBeforeAnotherThreadIsRunnable() {
        return VMThread.getTimeBeforeAnotherThreadIsRunnable();
    }

    public static PeripheralRegistry getPeripheralRegistry() {
        if (peripheralRegistry == null) {
            peripheralRegistry = new PeripheralRegistry();
        }
        return peripheralRegistry;
    }

    public static Thread[] getRunnableThreads() {
        return VMThread.getRunnableThreads();
    }

    public static Object getKeyedGlobalsMutex() {
        if (keyedGlobalsMutex == null) {
            keyedGlobalsMutex = new Object();
            keyeGlobals = new IntHashtable();
        }
        return keyedGlobalsMutex;
    }

    public static Object getKeyedGlobal(int key) {
        return keyeGlobals.get(key);
    }

    public static Object putKeyedGlobal(int key, Object value) {
        if (value == null) {
            keyeGlobals.remove(key);
        } else {
            keyeGlobals.put(key, value);
        }
        return value;
    }

    public static class Stats {
        public static final int STAT_WALL_TIME = 0;
        public static final int STAT_WAIT_TIME = 1;
        public static final int STAT_GC_TIME = 2;
        public static final int STAT_FULL_GC_TIME = 3;
        public static final int STAT_PARTIAL_GC_TIME = 4;
        public static final int STAT_LAST_GC_TIME = 5;
        public static final int STAT_MAX_FULLGC_TIME = 6;
        public static final int STAT_MAX_PARTGC_TIME = 7;
        public static final int STAT_FIRST_COUNT_STAT = 8;
        public static final int STAT_FULL_GC_COUNT = 9;
        public static final int STAT_PARTIAL_GC_COUNT = 10;
        public static final int STAT_BYTES_LAST_FREED = 11;
        public static final int STAT_BYTES_TOTAL_FREED = 12;
        public static final int STAT_BYTES_TOTAL_ALLOCATED = 13;
        public static final int STAT_OBJECTS_TOTAL_ALLOCATED = 14;
        public static final int STAT_THREADS_ALLOCATED = 15;
        public static final int STAT_THREAD_SWITCH_COUNT = 16;
        public static final int STAT_CONTENDED_MONITOR_COUNT = 17;
        public static final int STAT_MONITORS_ALLOCATED = 18;
        public static final int STAT_STACKS_ALLOCATED = 19;
        public static final int STAT_MAX_STACK_SIZE = 20;
        public static final int STAT_THROW_COUNT = 21;
        public static final int STAT_BRANCH_COUNT = 22;
        public static final int STAT_HEAP_FREE = 23;
        public static final int STAT_HEAP_TOTAL = 24;
        public static final int NUM_STAT_VALUES = 25;
        private long[] values = new long[25];

        public static long getTotalWaitTime() {
            return VMThread.getTotalWaitTime();
        }

        public static int getObjectsAllocatedTotal() {
            return VM.getGlobalInt(Global.getOffset(Global.newCount));
        }

        public static int getThreadsAllocatedCount() {
            return VMThread.getThreadsAllocatedCount();
        }

        public static int getThreadSwitchCount() {
            return VMThread.getThreadSwitchCount();
        }

        public static int getContendedMontorEnterCount() {
            return VMThread.getContendedMontorEnterCount();
        }

        public static int getMonitorsAllocatedCount() {
            return VMThread.getMonitorsAllocatedCount();
        }

        public static int getStacksAllocatedCount() {
            return VMThread.getStacksAllocatedCount();
        }

        public static int getMaxStackSize() {
            return VMThread.getMaxStackSize();
        }

        public static int getThrowCount() {
            return throwCount;
        }

        public static void initHeapStats() {
            GC.initHeapStats();
        }

        static void clearHeapStats() {
            GC.clearHeapStats();
        }

        public static void printHeapStats(Object startObj, boolean printInstances) {
            GC.printHeapStats(startObj, printInstances);
        }

        public static void readAllValues(long[] values) {
            GarbageCollector gc = GC.getCollector();
            values[0] = VM.getTimeMillis();
            values[1] = Stats.getTotalWaitTime();
            values[2] = gc.getTotalGCTime();
            values[3] = gc.getTotalFullGCTime();
            values[4] = gc.getTotalPartialGCTime();
            values[5] = gc.getLastGCTime();
            values[6] = gc.getMaxFullGCTime();
            values[7] = gc.getMaxPartialGCTime();
            values[9] = GC.getFullCount();
            values[10] = GC.getPartialCount();
            values[11] = gc.getBytesLastFreed();
            values[12] = gc.getBytesFreedTotal();
            values[13] = gc.getBytesAllocatedTotal();
            values[14] = Stats.getObjectsAllocatedTotal();
            values[15] = Stats.getThreadsAllocatedCount();
            values[16] = Stats.getThreadSwitchCount();
            values[17] = Stats.getContendedMontorEnterCount();
            values[18] = Stats.getMonitorsAllocatedCount();
            values[19] = Stats.getStacksAllocatedCount();
            values[20] = Stats.getMaxStackSize();
            values[21] = Stats.getThrowCount();
            values[22] = VM.branchCount();
            values[23] = GC.freeMemory();
            values[24] = GC.totalMemory();
        }

        public void sendStatData(DataOutputStream dos) {
            Stats.readAllValues(this.values);
            try {
                for (int i = 0; i < 25; ++i) {
                    dos.writeByte(i);
                    dos.writeLong(this.values[i]);
                }
                dos.flush();
            }
            catch (IOException ex) {
                System.out.println("Error writing stat " + ex);
                ex.printStackTrace();
            }
        }
    }

    static final class WeakIsolateListEntry
    extends Ref {
        private WeakIsolateListEntry nextIsolateRef;

        WeakIsolateListEntry(Isolate isolate, WeakIsolateListEntry next) {
            super(isolate);
            this.nextIsolateRef = next;
        }

        boolean contains(Isolate isolate) {
            if (this.get() == isolate) {
                return true;
            }
            if (this.nextIsolateRef != null) {
                return this.nextIsolateRef.contains(isolate);
            }
            return false;
        }

        void copyInto(SquawkVector set) {
            Object isolate = this.get();
            if (isolate != null) {
                set.addElement(isolate);
            }
            if (this.nextIsolateRef != null) {
                this.nextIsolateRef.copyInto(set);
            }
        }
    }
}

