/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.CrossIsolateThread;
import com.sun.squawk.Debugger;
import com.sun.squawk.EventHashtable;
import com.sun.squawk.ExecutionPoint;
import com.sun.squawk.GC;
import com.sun.squawk.HitBreakpoint;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.Monitor;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.Offset;
import com.sun.squawk.ThreadQueue;
import com.sun.squawk.TimerQueue;
import com.sun.squawk.VM;
import com.sun.squawk.platform.Platform;
import com.sun.squawk.platform.SystemEvents;
import com.sun.squawk.pragma.AllowInlinedPragma;
import com.sun.squawk.pragma.ForceInlinedPragma;
import com.sun.squawk.pragma.GlobalStaticFields;
import com.sun.squawk.pragma.NotInlinedPragma;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkHashtable;
import java.io.PrintStream;
import java.util.Enumeration;

public final class VMThread
implements GlobalStaticFields {
    private static final boolean FATAL_MONITOR_ERRORS = false;
    private static final int INITIAL_STACK_SIZE = 168;
    static final int MIN_STACK_SIZE = 78;
    private static VMThread currentThread;
    private static VMThread otherThread;
    private static VMThread serviceThread;
    private static Address serviceStack;
    private static ThreadQueue runnableThreads;
    private static TimerQueue timerQueue;
    private static int nextThreadNumber;
    private static EventHashtable events;
    private static EventHashtable osevents;
    private static int contendedEnterCount;
    static int monitorsAllocatedCount;
    static int threadSwitchCount;
    static int waitTimeHi32;
    static int waitTimeLo32;
    static SystemEvents systemEvents;
    private static int max_wait;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    public static final int MAX_SYS_PRIORITY = 12;
    private static final byte NEW = 0;
    private static final byte ALIVE = 1;
    private static final byte DEAD = 2;
    static final byte Q_NONE = 0;
    static final byte Q_MONITOR = 1;
    static final byte Q_CONDVAR = 2;
    static final byte Q_RUN = 3;
    static final byte Q_EVENT = 4;
    static final byte Q_JOIN = 5;
    static final byte Q_ISOLATEJOIN = 6;
    static final byte Q_HIBERNATEDRUN = 7;
    static final byte Q_TIMER = 8;
    private final Isolate isolate;
    private Object stack;
    private final int stackSize;
    private final Thread apiThread;
    private byte state;
    byte priority;
    private byte inqueue;
    VMThread nextThread;
    private VMThread waitingToJoin;
    private boolean isDaemon;
    VMThread nextTimerThread;
    private VMThread joiners;
    long time;
    private final int threadNumber;
    private String name;
    private HitBreakpoint hitBreakpoint;
    private Debugger.SingleStep step;
    Monitor monitor;
    boolean pendingInterrupt;
    private Offset appThreadTop;
    private short monitorDepth;
    private static final short MAXDEPTH = Short.MAX_VALUE;
    private int errno;
    private int debuggerSuspendCount;
    private ExecutionPoint eventEP;
    private static int stacksAllocatedCount;
    private static int maxStackSize;

    public static int getThreadsAllocatedCount() {
        return nextThreadNumber;
    }

    public static int getContendedMontorEnterCount() {
        return contendedEnterCount;
    }

    public static int getMonitorsAllocatedCount() {
        return monitorsAllocatedCount;
    }

    public static int getThreadSwitchCount() {
        return threadSwitchCount;
    }

    static void setMaxSystemWait(long max) {
        if (max <= 0L) {
            throw new IllegalArgumentException();
        }
        if (max == Long.MAX_VALUE) {
            max_wait = -1;
        } else {
            if (max > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            max_wait = (int)max;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VMThread(Thread apiThread, String name) {
        Assert.always(apiThread != null, "VMThread.java", 252);
        this.apiThread = apiThread;
        this.threadNumber = nextThreadNumber++;
        this.state = 0;
        this.stackSize = 168;
        Object target = NativeUnsafe.getObject(apiThread, 1);
        if (target instanceof Isolate) {
            if (!(apiThread instanceof CrossIsolateThread)) throw new SecurityException("No permision to create a cross-isolate thread");
            this.isolate = (Isolate)target;
        } else {
            this.isolate = VM.getCurrentIsolate();
        }
        if (currentThread != null) {
            this.priority = (byte)currentThread.getPriority();
            if (this.priority > 10) {
                this.priority = (byte)5;
            }
        } else {
            this.priority = (byte)5;
        }
        this.name = name != null ? name : (this.threadNumber == 0 ? "Thread-0" : "Thread-".concat(String.valueOf(this.threadNumber)));
    }

    public static VMThread currentThread() {
        return currentThread;
    }

    public void setDaemon(boolean value) {
        if (this.state != 0) {
            throw new IllegalThreadStateException();
        }
        this.isDaemon = value;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    private static void addToTimerQueue(VMThread thread, long millis) {
        thread.setInQueue((byte)8);
        timerQueue.add(thread, millis);
    }

    public static void sleep(long millis) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("negative sleep time");
        }
        currentThread.handlePendingInterrupt();
        if (millis > 0L) {
            VMThread.addToTimerQueue(currentThread, millis);
            VMThread.reschedule();
            currentThread.handlePendingInterrupt();
        }
    }

    private static void addToRunnableThreadsQueue(VMThread thread) {
        thread.checkInQueue((byte)0);
        runnableThreads.add(thread);
    }

    public static void yield() {
        VMThread.addToRunnableThreadsQueue(currentThread);
        VMThread.reschedule();
    }

    public void start() {
        if (this.state != 0) {
            throw new IllegalThreadStateException();
        }
        this.baptiseThread();
    }

    public final boolean isAlive() {
        return this.state == 1;
    }

    public final void setPriority(int newPriority) {
        if (newPriority > 10 || newPriority < 1) {
            throw new IllegalArgumentException();
        }
        this.priority = (byte)newPriority;
    }

    public final void setSystemPriority(int newPriority) {
        if (newPriority > 12 || newPriority < 1) {
            throw new IllegalArgumentException();
        }
        this.priority = (byte)newPriority;
    }

    public final int getPriority() {
        return this.priority;
    }

    public static int activeCount() {
        return runnableThreads.size() + 1;
    }

    public final void join() throws InterruptedException {
        if (this != currentThread && this.isAlive()) {
            currentThread.handlePendingInterrupt();
            VMThread.currentThread.nextThread = this.joiners;
            this.joiners = currentThread;
            VMThread.currentThread.waitingToJoin = this;
            currentThread.setInQueue((byte)5);
            VMThread.reschedule();
            currentThread.handlePendingInterrupt();
        }
    }

    static final void isolateJoin(Isolate isolate) {
        if (VMThread.currentThread.isolate == isolate) {
            throw new RuntimeException("Isolate cannot join itself");
        }
        if (!isolate.isHibernated()) {
            currentThread.setInQueue((byte)6);
            isolate.addJoiner(currentThread);
            VMThread.reschedule();
        }
    }

    private static void handleCrossIsolateSynchronization(Isolate isolate) {
    }

    private static void hibernateIsolate0(Isolate isolate) {
        VMThread.handleCrossIsolateSynchronization(isolate);
        VMThread list = isolate.getJoiners();
        VMThread.startJoiners(list, (byte)6);
        runnableThreads.prune(isolate);
        timerQueue.prune(isolate);
        events.prune(isolate);
    }

    static void hibernateIsolate(Isolate isolate, boolean forExit) {
        VMThread.hibernateIsolate0(isolate);
        if (VMThread.currentThread.isolate == isolate) {
            currentThread.setInQueue((byte)7);
            isolate.addToHibernatedRunThread(currentThread);
            VMThread.reschedule();
        }
    }

    static final void unhibernateIsolate(Isolate isolate) {
        VMThread thread;
        VMThread threads = isolate.getHibernatedTimerThreads();
        while (threads != null) {
            thread = threads;
            threads = thread.nextTimerThread;
            thread.nextTimerThread = null;
            long time = thread.time;
            if (time == 0L) {
                time = 1L;
            }
            timerQueue.add(thread, time);
        }
        threads = isolate.getHibernatedRunThreads();
        while (threads != null) {
            thread = threads;
            threads = thread.nextThread;
            thread.nextThread = null;
            thread.setNotInQueue((byte)7);
            VMThread.addToRunnableThreadsQueue(thread);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName().concat(" (pri=").concat(String.valueOf(this.getPriority())).concat(")]");
    }

    public static SystemEvents getSystemEvents() {
        return systemEvents;
    }

    private void checkInvarients() throws AllowInlinedPragma {
    }

    public final int getDebuggerSuspendCount() {
        return this.debuggerSuspendCount;
    }

    public final int suspendForDebugger() {
        return ++this.debuggerSuspendCount;
    }

    public final int resumeForDebugger(boolean forDetach) {
        if (forDetach) {
            this.debuggerSuspendCount = 0;
        } else if (this.debuggerSuspendCount > 0) {
            --this.debuggerSuspendCount;
        }
        return this.debuggerSuspendCount;
    }

    public ExecutionPoint getEventExecutionPoint() {
        return this.eventEP;
    }

    public final int getInternalStatus() {
        return this.state << 8 | this.inqueue;
    }

    public final Debugger.SingleStep getStep() {
        return this.step;
    }

    public final void setStep(Debugger.SingleStep step) {
        this.step = step;
    }

    public final void clearStep() {
        this.step = null;
    }

    void reportBreakpoint(Offset hitFO, Offset hitBCI, Debugger debugger) {
        this.hitBreakpoint = new HitBreakpoint(this, hitFO, hitBCI);
        if (this.inqueue == 0) {
            this.eventEP = this.hitBreakpoint.getLocation();
            debugger.notifyEvent(new Debugger.BreakpointEvent(this.eventEP));
            this.eventEP = null;
        }
        if (this.hitBreakpoint != null) {
            this.hitBreakpoint.setState(2);
        }
    }

    HitBreakpoint recordExceptionToReport(Offset throwFO, Offset throwBCI, Throwable exception, Offset catchFO, Offset catchBCI) {
        this.hitBreakpoint = new HitBreakpoint(this, throwFO, throwBCI, exception, catchFO, catchBCI);
        return this.hitBreakpoint;
    }

    void reportException(Debugger debugger) throws Throwable {
        HitBreakpoint hbp = this.hitBreakpoint;
        Throwable exception = hbp.getException();
        try {
            this.eventEP = hbp.getLocation();
            debugger.notifyEvent(new Debugger.ExceptionEvent(exception, this.eventEP, hbp.getCatchLocation(), hbp.isCaught()));
            this.eventEP = null;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        hbp.setState(5);
        throw exception;
    }

    void reportStepEvent(Offset fo, Offset bci) {
        Debugger debugger = VM.getCurrentIsolate().getDebugger();
        Object mp = VM.getMP(this.frameOffsetAsPointer(fo));
        this.eventEP = new ExecutionPoint(fo, bci, mp);
        debugger.notifyEvent(new Debugger.SingleStepEvent(this.eventEP));
        this.eventEP = null;
    }

    HitBreakpoint getHitBreakpoint() {
        return this.hitBreakpoint;
    }

    public void clearBreakpoint() {
        this.hitBreakpoint = null;
    }

    void setAppThreadTop(Offset fp) {
        this.appThreadTop = fp;
    }

    Offset getAppThreadTop() {
        return this.appThreadTop;
    }

    static void initializeThreading() {
        nextThreadNumber = 0;
        runnableThreads = new ThreadQueue();
        timerQueue = new TimerQueue();
        events = new EventHashtable();
        osevents = new EventHashtable();
        serviceThread = currentThread = VMThread.asVMThread(new Thread());
        max_wait = -1;
        int length = NativeUnsafe.getUWord(serviceStack, -2).toInt();
        Assert.always(length > 0, "VMThread.java", 1176);
        GC.setHeaderClass(serviceStack, Klass.LOCAL_ARRAY);
        GC.setHeaderLength(serviceStack, length);
        VMThread.serviceThread.stack = serviceStack.toObject();
    }

    static void initializeThreading2() {
        systemEvents = Platform.createSystemEvents();
        systemEvents.startIO();
    }

    public Isolate getIsolate() {
        return this.isolate;
    }

    public Thread getAPIThread() {
        return this.apiThread;
    }

    public static VMThread asVMThread(Thread thread) {
        if (thread == null) {
            return null;
        }
        return (VMThread)NativeUnsafe.getObject(thread, 0);
    }

    public boolean isServiceThread() {
        return this == serviceThread;
    }

    public final int getThreadNumber() {
        return this.threadNumber;
    }

    final void primitiveThreadStart() {
        this.start();
        VMThread.rescheduleNext();
    }

    private void baptiseThread() {
        Debugger debugger;
        Assert.always(this.state == 0, "VMThread.java", 1270);
        this.stack = VMThread.newStack(this.stackSize, this, true);
        if (this.stack == null) {
            VM.println("creating stack:");
            throw VM.getOutOfMemoryError();
        }
        this.state = 1;
        this.isolate.addThread(this);
        VMThread.addToRunnableThreadsQueue(this);
        if (VM.isThreadingInitialized() && (debugger = VM.getCurrentIsolate().getDebugger()) != null) {
            debugger.notifyEvent(new Debugger.Event(6, this));
        }
    }

    private void killThread(boolean nicely, boolean uncaughtException) {
        Debugger debugger;
        Assert.always(this.state == 1, "VMThread.java", 1325);
        if (VM.isThreadingInitialized() && (debugger = VM.getCurrentIsolate().getDebugger()) != null) {
            debugger.notifyEvent(new Debugger.Event(7, this));
        }
        boolean exitIsolate = false;
        if (nicely) {
            exitIsolate = this.isolate.removeThread(this);
        }
        VMThread list = this.joiners;
        this.joiners = null;
        VMThread.startJoiners(list, (byte)5);
        if (exitIsolate) {
            this.isolate.exit(uncaughtException ? 1 : 0);
        }
        this.state = (byte)2;
        this.abandonThread();
    }

    private static void startJoiners(VMThread list, byte queueName) {
        while (list != null) {
            VMThread next = list.nextThread;
            list.nextThread = null;
            list.waitingToJoin = null;
            list.setNotInQueue(queueName);
            if (list.isolate.isAlive()) {
                VMThread.addToRunnableThreadsQueue(list);
            }
            list = next;
        }
    }

    final Object getStack() throws ForceInlinedPragma {
        return this.stack;
    }

    final Offset framePointerAsOffset(Address fp) throws ForceInlinedPragma {
        int size = GC.getArrayLengthNoCheck(this.stack);
        Address stackEnd = Address.fromObject(this.stack).add(size * 4);
        return stackEnd.diff(fp);
    }

    final Address frameOffsetAsPointer(Offset fp) throws ForceInlinedPragma {
        int size = GC.getArrayLengthNoCheck(this.stack) * 4;
        Address stackEnd = Address.fromObject(this.stack).add(size);
        return stackEnd.subOffset(fp);
    }

    public static int getStacksAllocatedCount() {
        return stacksAllocatedCount;
    }

    public static int getMaxStackSize() {
        return maxStackSize;
    }

    private static Object newStack(int size, VMThread owner, boolean userThread) {
        Object stack;
        Object object = stack = GC.getExcessiveGC() ? null : GC.newStack(size, owner);
        if (stack == null) {
            if (userThread) {
                VM.collectGarbage(false);
            } else {
                GC.collectGarbage(false);
            }
            stack = GC.newStack(size, owner);
        }
        ++stacksAllocatedCount;
        if (size > maxStackSize) {
            maxStackSize = size;
        }
        return stack;
    }

    static boolean extendStack(int overflow) {
        Object newStack;
        Assert.always(VM.isCurrentIsolateInitialized(), "cannot extend stack until com.sun.squawk.Class is initialized", "VMThread.java", 1494);
        Assert.always(currentThread == serviceThread, "VMThread.java", 1495);
        int oldSize = GC.getArrayLength(VMThread.otherThread.stack);
        int minSize = oldSize + overflow;
        int newSize = oldSize * 2;
        if (newSize < minSize) {
            newSize = minSize * 2;
        }
        if ((newStack = VMThread.newStack(newSize, otherThread, false)) == null) {
            return false;
        }
        Object oldStack = VMThread.otherThread.stack;
        GC.stackCopy(oldStack, newStack);
        VMThread.otherThread.stack = newStack;
        return true;
    }

    final void callRun() throws NotInlinedPragma {
        boolean uncaughtException = false;
        try {
            boolean didAbort = false;
            try {
                VMThread thread = currentThread;
                Assert.always(thread == this, "VMThread.java", 1531);
                thread.appThreadTop = thread.framePointerAsOffset(VM.getFP());
                this.apiThread.run();
            }
            catch (OutOfMemoryError e) {
                uncaughtException = true;
                VM.print("Uncaught out of memory error on thread  - aborting isolate ");
                VM.printThread(this);
                VM.println();
                this.isolate.abort(999);
                didAbort = true;
            }
            catch (Throwable ex) {
                uncaughtException = true;
                VM.printExceptionAndTrace(ex, "Uncaught exception in Thread.run():");
            }
            this.killThread(!didAbort, uncaughtException);
        }
        catch (OutOfMemoryError e) {
            VM.println("Uncaught out of memory error while killing thread - aborting isolate");
        }
        catch (Throwable e) {
            VM.printExceptionAndTrace(e, "Uncaught exception while killing thread - aborting isolate:");
        }
        try {
            this.isolate.abort(999);
        }
        catch (Throwable e) {
            VM.print("Uncaught ");
            VM.print(GC.getKlass(e).getInternalName());
            VM.print(" while aborting isolate [");
            VM.println("]");
        }
        this.killThread(false, uncaughtException);
        VM.fatalVMError();
    }

    private static void rescheduleNext() {
        VMThread thread = null;
        while (true) {
            int event;
            if ((event = VM.getEvent()) != 0) {
                VMThread.signalEvent(event);
                continue;
            }
            while ((thread = timerQueue.next()) != null) {
                Monitor monitor = thread.monitor;
                if (monitor != null) {
                    monitor.removeCondvarWait(thread);
                } else {
                    thread.setNotInQueue((byte)8);
                }
                VMThread.addToRunnableThreadsQueue(thread);
            }
            thread = runnableThreads.next();
            if (thread != null) break;
            long delta = timerQueue.nextDelta();
            if (delta <= 0L) continue;
            if (delta == Long.MAX_VALUE && events.size() == 0 && osevents.size() == 0) {
                VM.println("=== DEAD-LOCK STATUS: ===");
                Isolate.printAllIsolateStates(System.err);
                Assert.shouldNotReachHere("Dead-locked system: no schedulable threads", "VMThread.java", 1641);
            }
            if (max_wait != -1 && delta > (long)max_wait) {
                delta = max_wait;
            }
            long waitTime = VM.getTimeMillis();
            long oldWaitTimeTotal = VMThread.getTotalWaitTime();
            VM.waitForEvent(delta);
            waitTime = VM.getTimeMillis() - waitTime;
            waitTimeHi32 = (int)((oldWaitTimeTotal += waitTime) >>> 32);
            waitTimeLo32 = (int)(oldWaitTimeTotal & 0xFFFFFFFFL);
        }
        thread.checkInQueue((byte)0);
        otherThread = thread;
    }

    public static long getTotalWaitTime() {
        return (long)waitTimeHi32 << 32 | (long)waitTimeLo32;
    }

    public void printState(PrintStream out) {
        VM.outPrint(out, "thread ");
        VM.outPrint(out, this.getName());
        VM.outPrint(out, " priority: ");
        VM.outPrint(out, this.getPriority());
        String stateStr = "NONE";
        String waitingStr = "NONE";
        switch (this.state) {
            case 0: {
                stateStr = "NEW";
                break;
            }
            case 1: {
                stateStr = "ALIVE";
                break;
            }
            case 2: {
                stateStr = "DEAD";
            }
        }
        switch (this.inqueue) {
            case 1: {
                waitingStr = "MONITOR";
                break;
            }
            case 2: {
                waitingStr = "CONDVAR";
                break;
            }
            case 3: {
                waitingStr = "RUNNABLE";
                break;
            }
            case 4: {
                waitingStr = "EVENT";
                break;
            }
            case 5: {
                waitingStr = "JOIN";
                break;
            }
            case 6: {
                waitingStr = "ISOLATEJOIN";
                break;
            }
            case 7: {
                waitingStr = "HIBERNATEDRUN";
                break;
            }
            case 8: {
                waitingStr = "TIMER";
            }
        }
        VM.outPrint(out, " state: ");
        VM.outPrint(out, stateStr);
        VM.outPrint(out, " queue: ");
        VM.outPrint(out, waitingStr);
        switch (this.inqueue) {
            case 1: {
                VM.outPrint(out, " waiting to lock object in ");
                Monitor m = this.lookupROMMonitor();
                if (m != null) {
                    VM.outPrint(out, "ROM " + m.object);
                    break;
                }
                VM.outPrint(out, "in heap");
                break;
            }
            case 2: {
                VM.outPrint(out, " waiting on condvar for object ");
                if (this.monitor != null) {
                    VM.outPrint(out, this.monitor.object.toString());
                    break;
                }
                VM.outPrint(out, "???");
                break;
            }
            case 4: {
                VM.outPrint(out, " waiting for ");
                if (this.waitingforEvent()) {
                    VM.outPrint(out, "low-level event");
                    break;
                }
                if (this.waitingforOSEvent()) {
                    VM.outPrint(out, "OS event");
                    break;
                }
                VM.outPrint(out, "????");
                break;
            }
            case 5: {
                VM.outPrint(out, " waiting to join " + this.waitingToJoin);
                break;
            }
            case 8: {
                VM.outPrint(out, " waiting for ms (remaining): ");
                long delta = this.time - VM.getTimeMillis();
                VM.outPrint(out, delta);
            }
        }
        if (this.pendingInterrupt) {
            VM.outPrint(out, " pendingInterrupt! ");
        }
        VM.outPrintln(out);
    }

    private Monitor lookupROMMonitor() {
        SquawkHashtable monitorTable = this.getIsolate().getMonitorHashtable();
        Enumeration e = monitorTable.elements();
        while (e.hasMoreElements()) {
            Monitor m = (Monitor)e.nextElement();
            VMThread thr = m.monitorQueue;
            while (thr != null) {
                if (thr == this) {
                    return m;
                }
                thr = thr.nextThread;
            }
        }
        return null;
    }

    public void printStackTrace(PrintStream stream) {
        ExecutionPoint[] trace = VM.reifyStack(this, -1);
        for (int i = 0; i != trace.length; ++i) {
            stream.print("    ");
            if (trace[i] != null) {
                trace[i].print(stream);
            } else {
                stream.print("undecipherable");
            }
            stream.println();
        }
    }

    private static void reschedule() throws NotInlinedPragma {
        VMThread.fixupPendingMonitors();
        ++threadSwitchCount;
        VMThread.rescheduleNext();
        VM.threadSwitch();
        currentThread.checkInQueue((byte)0);
        currentThread.checkInvarients();
    }

    private void abandonThread() throws NotInlinedPragma {
        VMThread.fixupPendingMonitors();
        VMThread.rescheduleNext();
        boolean oldState = GC.setAllocationEnabled(false);
        NativeUnsafe.setObject(this.stack, 1, null);
        NativeUnsafe.setAddress(this.stack, 2, Address.zero());
        this.stack = null;
        GC.setAllocationEnabled(oldState);
        VM.threadSwitch();
    }

    static VMThread getOtherThread() {
        return otherThread;
    }

    static Object getOtherThreadStack() {
        return VMThread.otherThread.stack;
    }

    private static void waitForEvent0(int event) {
        VMThread t = currentThread;
        t.setInQueue((byte)4);
        events.put(event, t);
    }

    static void waitForEvent(int event) {
        VMThread.waitForEvent0(event);
        VMThread.reschedule();
    }

    private boolean waitingforEvent() {
        return events.contains(this);
    }

    private static void signalEvent(int event) {
        VMThread thread = events.findEvent(event);
        if (thread != null) {
            VMThread.addToRunnableThreadsQueue(thread);
        }
    }

    private static void waitForOSEvent0(int event) {
        VMThread t = currentThread;
        t.setInQueue((byte)4);
        osevents.put(event, t);
    }

    public static void waitForOSEvent(int event) {
        VMThread.waitForOSEvent0(event);
        VMThread.reschedule();
    }

    private boolean waitingforOSEvent() {
        return osevents.contains(this);
    }

    public static void signalOSEvent(int event) {
        VMThread thread = osevents.findEvent(event);
        if (thread != null) {
            VMThread.addToRunnableThreadsQueue(thread);
        } else {
            VM.print("!!! no thread found waiting on event");
        }
    }

    public int getErrno() {
        return this.errno;
    }

    void setErrno(int newErrno) {
        this.errno = newErrno;
    }

    private static void throwIllegalMonitorStateException(Monitor monitor, Object object) {
        throw new IllegalMonitorStateException("current thread (" + Thread.currentThread() + ") not owner (" + monitor.owner + ")");
    }

    private static boolean releaseMonitor(Monitor monitor) {
        monitor.owner = null;
        monitor.depth = 0;
        VMThread waiter = monitor.removeMonitorWait();
        if (waiter != null) {
            VMThread.addToRunnableThreadsQueue(waiter);
            return true;
        }
        return false;
    }

    static void fixupPendingMonitors() {
        Object object = VM.removeVirtualMonitorObject();
        while (object != null) {
            Monitor monitor = GC.getMonitor(object);
            if (monitor.owner == null) {
                monitor.depth = 1;
                monitor.owner = currentThread;
            } else {
                monitor.depth = (short)(monitor.depth + 1);
            }
            object = VM.removeVirtualMonitorObject();
        }
    }

    static Monitor getMonitor(Object object) {
        VMThread.fixupPendingMonitors();
        return GC.getMonitor(object);
    }

    static Monitor retryMonitor(Object object) {
        Monitor monitor = VMThread.getMonitor(object);
        while (monitor.owner != null) {
            monitor.addMonitorWaitHead(currentThread);
            VMThread.reschedule();
            currentThread.checkInvarients();
            monitor = VMThread.getMonitor(object);
        }
        monitor.owner = currentThread;
        monitor.depth = VMThread.currentThread.monitorDepth;
        VMThread.currentThread.monitor = null;
        VMThread.currentThread.monitorDepth = 0;
        return monitor;
    }

    static void monitorEnter(Object object) {
        currentThread.checkInvarients();
        Monitor monitor = VMThread.getMonitor(object);
        if (monitor.owner == null) {
            monitor.owner = currentThread;
            monitor.depth = 1;
        } else if (monitor.owner == currentThread) {
            if (monitor.depth == Short.MAX_VALUE) {
                throw VM.getOutOfMemoryError();
            }
            monitor.depth = (short)(monitor.depth + 1);
        } else {
            ++contendedEnterCount;
            VMThread.currentThread.monitorDepth = 1;
            monitor.addMonitorWait(currentThread);
            VMThread.reschedule();
            monitor = VMThread.retryMonitor(object);
            currentThread.checkInvarients();
        }
    }

    static void monitorExit(Object object) {
        currentThread.checkInvarients();
        Monitor monitor = VMThread.getMonitor(object);
        if (monitor.owner != currentThread) {
            VMThread.throwIllegalMonitorStateException(monitor, object);
        }
        if ((monitor.depth = (short)(monitor.depth - 1)) == 0) {
            if (VMThread.releaseMonitor(monitor)) {
                if (monitor.hasHadWaiter) {
                    VMThread.addToRunnableThreadsQueue(currentThread);
                    VMThread.reschedule();
                }
            } else if (monitor.condvarQueue == null) {
                GC.removeMonitor(object, !monitor.hasHadWaiter);
            }
        }
        currentThread.checkInvarients();
    }

    private void handlePendingInterrupt() throws InterruptedException {
        if (this.pendingInterrupt) {
            this.pendingInterrupt = false;
            throw new InterruptedException();
        }
    }

    public static void monitorWait(Object object, long delta) throws InterruptedException {
        VMThread theCurrentThread = currentThread;
        theCurrentThread.checkInvarients();
        Monitor monitor = VMThread.getMonitor(object);
        if (monitor.owner != theCurrentThread) {
            VMThread.throwIllegalMonitorStateException(monitor, object);
        }
        theCurrentThread.handlePendingInterrupt();
        monitor.hasHadWaiter = true;
        if (delta > 0L) {
            timerQueue.add(theCurrentThread, delta);
        }
        theCurrentThread.monitorDepth = monitor.depth;
        monitor.addCondvarWait(theCurrentThread);
        VMThread.releaseMonitor(monitor);
        VMThread.reschedule();
        monitor = VMThread.retryMonitor(object);
        theCurrentThread.handlePendingInterrupt();
        theCurrentThread.checkInvarients();
    }

    public static void monitorNotify(Object object, boolean notifyAll) {
        VMThread waiter;
        if (VM.hasVirtualMonitorObject(object)) {
            return;
        }
        Monitor monitor = VMThread.getMonitor(object);
        if (monitor.owner != currentThread) {
            VMThread.throwIllegalMonitorStateException(monitor, object);
        }
        while ((waiter = monitor.removeCondvarWait()) != null) {
            timerQueue.remove(waiter);
            monitor.addMonitorWait(waiter);
            if (notifyAll) continue;
        }
    }

    final boolean inQueue(byte name) {
        return this.inqueue == name;
    }

    final void checkInQueue(byte expectedQueue) throws AllowInlinedPragma {
    }

    final void setInQueue(byte name) {
        this.inqueue = name;
    }

    final void setNotInQueue(byte name) {
        this.inqueue = 0;
    }

    public void interrupt() {
        if (this.state == 1 && currentThread != this) {
            Monitor thisMonitor;
            if (this.waitingToJoin != null) {
                if (this.waitingToJoin.joiners == this) {
                    this.waitingToJoin.joiners = this.nextThread;
                } else {
                    VMThread prev = this.waitingToJoin.joiners;
                    while (prev.nextThread != this) {
                        prev = prev.nextThread;
                    }
                    prev.nextThread = this.nextThread;
                }
                this.waitingToJoin = null;
                this.setNotInQueue((byte)5);
                VMThread.addToRunnableThreadsQueue(this);
            }
            if ((thisMonitor = this.monitor) != null) {
                timerQueue.remove(this);
                thisMonitor.removeCondvarWait(this);
                VMThread.addToRunnableThreadsQueue(this);
            } else if (this.inQueue((byte)8)) {
                timerQueue.remove(this);
                this.setNotInQueue((byte)8);
                VMThread.addToRunnableThreadsQueue(this);
            }
            this.pendingInterrupt = true;
        }
    }

    static long getTimeBeforeAnotherThreadIsRunnable() {
        if (runnableThreads.size() > 0) {
            return 0L;
        }
        return timerQueue.nextDelta();
    }

    public static Thread[] getRunnableThreads() {
        Thread[] result = new Thread[runnableThreads.size()];
        VMThread t = VMThread.runnableThreads.first;
        int i = 0;
        while (t != null) {
            result[i++] = t.getAPIThread();
            t = t.nextThread;
        }
        return result;
    }
}

