/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.Packet;
import com.sun.squawk.debugger.ReplyPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class CommandPacket
extends Packet {
    private final byte set;
    private final byte command;
    private volatile ReplyPacket reply;
    private final boolean needsReply;

    public CommandPacket(int set, int command, boolean needsReply) {
        super(CommandPacket.allocateUniqueID());
        this.set = (byte)set;
        this.command = (byte)command;
        this.needsReply = needsReply;
    }

    public CommandPacket(int id, int dataLength, DataInputStream data, int set, int command, boolean needsReply) throws IOException {
        super(id, dataLength, data);
        this.set = (byte)set;
        this.command = (byte)command;
        this.needsReply = needsReply;
    }

    public int set() {
        return this.set & 0xFF;
    }

    public int command() {
        return this.command & 0xFF;
    }

    public ReplyPacket createReply(int errorCode) {
        return new ReplyPacket(this, errorCode);
    }

    public final boolean needsReply() {
        return this.needsReply;
    }

    public int getFlags() {
        return this.needsReply ? 64 : 0;
    }

    synchronized void setReply(ReplyPacket reply) {
        this.reply = reply;
    }

    public synchronized ReplyPacket getReply() {
        return this.reply;
    }

    protected void writeFields(DataOutputStream dos) throws IOException {
        dos.writeByte(this.set);
        dos.writeByte(this.command);
    }

    public static String toString(int set, int command) {
        String s = Integer.toString(set &= 0xFF);
        String c = Integer.toString(command &= 0xFF);
        block0 : switch (set) {
            case 1: {
                s = "VirtualMachine";
                switch (command) {
                    case 1: {
                        c = "Version";
                        break;
                    }
                    case 2: {
                        c = "ClassesBySignature";
                        break;
                    }
                    case 3: {
                        c = "AllClasses";
                        break;
                    }
                    case 4: {
                        c = "AllThreads";
                        break;
                    }
                    case 5: {
                        c = "TopLevelThreadGroups";
                        break;
                    }
                    case 6: {
                        c = "Dispose";
                        break;
                    }
                    case 7: {
                        c = "IDSizes";
                        break;
                    }
                    case 8: {
                        c = "Suspend";
                        break;
                    }
                    case 9: {
                        c = "Resume";
                        break;
                    }
                    case 10: {
                        c = "Exit";
                        break;
                    }
                    case 11: {
                        c = "CreateString";
                        break;
                    }
                    case 12: {
                        c = "Capabilities";
                        break;
                    }
                    case 13: {
                        c = "ClassPaths";
                        break;
                    }
                    case 14: {
                        c = "DisposeObjects";
                        break;
                    }
                    case 15: {
                        c = "HoldEvents";
                        break;
                    }
                    case 16: {
                        c = "ReleaseEvents";
                        break;
                    }
                    case 17: {
                        c = "CapabilitiesNew";
                    }
                }
                break;
            }
            case 2: {
                s = "ReferenceType";
                switch (command) {
                    case 1: {
                        c = "Signature";
                        break;
                    }
                    case 2: {
                        c = "ClassLoader";
                        break;
                    }
                    case 3: {
                        c = "Modifiers";
                        break;
                    }
                    case 4: {
                        c = "Fields";
                        break;
                    }
                    case 5: {
                        c = "Methods";
                        break;
                    }
                    case 6: {
                        c = "GetValues";
                        break;
                    }
                    case 7: {
                        c = "SourceFile";
                        break;
                    }
                    case 8: {
                        c = "NestedTypes";
                        break;
                    }
                    case 9: {
                        c = "Status";
                        break;
                    }
                    case 10: {
                        c = "Interfaces";
                        break;
                    }
                    case 11: {
                        c = "ClassObject";
                    }
                }
                break;
            }
            case 3: {
                s = "ClassType";
                switch (command) {
                    case 1: {
                        c = "Superclass";
                        break;
                    }
                    case 2: {
                        c = "SetValues";
                        break;
                    }
                    case 3: {
                        c = "InvokeMethod";
                        break;
                    }
                    case 4: {
                        c = "NewInstance";
                    }
                }
                break;
            }
            case 4: {
                s = "ArrayType";
                switch (command) {
                    case 1: {
                        c = "NewInstance";
                    }
                }
                break;
            }
            case 5: {
                s = "InterfaceType";
                c = "";
                break;
            }
            case 6: {
                s = "Method";
                switch (command) {
                    case 1: {
                        c = "LineTable";
                        break;
                    }
                    case 2: {
                        c = "VariableTable";
                        break;
                    }
                    case 3: {
                        c = "Bytecodes";
                    }
                }
                break;
            }
            case 8: {
                s = "Field";
                c = "";
                break;
            }
            case 9: {
                s = "ObjectReference";
                switch (command) {
                    case 1: {
                        c = "ReferenceType";
                        break;
                    }
                    case 2: {
                        c = "GetValues";
                        break;
                    }
                    case 3: {
                        c = "SetValues";
                        break;
                    }
                    case 5: {
                        c = "MonitorInfo";
                        break;
                    }
                    case 6: {
                        c = "InvokeMethod";
                        break;
                    }
                    case 7: {
                        c = "DisableCollection";
                        break;
                    }
                    case 8: {
                        c = "EnableCollection";
                        break;
                    }
                    case 9: {
                        c = "IsCollected";
                    }
                }
                break;
            }
            case 10: {
                s = "StringReference";
                switch (command) {
                    case 1: {
                        c = "Value";
                    }
                }
                break;
            }
            case 11: {
                s = "ThreadReference";
                switch (command) {
                    case 1: {
                        c = "Name";
                        break;
                    }
                    case 2: {
                        c = "Suspend";
                        break;
                    }
                    case 3: {
                        c = "Resume";
                        break;
                    }
                    case 4: {
                        c = "Status";
                        break;
                    }
                    case 5: {
                        c = "ThreadGroup";
                        break;
                    }
                    case 6: {
                        c = "Frames";
                        break;
                    }
                    case 7: {
                        c = "FrameCount";
                        break;
                    }
                    case 8: {
                        c = "OwnedMonitors";
                        break;
                    }
                    case 9: {
                        c = "CurrentContendedMonitor";
                        break;
                    }
                    case 10: {
                        c = "Stop";
                        break;
                    }
                    case 11: {
                        c = "Interrupt";
                        break;
                    }
                    case 12: {
                        c = "SuspendCount";
                    }
                }
                break;
            }
            case 12: {
                s = "ThreadGroupReference";
                switch (command) {
                    case 1: {
                        c = "Name";
                        break;
                    }
                    case 2: {
                        c = "Parent";
                        break;
                    }
                    case 3: {
                        c = "Children";
                    }
                }
                break;
            }
            case 13: {
                s = "ArrayReference";
                switch (command) {
                    case 1: {
                        c = "Length";
                        break;
                    }
                    case 2: {
                        c = "GetValues";
                        break;
                    }
                    case 3: {
                        c = "SetValues";
                    }
                }
                break;
            }
            case 14: {
                s = "ClassLoaderReference";
                switch (command) {
                    case 1: {
                        c = "VisibleClasses";
                    }
                }
                break;
            }
            case 15: {
                s = "EventRequest";
                switch (command) {
                    case 1: {
                        c = "Set";
                        break;
                    }
                    case 2: {
                        c = "Clear";
                        break;
                    }
                    case 3: {
                        c = "ClearAllBreakpoints";
                    }
                }
                break;
            }
            case 16: {
                s = "StackFrame";
                switch (command) {
                    case 1: {
                        c = "GetValues";
                        break;
                    }
                    case 2: {
                        c = "SetValues";
                        break;
                    }
                    case 3: {
                        c = "ThisObject";
                    }
                }
                break;
            }
            case 17: {
                s = "ClassObjectReference";
                switch (command) {
                    case 1: {
                        c = "ReflectedType";
                    }
                }
                break;
            }
            case 64: {
                s = "Event";
                switch (command) {
                    case 100: {
                        c = "Composite";
                    }
                }
                break;
            }
            case 128: {
                s = "SDWP";
                switch (command) {
                    case 2: {
                        c = "SteppingInfo";
                        break block0;
                    }
                    case 3: {
                        c = "AllThreads";
                        break block0;
                    }
                    case 4: {
                        c = "ThreadStateChanged";
                    }
                }
            }
        }
        return s + "." + c;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("CommandPacket[id=").append(this.getID()).append(",size=").append(this.getSize()).append("]:").append(CommandPacket.toString(this.set, this.command));
        if (Log.debug()) {
            this.appendData(buf);
        }
        return buf.toString();
    }
}

