/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.Debugger;
import com.sun.squawk.debugger.EventNotifier;
import com.sun.squawk.debugger.EventRequest;
import com.sun.squawk.debugger.EventRequestModifier;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.SDWPException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class EventManager
implements Runnable,
EventNotifier.Consumer {
    protected final EventNotifier notifier = new EventNotifier();
    protected Vector requests = new Vector();
    private boolean done;
    private final EventRequestModifier.Matcher matcher;

    protected EventManager(EventRequestModifier.Matcher matcher) {
        this.matcher = matcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            this.notifier.consumeEvent(this);
        }
        this.clear(0, 0);
        EventNotifier eventNotifier = this.notifier;
        synchronized (eventNotifier) {
            this.notifier.notifyAll();
        }
        if (Log.info()) {
            Log.log("Completed shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quit() {
        if (!this.done) {
            this.done = true;
            if (Log.info()) {
                Log.log("Initiating shutdown of event manager...");
            }
            EventNotifier eventNotifier = this.notifier;
            synchronized (eventNotifier) {
                this.notifier.notifyAll();
            }
            return false;
        }
        return true;
    }

    public void register(EventRequest request) {
        this.requests.addElement(request);
        request.registered();
        if (Log.info()) {
            Log.log("Registered handler for event: " + request);
        }
        if (Log.debug()) {
            this.logRegisteredRequests();
        }
    }

    public boolean clear(int eventKind, int requestID) {
        EventRequest request;
        Vector kept = null;
        Vector cleared = null;
        Enumeration e = this.requests.elements();
        while (e.hasMoreElements()) {
            request = (EventRequest)e.nextElement();
            if (requestID == 0 ? eventKind != 0 && request.kind != eventKind : request.id != requestID) {
                if (kept == null) {
                    kept = new Vector(this.requests.size());
                }
                kept.addElement(request);
                continue;
            }
            if (cleared == null) {
                cleared = new Vector();
            }
            cleared.addElement(request);
        }
        if (kept != null) {
            this.requests = kept;
        } else {
            this.requests.removeAllElements();
        }
        if (cleared != null) {
            e = cleared.elements();
            while (e.hasMoreElements()) {
                request = (EventRequest)e.nextElement();
                if (Log.info()) {
                    Log.log("Clearing event request: " + request);
                }
                request.cleared();
            }
        }
        if (Log.debug()) {
            this.logRegisteredRequests();
        }
        return cleared != null;
    }

    public Enumeration getEventsOfKind(int eventKind) {
        Vector matchingEvents = new Vector();
        Enumeration e = this.requests.elements();
        while (e.hasMoreElements()) {
            EventRequest request = (EventRequest)e.nextElement();
            if (request.kind != eventKind) continue;
            matchingEvents.addElement(request);
        }
        return matchingEvents.elements();
    }

    public final void produceEvent(Debugger.Event event) {
        this.notifier.produceEvent(event, this);
    }

    public final boolean isDone() {
        return this.done;
    }

    public MatchedRequests matchRequests(Debugger.Event event) {
        Vector matchedRequests = null;
        int suspendPolicy = 0;
        boolean vmDeath = false;
        Enumeration e = this.requests.elements();
        while (e.hasMoreElements()) {
            EventRequest request = (EventRequest)e.nextElement();
            if (Log.debug()) {
                Log.log("Testing event request for match: " + request);
            }
            if (!request.matchKind(event.kind) || !request.matchModifiers(this.matcher, event)) continue;
            if (Log.verbose()) {
                Log.log("Matched event request: " + request);
            }
            if (matchedRequests == null) {
                matchedRequests = new Vector();
            }
            matchedRequests.addElement(request);
            if (request.kind == 99) {
                vmDeath = true;
            }
            if (request.suspendPolicy <= suspendPolicy) continue;
            suspendPolicy = request.suspendPolicy;
        }
        return new MatchedRequests(matchedRequests, vmDeath, suspendPolicy);
    }

    public void consumeEvent(Debugger.Event event) throws IOException {
        if (this.done) {
            return;
        }
        if (Log.info()) {
            Log.log("Got event: " + event);
        }
        MatchedRequests mr = this.matchRequests(event);
        if (mr.requests != null) {
            try {
                this.send(event, mr);
            }
            catch (SDWPException e) {
                if (Log.info()) {
                    Log.log("Error while notifying debugger of " + event + ": " + e);
                }
            }
        } else if (Log.info()) {
            Log.log("No matching event request found");
        }
        if (mr.vmDeath) {
            this.quit();
        }
    }

    public void logRegisteredRequests() {
        Log.log("Registered event requests [count=" + this.requests.size() + "]: ");
        Enumeration e = this.requests.elements();
        while (e.hasMoreElements()) {
            EventRequest request = (EventRequest)e.nextElement();
            Log.log("    " + request);
        }
    }

    public abstract void send(Debugger.Event var1, MatchedRequests var2) throws IOException, SDWPException;

    public abstract boolean isMyEventRequestID(int var1);

    public static class MatchedRequests {
        public final Vector requests;
        public final boolean vmDeath;
        public final int suspendPolicy;

        public MatchedRequests(Vector requests, boolean vmDeath, int suspendPolicy) {
            this.requests = requests;
            this.vmDeath = vmDeath;
            this.suspendPolicy = suspendPolicy;
        }
    }
}

