/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.JDWPConnection;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.Packet;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.debugger.PacketOutputStream;
import com.sun.squawk.debugger.ReplyPacket;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntHashtable;
import java.io.IOException;
import java.util.Enumeration;

public abstract class JDWPListener
implements Runnable {
    private Thread thisThread;
    private final IntHashtable sentCommands = new IntHashtable();
    private volatile String quittingThread;
    private JDWPConnection connection;
    protected JDWPListener otherHost;

    public void bindProxyPeer(JDWPListener p) {
        this.otherHost = p;
        p.otherHost = this;
    }

    public void open(String url, byte[] handshake, boolean initiate, boolean isJDB, Runnable delayer) throws IOException {
        this.connection = new JDWPConnection(url, handshake, initiate, isJDB, delayer);
    }

    protected abstract void processCommand(CommandPacket var1) throws IOException;

    public final void run() {
        block11: {
            this.thisThread = Thread.currentThread();
            if (Log.info()) {
                Log.log("Started event loop");
            }
            try {
                while (!this.hasQuit()) {
                    Packet packet = this.connection.readPacket();
                    if (packet instanceof ReplyPacket) {
                        this.replyReceived((ReplyPacket)packet);
                        continue;
                    }
                    CommandPacket command = (CommandPacket)packet;
                    if (Log.info()) {
                        Log.log("Received from " + this.sourceName() + ": " + command);
                    }
                    this.processCommand(command);
                }
            }
            catch (QuitException e) {
                if (Log.info()) {
                    Log.log(e.getMessage());
                }
            }
            catch (JDWPConnection.ClosedException e) {
                if (Log.info()) {
                    Log.log("Stopping JDWP as connection was closed: " + e.getMessage());
                }
            }
            catch (IOException e) {
                if (!Log.info()) break block11;
                Log.log("Stopping JDWP listener due to exception: " + e);
                e.printStackTrace();
            }
        }
        if (Log.info()) {
            Log.log("Completed event loop");
        }
        this.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyReceived(ReplyPacket reply) {
        CommandPacket command;
        int id = reply.getID();
        Object object = this.sentCommands;
        synchronized (object) {
            command = (CommandPacket)this.sentCommands.remove(id);
            if (command == null) {
                if (Log.info()) {
                    Log.log("***** Received reply with no sender: " + reply);
                }
                return;
            }
        }
        object = command;
        synchronized (object) {
            command.setReply(reply);
            command.notifyAll();
            if (Log.info()) {
                Log.log("Received from " + this.sourceName() + ": " + reply);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ReplyPacket sendCommand(CommandPacket command) throws IOException, SDWPException {
        if (Log.info()) {
            Log.log("Sending to " + this.sourceName() + ": " + command);
        }
        if (command.needsReply()) {
            Object object = this.sentCommands;
            synchronized (object) {
                this.connection.writePacket(command);
                if (Log.debug()) {
                    Log.log("Waiting for reply to: " + command);
                }
                if (Thread.currentThread() == this.thisThread) {
                    if (Log.info()) {
                        Log.log("Serialized wait for reply to: " + command);
                    }
                    Assert.always(this.sentCommands.isEmpty(), "JDWPListener.java", 229);
                    Packet packet = this.connection.readPacket();
                    Assert.always(packet instanceof ReplyPacket, "JDWPListener.java", 231);
                    ReplyPacket reply = (ReplyPacket)packet;
                    Assert.always(reply.getID() == command.getID(), "JDWPListener.java", 233);
                    command.setReply(reply);
                    return reply;
                }
                this.sentCommands.put(command.getID(), command);
            }
            object = command;
            synchronized (object) {
                ReplyPacket reply;
                while ((reply = command.getReply()) == null) {
                    this.checkQuit();
                    try {
                        command.wait();
                    }
                    catch (InterruptedException e) {
                        if (!Log.verbose()) continue;
                        Log.log("Waiting for reply interrupted: " + command);
                    }
                }
                this.checkQuit();
                if (reply.getErrorCode() != 0) {
                    throw new SDWPException(reply.getErrorCode(), "reply to " + command + " had an error");
                }
                return command.getReply();
            }
        }
        this.connection.writePacket(command);
        return null;
    }

    public final void sendReply(ReplyPacket reply) throws IOException {
        this.connection.writePacket(reply);
        if (Log.info()) {
            Log.log("Sent reply to " + this.sourceName() + ": " + reply);
        }
    }

    private void checkQuit() throws QuitException {
        if (this.quittingThread != null) {
            throw new QuitException(this.quittingThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quit() {
        boolean quitPreviously;
        JDWPListener jDWPListener = this;
        synchronized (jDWPListener) {
            quitPreviously = this.quittingThread != null;
            this.quittingThread = Thread.currentThread().toString();
            if (!quitPreviously) {
                if (Log.info()) {
                    Log.log("Initiating shutdown of " + this + "...");
                }
                IntHashtable intHashtable = this.sentCommands;
                synchronized (intHashtable) {
                    Enumeration e = this.sentCommands.elements();
                    while (e.hasMoreElements()) {
                        Object command;
                        Object object = command = e.nextElement();
                        synchronized (object) {
                            command.notifyAll();
                        }
                    }
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }
        if (!quitPreviously && this.otherHost != null) {
            this.otherHost.quit();
        }
        return quitPreviously;
    }

    public boolean hasQuit() {
        return this.quittingThread != null;
    }

    public abstract String sourceName();

    public PacketInputStream getInputStreamFor(CommandPacket command) {
        return command.getInputStream();
    }

    public static abstract class CommandSet {
        protected CommandPacket command;
        protected ReplyPacket reply;
        protected PacketInputStream in;
        protected PacketOutputStream out;

        public final boolean handle(JDWPListener listener, CommandPacket command) throws IOException {
            this.command = command;
            this.reply = command.createReply(0);
            this.in = listener.getInputStreamFor(command);
            this.out = this.reply.getOutputStream();
            boolean handled = true;
            try {
                handled = this.dispatch();
            }
            catch (SDWPException e) {
                if (Log.info()) {
                    System.err.println(command + " caused: " + e);
                    e.printStackTrace();
                }
                this.error(e.getError());
            }
            catch (IOException e) {
                System.err.println(command + " caused: " + e);
                e.printStackTrace();
                this.error(41);
            }
            if (handled) {
                if (command.needsReply()) {
                    listener.sendReply(this.reply);
                }
                this.postDispatch();
            }
            return handled;
        }

        protected abstract boolean dispatch() throws IOException, SDWPException;

        protected final void error(int errorCode) {
            this.reply.updateErrorCode(errorCode);
        }

        protected final void unimplemented() {
            this.error(99);
        }

        protected void postDispatch() {
        }
    }

    public static class QuitException
    extends RuntimeException {
        QuitException(String closedBy) {
            super("Quit by " + closedBy);
        }
    }
}

