/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sda;

import com.sun.squawk.DebuggerSupport;
import com.sun.squawk.GC;
import com.sun.squawk.Klass;
import com.sun.squawk.VMThread;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.JDWP;
import com.sun.squawk.debugger.PacketOutputStream;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.debugger.sda.WeakIntHashtable;
import java.io.IOException;

public class ObjectManager {
    private final WeakIntHashtable objects = new WeakIntHashtable();
    int objectIDCounter = 1;

    public DataType.ObjectID getIDForObject(Object object) {
        return new DataType.ObjectID(this.getIDForObject0(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getIDForObject0(Object object) {
        if (object == null) {
            return 0;
        }
        int romObjectID = DebuggerSupport.getIDForROMObject(object);
        if (romObjectID != 0) {
            int objectID = -romObjectID;
            return objectID;
        }
        Integer objectID = this.objects.getKey(object);
        if (objectID == null) {
            int newObjectID;
            ObjectManager objectManager = this;
            synchronized (objectManager) {
                newObjectID = this.objectIDCounter++;
            }
            Object oldVal = this.objects.put(newObjectID, object);
            return newObjectID;
        }
        return objectID;
    }

    public synchronized Object getObjectForID(DataType.ObjectID objectID) throws SDWPException {
        int id = objectID.id;
        if (id == 0) {
            return null;
        }
        if (id > 0) {
            Object object = this.objects.get(id);
            if (object == null) {
                throw new SDWPException(20, "object ID denotes a non-existent or garbage collected object: " + id);
            }
            return object;
        }
        return DebuggerSupport.getROMObjectForID(-id);
    }

    public VMThread getThreadForID(DataType.ObjectID objectID) throws SDWPException {
        try {
            return (VMThread)this.getObjectForID(objectID);
        }
        catch (ClassCastException e) {
            throw new SDWPException(10, "object ID does not denote a VMThread instance");
        }
    }

    public String getStringForID(DataType.ObjectID objectID) throws SDWPException {
        try {
            return (String)this.getObjectForID(objectID);
        }
        catch (ClassCastException e) {
            throw new SDWPException(506, "object ID does not denote a String instance");
        }
    }

    public Klass getClassForID(DataType.ObjectID objectID) throws SDWPException {
        try {
            return (Klass)this.getObjectForID(objectID);
        }
        catch (ClassCastException e) {
            throw new SDWPException(21, "object ID does not denote a Klass instance");
        }
    }

    public void writeTaggedObject(PacketOutputStream out, Object object, String s) throws IOException {
        int tag = 76;
        DataType.ObjectID objectID = this.getIDForObject(object);
        if (object != null) {
            Klass klass = GC.getKlass(object);
            tag = JDWP.getTag(klass);
        }
        out.writeTaggedObjectID(new DataType.TaggedObjectID(tag, objectID.id), s);
    }
}

