/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sda;

import com.sun.squawk.Debugger;
import com.sun.squawk.DebuggerSupport;
import com.sun.squawk.ExecutionPoint;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.Suite;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.EventManager;
import com.sun.squawk.debugger.EventRequest;
import com.sun.squawk.debugger.EventRequestModifier;
import com.sun.squawk.debugger.JDWP;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.debugger.PacketOutputStream;
import com.sun.squawk.debugger.ReplyPacket;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.debugger.sda.ObjectManager;
import com.sun.squawk.debugger.sda.SDPListener;
import com.sun.squawk.util.Assert;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;

public final class SDA
extends Debugger {
    private Hashtable classToIdTable;
    private Hashtable idToClassTable;
    private String url;
    private SDPListener sdp;
    private Isolate debuggeeIsolate;
    private Isolate debuggerIsolate = VM.getCurrentIsolate();
    private ObjectManager objectManager;
    private boolean vmStartEventSent = false;
    private SDAEventManager eventManager;
    private static final String DEFAULT_APPCLASSPATH = "file://.";
    private static final String DEFAULT_URL = "serversocket://:2800";

    private void initializeClassIDs(Suite suite, Hashtable processed) {
        if (!suite.isBootstrap()) {
            this.initializeClassIDs(suite.getParent(), processed);
        }
        if (processed.containsKey(suite)) {
            return;
        }
        int count = suite.getClassCount();
        for (int i = 0; i != count; ++i) {
            Klass klass = suite.getKlass(i);
            if (klass.isInternalType()) continue;
            this.getIDForClass(klass);
        }
        processed.put(suite, suite);
    }

    private void initializeClassIDTable() {
        if (this.classToIdTable == null) {
            this.classToIdTable = new Hashtable();
            this.idToClassTable = new Hashtable();
            Hashtable processed = new Hashtable();
            Suite suite = this.debuggerIsolate.getLeafSuite();
            this.initializeClassIDs(suite, processed);
            suite = this.debuggeeIsolate.getLeafSuite();
            this.initializeClassIDs(suite, processed);
        }
    }

    Enumeration getClasses() {
        this.initializeClassIDTable();
        return this.classToIdTable.keys();
    }

    Klass getClassForID(DataType.ReferenceTypeID classID, int errorCode) throws SDWPException {
        Klass klass = (Klass)this.idToClassTable.get(classID);
        if (klass == null) {
            throw new SDWPException(errorCode, "cannot resolve class for identifier: " + classID);
        }
        return klass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final DataType.ReferenceTypeID getIDForClass(Klass klass) {
        this.initializeClassIDTable();
        DataType.ReferenceTypeID typeID = (DataType.ReferenceTypeID)this.classToIdTable.get(klass);
        if (typeID == null) {
            Hashtable hashtable = this.classToIdTable;
            synchronized (hashtable) {
                int id = this.classToIdTable.size() + 1;
                typeID = new DataType.ReferenceTypeID(id);
                this.classToIdTable.put(klass, typeID);
                this.idToClassTable.put(typeID, klass);
            }
        }
        return typeID;
    }

    void writeAllClasses(PacketOutputStream out) throws IOException {
        this.initializeClassIDTable();
        int size = this.classToIdTable.size();
        out.writeInt(size, "classes");
        Enumeration classes = this.classToIdTable.keys();
        Enumeration ids = this.classToIdTable.elements();
        String lastName = "";
        for (int i = 0; i < size; ++i) {
            int commonPrefix;
            Klass klass = (Klass)classes.nextElement();
            DataType.ReferenceTypeID id = (DataType.ReferenceTypeID)ids.nextElement();
            String name = klass.getInternalName();
            int minLength = Math.min(name.length(), lastName.length());
            for (commonPrefix = 0; commonPrefix < minLength && name.charAt(commonPrefix) == lastName.charAt(commonPrefix); ++commonPrefix) {
            }
            if (commonPrefix > 255) {
                commonPrefix = 0;
            }
            out.writeReferenceTypeID(id, "typeID");
            out.writeByte(commonPrefix, "commonPrefix");
            out.writeString(commonPrefix == 0 ? name : name.substring(commonPrefix), "name");
            lastName = name;
        }
    }

    private void cleanupForDetach() {
        this.debuggeeIsolate.updateBreakpoints(null);
        this.eventManager.clear(0, 0);
        this.eventManager.quit();
        DebuggerSupport.setDebugger(this.debuggeeIsolate, this, false);
    }

    void resumeIsolate(boolean forDetach) {
        if (forDetach) {
            this.cleanupForDetach();
        }
        Enumeration e = this.debuggeeIsolate.getChildThreads();
        while (e.hasMoreElements()) {
            VMThread vmThread = (VMThread)e.nextElement();
            vmThread.resumeForDebugger(forDetach);
        }
    }

    SDPListener getListener() {
        return this.sdp;
    }

    public boolean hasQuit() {
        return this.sdp.hasQuit();
    }

    Klass getClassForID(DataType.ReferenceTypeID id) throws SDWPException {
        return this.getClassForID(id, 21);
    }

    Object getObjectForID(DataType.ObjectID id) throws SDWPException {
        return this.objectManager.getObjectForID(id);
    }

    DataType.ObjectID getIDForObject(Object object) {
        return this.objectManager.getIDForObject(object);
    }

    void suspendThreads(VMThread vmThread) {
        if (vmThread != null) {
            if (Log.info()) {
                Log.log("Suspending thread: " + vmThread.getName());
            }
            vmThread.suspendForDebugger();
        } else {
            if (Log.info()) {
                Log.log("Suspending all threads");
            }
            Enumeration e = this.debuggeeIsolate.getChildThreads();
            while (e.hasMoreElements()) {
                vmThread = (VMThread)e.nextElement();
                vmThread.suspendForDebugger();
            }
        }
        this.sendThreadStateChanged();
    }

    void sendThreadStateChanged() {
        CommandPacket command = new CommandPacket(128, 4, false);
        try {
            PacketOutputStream out = command.getOutputStream();
            this.writeThreadState(out);
            this.sdp.sendCommand(command);
        }
        catch (SDWPException e) {
            Assert.shouldNotReachHere("SDA.java", 311);
        }
        catch (IOException e) {
            System.err.println("IO error when sending SquawkVM_ThreadStateChanged_COMMAND to proxy");
            e.printStackTrace();
        }
    }

    void writeThreadState(PacketOutputStream out) throws IOException {
        int count = this.debuggeeIsolate.getChildThreadCount();
        out.writeInt(count, "threads");
        Enumeration e = this.debuggeeIsolate.getChildThreads();
        while (e.hasMoreElements()) {
            VMThread vmThread = (VMThread)e.nextElement();
            out.writeObjectID(this.getIDForObject(vmThread), "thread");
            out.writeInt(DebuggerSupport.getThreadJDWPState(vmThread), "state");
            out.writeInt(vmThread.getDebuggerSuspendCount(), "suspendCount");
            out.writeString(vmThread.getName(), "name");
        }
    }

    void resumeThreads(VMThread thread) {
        if (thread != null) {
            if (Log.info()) {
                Log.log("Resuming thread: " + thread.getName());
            }
            thread.resumeForDebugger(false);
        } else {
            if (Log.info()) {
                Log.log("Resuming all threads");
            }
            this.resumeIsolate(false);
        }
        this.sendThreadStateChanged();
    }

    int getClassStatus(Klass klass) {
        if (klass.isArray() || klass.isPrimitive() || klass.isSquawkPrimitive()) {
            return 0;
        }
        int status = 7;
        return status;
    }

    Isolate getDebuggeeIsolate() {
        return this.debuggeeIsolate;
    }

    ObjectManager getObjectManager() {
        return this.objectManager;
    }

    SDAEventManager getEventManager() {
        return this.eventManager;
    }

    public synchronized void notifyEvent(Debugger.Event event) {
        if (!this.hasQuit()) {
            Thread thread = Thread.currentThread();
            DataType.ObjectID threadID = this.objectManager.getIDForObject(VMThread.asVMThread(thread));
            event.setThread(thread, threadID);
            this.eventManager.produceEvent(event);
        }
    }

    public void updateBreakpoints() {
        Enumeration e = this.eventManager.getEventsOfKind(2);
        if (!e.hasMoreElements()) {
            this.debuggeeIsolate.updateBreakpoints(null);
            return;
        }
        Vector breakpoints = new Vector(5);
        while (e.hasMoreElements()) {
            EventRequest request = (EventRequest)e.nextElement();
            EventRequestModifier[] mods = request.modifiers;
            for (int j = 0; j < mods.length; ++j) {
                if (!(mods[j] instanceof EventRequestModifier.LocationOnly)) continue;
                EventRequestModifier.LocationOnly loc = (EventRequestModifier.LocationOnly)mods[j];
                DataType.Location location = loc.location;
                DataType.MethodID methodID = location.method;
                try {
                    Klass definingClass = this.getClassForID(loc.location.definingClass);
                    Object method = DebuggerSupport.getMethodBody(definingClass, methodID.getOffset(), methodID.isStatic());
                    long offset = location.offset;
                    Isolate.Breakpoint bp = new Isolate.Breakpoint(method, (int)offset);
                    if (breakpoints.contains(bp)) continue;
                    breakpoints.addElement(bp);
                    continue;
                }
                catch (SDWPException ex) {
                    if (!Log.info()) continue;
                    Log.log("Error while updating breakpoints: " + ex);
                }
            }
        }
        Object[] bps = new Isolate.Breakpoint[breakpoints.size()];
        breakpoints.copyInto(bps);
        this.debuggeeIsolate.updateBreakpoints((Isolate.Breakpoint[])bps);
    }

    private SDA() {
    }

    private static String makeURL(String arg) {
        if (arg.indexOf(58) == -1) {
            arg = "file://" + arg;
        }
        return arg;
    }

    boolean parseArgs(String[] args) {
        int argc;
        String mainClassName = null;
        String[] mainClassArgs = new String[]{};
        String appSuite = VMThread.currentThread().getIsolate().getParentSuiteSourceURI();
        String logLevel = "none";
        String logURL = null;
        String appClassPath = DEFAULT_APPCLASSPATH;
        this.url = DEFAULT_URL;
        String outURL = null;
        String errURL = null;
        Vector newProps = new Vector();
        for (argc = 0; argc != args.length; ++argc) {
            String arg = args[argc];
            try {
                if (arg.charAt(0) != '-') break;
                if (arg.startsWith("-suite:")) {
                    appSuite = arg.substring("-suite:".length());
                    if (appSuite.indexOf(58) != -1) continue;
                    appSuite = "file://" + appSuite + ".suite";
                    continue;
                }
                if (arg.startsWith("-url:")) {
                    this.url = arg.substring("-url:".length());
                    continue;
                }
                if (arg.startsWith("-log:")) {
                    logLevel = arg.substring("-log:".length());
                    continue;
                }
                if (arg.startsWith("-logURL:")) {
                    logURL = SDA.makeURL(arg.substring("-logURL:".length()));
                    continue;
                }
                if (arg.startsWith("-outURL:")) {
                    outURL = SDA.makeURL(arg.substring("-outURL:".length()));
                    continue;
                }
                if (arg.startsWith("-errURL:")) {
                    errURL = SDA.makeURL(arg.substring("-errURL:".length()));
                    continue;
                }
                if (arg.startsWith("-D")) {
                    String propAndValue = arg.substring("-D".length());
                    int seperator = propAndValue.indexOf(61);
                    String prop = propAndValue.substring(0, seperator);
                    String val = propAndValue.substring(seperator + 1);
                    System.out.println("Setting property " + prop + " to " + val);
                    String[] pair = new String[]{prop, val};
                    newProps.addElement(pair);
                    continue;
                }
                if (arg.equals("-h")) {
                    this.usage(null);
                    return false;
                }
                this.usage("Unknown option: " + arg);
                return false;
            }
            catch (NumberFormatException e) {
                System.err.println("Badly formatted option: " + arg);
                return false;
            }
        }
        this.debuggerIsolate.setProperty("squawk.debugger.log.level", logLevel);
        if (logURL != null) {
            if (logURL.indexOf("file://") != -1) {
                try {
                    Connector.openOutputStream(logURL).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (logURL.indexOf("append=true") == -1) {
                    logURL = logURL + ";append=true";
                }
            }
            this.debuggerIsolate.setProperty("squawk.debugger.log.url", logURL);
        }
        if (argc != args.length) {
            mainClassName = args[argc++];
            if (argc != args.length) {
                int argsCount = args.length - argc;
                mainClassArgs = new String[argsCount];
                System.arraycopy(args, argc, mainClassArgs, 0, argsCount);
            }
        }
        if (mainClassName == null) {
            this.usage("Missing application main class name");
            return false;
        }
        this.debuggeeIsolate = new Isolate(mainClassName, mainClassArgs, appClassPath, appSuite);
        Enumeration e = newProps.elements();
        while (e.hasMoreElements()) {
            String[] prop = (String[])e.nextElement();
            this.debuggeeIsolate.setProperty(prop[0], prop[1]);
        }
        this.debuggeeIsolate.setProperty("squawk.debugger.log.level", logLevel);
        if (logURL != null) {
            this.debuggeeIsolate.setProperty("squawk.debugger.log.url", logURL);
        }
        if (outURL != null) {
            this.debuggeeIsolate.clearOut();
            if (outURL.length() > 0) {
                this.debuggeeIsolate.addOut(outURL);
            }
        }
        if (errURL != null) {
            this.debuggeeIsolate.clearErr();
            if (errURL.length() > 0) {
                this.debuggeeIsolate.addErr(errURL);
            }
        }
        return true;
    }

    private void usage(String errMsg) {
        PrintStream out = System.out;
        if (errMsg != null) {
            out.println(errMsg);
        }
        out.println("Usage: SDA [-options] class [args...]");
        out.println("where options include:");
        out.println();
        out.println("    -suite:<suite>   specifies the suite containing the application");
        out.println("    -url:<url>       specifies the URL of the channel that the debug agent will");
        out.println("                     listen on for a connection from a debugger proxy.");
        out.println("                     (default is serversocket://:2800)");
        out.println("    -log:<level>     sets logging level to 'none, 'info', 'verbose' or 'debug'");
        out.println("    -logURL:<url>    where messages should be logged (default is stdout)");
        out.println("    -outURL:<url>    where the debugee's output stream should be logged. If no <url>");
        out.println("                     is specified, then output is dropped. (default is stdout)");
        out.println("    -errURL:<url>    where the debugee's err stream should be logged. If no <url>");
        out.println("                     is specified, then err is dropped. (default is stderr)");
        out.println("    -D<name>=<value> set a system property in the application being debugged");
        out.println("    -h               shows this usage message");
        out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean go() {
        if (this.debuggeeIsolate.isHibernated() || this.debuggeeIsolate.isExited()) {
            return false;
        }
        int defaultSuspendPolicy = 2;
        VMStart autoVMStartEvent = new VMStart(2);
        this.objectManager = new ObjectManager();
        this.eventManager = new SDAEventManager(new MatcherImpl());
        this.eventManager.register(autoVMStartEvent);
        this.eventManager.register(new ThreadStartOrEnd(6, 0));
        this.eventManager.register(new ThreadStartOrEnd(7, 0));
        this.eventManager.register(new VMDeath(0));
        if (defaultSuspendPolicy == 0 && this.debuggeeIsolate.isNew()) {
            this.debuggeeIsolate.start();
        }
        Thread evtThread = new Thread(this.eventManager, "EventManager");
        while (true) {
            try {
                this.sdp = new SDPListener(this);
                System.out.println("Listening for connection from proxy on " + this.url);
                this.sdp.open(this.url, "SDWP-Handshake".getBytes(), false, false, null);
            }
            catch (InterruptedIOException e) {
                if (!this.debuggeeIsolate.isHibernated() && !this.debuggeeIsolate.isExited()) continue;
                return false;
            }
            catch (IOException e) {
                System.out.println("Failed to establish connection to proxy: " + e.getMessage());
                e.printStackTrace();
                return e.getMessage().indexOf("BindException") == -1;
            }
            break;
        }
        try {
            Thread sdpThread = new Thread(this.sdp, "SDPListener");
            sdpThread.start();
            evtThread.start();
            DebuggerSupport.setDebugger(this.debuggeeIsolate, this, true);
            if (this.debuggeeIsolate.isNew()) {
                if (Log.info()) {
                    Log.log("Starting application: " + SDA.getMainAndArgs(this.debuggeeIsolate));
                }
                this.debuggeeIsolate.start();
            } else {
                if (Log.info()) {
                    Log.log("Attaching to application: " + SDA.getMainAndArgs(this.debuggeeIsolate));
                }
                try {
                    Vector oneEvent = new Vector(1);
                    oneEvent.addElement(autoVMStartEvent);
                    this.eventManager.send(null, new EventManager.MatchedRequests(oneEvent, false, 2));
                }
                catch (SDWPException e) {
                    System.out.println("Error while sending VM_INIT to proxy: " + e.getMessage());
                    e.printStackTrace();
                }
                catch (IOException e) {
                    System.out.println("IO error while sending VM_INIT to proxy: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            try {
                sdpThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (Log.info()) {
                Log.log("Detaching debuggee isolate...");
            }
            if (!this.sdp.hasQuit()) {
                this.resumeIsolate(true);
                this.sdp.quit();
            }
        }
        try {
            this.eventManager.quit();
            evtThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (Log.info()) {
            Log.log("Completed shutdown");
        }
        return this.debuggeeIsolate.isAlive();
    }

    private static String getMainAndArgs(Isolate isolate) {
        StringBuffer buf = new StringBuffer(isolate.getMainClassName());
        String[] args = isolate.getMainClassArguments();
        for (int i = 0; i != args.length; ++i) {
            buf.append(' ').append(args[i]);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        Assert.always(!VM.isHosted(), "Squawk Debugger Agent can only run on a native Squawk VM, not hosted", "SDA.java", 1434);
        VMThread.currentThread().setName("SDA");
        SDA debugger = new SDA();
        if (!debugger.parseArgs(args)) {
            System.exit(1);
        }
        try {
            while (debugger.go()) {
            }
        }
        catch (RuntimeException e) {
            if (debugger.sdp != null) {
                debugger.sdp.quit();
            }
            throw e;
        }
        catch (Error e) {
            if (debugger.sdp != null) {
                debugger.sdp.quit();
            }
            throw e;
        }
        finally {
            System.out.println("Debug agent disconnected from application");
        }
        if (debugger.getDebuggeeIsolate() != null) {
            System.exit(debugger.getDebuggeeIsolate().getExitCode());
        }
    }

    class Unsupported
    extends SDAEventRequest {
        public Unsupported(int id, PacketInputStream in, int kind) throws SDWPException, IOException {
            super(id, in, kind);
        }

        public void write(PacketOutputStream out, Debugger.Event event, int suspendPolicy) throws IOException {
            Assert.shouldNotReachHere("SDA.java", 1019);
        }

        public boolean matchKind(int eventKind) {
            return false;
        }
    }

    final class VMDeath
    extends SDAEventRequest {
        public VMDeath(int suspendPolicy) {
            super(99, suspendPolicy);
        }

        public VMDeath(int id, PacketInputStream in) throws SDWPException, IOException {
            super(id, in, 99);
        }

        public boolean matchKind(int eventKind) {
            return SDA.this.vmStartEventSent && (eventKind == 99 || eventKind == 7 && SDA.this.debuggeeIsolate.getChildThreadCount() <= 1);
        }

        public void write(PacketOutputStream out, Debugger.Event event, int suspendPolicy) throws IOException {
        }
    }

    final class ExceptionRequest
    extends SDAEventRequest {
        public ExceptionRequest(int id, PacketInputStream in) throws SDWPException, IOException {
            super(id, in, 4);
        }

        public void write(PacketOutputStream out, Debugger.Event evt, int suspendPolicy) throws IOException {
            Debugger.ExceptionEvent event = (Debugger.ExceptionEvent)evt;
            out.writeObjectID((DataType.ObjectID)event.getThreadID(), "thread");
            Klass definingKlass = DebuggerSupport.getDefiningClass(event.location.mp);
            DataType.MethodID methodID = DebuggerSupport.getIDForMethodBody(definingKlass, event.location.mp);
            DataType.ReferenceTypeID typeID = SDA.this.getIDForClass(definingKlass);
            DataType.Location location = new DataType.Location(JDWP.getTypeTag(definingKlass), typeID, methodID, event.location.bci.toPrimitive());
            out.writeLocation(location, "location");
            if (Log.debug()) {
                Log.log("   Throw from : " + definingKlass + "." + methodID + ":" + event.location.bci.toPrimitive());
            }
            out.writeTaggedObjectID(new DataType.TaggedObjectID(76, SDA.this.getIDForObject((Object)event.object).id), "exception");
            if (!event.isCaught) {
                out.writeNullLocation("catchLocation");
            } else {
                Klass catchType = DebuggerSupport.getDefiningClass(event.catchLocation.mp);
                DataType.MethodID catchMethodID = DebuggerSupport.getIDForMethodBody(catchType, event.catchLocation.mp);
                DataType.ReferenceTypeID catchTypeID = SDA.this.getIDForClass(catchType);
                location = new DataType.Location(JDWP.getTypeTag(catchType), catchTypeID, catchMethodID, event.catchLocation.bci.toPrimitive());
                out.writeLocation(location, "catchLocation");
                if (Log.debug()) {
                    Log.log("   Catch at : " + catchType + "." + catchMethodID + ":" + event.catchLocation.bci.toPrimitive());
                }
            }
        }
    }

    final class VMStart
    extends SDAEventRequest {
        public VMStart(int suspendPolicy) {
            super(90, suspendPolicy);
        }

        public VMStart(int id, PacketInputStream in) throws SDWPException, IOException {
            super(id, in, 90);
        }

        public void write(PacketOutputStream out, Debugger.Event event, int suspendPolicy) throws IOException {
            VMThread vmThread = event == null ? null : (VMThread)event.object;
            SDA.this.vmStartEventSent = true;
            DataType.ObjectID threadID = SDA.this.getIDForObject(vmThread);
            out.writeObjectID(threadID, "thread");
            if (this.id == 0) {
                out.writeString(SDA.this.getDebuggeeIsolate().getName(), "isolate name");
                SDA.this.writeAllClasses(out);
            }
        }
    }

    final class ThreadStartOrEnd
    extends SDAEventRequest {
        public ThreadStartOrEnd(int kind, int suspendPolicy) {
            super(kind, suspendPolicy);
        }

        public ThreadStartOrEnd(int id, PacketInputStream in, int kind) throws SDWPException, IOException {
            super(id, in, kind);
        }

        public void write(PacketOutputStream out, Debugger.Event event, int suspendPolicy) throws IOException {
            VMThread vmThread = (VMThread)event.object;
            DataType.ObjectID threadID = SDA.this.getIDForObject(vmThread);
            out.writeObjectID(threadID, "thread");
            if (this.id == 0) {
                out.writeInt(DebuggerSupport.getThreadJDWPState(vmThread), "state");
                out.writeInt(vmThread.getDebuggerSuspendCount(), "suspendCount");
                out.writeString(vmThread.getName(), "name");
            }
        }
    }

    final class SingleStep
    extends SDAEventRequest {
        final EventRequestModifier.Step step;

        public SingleStep(int id, PacketInputStream in) throws SDWPException, IOException {
            super(id, in, 1);
            if (Log.debug()) {
                Log.log("[SingleStep] Creating SingleStep...");
            }
            this.step = this.getStep();
            VMThread steppingThread = SDA.this.objectManager.getThreadForID(this.step.threadID);
            if (steppingThread.getStep() != null) {
                throw new SDWPException(10, "thread already has a pending step event");
            }
            if (steppingThread.getDebuggerSuspendCount() == 0) {
                throw new SDWPException(10, "cannot step a non-suspended thread");
            }
            ExecutionPoint start = steppingThread.getEventExecutionPoint();
            if (start == null) {
                start = DebuggerSupport.getThreadCurrentExecutionPoint(steppingThread);
            }
            Klass definingClass = DebuggerSupport.getDefiningClass(start.mp);
            CommandPacket sdpCommand = new CommandPacket(128, 2, true);
            PacketOutputStream sdpOut = sdpCommand.getOutputStream();
            sdpOut.writeReferenceTypeID(SDA.this.getIDForClass(definingClass), "refType");
            sdpOut.writeMethodID(DebuggerSupport.getIDForMethodBody(definingClass, start.mp), "method");
            sdpOut.writeLong(start.bci.toPrimitive(), "bci");
            SDA.this.sdp.sendCommand(sdpCommand);
            if (Log.debug()) {
                Log.log("[SingleStep] Received reply from proxy, constructing stepInfo");
            }
            ReplyPacket sdpReply = sdpCommand.getReply();
            PacketInputStream sdpIn = sdpReply.getInputStream();
            int targeBCI = (int)sdpIn.readLong("targetBCI");
            int dupBCI = (int)sdpIn.readLong("dupBCI");
            int afterDupBCI = (int)sdpIn.readLong("afterDupBCI");
            steppingThread.setStep(new Debugger.SingleStep(start.frame, start.bci, targeBCI, dupBCI, afterDupBCI, this.step.size, this.step.depth));
        }

        public boolean matchKind(int eventKind) {
            return eventKind == 2 || eventKind == 1;
        }

        public void cleared() {
            try {
                VMThread steppingThread = SDA.this.objectManager.getThreadForID(this.step.threadID);
                steppingThread.clearStep();
                return;
            }
            catch (SDWPException e) {
                if (Log.info()) {
                    Log.log("cannot find thread while clearing single step");
                }
                return;
            }
        }

        private EventRequestModifier.Step getStep() throws SDWPException {
            int len = this.modifiers.length;
            EventRequestModifier.Step sm = null;
            for (int i = 0; i < len; ++i) {
                EventRequestModifier mod = this.modifiers[i];
                if (!(mod instanceof EventRequestModifier.Step)) continue;
                sm = (EventRequestModifier.Step)mod;
                break;
            }
            if (sm == null) {
                throw new SDWPException(101, "no valid modifier provided for step command");
            }
            return sm;
        }

        public void write(PacketOutputStream out, Debugger.Event evt, int suspendPolicy) throws IOException {
            Debugger.LocationEvent event = (Debugger.LocationEvent)evt;
            out.writeObjectID((DataType.ObjectID)event.getThreadID(), "thread");
            Klass definingKlass = DebuggerSupport.getDefiningClass(event.location.mp);
            DataType.MethodID methodID = DebuggerSupport.getIDForMethodBody(definingKlass, event.location.mp);
            DataType.ReferenceTypeID typeID = SDA.this.getIDForClass(definingKlass);
            DataType.Location location = new DataType.Location(JDWP.getTypeTag(definingKlass), typeID, methodID, event.location.bci.toPrimitive());
            out.writeLocation(location, "location");
            if (Log.debug()) {
                Log.log("   Stepped to : " + definingKlass + "." + methodID + ":" + event.location.bci.toPrimitive());
            }
        }
    }

    final class Breakpoint
    extends SDAEventRequest {
        public Breakpoint(int id, PacketInputStream in) throws SDWPException, IOException {
            super(id, in, 2);
        }

        public void registered() {
            SDA.this.updateBreakpoints();
        }

        public void cleared() {
            SDA.this.updateBreakpoints();
        }

        public boolean matchKind(int eventKind) {
            return eventKind == 2 || eventKind == 1;
        }

        public void write(PacketOutputStream out, Debugger.Event evt, int suspendPolicy) throws IOException {
            Debugger.LocationEvent event = (Debugger.LocationEvent)evt;
            out.writeObjectID((DataType.ObjectID)event.getThreadID(), "thread");
            Klass definingKlass = DebuggerSupport.getDefiningClass(event.location.mp);
            DataType.MethodID methodID = DebuggerSupport.getIDForMethodBody(definingKlass, event.location.mp);
            DataType.ReferenceTypeID typeID = SDA.this.getIDForClass(definingKlass);
            DataType.Location location = new DataType.Location(JDWP.getTypeTag(definingKlass), typeID, methodID, event.location.bci.toPrimitive());
            out.writeLocation(location, "location");
            if (Log.debug()) {
                Log.log("   Breakpoint in : " + definingKlass + "." + methodID + ":" + event.location.bci.toPrimitive());
            }
        }
    }

    abstract class SDAEventRequest
    extends EventRequest {
        protected SDAEventRequest(int kind, int suspendPolicy) {
            super(kind, suspendPolicy);
        }

        protected SDAEventRequest(int id, PacketInputStream in, int kind) throws SDWPException, IOException {
            super(id, in, kind);
        }

        protected EventRequestModifier readModifier(PacketInputStream in, int kind) throws SDWPException, IOException {
            EventRequestModifier modifier;
            byte modKind = in.readByte("modKind");
            switch (modKind) {
                case 1: {
                    modifier = new EventRequestModifier.Count(in);
                    break;
                }
                case 4: {
                    modifier = new EventRequestModifier.ClassOnly(in, kind);
                    break;
                }
                case 5: {
                    modifier = new EventRequestModifier.ClassMatch(in, kind, false);
                    break;
                }
                case 6: {
                    modifier = new EventRequestModifier.ClassMatch(in, kind, true);
                    break;
                }
                case 7: {
                    modifier = new EventRequestModifier.LocationOnly(in, kind);
                    break;
                }
                case 8: {
                    modifier = new EventRequestModifier.ExceptionOnly(in, kind);
                    break;
                }
                case 10: {
                    modifier = new EventRequestModifier.Step(in, kind);
                    break;
                }
                case 3: {
                    modifier = new EventRequestModifier.ThreadOnly(in, kind);
                    break;
                }
                default: {
                    throw new SDWPException(99, "Unimplemented modkind " + modKind);
                }
            }
            return modifier;
        }

        abstract void write(PacketOutputStream var1, Debugger.Event var2, int var3) throws IOException, SDWPException;
    }

    final class SDAEventManager
    extends EventManager {
        private int nextEventID = 0;
        private Hashtable stepRequests = new Hashtable();

        SDAEventManager(EventRequestModifier.Matcher matcher) {
            super(matcher);
        }

        public boolean isMyEventRequestID(int id) {
            return (id & 1) == 0;
        }

        private int getNextEventRequestID() {
            int id = this.nextEventID += 2;
            return id;
        }

        public int registerEventRequest(PacketInputStream in) throws IOException, SDWPException {
            SDAEventRequest request;
            byte kind = in.readByte("eventKind");
            int id = this.getNextEventRequestID();
            switch (kind) {
                case 2: {
                    request = new Breakpoint(id, in);
                    break;
                }
                case 1: {
                    SingleStep ss = new SingleStep(id, in);
                    this.stepRequests.put(ss.step.threadID, ss);
                    request = ss;
                    break;
                }
                case 90: {
                    request = new VMStart(id, in);
                    break;
                }
                case 6: 
                case 7: {
                    request = new ThreadStartOrEnd(id, in, kind);
                    break;
                }
                case 99: {
                    request = new VMDeath(id, in);
                    break;
                }
                case 4: {
                    request = new ExceptionRequest(id, in);
                    break;
                }
                case 8: {
                    request = new Unsupported(id, in, kind);
                    break;
                }
                case 3: 
                case 5: 
                case 9: 
                case 10: 
                case 20: 
                case 21: 
                case 30: 
                case 40: 
                case 41: {
                    request = new Unsupported(id, in, kind);
                    break;
                }
                default: {
                    throw new SDWPException(102, "event kind = " + kind);
                }
            }
            this.register(request);
            return id;
        }

        public void send(Debugger.Event event, EventManager.MatchedRequests mr) throws IOException, SDWPException {
            SingleStep ss;
            if (mr.suspendPolicy != 0) {
                VMThread vmThread = null;
                if (mr.suspendPolicy != 2 && event.getThread() != null) {
                    vmThread = VMThread.asVMThread(event.getThread());
                }
                SDA.this.suspendThreads(vmThread);
            }
            CommandPacket command = new CommandPacket(64, 100, false);
            PacketOutputStream out = command.getOutputStream();
            out.writeByte(mr.suspendPolicy, "suspendPolicy");
            out.writeInt(mr.requests.size(), "events");
            Enumeration e = mr.requests.elements();
            while (e.hasMoreElements()) {
                SDAEventRequest request = (SDAEventRequest)e.nextElement();
                out.writeByte(request.kind, "eventKind");
                out.writeInt(request.id, "requestID");
                request.write(out, event, mr.suspendPolicy);
                if (!Log.info()) continue;
                Log.log("Added notification: " + request);
            }
            if (mr.suspendPolicy == 2) {
                this.clear(1, 0);
            } else if (mr.suspendPolicy == 1 && (ss = (SingleStep)this.stepRequests.remove(event.getThreadID())) != null) {
                this.clear(ss.kind, ss.id);
            }
            SDA.this.sdp.sendCommand(command);
        }

        public void run() {
            super.run();
            SDA.this.sdp.quit();
        }
    }

    final class MatcherImpl
    implements EventRequestModifier.Matcher {
        MatcherImpl() {
        }

        public boolean matches(EventRequestModifier.ClassMatch modifier, Debugger.Event event) {
            String name = null;
            switch (modifier.eventKind) {
                case 8: {
                    name = ((Klass)event.object).getName();
                    break;
                }
                default: {
                    if (!(event instanceof Debugger.LocationEvent)) {
                        if (Log.info()) {
                            Log.log("No location to match on for " + this);
                        }
                        return false;
                    }
                    name = DebuggerSupport.getDefiningClass(((Debugger.LocationEvent)event).location.mp).getName();
                }
            }
            boolean result = false;
            switch (modifier.matchKind) {
                case 1: {
                    result = name.equals(modifier.pattern);
                    break;
                }
                case 2: {
                    result = name.startsWith(modifier.pattern);
                    break;
                }
                case 3: {
                    result = name.endsWith(modifier.pattern);
                    break;
                }
                case 4: {
                    result = name.indexOf(modifier.pattern) != -1;
                    break;
                }
                default: {
                    Assert.shouldNotReachHere("SDA.java", 426);
                }
            }
            return modifier.exclude ^ result;
        }

        public boolean matches(EventRequestModifier.ClassOnly modifier, Debugger.Event event) {
            Klass klass;
            if (modifier.eventKind == 8) {
                klass = (Klass)event.object;
            } else {
                if (!(event instanceof Debugger.LocationEvent)) {
                    if (Log.info()) {
                        Log.log("No location to match on for " + this);
                    }
                    return false;
                }
                klass = DebuggerSupport.getDefiningClass(((Debugger.LocationEvent)event).location.mp);
            }
            try {
                return SDA.this.getClassForID(modifier.clazz).isAssignableFrom(klass);
            }
            catch (SDWPException e) {
                System.err.println("Class ID in ClassOnly modifier is invalid: " + e);
                return false;
            }
        }

        public boolean matches(EventRequestModifier.ExceptionOnly modifier, Debugger.Event evt) {
            Debugger.ExceptionEvent event = (Debugger.ExceptionEvent)evt;
            if (modifier.caught & event.isCaught || modifier.uncaught & !event.isCaught) {
                try {
                    Klass exceptionKlass = modifier.exceptionOrNull.id == 0 ? null : SDA.this.getClassForID(modifier.exceptionOrNull);
                    return exceptionKlass == null || exceptionKlass.isInstance(event.object);
                }
                catch (SDWPException e) {
                    System.err.println("Class ID in ExceptionOnly modifier is invalid: " + e);
                    return false;
                }
            }
            return false;
        }

        public boolean matches(EventRequestModifier.LocationOnly modifier, Debugger.Event evt) {
            Debugger.LocationEvent event = (Debugger.LocationEvent)evt;
            Klass definingClass = DebuggerSupport.getDefiningClass(event.location.mp);
            DataType.MethodID methodID = DebuggerSupport.getIDForMethodBody(definingClass, event.location.mp);
            DataType.Location location = modifier.location;
            try {
                return definingClass == SDA.this.getClassForID(location.definingClass) && methodID.equals(location.method) && (long)event.location.bci.toPrimitive() == location.offset;
            }
            catch (SDWPException e) {
                System.err.println("Class ID in LocationOnly modifier is invalid: " + e);
                return false;
            }
        }
    }
}

