/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sda;

import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntHashtable;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;

public final class WeakIntHashtable
extends IntHashtable {
    public boolean contains(Object value) {
        return this.getKey(value) != null;
    }

    public Object put(int key, Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new NullPointerException();
        }
        WeakReference ref = new WeakReference(value);
        if ((ref = (WeakReference)super.put(key, ref)) != null) {
            value = ref.get();
            Assert.always(!(value instanceof WeakReference), "WeakIntHashtable.java", 83);
            return value;
        }
        return null;
    }

    public void compact() {
        Vector deadEntries = new Vector();
        Enumeration keys = this.keys();
        Enumeration values = this.elements();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            WeakReference ref = (WeakReference)values.nextElement();
            if (ref.get() != null) continue;
            deadEntries.addElement(key);
        }
        keys = deadEntries.elements();
        while (keys.hasMoreElements()) {
            int key = (Integer)keys.nextElement();
            this.remove(key);
        }
    }

    public Object get(int key) {
        WeakReference ref = (WeakReference)super.get(key);
        if (ref != null) {
            Object value = ref.get();
            if (value == null) {
                super.remove(key);
            }
            return value;
        }
        return null;
    }

    public Integer getKey(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Enumeration keys = this.keys();
        Enumeration values = this.elements();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            WeakReference ref = (WeakReference)values.nextElement();
            Object v = ref.get();
            if (value != v) continue;
            return (Integer)key;
        }
        return null;
    }
}

