/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2me.socket;

import com.sun.squawk.io.ConnectionBase;
import com.sun.squawk.io.j2me.socket.PrivateInputStream;
import com.sun.squawk.io.j2me.socket.PrivateOutputStream;
import com.sun.squawk.platform.GCFSockets;
import com.sun.squawk.platform.Platform;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.SocketConnection;

public class Protocol
extends ConnectionBase
implements SocketConnection {
    int handle;
    private int mode;
    int opens = 0;
    private boolean copen = false;
    protected boolean isopen = false;
    protected boolean osopen = false;
    private int port;
    private String remoteHostName;
    static GCFSockets gcfSockets = Platform.getGCFSockets();

    public Connection open(String protocol, String name, int mode, boolean timeouts) throws IOException {
        if (!name.startsWith("//")) {
            throw new IOException();
        }
        int i = name.indexOf(58);
        if (i < 0) {
            throw new IOException();
        }
        this.remoteHostName = name.substring(2, i);
        if (this.remoteHostName.length() == 0) {
            com.sun.squawk.io.j2me.serversocket.Protocol con = new com.sun.squawk.io.j2me.serversocket.Protocol();
            con.open("serversocket", name, mode, timeouts);
            return con;
        }
        try {
            this.port = Integer.parseInt(name.substring(i + 1));
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        this.handle = gcfSockets.open(this.remoteHostName, this.port, mode);
        ++this.opens;
        this.copen = true;
        this.mode = mode;
        return this;
    }

    public Protocol() {
    }

    public Protocol(int fd) {
        this.handle = fd;
        ++this.opens;
        this.copen = true;
        this.mode = 3;
    }

    void ensureOpen() throws IOException {
        if (!this.copen) {
            throw new IOException();
        }
    }

    public synchronized InputStream openInputStream() throws IOException {
        this.ensureOpen();
        if ((this.mode & 1) == 0) {
            throw new IOException();
        }
        if (this.isopen) {
            throw new IOException();
        }
        this.isopen = true;
        PrivateInputStream in = new PrivateInputStream(this);
        ++this.opens;
        return in;
    }

    public synchronized OutputStream openOutputStream() throws IOException {
        this.ensureOpen();
        if ((this.mode & 2) == 0) {
            throw new IOException();
        }
        if (this.osopen) {
            throw new IOException();
        }
        this.osopen = true;
        PrivateOutputStream os = new PrivateOutputStream(this);
        ++this.opens;
        return os;
    }

    public synchronized void close() throws IOException {
        if (this.copen) {
            this.copen = false;
            this.realClose();
        }
    }

    synchronized void realClose() throws IOException {
        if (--this.opens == 0) {
            gcfSockets.close(this.handle);
        }
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void setSocketOption(byte option, int value) throws IllegalArgumentException, IOException {
        this.ensureOpen();
        gcfSockets.setSockOpt(this.handle, option, value);
    }

    public int getSocketOption(byte option) throws IllegalArgumentException, IOException {
        this.ensureOpen();
        return gcfSockets.getSockOpt(this.handle, option);
    }

    public String getLocalAddress() throws IOException {
        this.ensureOpen();
        return "127.0.0.1";
    }

    public int getLocalPort() throws IOException {
        this.ensureOpen();
        throw new IOException("Not supported yet.");
    }

    public String getAddress() throws IOException {
        this.ensureOpen();
        return this.remoteHostName;
    }

    public int getPort() throws IOException {
        this.ensureOpen();
        return this.port;
    }
}

