/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.mailboxes;

import com.sun.squawk.Isolate;
import com.sun.squawk.VM;
import com.sun.squawk.io.mailboxes.MailboxAddress;

public abstract class Envelope {
    private MailboxAddress toAddress;

    final MailboxAddress getToAddress() {
        return this.toAddress;
    }

    final MailboxAddress getReplyAddress() {
        if (this.toAddress == null) {
            return null;
        }
        return this.toAddress.getReplyAddress();
    }

    public abstract Object getContents();

    final void setAddresses(MailboxAddress toAddress) {
        this.toAddress = toAddress;
    }

    protected void checkCallContext() throws IllegalStateException {
        MailboxAddress replyAddress = this.getReplyAddress();
        if (replyAddress == null) {
            throw new IllegalStateException("Envelope has not been sent.");
        }
        if (replyAddress.isOpen() && !replyAddress.isOwner(Isolate.currentIsolate())) {
            throw new IllegalStateException("Calling isolate is not the receiver of the envelope.");
        }
    }

    Envelope copy() {
        Envelope newEnv = (Envelope)VM.shallowCopy(this);
        return newEnv;
    }
}

