/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.peripheral;

import com.sun.squawk.Address;
import com.sun.squawk.peripheral.INorFlashSector;
import com.sun.squawk.util.Arrays;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;

public class SimulatedNorFlashSector
implements INorFlashSector {
    public static final String SECTORS_FILE_EXTENSION = ".nor-flash";
    public static final String ZERO_PADDING = "00000000";
    protected int purpose;
    protected int size;
    protected Address startAddress;
    protected byte[] bytes;
    protected String fileName;

    public SimulatedNorFlashSector(Address startAddress, byte[] bytes, int purpose) {
        this.init(startAddress, bytes.length, purpose);
        this.bytes = bytes;
    }

    public SimulatedNorFlashSector(Address startAddress, int size, int purpose, boolean useFile) {
        this.init(startAddress, size, purpose);
        if (useFile) {
            String string = Integer.toHexString(startAddress.toUWord().toInt());
            if (string.length() < ZERO_PADDING.length()) {
                string = ZERO_PADDING + string;
                string = string.substring(string.length() - ZERO_PADDING.length());
            }
            this.fileName = "sector-" + string + SECTORS_FILE_EXTENSION;
        }
        this.bytes = new byte[size];
        this.erase();
    }

    public SimulatedNorFlashSector(String fileName) throws IOException {
        this.fileName = fileName;
        DataInputStream input = Connector.openDataInputStream("file://" + fileName);
        Address startAddress = Address.fromPrimitive(input.readInt());
        int size = input.readInt();
        short purpose = input.readShort();
        this.init(startAddress, size, purpose);
        this.bytes = new byte[input.available()];
        input.read(this.bytes, 0, this.bytes.length);
        input.close();
    }

    void ensureInBounds(int memoryOffset, byte[] buffer, int bufferOffset, int length) {
        if (memoryOffset > this.size || memoryOffset < 0) {
            throw new IndexOutOfBoundsException("sectorSize: " + this.size + "memoryOffset: " + memoryOffset);
        }
        if (memoryOffset + length > this.size) {
            throw new IndexOutOfBoundsException("sectorSize: " + this.size + "memoryOffset: " + memoryOffset + " length: " + length);
        }
        int bufferSize = buffer.length;
        if (bufferOffset > bufferSize || bufferOffset < 0) {
            throw new IndexOutOfBoundsException("bufferSize: " + bufferSize + "bufferOffset: " + bufferOffset);
        }
        if (bufferOffset + length > bufferSize) {
            throw new IndexOutOfBoundsException("bufferSize: " + bufferSize + "bufferOffset: " + bufferOffset + " length: " + length);
        }
    }

    public void erase() {
        Arrays.fill(this.bytes, 0, this.bytes.length, this.getErasedValue());
        this.setBytes(0, this.bytes, 0, this.size);
    }

    public void getBytes(int memoryOffset, byte[] buffer, int bufferOffset, int length) {
        if (length == 0) {
            return;
        }
        this.ensureInBounds(memoryOffset, buffer, bufferOffset, length);
        System.arraycopy(this.bytes, memoryOffset, buffer, bufferOffset, length);
    }

    public byte getErasedValue() {
        return -1;
    }

    public int getPurpose() {
        return this.purpose;
    }

    public int getSize() {
        return this.size;
    }

    public Address getStartAddress() {
        return this.startAddress;
    }

    protected void init(Address startAddress, int size, int purpose) {
        if (size <= 0) {
            throw new IllegalArgumentException("Sector size must be greater than 0");
        }
        this.startAddress = startAddress;
        this.size = size;
        this.purpose = purpose;
    }

    public void setBytes(int memoryOffset, byte[] buffer, int bufferOffset, int length) {
        if (length == 0) {
            return;
        }
        if ((memoryOffset & 1) == 1) {
            throw new IndexOutOfBoundsException("offset must be even");
        }
        if ((length & 1) == 1) {
            throw new IndexOutOfBoundsException("length must be even");
        }
        this.ensureInBounds(memoryOffset, buffer, bufferOffset, length);
        System.arraycopy(buffer, bufferOffset, this.bytes, memoryOffset, length);
        if (this.fileName == null) {
            return;
        }
        try {
            DataOutputStream output = Connector.openDataOutputStream("file://" + this.fileName);
            output.writeInt(this.startAddress.toUWord().toInt());
            output.writeInt(this.size);
            output.writeShort(this.purpose);
            output.write(this.bytes);
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

