/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.platform;

import com.sun.squawk.VM;
import com.sun.squawk.platform.GCFFile;
import java.io.IOException;

public abstract class BaseGCFFile
implements GCFFile {
    public static final int INVALID_HANDLE = -1;
    protected int readHandle = -1;
    protected int writeHandle = -1;
    protected String nativeFileName;

    public void connect(String rootName, String fileName) {
        if (this.containsIllegalFilenameChars(rootName)) {
            throw new IllegalArgumentException(rootName);
        }
        if (this.containsIllegalFilenameChars(fileName)) {
            throw new IllegalArgumentException(fileName);
        }
        StringBuffer name = new StringBuffer(fileName);
        this.pathToNativeSeparator(name, 0, name.length());
        this.nativeFileName = name.toString();
    }

    public static char getFileSeparator() {
        return VM.getFileSeparatorChar();
    }

    boolean containsIllegalFilenameChars(String filename) {
        String illegalChars = this.illegalFileNameChars();
        for (int i = 0; i < illegalChars.length(); ++i) {
            char c = illegalChars.charAt(i);
            if (filename.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    private StringBuffer pathToNativeSeparator(StringBuffer name, int off, int len) {
        int length = off + len;
        int curr = off;
        char sep = BaseGCFFile.getFileSeparator();
        while (curr + 1 < length) {
            if (name.charAt(curr) == '/' && name.charAt(curr + 1) == '/') {
                name.deleteCharAt(curr);
                --length;
                continue;
            }
            if (name.charAt(curr) == '/') {
                name.setCharAt(curr, sep);
            }
            ++curr;
        }
        if (length != 1 && name.charAt(length - 1) == '/') {
            name.deleteCharAt(length - 1);
        }
        return name;
    }

    public void close() throws IOException {
        this.closeForReadWrite();
    }

    public void closeForReadWrite() throws IOException {
        this.closeForRead();
        this.closeForWrite();
    }
}

