/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.platform.posix;

import com.sun.squawk.platform.BaseGCFFile;
import com.sun.squawk.platform.posix.LibCUtil;
import com.sun.squawk.platform.posix.natives.LibC;
import java.io.IOException;

public class GCFFileImpl
extends BaseGCFFile {
    private LibC libc = LibC.INSTANCE;
    private static final String illegalChars = ":\\";

    public boolean exists() {
        return this.libc.stat(this.nativeFileName, new LibC.stat()) != -1;
    }

    public boolean isDirectory() {
        LibC.stat stats = new LibC.stat();
        if (this.libc.stat(this.nativeFileName, stats) != -1) {
            return (stats.st_mode & LibC.S_IFMT) == LibC.S_IFDIR;
        }
        return false;
    }

    public void delete() throws IOException {
        if (this.isDirectory()) {
            throw new IOException("isDirectory");
        }
        int res = this.libc.unlink(this.nativeFileName);
        LibCUtil.errCheckNeg(res);
    }

    public long fileSize() throws IOException {
        if (this.isDirectory()) {
            throw new IOException("isDirectory");
        }
        LibC.stat stats = new LibC.stat();
        if (this.libc.stat(this.nativeFileName, stats) != -1) {
            return stats.st_size;
        }
        return -1L;
    }

    public String illegalFileNameChars() {
        return illegalChars;
    }

    public void openForRead() throws IOException {
        this.readHandle = this.libc.open(this.nativeFileName, LibC.O_RDONLY, 0);
        LibCUtil.errCheckNeg(this.readHandle);
    }

    public void closeForRead() throws IOException {
        if (this.readHandle >= 0) {
            LibCUtil.errCheckNeg(this.libc.close(this.readHandle));
            this.readHandle = -1;
        }
    }

    public void openForWrite() throws IOException {
        this.writeHandle = this.libc.open(this.nativeFileName, LibC.O_WRONLY, 438);
        LibCUtil.errCheckNeg(this.writeHandle);
    }

    public void closeForWrite() throws IOException {
        if (this.writeHandle >= 0) {
            LibCUtil.errCheckNeg(this.libc.close(this.writeHandle));
            this.writeHandle = -1;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.readHandle < 0) {
            throw new IOException("file closed");
        }
        byte[] buf = b;
        if (off != 0) {
            buf = new byte[len];
            System.arraycopy(b, off, buf, 0, len);
        }
        int result = this.libc.read(this.readHandle, buf, len);
        LibCUtil.errCheckNeg(result);
        return result;
    }

    public int write(byte[] b, int off, int len) throws IOException {
        if (this.writeHandle < 0) {
            throw new IOException("file closed");
        }
        byte[] buf = b;
        if (off != 0) {
            buf = new byte[len];
            System.arraycopy(b, off, buf, 0, len);
        }
        int result = this.libc.write(this.writeHandle, buf, len);
        LibCUtil.errCheckNeg(result);
        return result;
    }

    public void positionForWrite(long offset) throws IOException {
        if (this.writeHandle > 0) {
            long fsize = this.fileSize();
            if (fsize < 0L) {
                throw new IOException("fileSize errno: " + LibCUtil.errno());
            }
            offset = Math.min(offset, fsize);
            int result = this.libc.lseek(this.writeHandle, offset, LibC.SEEK_SET);
            LibCUtil.errCheckNeg(result);
        }
    }

    public void flush() throws IOException {
        if (this.writeHandle > 0) {
            LibCUtil.errCheckNeg(this.libc.fsync(this.writeHandle));
        }
    }

    public void create() throws IOException {
        int tHandle = this.libc.open(this.nativeFileName, LibC.O_WRONLY | LibC.O_CREAT | LibC.O_TRUNC, 438);
        LibCUtil.errCheckNeg(tHandle);
        this.libc.close(tHandle);
    }
}

