/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.platform.posix;

import com.sun.cldc.jna.BlockingFunction;
import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import com.sun.squawk.platform.SystemEvents;
import com.sun.squawk.platform.posix.LibCUtil;
import com.sun.squawk.platform.posix.natives.Select;
import com.sun.squawk.platform.posix.natives.Time;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntSet;

public class SystemEventsImpl
extends SystemEvents
implements Runnable {
    private static final boolean DEBUG = false;
    Pointer masterReadSet;
    Pointer masterWriteSet;
    private Pointer tempReadSet;
    private Pointer tempWriteSet;
    private IntSet readSet;
    private IntSet writeSet;
    private Time.timeval zeroTime;
    private Time.timeval timeoutTime;
    private int maxFD = 0;
    private BlockingFunction selectPtr;
    private Function cancelSelectPtr;
    protected Select select = Select.INSTANCE;
    private boolean didCheck = false;

    private int copyIntoFDSet(IntSet src, Pointer fd_set) {
        int num = src.size();
        int[] data = src.getElements();
        int localMax = 0;
        SystemEventsImpl.FD_ZERO(fd_set);
        for (int i = 0; i < num; ++i) {
            int fd = data[i];
            this.select.FD_SET(fd, fd_set);
            if (fd <= localMax) continue;
            localMax = fd;
        }
        return localMax;
    }

    public static void FD_ZERO(Pointer fd_set) {
        fd_set.clear(Select.fd_set_SIZEOF);
    }

    public static void FD_COPY(Pointer fdset_orig, Pointer fdset_copy) {
        Pointer.copyBytes(fdset_orig, 0, fdset_copy, 0, Select.fd_set_SIZEOF);
    }

    public static Pointer FD_ALLOCATE() {
        return new Pointer(Select.fd_set_SIZEOF);
    }

    private void setupTempSet(IntSet set, Pointer master, Pointer temp) {
        if (set.size() != 0) {
            SystemEventsImpl.FD_COPY(master, temp);
        } else {
            SystemEventsImpl.FD_ZERO(temp);
        }
    }

    private void printFDSet(Pointer fd_set) {
        for (int i = 0; i < this.maxFD + 1; ++i) {
            if (!this.select.FD_ISSET(i, fd_set)) continue;
            VM.print("    fd: ");
            VM.print(i);
            VM.println();
        }
    }

    public SystemEventsImpl() {
        NativeLibrary jnaNativeLibrary = NativeLibrary.getDefaultInstance();
        this.selectPtr = jnaNativeLibrary.getBlockingFunction("squawk_select");
        this.selectPtr.setTaskExecutor(this.selectRunner);
        this.cancelSelectPtr = jnaNativeLibrary.getFunction("cancel_squawk_select");
        this.masterReadSet = SystemEventsImpl.FD_ALLOCATE();
        this.masterWriteSet = SystemEventsImpl.FD_ALLOCATE();
        this.readSet = new IntSet();
        this.writeSet = new IntSet();
        this.tempReadSet = SystemEventsImpl.FD_ALLOCATE();
        this.tempWriteSet = SystemEventsImpl.FD_ALLOCATE();
        this.zeroTime = new Time.timeval();
        this.zeroTime.tv_sec = 0L;
        this.zeroTime.tv_usec = 0L;
        this.zeroTime.allocateMemory();
        this.zeroTime.write();
        this.timeoutTime = new Time.timeval();
        this.timeoutTime.allocateMemory();
    }

    private int select(int nfds, Pointer readSet, Pointer writeSet, Pointer excSet, Pointer theTimout) {
        return this.selectPtr.call5(nfds, readSet, writeSet, excSet, theTimout);
    }

    private int cancelSelectCall() {
        return this.cancelSelectPtr.call0();
    }

    private int handleEvents(int num, IntSet waitingSet, Pointer eventFDSet) {
        if (num > 0) {
            for (int i = 0; i < waitingSet.size(); ++i) {
                int fd = waitingSet.getElements()[i];
                if (!this.select.FD_ISSET(fd, eventFDSet)) continue;
                waitingSet.remove(fd);
                VMThread.signalOSEvent(fd);
                if (--num == 0) break;
                --i;
            }
        }
        return num;
    }

    private void doCheck() {
        this.didCheck = true;
        int sysFD_SIZE = NativeLibrary.getDefaultInstance().getGlobalVariableAddress("sysFD_SIZE", 4).getInt(0L);
        Assert.always(Select.FD_SETSIZE == sysFD_SIZE * 8, "select.FD_SETSIZE: " + Select.FD_SETSIZE + " sysFD_SIZE: " + sysFD_SIZE, "SystemEventsImpl.java", 217);
        Assert.always(Select.fd_set_SIZEOF == sysFD_SIZE, "fd_set_SIZEOF: " + Select.fd_set_SIZEOF, "SystemEventsImpl.java", 218);
    }

    public void waitForEvents(long timeout) {
        Pointer theTimout;
        this.setupTempSet(this.readSet, this.masterReadSet, this.tempReadSet);
        this.setupTempSet(this.writeSet, this.masterWriteSet, this.tempWriteSet);
        if (timeout > this.max_wait) {
            timeout = this.max_wait;
        }
        if (timeout == 0L) {
            theTimout = this.zeroTime.getPointer();
        } else if (timeout == Long.MAX_VALUE) {
            theTimout = Pointer.NULL();
        } else {
            this.timeoutTime.tv_sec = timeout / 1000L;
            this.timeoutTime.tv_usec = timeout % 1000L * 1000L;
            this.timeoutTime.write();
            theTimout = this.timeoutTime.getPointer();
        }
        int num = this.select(this.maxFD + 1, this.tempReadSet, this.tempWriteSet, Pointer.NULL(), theTimout);
        if (num > 0) {
            num = this.handleEvents(num, this.readSet, this.tempReadSet);
            if ((num = this.handleEvents(num, this.writeSet, this.tempWriteSet)) != 0) {
                // empty if block
            }
            this.updateSets();
        } else if (num < 0) {
            System.err.println("select error: " + LibCUtil.errno());
        }
    }

    private void updateSets() {
        this.maxFD = this.copyIntoFDSet(this.readSet, this.masterReadSet);
        int mfd = this.copyIntoFDSet(this.writeSet, this.masterWriteSet);
        if (mfd > this.maxFD) {
            this.maxFD = mfd;
        }
    }

    public void waitForReadEvent(int fd) {
        this.readSet.add(fd);
        this.updateSets();
        this.cancelSelectCall();
        VMThread.waitForOSEvent(fd);
    }

    public void waitForWriteEvent(int fd) {
        this.writeSet.add(fd);
        this.updateSets();
        this.cancelSelectCall();
        VMThread.waitForOSEvent(fd);
    }
}

