/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.platform.windows;

import com.sun.cldc.jna.BlockingFunction;
import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import com.sun.squawk.platform.SystemEvents;
import com.sun.squawk.platform.windows.LibCUtil;
import com.sun.squawk.platform.windows.natives.Select;
import com.sun.squawk.platform.windows.natives.Time;
import com.sun.squawk.util.IntSet;

public class SystemEventsImpl
extends SystemEvents {
    Pointer masterReadSet;
    Pointer masterWriteSet;
    private Pointer tempReadSet;
    private Pointer tempWriteSet;
    private IntSet readSet;
    private IntSet writeSet;
    private Time.timeval zeroTime;
    private Time.timeval timeoutTime;
    private int maxFD = 0;
    private BlockingFunction selectPtr;
    private Function cancelSelectPtr;
    protected Select select = Select.INSTANCE;

    private static int copyIntoFDSet(IntSet src, Pointer fd_set) {
        int num = src.size();
        int[] data = src.getElements();
        int localMax = 0;
        SystemEventsImpl.FD_ZERO(fd_set);
        for (int i = 0; i < num; ++i) {
            int fd = data[i];
            Select.INSTANCE.FD_SET(fd, fd_set);
            if (fd <= localMax) continue;
            localMax = fd;
        }
        return localMax;
    }

    public static void FD_ZERO(Pointer fd_set) {
        fd_set.clear(260);
    }

    public static void FD_COPY(Pointer fdset_orig, Pointer fdset_copy) {
        Pointer.copyBytes(fdset_orig, 0, fdset_copy, 0, 260);
    }

    public static Pointer FD_ALLOCATE() {
        return new Pointer(260);
    }

    public SystemEventsImpl() {
        NativeLibrary jnaNativeLibrary = NativeLibrary.getDefaultInstance();
        this.selectPtr = jnaNativeLibrary.getBlockingFunction("squawk_select");
        this.selectPtr.setTaskExecutor(this.selectRunner);
        this.masterReadSet = SystemEventsImpl.FD_ALLOCATE();
        this.masterWriteSet = SystemEventsImpl.FD_ALLOCATE();
        this.readSet = new IntSet();
        this.writeSet = new IntSet();
        this.tempReadSet = SystemEventsImpl.FD_ALLOCATE();
        this.tempWriteSet = SystemEventsImpl.FD_ALLOCATE();
        this.zeroTime = new Time.timeval();
        this.zeroTime.tv_sec = 0L;
        this.zeroTime.tv_usec = 0L;
        this.zeroTime.allocateMemory();
        this.zeroTime.write();
        this.timeoutTime = new Time.timeval();
        this.timeoutTime.allocateMemory();
    }

    private void setupTempSet(IntSet set, Pointer master, Pointer temp) {
        if (set.size() != 0) {
            SystemEventsImpl.FD_COPY(master, temp);
        } else {
            SystemEventsImpl.FD_ZERO(temp);
        }
    }

    private void printFDSet(Pointer fd_set) {
        for (int i = 0; i < this.maxFD + 1; ++i) {
            if (!Select.INSTANCE.FD_ISSET(i, fd_set)) continue;
            VM.println("    fd: " + i);
        }
    }

    private int select(int nfds, Pointer readSet, Pointer writeSet, Pointer excSet, Pointer theTimout) {
        return this.selectPtr.call5(nfds, readSet, writeSet, excSet, theTimout);
    }

    public void waitForEvents(long timeout) {
        Pointer theTimout;
        if (this.maxFD <= 0) {
            return;
        }
        this.setupTempSet(this.readSet, this.masterReadSet, this.tempReadSet);
        this.setupTempSet(this.writeSet, this.masterWriteSet, this.tempWriteSet);
        if (timeout == 0L) {
            theTimout = this.zeroTime.getPointer();
        } else if (timeout == Long.MAX_VALUE) {
            theTimout = Pointer.NULL();
        } else {
            this.timeoutTime.tv_sec = timeout / 1000L;
            this.timeoutTime.tv_usec = timeout % 1000L * 1000L;
            this.timeoutTime.write();
            theTimout = this.timeoutTime.getPointer();
        }
        int num = this.select(this.maxFD + 1, this.tempReadSet, this.tempWriteSet, Pointer.NULL(), theTimout);
        if (num < 0) {
            System.err.println("select error: " + LibCUtil.errno());
        }
        if (num > 0) {
            int fd;
            int i;
            if (this.readSet.size() != 0) {
                for (i = 0; i < this.readSet.size(); ++i) {
                    fd = this.readSet.getElements()[i];
                    if (!Select.INSTANCE.FD_ISSET(fd, this.tempReadSet)) continue;
                    this.readSet.remove(fd);
                    VMThread.signalOSEvent(fd);
                    --num;
                }
            }
            if (this.writeSet.size() != 0) {
                for (i = 0; i < this.writeSet.size(); ++i) {
                    fd = this.writeSet.getElements()[i];
                    if (!Select.INSTANCE.FD_ISSET(fd, this.tempWriteSet)) continue;
                    this.writeSet.remove(fd);
                    VMThread.signalOSEvent(fd);
                    --num;
                }
            }
            if (num != 0) {
                System.err.println("Missed handling a select event?\n Read FDs set:");
                this.printFDSet(this.tempReadSet);
                System.err.println("Write FDs set:");
                this.printFDSet(this.tempWriteSet);
            }
            this.updateSets();
        }
    }

    private void updateSets() {
        this.maxFD = SystemEventsImpl.copyIntoFDSet(this.readSet, this.masterReadSet);
        int mfd = SystemEventsImpl.copyIntoFDSet(this.writeSet, this.masterWriteSet);
        if (mfd > this.maxFD) {
            this.maxFD = mfd;
        }
    }

    public void waitForReadEvent(int fd) {
        this.readSet.add(fd);
        this.updateSets();
        VMThread.waitForOSEvent(fd);
    }

    public void waitForWriteEvent(int fd) {
        this.writeSet.add(fd);
        this.updateSets();
        VMThread.waitForOSEvent(fd);
    }
}

