/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.rms;

import com.sun.squawk.rms.IApplicationDescriptorEntry;
import com.sun.squawk.rms.IRecordEntry;
import com.sun.squawk.rms.IRecordStoreEntry;
import com.sun.squawk.rms.IRecordStoreSequenceEntry;
import com.sun.squawk.rms.IRmsEntryVisitor;
import com.sun.squawk.rms.IUnknownEntry;
import com.sun.squawk.rms.RecordStoreManager;
import javax.microedition.rms.RecordStoreException;

class RecordStoreManagerReScanVisitor
implements IRmsEntryVisitor {
    protected final RecordStoreManager manager;

    public RecordStoreManagerReScanVisitor(RecordStoreManager manager) {
        this.manager = manager;
    }

    public void visitApplicationDescriptor(IApplicationDescriptorEntry newDescriptor) throws RecordStoreException {
        this.manager.currentApplicationDescriptor.setAddress(newDescriptor.getAddress());
    }

    public void visitRecord(IRecordEntry entry) throws RecordStoreException {
        int storeId = entry.getStoreId();
        IRecordStoreEntry recordStore = this.manager.getRecordStore(storeId);
        if (recordStore == null) {
            throw new RecordStoreException("System error: encountered record prior to store existing");
        }
        recordStore.reVisitRecordEntry(entry);
    }

    public void visitRecordStore(IRecordStoreEntry entry) throws RecordStoreException {
        IRecordStoreEntry originalEntry = this.manager.currentRecordStores[entry.getId()];
        originalEntry.setAddress(entry.getAddress());
    }

    public void visitRecordStoreSequence(IRecordStoreSequenceEntry entry) {
    }

    public void visitUnknown(IUnknownEntry entry) {
    }
}

