/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.security;

public class HexEncoding {
    private static final char[] hc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HexEncoding() {
    }

    public static String hexEncode(byte[] b) {
        return HexEncoding.hexEncode(b, b.length);
    }

    public static String hexEncode(byte[] b, int len) {
        if (b == null) {
            return "";
        }
        char[] r = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int v = b[i] & 0xFF;
            r[j++] = hc[v >>> 4];
            r[j++] = hc[v & 0xF];
        }
        return new String(r);
    }

    public static byte[] hexDecode(String str) {
        int len = (str.length() + 1) / 2;
        byte[] res = new byte[len];
        HexEncoding.hexDecode(str, res, 0, len);
        return res;
    }

    private static int hexDecode(String str, byte[] b, int ofs, int len) {
        int strLen = str.length();
        if (strLen % 2 == 1) {
            str = "0" + str;
            ++strLen;
        }
        if (len * 2 > strLen) {
            len = strLen / 2;
        }
        for (int i = 0; i < strLen; i += 2) {
            b[ofs++] = (byte)((HexEncoding.fromHex(str.charAt(i)) << 4) + HexEncoding.fromHex(str.charAt(i + 1)));
        }
        return len;
    }

    private static int fromHex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        return 0;
    }
}

