/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.security.ecc;

import com.sun.squawk.security.ecc.ECPoint;
import com.sun.squawk.security.ecc.FFA;
import com.sun.squawk.security.ecc.NIST160PrimeField;
import com.sun.squawk.security.ecc.PrimeField;

public final class ECCurveFp {
    private static ECCurveFp curve;
    protected final boolean aIsMinus3;
    protected final int[] t1;
    protected final int[] t2;
    protected final int[] t3;
    protected final int[] t4;
    protected final PrimeField field;
    protected final int[] a;
    protected final int[] b;
    protected final int h;
    protected final ECPoint generator;
    protected final PrimeField order;
    protected final FFA ffa;

    private ECCurveFp() {
        FFA ffa = new FFA(160);
        FFA orderFFA = new FFA(161);
        this.field = new NIST160PrimeField(ffa);
        this.ffa = this.field.getFFA();
        this.a = ffa.from("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFC");
        this.b = ffa.from("1C97BEFC54BD7A8B65ACF89F81D4D4ADC565FA45");
        this.order = new PrimeField(orderFFA, orderFFA.from("100000000000000000001F4C8F927AED3CA752257"));
        this.h = 1;
        this.generator = new ECPoint(this, ffa.from("4A96B5688EF573284664698968C38BB913CBFC82"), ffa.from("23A628553168947D59DCC912042351377AC5FB32"));
        this.t1 = ffa.acquireVar();
        this.t2 = ffa.acquireVar();
        this.t3 = ffa.acquireVar();
        this.t4 = ffa.acquireVar();
        ffa.set(this.t1, 3);
        this.field.negate(this.t1, this.t1);
        this.aIsMinus3 = ffa.cmp(this.t1, this.a) == 0;
    }

    public static synchronized ECCurveFp getInstance() {
        if (curve == null) {
            curve = new ECCurveFp();
        }
        return curve;
    }

    public void add(ECPoint a, ECPoint b) {
        int[] x1 = a.x;
        int[] y1 = a.y;
        int[] z1 = a.z;
        int[] x2 = b.x;
        int[] y2 = b.y;
        this.field.square(this.t1, z1);
        this.field.multiply(this.t2, this.t1, z1);
        this.field.multiply(this.t1, this.t1, x2);
        this.field.multiply(this.t2, this.t2, y2);
        this.field.subtract(this.t1, this.t1, x1);
        this.field.subtract(this.t2, this.t2, y1);
        if (this.ffa.is(this.t1, 0) && this.ffa.is(this.t2, 0)) {
            this.twice(a);
            return;
        }
        this.field.multiply(z1, z1, this.t1);
        this.field.square(this.t3, this.t1);
        this.field.multiply(this.t4, this.t3, this.t1);
        this.field.multiply(this.t3, this.t3, x1);
        this.field.multiply2(this.t1, this.t3);
        this.field.square(x1, this.t2);
        this.field.subtract(x1, x1, this.t1);
        this.field.subtract(x1, x1, this.t4);
        this.field.subtract(this.t3, this.t3, x1);
        this.field.multiply(this.t3, this.t3, this.t2);
        this.field.multiply(this.t4, this.t4, y1);
        this.field.subtract(y1, this.t3, this.t4);
    }

    public void negate(ECPoint a) {
        this.field.negate(a.y, a.y);
    }

    public void twice(ECPoint a) {
        int[] x = a.x;
        int[] y = a.y;
        int[] z = a.z;
        this.field.square(this.t1, z);
        if (this.aIsMinus3) {
            this.field.subtract(this.t2, x, this.t1);
            this.field.add(this.t1, x, this.t1);
            this.field.multiply(this.t2, this.t2, this.t1);
            this.field.multiply2(this.t3, this.t2);
            this.field.add(this.t2, this.t3, this.t2);
        } else {
            this.field.square(this.t1, this.t1);
            this.field.multiply(this.t1, this.t1, this.a);
            this.field.square(this.t2, x);
            this.field.multiply2(this.t3, this.t2);
            this.field.add(this.t2, this.t3, this.t2);
            this.field.add(this.t2, this.t2, this.t1);
        }
        this.field.multiply2(y, y);
        this.field.multiply(z, y, z);
        this.field.square(y, y);
        this.field.multiply(this.t3, y, x);
        this.field.square(y, y);
        this.field.divide2(y, y);
        this.field.square(x, this.t2);
        this.field.multiply2(this.t1, this.t3);
        this.field.subtract(x, x, this.t1);
        this.field.subtract(this.t1, this.t3, x);
        this.field.multiply(this.t1, this.t1, this.t2);
        this.field.subtract(y, this.t1, y);
    }

    public void makeAffine(ECPoint a) {
        this.field.invert(a.z, a.z);
        this.field.square(this.t1, a.z);
        this.field.multiply(a.x, a.x, this.t1);
        this.field.multiply(this.t1, a.z, this.t1);
        this.field.multiply(a.y, a.y, this.t1);
        this.ffa.set(a.z, 1);
    }

    public void multiply(ECPoint R, int[] k) {
        FFA ffa = this.order.getFFA();
        int[] e = ffa.acquireVar(ffa.getBitSize() + 2);
        int[] h = ffa.acquireVar(ffa.getBitSize() + 2);
        ffa.copy(e, k);
        ffa.add(h, e, e);
        ffa.add(h, h, e);
        ffa.xor(h, h, e);
        ECPoint P = R.clonePoint();
        ECPoint N = R.clonePoint();
        this.negate(N);
        for (int bit = ffa.bitLength(h) - 2; bit > 0; --bit) {
            this.twice(R);
            if (!ffa.testBit(h, bit)) continue;
            if (!ffa.testBit(e, bit)) {
                this.add(R, P);
                continue;
            }
            this.add(R, N);
        }
        P.release();
        N.release();
        ffa.releaseVar(e);
        ffa.releaseVar(h);
        this.makeAffine(R);
    }

    public void multiplySum(ECPoint R1, int[] k1, ECPoint R2, int[] k2) {
        FFA ffa = this.order.getFFA();
        int bitSize = ffa.getBitSize() + 2;
        int[] e1 = ffa.acquireVar(bitSize);
        int[] h1 = ffa.acquireVar(bitSize);
        int[] e2 = ffa.acquireVar(bitSize);
        int[] h2 = ffa.acquireVar(bitSize);
        ffa.copy(e1, k1);
        ffa.copy(e2, k2);
        ffa.add(h1, e1, e1);
        ffa.add(h1, h1, e1);
        ffa.xor(h1, h1, e1);
        ffa.add(h2, e2, e2);
        ffa.add(h2, h2, e2);
        ffa.xor(h2, h2, e2);
        ECPoint[] P = new ECPoint[]{null, R1.clonePoint(), R2, R1.clonePoint(), R1.clonePoint()};
        this.add(P[3], P[2]);
        this.makeAffine(P[3]);
        this.negate(P[2]);
        this.add(P[4], P[2]);
        this.negate(P[2]);
        this.makeAffine(P[4]);
        int[][] Pind = new int[][]{{0, 2, -2}, {1, 3, 4}, {-1, -4, -3}};
        boolean isInfinity = true;
        for (int bit = bitSize - 1; bit > 0; --bit) {
            boolean neg;
            if (!isInfinity) {
                this.twice(R1);
            }
            int[] Prow = Pind[ffa.testBit(h1, bit) ? (!ffa.testBit(e1, bit) ? 1 : 2) : 0];
            int point = Prow[ffa.testBit(h2, bit) ? (!ffa.testBit(e2, bit) ? 1 : 2) : 0];
            if (point == 0) continue;
            boolean bl = neg = point < 0;
            if (neg) {
                point = -point;
            }
            ECPoint myP = P[point];
            if (neg) {
                this.negate(myP);
            }
            if (isInfinity) {
                this.copy(R1, myP);
                isInfinity = false;
            } else {
                this.add(R1, myP);
            }
            if (!neg) continue;
            this.negate(myP);
        }
        P[1].release();
        P[3].release();
        P[4].release();
        ffa.releaseVar(e1);
        ffa.releaseVar(h1);
        ffa.releaseVar(e2);
        ffa.releaseVar(h2);
        this.makeAffine(R1);
    }

    public boolean isOnCurve(ECPoint o1) {
        if (o1.curve != this || this.ffa.is(o1.z, 0) || this.ffa.cmp(o1.x, this.field.getP()) >= 0 || this.ffa.cmp(o1.y, this.field.getP()) >= 0 || this.ffa.cmp(o1.z, this.field.getP()) >= 0) {
            return false;
        }
        if (!this.ffa.is(o1.z, 1)) {
            this.makeAffine(o1);
        }
        this.field.square(this.t1, o1.y);
        this.field.square(this.t2, o1.x);
        this.field.multiply(this.t2, this.t2, o1.x);
        this.field.multiply(this.t3, this.a, o1.x);
        this.field.add(this.t2, this.t2, this.t3);
        this.field.add(this.t2, this.t2, this.b);
        return this.ffa.cmp(this.t1, this.t2) == 0;
    }

    public PrimeField getField() {
        return this.field;
    }

    public int[] getA() {
        return this.a;
    }

    public int[] getB() {
        return this.b;
    }

    public PrimeField getOrder() {
        return this.order;
    }

    public int[] getN() {
        return this.order.getP();
    }

    public int getH() {
        return this.h;
    }

    public ECPoint getGenerator() {
        return this.generator;
    }

    public boolean decodePoint(ECPoint point, byte[] data, int offset, int length) {
        int numLen = this.ffa.getByteSize();
        int totalLen = 2 * numLen + 1;
        if (length != totalLen || data[offset] != 4) {
            return false;
        }
        int[] x = this.ffa.from(point.x, data, offset + 1, numLen);
        int[] y = this.ffa.from(point.y, data, offset + numLen + 1, numLen);
        this.ffa.set(point.z, 1);
        return true;
    }

    public int encodePoint(ECPoint point, byte[] data, int offset) {
        int numLen = this.ffa.getByteSize();
        int totalLen = 2 * numLen + 1;
        if (data.length - offset < totalLen) {
            return 0;
        }
        if (!this.ffa.is(point.z, 1)) {
            this.makeAffine(point);
        }
        data[offset] = 4;
        this.ffa.toByteArray(data, offset + 1, numLen, point.x);
        this.ffa.toByteArray(data, offset + numLen + 1, numLen, point.y);
        return totalLen;
    }

    public void copy(ECPoint dst, ECPoint src) {
        this.ffa.copy(dst.x, src.x);
        this.ffa.copy(dst.y, src.y);
        this.ffa.copy(dst.z, src.z);
    }
}

