/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.VM;
import com.sun.squawk.util.Comparer;

public class Arrays {
    private Arrays() {
    }

    public static void sort(long[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(int[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(short[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(char[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(byte[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(double[] a) {
        Arrays.sort2(a, 0, a.length);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort2(a, fromIndex, toIndex);
    }

    public static void sort(float[] a) {
        Arrays.sort2(a, 0, a.length);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort2(a, fromIndex, toIndex);
    }

    private static void sort2(double[] a, int fromIndex, int toIndex) {
        long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (a[i] != a[i]) {
                double swap = a[i];
                a[i] = a[--n];
                a[n] = swap;
                continue;
            }
            if (a[i] == 0.0 && Double.doubleToLongBits(a[i]) == NEG_ZERO_BITS) {
                a[i] = 0.0;
                ++numNegZeros;
            }
            ++i;
        }
        Arrays.sort1(a, fromIndex, n - fromIndex);
        if (numNegZeros != 0) {
            int j = Arrays.binarySearch(a, 0.0, fromIndex, n - 1);
            while (--j >= 0 && a[j] == 0.0) {
            }
            for (int k = 0; k < numNegZeros; ++k) {
                a[++j] = -0.0;
            }
        }
    }

    private static void sort2(float[] a, int fromIndex, int toIndex) {
        int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (a[i] != a[i]) {
                float swap = a[i];
                a[i] = a[--n];
                a[n] = swap;
                continue;
            }
            if (a[i] == 0.0f && Float.floatToIntBits(a[i]) == NEG_ZERO_BITS) {
                a[i] = 0.0f;
                ++numNegZeros;
            }
            ++i;
        }
        Arrays.sort1(a, fromIndex, n - fromIndex);
        if (numNegZeros != 0) {
            int j = Arrays.binarySearch(a, 0.0f, fromIndex, n - 1);
            while (--j >= 0 && a[j] == 0.0f) {
            }
            for (int k = 0; k < numNegZeros; ++k) {
                a[++j] = -0.0f;
            }
        }
    }

    private static void sort1(long[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        long v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(long[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(int[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        int v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(short[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        short v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(short[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(short[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(char[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        char v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(char[] x, int a, int b) {
        char t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(char[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(char[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(byte[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        byte v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(byte[] x, int a, int b) {
        byte t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(byte[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(byte[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(double[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(double[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(float[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        float v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(float[] x, int a, int b) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(float[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(float[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void sort(Object[] a, Comparer c) {
        Object[] aux = new Object[a.length];
        System.arraycopy(a, 0, aux, 0, aux.length);
        Arrays.mergeSort(aux, a, 0, a.length, c);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex, Comparer c) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Object[] aux = new Object[a.length];
        System.arraycopy(a, 0, aux, 0, aux.length);
        Arrays.mergeSort(aux, a, fromIndex, toIndex, c);
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, Comparer c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Arrays.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = low + high >> 1;
        Arrays.mergeSort(dest, src, low, mid, c);
        Arrays.mergeSort(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static int binarySearch(long[] a, long key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(int[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(short[] a, short key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            short midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(char[] a, char key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            char midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(byte[] a, byte key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            byte midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(double[] a, double key) {
        return Arrays.binarySearch(a, key, 0, a.length - 1);
    }

    private static int binarySearch(double[] a, double key, int low, int high) {
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            double midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(float[] a, float key) {
        return Arrays.binarySearch(a, key, 0, a.length - 1);
    }

    private static int binarySearch(float[] a, float key, int low, int high) {
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            float midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                int keyBits;
                int midBits = Float.floatToIntBits(midVal);
                int n = midBits == (keyBits = Float.floatToIntBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(Object[] a, Object key, Comparer c) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static boolean[] copy(boolean[] src, int srcPos, int destLength, int destPos, int length) {
        boolean[] arr = new boolean[destLength];
        System.arraycopy(src, srcPos, arr, destPos, length);
        return arr;
    }

    public static byte[] copy(byte[] src, int srcPos, int destLength, int destPos, int length) {
        byte[] arr = new byte[destLength];
        System.arraycopy(src, srcPos, arr, destPos, length);
        return arr;
    }

    public static char[] copy(char[] src, int srcPos, int destLength, int destPos, int length) {
        char[] arr = new char[destLength];
        System.arraycopy(src, srcPos, arr, destPos, length);
        return arr;
    }

    public static double[] copy(double[] src, int srcPos, int destLength, int destPos, int length) {
        double[] arr = new double[destLength];
        System.arraycopy(src, srcPos, arr, destPos, length);
        return arr;
    }

    public static float[] copy(float[] src, int srcPos, int destLength, int destPos, int length) {
        float[] arr = new float[destLength];
        System.arraycopy(src, srcPos, arr, destPos, length);
        return arr;
    }

    public static int[] copy(int[] src, int srcPos, int destLength, int destPos, int length) {
        int[] arr = new int[destLength];
        System.arraycopy(src, srcPos, arr, destPos, length);
        return arr;
    }

    public static long[] copy(long[] src, int srcPos, int destLength, int destPos, int length) {
        long[] arr = new long[destLength];
        System.arraycopy(src, srcPos, arr, destPos, length);
        return arr;
    }

    public static Object[] copy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object[] copy(Object[] array) {
        Object[] newArray = new Object[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static short[] copy(short[] src, int srcPos, int destLength, int destPos, int length) {
        short[] arr = new short[destLength];
        System.arraycopy(src, srcPos, arr, destPos, length);
        return arr;
    }

    public static boolean equals(long[] a, long[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] a, int[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] a, short[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a, char[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] a, byte[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] a, boolean[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] a, double[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Double.doubleToLongBits(a[i]) == Double.doubleToLongBits(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] a, float[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Float.floatToIntBits(a[i]) == Float.floatToIntBits(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object o1 = a[i];
            Object o2 = a2[i];
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!VM.isArray(a) || !VM.isArray(b)) {
            return a.equals(b);
        }
        if (a instanceof int[] && b instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof short[] && b instanceof short[]) {
            return Arrays.equals((short[])a, (short[])b);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof boolean[] && b instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof char[] && b instanceof char[]) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a instanceof double[] && b instanceof double[]) {
            return Arrays.equals((double[])a, (double[])b);
        }
        if (a instanceof float[] && b instanceof float[]) {
            return Arrays.equals((float[])a, (float[])b);
        }
        if (a instanceof long[] && b instanceof long[]) {
            return Arrays.equals((long[])a, (long[])b);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Arrays.equals((Object[])a, (Object[])b);
        }
        return false;
    }

    public static int hashCode(Object object) {
        int hash;
        if (!VM.isArray(object)) {
            return object.hashCode();
        }
        if (object instanceof int[]) {
            int length;
            int[] array = (int[])object;
            hash = length = array.length;
            int step = (length + 5) / 5;
            for (int i = 0; i < length; i += step) {
                hash += array[i];
            }
        } else if (object instanceof short[]) {
            int length;
            short[] array = (short[])object;
            hash = length = array.length;
            int step = (length + 5) / 5;
            for (int i = 0; i < length; i += step) {
                hash += array[i];
            }
        } else if (object instanceof byte[]) {
            int length;
            byte[] array = (byte[])object;
            hash = length = array.length;
            int step = (length + 5) / 5;
            for (int i = 0; i < length; i += step) {
                hash += array[i];
            }
        } else if (object instanceof boolean[]) {
            int length;
            boolean[] array = (boolean[])object;
            hash = length = array.length;
            int step = (length + 5) / 5;
            for (int i = 0; i < length; i += step) {
                hash += array[i] ? i : 0;
            }
        } else if (object instanceof char[]) {
            int length;
            char[] array = (char[])object;
            hash = length = array.length;
            int step = (length + 5) / 5;
            for (int i = 0; i < length; i += step) {
                hash += array[i];
            }
        } else if (object instanceof double[]) {
            int length;
            double[] array = (double[])object;
            hash = length = array.length;
            int step = (length + 5) / 5;
            for (int i = 0; i < length; i += step) {
                hash = (int)((double)hash + array[i]);
            }
        } else if (object instanceof float[]) {
            int length;
            float[] array = (float[])object;
            hash = length = array.length;
            int step = (length + 5) / 5;
            for (int i = 0; i < length; i += step) {
                hash = (int)((float)hash + array[i]);
            }
        } else if (object instanceof long[]) {
            int length;
            long[] array = (long[])object;
            hash = length = array.length;
            int step = (length + 5) / 5;
            for (int i = 0; i < length; i += step) {
                hash = (int)((long)hash + array[i]);
            }
        } else if (object instanceof Object[]) {
            int length;
            Object[] array = (Object[])object;
            hash = length = array.length;
            int step = (length + 5) / 5;
            for (int i = 0; i < length; i += step) {
                if (array[i] == null) {
                    hash += i;
                    continue;
                }
                hash += array[i].hashCode();
            }
        } else {
            throw new Error("InternalError");
        }
        return hash;
    }

    public static int length(Object array) {
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        throw new IllegalArgumentException();
    }

    public static void fill(long[] a, long val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(int[] a, int val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(short[] a, short val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(char[] a, char val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(byte[] a, byte val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(boolean[] a, boolean val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(double[] a, double val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(float[] a, float val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(Object[] a, Object val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }
}

