/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.VM;
import com.sun.squawk.pragma.NotInlinedPragma;

public class Assert {
    public static final boolean ASSERTS_ENABLED = false;
    public static final boolean SHOULD_NOT_REACH_HERE_ALWAYS_ENABLED = true;
    public static final boolean ASSERT_ALWAYS_IS_FATAL = true;

    private Assert() {
    }

    protected static void throwAssertFailedException(String message) throws NotInlinedPragma {
        System.err.flush();
        System.out.flush();
        throw new RuntimeException(message);
    }

    private static void throwAssertFailedException(String systemMessage, String message) throws NotInlinedPragma {
        Assert.throwAssertFailedException(systemMessage + message);
    }

    private static void throwAssertFailedException(String systemMessage, String message, String filename, int lineno) throws NotInlinedPragma {
        Assert.throwAssertFailedException(systemMessage + "(" + filename + ":" + lineno + "): " + message);
    }

    public static void that(boolean cond, String msg) {
    }

    public static void that(boolean cond, String msg, String filename, int lineno) {
    }

    public static void that(boolean cond) {
    }

    public static void that(boolean cond, String filename, int lineno) {
    }

    public static RuntimeException shouldNotReachHere(String msg) throws NotInlinedPragma {
        Assert.throwAssertFailedException("Assertion failed: should not reach here: ", msg);
        return null;
    }

    public static RuntimeException shouldNotReachHere(String msg, String filename, int lineno) throws NotInlinedPragma {
        Assert.throwAssertFailedException("Assertion failed: should not reach here: ", msg, filename, lineno);
        return null;
    }

    public static RuntimeException shouldNotReachHere() {
        Assert.throwAssertFailedException("Assertion failed: ", "should not reach here");
        return null;
    }

    public static RuntimeException shouldNotReachHere(String filename, int lineno) {
        Assert.throwAssertFailedException("Assertion failed: ", "should not reach here", filename, lineno);
        return null;
    }

    public static void thatFatal(boolean cond, String msg) {
        if (!cond) {
            VM.print("Assertion failed: ");
            VM.println(msg);
            VM.fatalVMError();
        }
    }

    private static void printContext(String filename, int lineno) {
        VM.print("(");
        VM.print(filename);
        VM.print(":");
        VM.print(lineno);
        VM.print("): ");
    }

    public static void thatFatal(boolean cond, String msg, String filename, int lineno) {
        if (!cond) {
            VM.print("Assertion failed: ");
            Assert.printContext(filename, lineno);
            VM.println(msg);
            VM.fatalVMError();
        }
    }

    public static void thatFatal(boolean cond) {
        if (!cond) {
            VM.println("Assertion failed");
            VM.fatalVMError();
        }
    }

    public static void thatFatal(boolean cond, String filename, int lineno) {
        if (!cond) {
            VM.println("Assertion failed");
            Assert.printContext(filename, lineno);
            VM.fatalVMError();
        }
    }

    public static RuntimeException shouldNotReachHereFatal(String msg) {
        VM.print("Assertion failed: ");
        VM.print("should not reach here: ");
        VM.println(msg);
        VM.fatalVMError();
        return null;
    }

    public static RuntimeException shouldNotReachHereFatal(String msg, String filename, int lineno) {
        VM.print("Assertion failed: ");
        VM.print("should not reach here: ");
        Assert.printContext(filename, lineno);
        VM.println(msg);
        VM.fatalVMError();
        return null;
    }

    public static RuntimeException shouldNotReachHereFatal() {
        VM.print("Assertion failed: ");
        VM.println("should not reach here: ");
        VM.fatalVMError();
        return null;
    }

    public static RuntimeException shouldNotReachHereFatal(String filename, int lineno) {
        VM.print("Assertion failed: ");
        VM.print("should not reach here: ");
        Assert.printContext(filename, lineno);
        VM.fatalVMError();
        return null;
    }

    public static void always(boolean cond, String msg) {
        if (!cond) {
            VM.print("Assertion failed: ");
            VM.println(msg);
            VM.fatalVMError();
        }
    }

    public static void always(boolean cond, String msg, String filename, int lineno) {
        if (!cond) {
            VM.print("Assertion failed: ");
            Assert.printContext(filename, lineno);
            VM.println(msg);
            VM.fatalVMError();
        }
    }

    public static void always(boolean cond) {
        if (!cond) {
            VM.println("Assertion failed");
            VM.fatalVMError();
        }
    }

    public static void always(boolean cond, String filename, int lineno) {
        if (!cond) {
            VM.println("Assertion failed");
            Assert.printContext(filename, lineno);
            VM.fatalVMError();
        }
    }
}

