/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

public final class BitSet {
    private byte[] bits;
    private int bytesInUse;
    private final boolean bitsAreExternal;
    private static final String BIT_COUNT = "\u0000\u0001\u0001\u0002\u0001\u0002\u0002\u0003\u0001\u0002\u0002\u0003\u0002\u0003\u0003\u0004\u0001\u0002\u0002\u0003\u0002\u0003\u0003\u0004\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0001\u0002\u0002\u0003\u0002\u0003\u0003\u0004\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0001\u0002\u0002\u0003\u0002\u0003\u0003\u0004\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0004\u0005\u0005\u0006\u0005\u0006\u0006\u0007\u0001\u0002\u0002\u0003\u0002\u0003\u0003\u0004\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0004\u0005\u0005\u0006\u0005\u0006\u0006\u0007\u0002\u0003\u0003\u0004\u0003\u0004\u0004\u0005\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0004\u0005\u0005\u0006\u0005\u0006\u0006\u0007\u0003\u0004\u0004\u0005\u0004\u0005\u0005\u0006\u0004\u0005\u0005\u0006\u0005\u0006\u0006\u0007\u0004\u0005\u0005\u0006\u0005\u0006\u0006\u0007\u0005\u0006\u0006\u0007\u0006\u0007\u0007\b";

    public BitSet() {
        this.bits = new byte[10];
        this.bytesInUse = 0;
        this.bitsAreExternal = false;
    }

    public BitSet(byte[] bits) {
        this.bits = bits;
        this.bitsAreExternal = true;
        for (int i = bits.length - 1; i >= 0; --i) {
            if (bits[i] == 0) continue;
            this.bytesInUse = i + 1;
            break;
        }
    }

    public boolean areBitsExternal() {
        return this.bitsAreExternal;
    }

    protected void validateIndex(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
    }

    public void copyInto(byte[] bits) {
        int length = bits.length;
        if (length > this.bits.length) {
            length = this.bits.length;
        }
        System.arraycopy(this.bits, 0, bits, 0, length);
    }

    public int length() {
        if (this.bytesInUse == 0) {
            return 0;
        }
        int highestUnit = this.bits[this.bytesInUse - 1] & 0xFF;
        int hiBit = 0;
        while (highestUnit != 0) {
            highestUnit >>= 1;
            ++hiBit;
        }
        return 8 * (this.bytesInUse - 1) + hiBit;
    }

    public int size() {
        return this.bits.length * 8;
    }

    public void set(int bitIndex) {
        this.validateIndex(bitIndex);
        int byteIndex = bitIndex / 8;
        this.ensureCapacity(bitIndex);
        if (byteIndex >= this.bytesInUse) {
            this.bytesInUse = byteIndex + 1;
        }
        byte bit = (byte)(1 << bitIndex % 8);
        int n = byteIndex;
        this.bits[n] = (byte)(this.bits[n] | bit);
    }

    private void ensureCapacity(int bitIndex) throws IndexOutOfBoundsException {
        int bytesRequired = bitIndex / 8 + 1;
        if (this.bits.length < bytesRequired) {
            this.grow(bitIndex, bytesRequired);
        }
    }

    private void grow(int bitIndex, int bytesRequired) throws IndexOutOfBoundsException {
        if (this.bitsAreExternal) {
            throw new IndexOutOfBoundsException("bitIndex >= this.size(): " + bitIndex);
        }
        int request = Math.max(2 * this.bits.length, bytesRequired);
        byte[] newBits = new byte[request];
        System.arraycopy(this.bits, 0, newBits, 0, this.bytesInUse);
        this.bits = newBits;
    }

    public void clear(int bitIndex) {
        this.validateIndex(bitIndex);
        int byteIndex = bitIndex / 8;
        if (byteIndex < this.bytesInUse) {
            byte bit = (byte)(1 << bitIndex % 8);
            int n = byteIndex;
            this.bits[n] = (byte)(this.bits[n] & ~bit);
        }
    }

    public void clear() {
        while (this.bytesInUse > 0) {
            this.bits[--this.bytesInUse] = 0;
        }
    }

    public boolean get(int bitIndex) {
        this.validateIndex(bitIndex);
        boolean result = false;
        int byteIndex = bitIndex / 8;
        if (byteIndex < this.bytesInUse) {
            byte bit = (byte)(1 << bitIndex % 8);
            result = (this.bits[byteIndex] & bit) != 0;
        }
        return result;
    }

    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.bytesInUse; ++i) {
            sum += BIT_COUNT.charAt(this.bits[i] & 0xFF);
        }
        return sum;
    }

    public void or(BitSet other) {
        this.or(other, 0);
    }

    public void or(BitSet other, int shift) {
        if (this == other) {
            return;
        }
        if (shift >= 0) {
            this.ensureCapacity(other.bytesInUse + (shift + 7) / 8);
            int bitIndex = other.nextSetBit(0);
            while (bitIndex != -1) {
                this.set(bitIndex + shift);
                bitIndex = other.nextSetBit(bitIndex + 1);
            }
        } else {
            shift = -shift;
            this.ensureCapacity(other.bytesInUse - (shift + 7) / 8);
            int bitIndex = other.nextSetBit(shift);
            while (bitIndex != -1) {
                this.set(bitIndex - shift);
                bitIndex = other.nextSetBit(bitIndex + 1);
            }
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof BitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BitSet set = (BitSet)obj;
        int minBytesInUse = Math.min(this.bytesInUse, set.bytesInUse);
        for (i = 0; i < minBytesInUse; ++i) {
            if (this.bits[i] == set.bits[i]) continue;
            return false;
        }
        if (this.bytesInUse > minBytesInUse) {
            for (i = minBytesInUse; i < this.bytesInUse; ++i) {
                if (this.bits[i] == 0) continue;
                return false;
            }
        } else {
            for (i = minBytesInUse; i < set.bytesInUse; ++i) {
                if (set.bits[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int h = 1234;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i] * (i + 1);
        }
        return h;
    }

    public int nextSetBit(int fromIndex) {
        int byteIndex;
        this.validateIndex(fromIndex);
        if (byteIndex >= this.bytesInUse) {
            return -1;
        }
        int bitIndex = fromIndex % 8;
        for (byteIndex = fromIndex / 8; byteIndex != this.bytesInUse; ++byteIndex) {
            byte bitSetUnit = this.bits[byteIndex];
            if (BIT_COUNT.charAt(bitSetUnit & 0xFF) != '\u0000') {
                while (bitIndex != 8) {
                    if ((bitSetUnit & 1 << bitIndex) != 0) {
                        return byteIndex * 8 + bitIndex;
                    }
                    ++bitIndex;
                }
            }
            bitIndex = 0;
        }
        return -1;
    }

    public String toString() {
        int numBits = this.bytesInUse * 8;
        StringBuffer buffer = new StringBuffer(8 * numBits + 2);
        String separator = "";
        buffer.append('{');
        for (int i = 0; i < numBits; ++i) {
            if (!this.get(i)) continue;
            buffer.append(separator);
            separator = ", ";
            buffer.append(i);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

