/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.util.SquawkHashtable;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Stack;

public final class ComputationTimer {
    private static final SquawkHashtable flatTimes = new SquawkHashtable();
    private static final SquawkHashtable totalTimes = new SquawkHashtable();
    private static final Stack executions = new Stack();

    private ComputationTimer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Execution execute(String id, Object c) {
        long start = System.currentTimeMillis();
        Execution e = new Execution();
        executions.push(e);
        Long currentTotal = (Long)totalTimes.get(id);
        try {
            e.result = c instanceof Computation ? ((Computation)c).run() : ((ComputationException)c).run();
            executions.pop();
        }
        catch (Exception ex) {
            try {
                e.exception = ex;
                executions.pop();
            }
            catch (Throwable throwable) {
                executions.pop();
                long time = System.currentTimeMillis() - start;
                if (!executions.isEmpty()) {
                    ((Execution)ComputationTimer.executions.peek()).nestedTimes += time;
                }
                totalTimes.put(id, new Long(time + (currentTotal == null ? 0L : currentTotal)));
                Long flatTime = (Long)flatTimes.get(id);
                if (flatTime == null) {
                    flatTimes.put(id, new Long(time - e.nestedTimes));
                } else {
                    flatTimes.put(id, new Long(flatTime + (time - e.nestedTimes)));
                }
                throw throwable;
            }
            long time = System.currentTimeMillis() - start;
            if (!executions.isEmpty()) {
                ((Execution)ComputationTimer.executions.peek()).nestedTimes += time;
            }
            totalTimes.put(id, new Long(time + (currentTotal == null ? 0L : currentTotal)));
            Long flatTime = (Long)flatTimes.get(id);
            if (flatTime == null) {
                flatTimes.put(id, new Long(time - e.nestedTimes));
            } else {
                flatTimes.put(id, new Long(flatTime + (time - e.nestedTimes)));
            }
        }
        long time = System.currentTimeMillis() - start;
        if (!executions.isEmpty()) {
            ((Execution)ComputationTimer.executions.peek()).nestedTimes += time;
        }
        totalTimes.put(id, new Long(time + (currentTotal == null ? 0L : currentTotal)));
        Long flatTime = (Long)flatTimes.get(id);
        if (flatTime == null) {
            flatTimes.put(id, new Long(time - e.nestedTimes));
        } else {
            flatTimes.put(id, new Long(flatTime + (time - e.nestedTimes)));
        }
        return e;
    }

    public static Object time(String id, Computation computation) {
        Execution e = ComputationTimer.execute(id, computation);
        if (e.exception != null) {
            throw (RuntimeException)e.exception;
        }
        return e.result;
    }

    public static Object time(String id, ComputationException computation) throws Exception {
        Execution e = ComputationTimer.execute(id, computation);
        if (e.exception != null) {
            throw e.exception;
        }
        return e.result;
    }

    public static Enumeration getComputations() {
        return flatTimes.keys();
    }

    public static Enumeration getFlatTimes() {
        return flatTimes.elements();
    }

    public static Enumeration getTotalTimes() {
        return totalTimes.elements();
    }

    public static void reset() {
        if (!executions.isEmpty()) {
            throw new IllegalStateException();
        }
        flatTimes.clear();
        totalTimes.clear();
    }

    public static String timesAsString() {
        StringBuffer buf = new StringBuffer("{ ");
        Enumeration keys = flatTimes.keys();
        Enumeration ftimes = flatTimes.elements();
        Enumeration ttimes = totalTimes.elements();
        while (keys.hasMoreElements()) {
            String id = (String)keys.nextElement();
            Long ftime = (Long)ftimes.nextElement();
            Long ttime = (Long)ttimes.nextElement();
            buf.append(id).append(":").append(ttime.toString()).append(":").append(ftime.toString());
            if (!keys.hasMoreElements()) continue;
            buf.append(", ");
        }
        return buf.append(" }").toString();
    }

    public static void dump(PrintStream out) {
        out.println("Times: flat | total | computation");
        Enumeration keys = flatTimes.keys();
        Enumeration ftimes = flatTimes.elements();
        Enumeration ttimes = totalTimes.elements();
        while (keys.hasMoreElements()) {
            String id = (String)keys.nextElement();
            Long ftime = (Long)ftimes.nextElement();
            Long ttime = (Long)ttimes.nextElement();
            out.println(ftime.toString() + '\t' + ttime + '\t' + id);
        }
    }

    static class Execution {
        long nestedTimes;
        Object result;
        Exception exception;

        Execution() {
        }
    }

    public static interface ComputationException {
        public Object run() throws Exception;
    }

    public static interface Computation {
        public Object run();
    }
}

