/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public final class DataOutputUTF8Encoder {
    private DataOutputUTF8Encoder() {
    }

    public static final int writeUTF(String str, DataOutput out, boolean twoByteLength) throws IOException {
        int maxLen;
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        int n = maxLen = twoByteLength ? 65535 : Integer.MAX_VALUE;
        if (utflen > maxLen) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + (twoByteLength ? 2 : 4)];
        if (!twoByteLength) {
            bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        out.write(bytearr);
        return utflen + 2;
    }
}

