/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

public class MathUtils {
    private static final long sign_mask = Long.MIN_VALUE;
    private static final long no_sign_mask = Long.MAX_VALUE;
    private static final long exp_mask = 0x7FF0000000000000L;
    private static final long no_exp_mask = -9218868437227405313L;
    private static final long significand_mask = 0xFFFFFFFFFFFFFL;
    private static final long implicit_significand_bit = 0x10000000000000L;
    private static final long one = 0x3FF0000000000000L;
    private static final long half = 4602678819172646912L;
    private static final long low_bits_mask = 0xFFFFFFFFL;
    private static final long high_bits_mask = -4294967296L;
    private static final double two54 = 1.8014398509481984E16;
    private static final double two53 = 9.007199254740992E15;
    private static final double twom54 = 5.551115123125783E-17;
    private static final double two24 = 1.6777216E7;
    private static final double twon24 = 5.960464477539063E-8;
    private static final double twon28 = 3.725290298461914E-9;
    private static final double twon27 = 7.450580596923828E-9;
    private static final double pio2_hi = 1.5707963267948966;
    private static final double pio2_lo = 6.123233995736766E-17;
    private static final double pio4_hi = 0.7853981633974483;
    private static final double pio4_lo = 3.061616997868383E-17;
    private static final double arc_pS0 = 0.16666666666666666;
    private static final double arc_pS1 = -0.3255658186224009;
    private static final double arc_pS2 = 0.20121253213486293;
    private static final double arc_pS3 = -0.04005553450067941;
    private static final double arc_pS4 = 7.915349942898145E-4;
    private static final double arc_pS5 = 3.479331075960212E-5;
    private static final double arc_qS1 = -2.403394911734414;
    private static final double arc_qS2 = 2.0209457602335057;
    private static final double arc_qS3 = -0.6882839716054533;
    private static final double arc_qS4 = 0.07703815055590194;
    private static final double exp_P1 = 0.16666666666666602;
    private static final double exp_P2 = -0.0027777777777015593;
    private static final double exp_P3 = 6.613756321437934E-5;
    private static final double exp_P4 = -1.6533902205465252E-6;
    private static final double exp_P5 = 4.1381367970572385E-8;
    private static final double[] halF = new double[]{0.5, -0.5};
    private static final double o_threshold = 709.782712893384;
    private static final double u_threshold = -745.1332191019411;
    private static final double ln2_hi = 0.6931471803691238;
    private static final double ln2_lo = 1.9082149292705877E-10;
    private static final double[] ln2HI = new double[]{0.6931471803691238, -0.6931471803691238};
    private static final double[] ln2LO = new double[]{1.9082149292705877E-10, -1.9082149292705877E-10};
    private static final double invln2 = 1.4426950408889634;
    private static final double Lg1 = 0.6666666666666735;
    private static final double Lg2 = 0.3999999999940942;
    private static final double Lg3 = 0.2857142874366239;
    private static final double Lg4 = 0.22222198432149784;
    private static final double Lg5 = 0.1818357216161805;
    private static final double Lg6 = 0.15313837699209373;
    private static final double Lg7 = 0.14798198605116586;
    private static final double ln2 = 0.6931471805599453;
    private static final double twom1000 = 9.332636185032189E-302;
    private static final double pow_L1 = 0.5999999999999946;
    private static final double pow_L2 = 0.4285714285785502;
    private static final double pow_L3 = 0.33333332981837743;
    private static final double pow_L4 = 0.272728123808534;
    private static final double pow_L5 = 0.23066074577556175;
    private static final double pow_L6 = 0.20697501780033842;
    private static final double pow_P1 = 0.16666666666666602;
    private static final double pow_P2 = -0.0027777777777015593;
    private static final double pow_P3 = 6.613756321437934E-5;
    private static final double pow_P4 = -1.6533902205465252E-6;
    private static final double pow_P5 = 4.1381367970572385E-8;
    private static final double lg2 = 0.6931471805599453;
    private static final double lg2_h = 0.6931471824645996;
    private static final double lg2_l = -1.904654299957768E-9;
    private static final double ovt = 8.008566259537294E-17;
    private static final double cp = 0.9617966939259756;
    private static final double cp_h = 0.9617967009544373;
    private static final double cp_l = -7.028461650952758E-9;
    private static final double ivln2 = 1.4426950408889634;
    private static final double ivln2_h = (double)1.442695f;
    private static final double ivln2_l = 1.9259629911266175E-8;
    private static final double[] atanhi = new double[]{0.4636476090008061, 0.7853981633974483, 0.982793723247329, 1.5707963267948966};
    private static final double[] atanlo = new double[]{2.2698777452961687E-17, 3.061616997868383E-17, 1.3903311031230998E-17, 6.123233995736766E-17};
    private static final double[] aT = new double[]{0.3333333333333293, -0.19999999999876483, 0.14285714272503466, -0.11111110405462356, 0.09090887133436507, -0.0769187620504483, 0.06661073137387531, -0.058335701337905735, 0.049768779946159324, -0.036531572744216916, 0.016285820115365782};
    private static final double Lp1 = 0.6666666666666735;
    private static final double Lp2 = 0.3999999999940942;
    private static final double Lp3 = 0.2857142874366239;
    private static final double Lp4 = 0.22222198432149784;
    private static final double Lp5 = 0.1818357216161805;
    private static final double Lp6 = 0.15313837699209373;
    private static final double Lp7 = 0.14798198605116586;
    private static final double expm1_Q1 = -0.03333333333333313;
    private static final double expm1_Q2 = 0.0015873015872548146;
    private static final double expm1_Q3 = -7.93650757867488E-5;
    private static final double expm1_Q4 = 4.008217827329362E-6;
    private static final double expm1_Q5 = -2.0109921818362437E-7;

    private MathUtils() {
    }

    public static double scalbn(double x, int n) {
        long lx = Double.doubleToLongBits(x);
        long k = (lx & 0x7FF0000000000000L) >> 52;
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return x;
        }
        if (k == 0L) {
            if (x == 0.0) {
                return x;
            }
            k = ((Double.doubleToLongBits(x *= 1.8014398509481984E16) & 0x7FF0000000000000L) >> 52) - 54L;
            if (n < -50000) {
                return 0.0;
            }
        }
        if ((k += (long)n) > 2046L) {
            return x;
        }
        if (k > 0L) {
            x = Double.longBitsToDouble(lx & 0x800FFFFFFFFFFFFFL | k << 52);
            return x;
        }
        if (k <= -54L) {
            if (n > 50000) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        x = lx & 0x800FFFFFFFFFFFFFL | (k += 54L) << 52;
        return x * 5.551115123125783E-17;
    }

    public static int round(float a) {
        return (int)Math.floor(a + 0.5f);
    }

    public static long round(double a) {
        return (long)Math.floor(a + 0.5);
    }

    public static double exp(double a) {
        double t;
        int k;
        double hi = 0.0;
        double lo = 0.0;
        int xsb = (int)((Double.doubleToLongBits(a) & Long.MIN_VALUE) >>> 63);
        double absa = Math.abs(a);
        if (absa >= 709.78) {
            if (Double.isInfinite(a)) {
                if (a > 0.0) {
                    return a;
                }
                return 0.0;
            }
            if (Double.isNaN(a)) {
                return a;
            }
            if (a > 709.782712893384) {
                return Double.POSITIVE_INFINITY;
            }
            if (a < -745.1332191019411) {
                return 0.0;
            }
        }
        if (absa > Double.longBitsToDouble(4599914934703226879L)) {
            if (absa < Double.longBitsToDouble(4607361304187895808L)) {
                hi = a - ln2HI[xsb];
                lo = ln2LO[xsb];
                k = 1 - xsb - xsb;
            } else {
                k = (int)(1.4426950408889634 * a + halF[xsb]);
                t = k;
                hi = a - t * ln2HI[0];
                lo = t * ln2LO[0];
            }
            a = hi - lo;
        } else {
            if (absa < 3.725290298461914E-9) {
                return 1.0 + a;
            }
            k = 0;
        }
        t = a * a;
        double c = a - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
        if (k == 0) {
            return 1.0 - (a * c / (c - 2.0) - a);
        }
        double y = 1.0 - (lo - a * c / (2.0 - c) - hi);
        if (k >= -1021) {
            y = Double.longBitsToDouble(Double.doubleToLongBits(y) + ((long)k << 52));
            return y;
        }
        y = Double.longBitsToDouble(Double.doubleToLongBits(y) + ((long)k + 1000L << 52));
        return y * 9.332636185032189E-302;
    }

    public static double log(double a) {
        int k = 0;
        long lo = Double.doubleToLongBits(a);
        int hx = (int)(lo >>> 32);
        if (Double.isInfinite(a)) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(a)) {
            return a;
        }
        if (hx < 0x100000) {
            if (Math.abs(a) == 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (a < 0.0) {
                return Double.NaN;
            }
        }
        k += (hx >>> 20) - 1023;
        int i = (hx &= 0xFFFFF) + 614244 & 0x100000;
        a = Double.longBitsToDouble((Double.doubleToLongBits(a) & 0xFFFFFFFFL) + ((long)(hx | i ^ 0x3FF00000) << 32));
        k += i >>> 20;
        double f = a - 1.0;
        if ((0xFFFFF & 2 + hx) < 3) {
            if (f == 0.0) {
                if (k == 0) {
                    return 0.0;
                }
                double dk = k;
                return dk * 0.6931471803691238 + dk * 1.9082149292705877E-10;
            }
            double R = f * f * (0.5 - f / 3.0);
            if (k == 0) {
                return f - R;
            }
            double dk = k;
            return dk * 0.6931471803691238 - (R - dk * 1.9082149292705877E-10 - f);
        }
        double s = f / (2.0 + f);
        double dk = k;
        double z = s * s;
        i = hx - 398458;
        double w = z * z;
        int j = 440401 - hx;
        double t1 = w * (0.3999999999940942 + w * (0.22222198432149784 + w * 0.15313837699209373));
        double t2 = z * (0.6666666666666735 + w * (0.2857142874366239 + w * (0.1818357216161805 + w * 0.14798198605116586)));
        double R = t2 + t1;
        if ((i |= j) > 0) {
            double hfsq = 0.5 * f * f;
            if (k == 0) {
                return f - (hfsq - s * (hfsq + R));
            }
            return dk * 0.6931471803691238 - (hfsq - (s * (hfsq + R) + dk * 1.9082149292705877E-10) - f);
        }
        if (k == 0) {
            return f - s * (f - R);
        }
        return dk * 0.6931471803691238 - (s * (f - R) - dk * 1.9082149292705877E-10 - f);
    }

    public static double pow(double x, double y) {
        double p_l;
        double p_h;
        double r;
        double s;
        int n;
        double t2;
        double t1;
        double v;
        double u;
        double w;
        double t;
        int k;
        long j;
        double[] bp = new double[]{1.0, 1.5};
        double[] dp_h = new double[]{0.0, 0.5849624872207642};
        double[] dp_l = new double[]{0.0, 1.350039202129749E-8};
        long hx = Double.doubleToLongBits(x);
        long hy = Double.doubleToLongBits(y);
        long ix = hx & Long.MAX_VALUE;
        long iy = hy & Long.MAX_VALUE;
        if (iy == 0L) {
            return 1.0;
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return x + y;
        }
        int yisint = 0;
        if ((int)(hx >> 32) < 0) {
            if (iy >= 0x4340000000000000L) {
                yisint = 2;
            } else if (iy >= 0x3FF0000000000000L && (j = iy >> 52 - (k = (int)(iy >> 52) - 1023)) << 52 - k == iy) {
                yisint = 2 - ((int)j & 1);
            }
        }
        if ((int)iy == 0) {
            if (Double.isInfinite(y)) {
                if (ix == 0x3FF0000000000000L) {
                    return y - y;
                }
                if (ix >= 0x3FF0000000000000L) {
                    if (hy >= 0L) {
                        return y;
                    }
                    return 0.0;
                }
                if (hy < 0L) {
                    return -y;
                }
                return 0.0;
            }
            if (Math.abs(y) == 1.0) {
                if (hy < 0L) {
                    return 1.0 / x;
                }
                return x;
            }
            if (y == 2.0) {
                return x * x;
            }
            if (y == 0.5 && hx >= 0L) {
                return Math.sqrt(x);
            }
        }
        double ax = Math.abs(x);
        if ((int)ix == 0 && (ix == 0L || Double.isInfinite(x) || ax == 1.0)) {
            double z = ax;
            if (hy < 0L) {
                z = 1.0 / z;
            }
            if (hx < 0L) {
                if (Math.abs(x) == 1.0 && yisint == 0) {
                    z = (z - z) / (z - z);
                } else if (yisint == 1) {
                    z = -z;
                }
            }
            return z;
        }
        if (hx < 0L & yisint == 0) {
            return (x - x) / (x - x);
        }
        if (iy > 4746794011543470079L) {
            if (iy > 4895412799246696447L) {
                if (ix <= 0x3FEFFFFFFFFFFFFFL) {
                    if (hy < 0L) {
                        return Double.POSITIVE_INFINITY;
                    }
                    return 0.0;
                }
                if (ix >= 0x3FF0000000000000L) {
                    if (hy > 0L) {
                        return Double.POSITIVE_INFINITY;
                    }
                    return 0.0;
                }
            }
            if (ix < 4607182414505050112L) {
                if (hy < 0L) {
                    return Double.POSITIVE_INFINITY;
                }
                return 0.0;
            }
            if (ix > 0x3FF00000FFFFFFFFL) {
                if (hy > 0L) {
                    return Double.POSITIVE_INFINITY;
                }
                return 0.0;
            }
            t = x - 1.0;
            w = t * t * (0.5 - t * (0.3333333333333333 - t * 0.25));
            u = (double)1.442695f * t;
            v = t * 1.9259629911266175E-8 - w * 1.4426950408889634;
            t1 = u + v;
            t1 = Double.longBitsToDouble(Double.doubleToLongBits(t1) & 0xFFFFFFFF00000000L);
            t2 = v - (t1 - u);
        } else {
            n = 0;
            if (ix < 0x10000000000000L) {
                n -= 53;
                ix = Double.doubleToLongBits(ax *= 9.007199254740992E15);
            }
            n += (int)(ix >>> 52) - 1023;
            j = ix & 0xFFFFFFFFFFFFFL;
            ix = j | 0x3FF0000000000000L;
            if ((int)(j >> 32) <= 235662) {
                k = 0;
            } else if ((int)(j >> 32) < 767610) {
                k = 1;
            } else {
                k = 0;
                ++n;
                ix -= 0x10000000000000L;
            }
            ax = Double.longBitsToDouble((Double.doubleToLongBits(ax) & 0xFFFFFFFFL) + (ix & 0xFFFFFFFF00000000L));
            u = ax - bp[k];
            v = 1.0 / (ax + bp[k]);
            double s_h = s = u * v;
            s_h = Double.longBitsToDouble(Double.doubleToLongBits(s_h) & 0xFFFFFFFF00000000L);
            double t_h = Double.longBitsToDouble((ix >>> 1 | 0x2000000000000000L) + 0x8000000000000L + ((long)k << 50) & 0xFFFFFFFF00000000L);
            double t_l = ax - (t_h - bp[k]);
            double s_l = v * (u - s_h * t_h - s_h * t_l);
            double s2 = s * s;
            r = s2 * s2 * (0.5999999999999946 + s2 * (0.4285714285785502 + s2 * (0.33333332981837743 + s2 * (0.272728123808534 + s2 * (0.23066074577556175 + s2 * 0.20697501780033842)))));
            s2 = s_h * s_h;
            t_h = 3.0 + s2 + (r += s_l * (s_h + s));
            t_h = Double.longBitsToDouble(Double.doubleToLongBits(t_h) & 0xFFFFFFFF00000000L);
            t_l = r - (t_h - 3.0 - s2);
            u = s_h * t_h;
            v = s_l * t_h + t_l * s;
            p_h = u + v;
            p_h = Double.longBitsToDouble(Double.doubleToLongBits(p_h) & 0xFFFFFFFF00000000L);
            p_l = v - (p_h - u);
            double z_h = 0.9617967009544373 * p_h;
            double z_l = -7.028461650952758E-9 * p_h + p_l * 0.9617966939259756 + dp_l[k];
            t = n;
            t1 = z_h + z_l + dp_h[k] + t;
            t1 = Double.longBitsToDouble(Double.doubleToLongBits(t1) & 0xFFFFFFFF00000000L);
            t2 = z_l - (t1 - t - dp_h[k] - z_h);
        }
        s = 1.0;
        if ((hx >> 63) + 1L == 0L && yisint == 1) {
            s = -1.0;
        }
        double y1 = y;
        p_l = (y - (y1 = Double.longBitsToDouble(Double.doubleToLongBits(y1) & 0xFFFFFFFF00000000L))) * t1 + y * t2;
        double z = p_l + (p_h = y1 * t1);
        j = Double.doubleToLongBits(z);
        if (j >= 0x4090000000000000L) {
            if (j - 0x4090000000000000L != 0L) {
                return s * Double.POSITIVE_INFINITY;
            }
            if (p_l + 8.008566259537294E-17 > z - p_h) {
                return s * Double.POSITIVE_INFINITY;
            }
        } else if ((j & Long.MAX_VALUE) >= 4652442715445788672L) {
            if (j - 4652442715445788672L != 0L) {
                return s * 0.0;
            }
            if (p_l <= z - p_h) {
                return s * 0.0;
            }
        }
        long i = j & Long.MAX_VALUE;
        k = (int)(i >> 52) - 1023;
        n = 0;
        if (i > 4602678823467614207L) {
            n = (int)((j >> 32) + (0x100000L >> k + 1));
            k = ((n & Integer.MAX_VALUE) >>> 20) - 1023;
            t = 0.0;
            t = Double.longBitsToDouble((Double.doubleToLongBits(t) & 0xFFFFFFFFL) + ((long)(n & ~(1048575 >> k)) << 32));
            n = (n & 0xFFFFF | 0x100000) >> 20 - k;
            if (j < 0L) {
                n = -n;
            }
            p_h -= t;
        }
        t = p_l + p_h;
        t = Double.longBitsToDouble(Double.doubleToLongBits(t) & 0xFFFFFFFF00000000L);
        u = t * 0.6931471824645996;
        v = (p_l - (t - p_h)) * 0.6931471805599453 + t * -1.904654299957768E-9;
        z = u + v;
        w = v - (z - u);
        t = z * z;
        t1 = z - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
        r = z * t1 / (t1 - 2.0) - (w + z * w);
        z = 1.0 - (r - z);
        j = Double.doubleToLongBits(z) & 0xFFFFFFFF00000000L;
        z = (j += (long)n << 52) >> 52 <= 0L ? MathUtils.scalbn(z, n) : Double.longBitsToDouble(Double.doubleToLongBits(z) + ((long)n << 52));
        return s * z;
    }

    public static double asin(double a) {
        long hx = Double.doubleToLongBits(a);
        long ix = hx & Long.MAX_VALUE;
        if (Math.abs(a) >= 1.0) {
            if (Math.abs(a) == 1.0) {
                return a * 1.5707963267948966 + a * 6.123233995736766E-17;
            }
            if (Math.abs(a) > 1.0) {
                return Double.NaN;
            }
        } else if (ix < 4602678819172646912L) {
            if (ix < 4485585228861014016L) {
                return a;
            }
            double t = a * a;
            double p = t * (0.16666666666666666 + t * (-0.3255658186224009 + t * (0.20121253213486293 + t * (-0.04005553450067941 + t * (7.915349942898145E-4 + t * 3.479331075960212E-5)))));
            double q = 1.0 + t * (-2.403394911734414 + t * (2.0209457602335057 + t * (-0.6882839716054533 + t * 0.07703815055590194)));
            double w = p / q;
            return a + a * w;
        }
        double w = 1.0 - Math.abs(a);
        double t = w * 0.5;
        double p = t * (0.16666666666666666 + t * (-0.3255658186224009 + t * (0.20121253213486293 + t * (-0.04005553450067941 + t * (7.915349942898145E-4 + t * 3.479331075960212E-5)))));
        double q = 1.0 + t * (-2.403394911734414 + t * (2.0209457602335057 + t * (-0.6882839716054533 + t * 0.07703815055590194)));
        double s = Math.sqrt(t);
        if (ix >= 4606957237959655424L) {
            w = p / q;
            t = 1.5707963267948966 - (2.0 * (s + s * w) - 6.123233995736766E-17);
        } else {
            w = s;
            w = Double.longBitsToDouble(Double.doubleToLongBits(w) & 0xFFFFFFFF00000000L);
            double c = (t - w * w) / (s + w);
            double r = p / q;
            p = 2.0 * s * r - (6.123233995736766E-17 - 2.0 * c);
            q = 0.7853981633974483 - 2.0 * w;
            t = 0.7853981633974483 - (p - q);
        }
        if (hx > 0L) {
            return t;
        }
        return -t;
    }

    public static double acos(double a) {
        double s;
        long hx = Double.doubleToLongBits(a);
        long ix = hx & Long.MAX_VALUE;
        if (Math.abs(a) >= 1.0) {
            if (ix == 0x3FF0000000000000L) {
                if (hx > 0L) {
                    return 0.0;
                }
                return Math.PI;
            }
            return (a - a) / (a - a);
        }
        if (ix < 4602678819172646912L) {
            if (ix <= 4350477244334866431L) {
                return 1.5707963267948966;
            }
            double z = a * a;
            double p = z * (0.16666666666666666 + z * (-0.3255658186224009 + z * (0.20121253213486293 + z * (-0.04005553450067941 + z * (7.915349942898145E-4 + z * 3.479331075960212E-5)))));
            double q = 1.0 + z * (-2.403394911734414 + z * (2.0209457602335057 + z * (-0.6882839716054533 + z * 0.07703815055590194)));
            double r = p / q;
            return 1.5707963267948966 - (a - (6.123233995736766E-17 - a * r));
        }
        if (hx < 0L) {
            double z = (1.0 + a) * 0.5;
            double p = z * (0.16666666666666666 + z * (-0.3255658186224009 + z * (0.20121253213486293 + z * (-0.04005553450067941 + z * (7.915349942898145E-4 + z * 3.479331075960212E-5)))));
            double q = 1.0 + z * (-2.403394911734414 + z * (2.0209457602335057 + z * (-0.6882839716054533 + z * 0.07703815055590194)));
            double s2 = Math.sqrt(z);
            double r = p / q;
            double w = r * s2 - 6.123233995736766E-17;
            return Math.PI - 2.0 * (s2 + w);
        }
        double z = (1.0 - a) * 0.5;
        double df = s = Math.sqrt(z);
        df = Double.longBitsToDouble(Double.doubleToLongBits(df) & 0xFFFFFFFF00000000L);
        double c = (z - df * df) / (s + df);
        double p = z * (0.16666666666666666 + z * (-0.3255658186224009 + z * (0.20121253213486293 + z * (-0.04005553450067941 + z * (7.915349942898145E-4 + z * 3.479331075960212E-5)))));
        double q = 1.0 + z * (-2.403394911734414 + z * (2.0209457602335057 + z * (-0.6882839716054533 + z * 0.07703815055590194)));
        double r = p / q;
        double w = r * s + c;
        return 2.0 * (df + w);
    }

    public static double atan(double a) {
        int id;
        long hx = Double.doubleToLongBits(a);
        long ix = hx & Long.MAX_VALUE;
        if (ix >= 0x4410000000000000L) {
            if (ix > 0x7FF0000000000000L) {
                return a + a;
            }
            if (hx > 0L) {
                return atanhi[3] + atanlo[3];
            }
            return -atanhi[3] - atanlo[3];
        }
        if (ix < 4601552919265804288L) {
            if (ix < 4476578029606273024L) {
                return a;
            }
            id = -1;
        } else {
            a = Math.abs(a);
            if (ix < 0x3FF3000000000000L) {
                if (ix < 4604367669032910848L) {
                    id = 0;
                    a = (2.0 * a - 1.0) / (2.0 + a);
                } else {
                    id = 1;
                    a = (a - 1.0) / (a + 1.0);
                }
            } else if (ix < 4612671180845875200L) {
                id = 2;
                a = (a - 1.5) / (1.0 + 1.5 * a);
            } else {
                id = 3;
                a = -1.0 / a;
            }
        }
        double z = a * a;
        double w = z * z;
        double s1 = z * (aT[0] + w * (aT[2] + w * (aT[4] + w * (aT[6] + w * (aT[8] + w * aT[10])))));
        double s2 = w * (aT[1] + w * (aT[3] + w * (aT[5] + w * (aT[7] + w * aT[9]))));
        if (id < 0) {
            return a - a * (s1 + s2);
        }
        z = atanhi[id] - (a * (s1 + s2) - atanlo[id] - a);
        if (hx < 0L) {
            return -z;
        }
        return z;
    }

    public static double atan2(double y, double x) {
        double pi_o_4 = 0.7853981633974483;
        double pi_o_2 = 1.5707963267948966;
        double pi = Math.PI;
        double pi_lo = 1.2246467991473532E-16;
        long hx = Double.doubleToLongBits(x);
        long hy = Double.doubleToLongBits(y);
        long ix = hx & Long.MAX_VALUE;
        long iy = hy & Long.MAX_VALUE;
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return x + y;
        }
        if (hx == 0x3FF0000000000000L) {
            return MathUtils.atan(y);
        }
        int m = (int)(hy >> 63 & 1L | hx >> 62 & 2L);
        if (iy == 0L) {
            switch (m) {
                case 0: 
                case 1: {
                    return y;
                }
                case 2: {
                    return pi;
                }
                case 3: {
                    return -pi;
                }
            }
        }
        if (ix == 0L) {
            if (hy < 0L) {
                return -pi_o_2;
            }
            return pi_o_2;
        }
        if (Double.isInfinite(x)) {
            if (Double.isInfinite(y)) {
                switch (m) {
                    case 0: {
                        return pi_o_4;
                    }
                    case 1: {
                        return -pi_o_4;
                    }
                    case 2: {
                        return 3.0 * pi_o_4;
                    }
                    case 3: {
                        return -3.0 * pi_o_4;
                    }
                }
            } else {
                switch (m) {
                    case 0: {
                        return 0.0;
                    }
                    case 1: {
                        return -0.0;
                    }
                    case 2: {
                        return pi;
                    }
                    case 3: {
                        return -pi;
                    }
                }
            }
        }
        if (Double.isInfinite(y)) {
            if (hy < 0L) {
                return -pi_o_2;
            }
            return pi_o_2;
        }
        int k = (int)(iy - ix >> 52);
        double z = k > 60 ? pi_o_2 + 0.5 * pi_lo : (hx < 0L && k < -60 ? 0.0 : MathUtils.atan(Math.abs(y / x)));
        switch (m) {
            case 0: {
                return z;
            }
            case 1: {
                return -z;
            }
            case 2: {
                return pi - (z - pi_lo);
            }
        }
        return z - pi_lo - pi;
    }

    public static double rint(double a) {
        double fl = Math.floor(a);
        double ce = Math.ceil(a);
        if (fl == a || ce == a) {
            return a;
        }
        double up = ce - a;
        double down = a - fl;
        if (up > down) {
            return fl;
        }
        if (up == down) {
            if (Math.ceil(ce / 2.0) * 2.0 == ce) {
                return ce;
            }
            return fl;
        }
        return ce;
    }

    public static double log1p(double a) {
        double f = 0.0;
        double c = 0.0;
        long hu = 0L;
        long hx = Double.doubleToLongBits(a);
        long ax = hx & Long.MAX_VALUE;
        int k = 1;
        if (hx < 4601133429810003968L) {
            if (ax >= 0x3FF0000000000000L) {
                if (a == -1.0) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.NaN;
            }
            if (ax < 4476578029606273024L) {
                if (ax < 4363988038922010624L) {
                    return a;
                }
                return a - a * a * 0.5;
            }
            if (hx > 0L || hx <= -4624424118333210625L) {
                k = 0;
                f = a;
                hu = 1L;
            }
        }
        if (hx >= 0x7FF0000000000000L) {
            return a + a;
        }
        if (k != 0) {
            double u;
            if (hx < 0x4340000000000000L) {
                u = 1.0 + a;
                hu = Double.doubleToLongBits(u);
                k = (int)(hu >>> 52) - 1023;
                c = k > 0 ? 1.0 - (u - a) : a - (u - 1.0);
                c /= u;
            } else {
                u = a;
                hu = Double.doubleToLongBits(u);
                k = (int)(hu >>> 52) - 1023;
                c = 0.0;
            }
            if ((hu &= 0xFFFFFFFFFFFFFL) < 1865450325540864L) {
                u = Double.longBitsToDouble(hu | 0x3FF0000000000000L);
            } else {
                ++k;
                u = Double.longBitsToDouble(hu | 0x3FE0000000000000L);
                hu = 0x10000000000000L - hu >>> 2;
            }
            f = u - 1.0;
        }
        double hfsq = 0.5 * f * f;
        if (hu == 0L) {
            if (f == 0.0) {
                if (k == 0) {
                    return 0.0;
                }
                return (double)k * 0.6931471803691238 + (c += (double)k * 1.9082149292705877E-10);
            }
            double R = hfsq * (1.0 - 0.6666666666666666 * f);
            if (k == 0) {
                return f - R;
            }
            return (double)k * 0.6931471803691238 - (R - ((double)k * 1.9082149292705877E-10 + c) - f);
        }
        double s = f / (2.0 + f);
        double z = s * s;
        double R = z * (0.6666666666666735 + z * (0.3999999999940942 + z * (0.2857142874366239 + z * (0.22222198432149784 + z * (0.1818357216161805 + z * (0.15313837699209373 + z * 0.14798198605116586))))));
        if (k == 0) {
            return f - (hfsq - s * (hfsq + R));
        }
        return (double)k * 0.6931471803691238 - (hfsq - (s * (hfsq + R) + ((double)k * 1.9082149292705877E-10 + c)) - f);
    }

    public static double expm1(double a) {
        double t;
        int k;
        double c = 0.0;
        long hx = Double.doubleToLongBits(a);
        int xsb = (int)(hx >>> 63);
        double y = Math.abs(a);
        if ((hx &= Long.MAX_VALUE) >= 4630659715062300672L) {
            if (hx >= 4649454526309335040L) {
                if (hx >= 0x7FF0000000000000L) {
                    if ((hx & 0xFFFFFFFFFFFFFL) == 0L) {
                        return a + a;
                    }
                    if (xsb == 0) {
                        return a;
                    }
                    return -1.0;
                }
                if (a > 709.782712893384) {
                    return Double.POSITIVE_INFINITY;
                }
            }
            if (xsb != 0) {
                return -1.0;
            }
        }
        if (hx > 4599914934703226879L) {
            double lo;
            double hi;
            if (hx < 4607361304187895808L) {
                if (xsb == 0) {
                    hi = a - 0.6931471803691238;
                    lo = 1.9082149292705877E-10;
                    k = 1;
                } else {
                    hi = a + 0.6931471803691238;
                    lo = -1.9082149292705877E-10;
                    k = -1;
                }
            } else {
                k = (int)(1.4426950408889634 * a + halF[xsb]);
                t = k;
                hi = a - t * 0.6931471803691238;
                lo = t * 1.9082149292705877E-10;
            }
            a = hi - lo;
            c = hi - a - lo;
        } else {
            if (hx < 4363988038922010624L) {
                return a;
            }
            k = 0;
        }
        double hfx = 0.5 * a;
        double hxs = a * hfx;
        double r1 = 1.0 + hxs * (-0.03333333333333313 + hxs * (0.0015873015872548146 + hxs * (-7.93650757867488E-5 + hxs * (4.008217827329362E-6 + hxs * -2.0109921818362437E-7))));
        t = 3.0 - r1 * hfx;
        double e = hxs * ((r1 - t) / (6.0 - a * t));
        if (k == 0) {
            return a - (a * e - hxs);
        }
        e = a * (e - c) - c;
        e -= hxs;
        if (k == -1) {
            return 0.5 * (a - e) - 0.5;
        }
        if (k == 1) {
            if (a < -0.25) {
                return -2.0 * (e - (a + 0.5));
            }
            return 1.0 + 2.0 * (a - e);
        }
        if (k <= -2 || k > 56) {
            y = 1.0 - (e - a);
            y = Double.longBitsToDouble(Double.doubleToLongBits(y) + ((long)k << 52));
            return y - 1.0;
        }
        t = 1.0;
        if (k < 20) {
            t = Double.longBitsToDouble((Double.doubleToLongBits(t) & 0xFFFFFFFFL) + 0x3FF0000000000000L - (0x20000000000000L >>> k));
            y = t - (e - a);
            y = Double.longBitsToDouble(Double.doubleToLongBits(y) + ((long)k << 52));
        } else {
            t = Double.longBitsToDouble((Double.doubleToLongBits(t) & 0xFFFFFFFFL) + ((long)(1023 - k) << 52));
            y = a - (e + t);
            y += 1.0;
            y = Double.longBitsToDouble(Double.doubleToLongBits(y) + ((long)k << 52));
        }
        return y;
    }

    public static double IEEEremainder(double x, double p) {
        long lx = Double.doubleToLongBits(x) & Long.MAX_VALUE;
        long lp = Double.doubleToLongBits(p) & Long.MAX_VALUE;
        long sx = Double.doubleToLongBits(x) & Long.MIN_VALUE;
        if (p == 0.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(p)) {
            return Double.NaN;
        }
        if (lp < 9214364833305067520L) {
            x %= p + p;
        }
        if (lx - lp == 0L) {
            return 0.0 * x;
        }
        x = Math.abs(x);
        p = Math.abs(p);
        if (lp < 0x20000000000000L) {
            if (x + x > p && (x -= p) + x >= p) {
                x -= p;
            }
        } else {
            double p_half = 0.5 * p;
            if (x > p_half && (x -= p) >= p_half) {
                x -= p;
            }
        }
        if (sx == 0L) {
            return x;
        }
        return -x;
    }
}

