/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.sun.squawk.util.DataOutputUTF8Encoder;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class DataOutputStream
extends OutputStream
implements DataOutput {
    protected OutputStream out;
    final DataOutput dout;

    public DataOutputStream(OutputStream out) {
        this.out = out;
        this.dout = out instanceof DataOutput ? (DataOutput)((Object)out) : null;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    public final void writeShort(int v) throws IOException {
        if (this.dout != null) {
            this.dout.writeShort(v);
            return;
        }
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeChar(int v) throws IOException {
        if (this.dout != null) {
            this.dout.writeChar(v);
            return;
        }
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeInt(int v) throws IOException {
        if (this.dout != null) {
            this.dout.writeInt(v);
            return;
        }
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeLong(long v) throws IOException {
        if (this.dout != null) {
            this.dout.writeLong(v);
            return;
        }
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public final void writeUTF(String str) throws IOException {
        DataOutputStream.writeUTF(str, this);
    }

    static int writeUTF(String str, DataOutput out) throws IOException {
        return DataOutputUTF8Encoder.writeUTF(str, out, true);
    }
}

