/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.sun.cldc.i18n.Helper;
import com.sun.squawk.GC;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import com.sun.squawk.pragma.ReplacementConstructorPragma;
import java.io.UnsupportedEncodingException;

public final class String {
    private static void stringcopy(Object src, int src_position, Object dst, int dst_position, int totalLength) {
        int MAXMOVE = 8192;
        while (true) {
            int length = totalLength < 8192 ? totalLength : 8192;
            GC.stringcopy(src, src_position, dst, dst_position, length);
            if ((totalLength -= length) == 0) break;
            src_position += length;
            dst_position += length;
            VMThread.yield();
        }
    }

    private static String init(Object src, int offset, int count, boolean isEightBit) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (src == null) {
            throw new NullPointerException();
        }
        if (offset > GC.getArrayLength(src) - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        if (isEightBit) {
            byte[] buf = new byte[count];
            String.stringcopy(src, offset, buf, 0, count);
            return GC.makeEightBitString(buf);
        }
        char[] buf = new char[count];
        String.stringcopy(src, offset, buf, 0, count);
        return GC.makeSixteenBitString(buf);
    }

    private static String init(char[] src, int offset, int count) {
        return String.init(src, offset, count, String.isEightBitEnc(src, offset, count));
    }

    public String() {
        VM.fatalVMError();
    }

    static String _init(String self) throws ReplacementConstructorPragma {
        return String.init(new char[0], 0, 0, true);
    }

    public String(String value) {
        VM.fatalVMError();
    }

    static String _init_(String self, String value) throws ReplacementConstructorPragma {
        return String.init(value, 0, value.length(), value.isEightBit());
    }

    public String(char[] value) {
        VM.fatalVMError();
    }

    static String _init_(String self, char[] value) throws ReplacementConstructorPragma {
        return String.init(value, 0, value.length);
    }

    public String(char[] value, int offset, int count) {
        VM.fatalVMError();
    }

    static String _init_(String self, char[] value, int offset, int count) throws ReplacementConstructorPragma {
        return String.init(value, offset, count);
    }

    private String(String str, int offset, int count) {
        VM.fatalVMError();
    }

    static String _init_(String self, String str, int offset, int count) throws ReplacementConstructorPragma {
        return String.init(str, offset, count, str.isEightBit());
    }

    public String(byte[] bytes, int off, int len, String enc) throws UnsupportedEncodingException {
        VM.fatalVMError();
    }

    static String _init_(String self, byte[] bytes, int off, int len, String enc) throws UnsupportedEncodingException, ReplacementConstructorPragma {
        return String.initEncoded(bytes, off, len, enc);
    }

    private static String initEncoded(byte[] bytes, int off, int len, String enc) throws UnsupportedEncodingException {
        if (Helper.isISO8859_1(enc)) {
            return String.init(bytes, off, len, true);
        }
        throw new UnsupportedEncodingException(enc);
    }

    public String(byte[] bytes, String enc) throws UnsupportedEncodingException {
        VM.fatalVMError();
    }

    static String _init_(String self, byte[] bytes, String enc) throws UnsupportedEncodingException, ReplacementConstructorPragma {
        return String.initEncoded(bytes, 0, bytes.length, enc);
    }

    public String(byte[] bytes, int off, int len) {
        VM.fatalVMError();
    }

    static String _init_(String self, byte[] bytes, int off, int len) throws ReplacementConstructorPragma {
        return String.init(bytes, off, len, true);
    }

    public String(byte[] bytes) {
        VM.fatalVMError();
    }

    static String _init_(String self, byte[] bytes) throws ReplacementConstructorPragma {
        return String.init(bytes, 0, bytes.length, true);
    }

    public String(StringBuffer buffer) {
        VM.fatalVMError();
    }

    static String _init_(String self, StringBuffer buffer) throws ReplacementConstructorPragma {
        return String.init(buffer.getValue(), 0, buffer.length(), buffer.isEightBit());
    }

    public int length() {
        return GC.getArrayLength(this);
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return NativeUnsafe.charAt(this, index);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        int count = srcEnd - srcBegin;
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.length()) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(count);
        }
        int dstEnd = dstBegin + count;
        if (dstBegin < 0 || dstEnd < 0 || dstEnd > dst.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String.stringcopy(this, srcBegin, dst, dstBegin, count);
    }

    public byte[] getBytes(String enc) throws UnsupportedEncodingException {
        return Helper.charToByteArray(this.toCharArray(), 0, this.length(), enc);
    }

    public byte[] getBytes() {
        return Helper.charToByteArray(this.toCharArray(), 0, this.length());
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof String) {
            String anotherString = (String)anObject;
            int lth = this.length();
            if (lth == anotherString.length()) {
                if (this.isEightBit() && anotherString.isEightBit()) {
                    for (int i = 0; i < lth; ++i) {
                        if (NativeUnsafe.getByte(this, i) == NativeUnsafe.getByte(anotherString, i)) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < lth; ++i) {
                        if (NativeUnsafe.charAt(this, i) == NativeUnsafe.charAt(anotherString, i)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean equalsIgnoreCase(String anotherString) {
        int len = this.length();
        return anotherString != null && anotherString.length() == len && this.regionMatches(true, 0, anotherString, 0, len);
    }

    public int compareTo(String anotherString) {
        int len2;
        int len1 = this.length();
        int lth = len1 < (len2 = anotherString.length()) ? len1 : len2;
        for (int i = 0; i < lth; ++i) {
            char c2;
            char c1 = NativeUnsafe.charAt(this, i);
            if (c1 == (c2 = NativeUnsafe.charAt(anotherString, i))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        int to = toffset;
        int po = ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.length() - (long)len || (long)ooffset > (long)other.length() - (long)len) {
            return false;
        }
        while (len-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = NativeUnsafe.charAt(this, to++)) == (c2 = NativeUnsafe.charAt(other, po++)) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix, int toffset) {
        int to = toffset;
        int plth = prefix.length();
        if (toffset < 0 || toffset > this.length() - plth) {
            return false;
        }
        for (int i = 0; i < plth; ++i) {
            if (NativeUnsafe.charAt(this, to + i) == NativeUnsafe.charAt(prefix, i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public int hashCode() {
        int h = 0;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            h = 31 * h + NativeUnsafe.charAt(this, i);
        }
        return h;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        for (int i = fromIndex; i < max; ++i) {
            if (NativeUnsafe.charAt(this, i) != ch) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length() - 1);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        int i;
        int len = this.length();
        int n = i = fromIndex >= len ? len - 1 : fromIndex;
        while (i >= 0) {
            if (NativeUnsafe.charAt(this, i) == ch) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        int this_length = this.length();
        int str_length = str.length();
        int max = this_length - str_length;
        if (fromIndex >= this_length) {
            if (this_length == 0 && fromIndex == 0 && str_length == 0) {
                return 0;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (str_length == 0) {
            return fromIndex;
        }
        char first = NativeUnsafe.charAt(str, 0);
        int i = fromIndex;
        block0: while (true) {
            if (i <= max && NativeUnsafe.charAt(this, i) != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + str_length - 1;
            int k = 1;
            while (j < end) {
                if (NativeUnsafe.charAt(this, j++) == NativeUnsafe.charAt(str, k++)) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public String substring(int beginIndex) {
        return this.substring(beginIndex, this.length());
    }

    public String substring(int beginIndex, int endIndex) {
        int len = this.length();
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > len) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        if (beginIndex == 0 && endIndex == len) {
            return this;
        }
        return new String(this, beginIndex, endIndex - beginIndex);
    }

    public String concat(String str) {
        int otherLen = str.length();
        if (otherLen == 0) {
            return this;
        }
        int thisLen = this.length();
        char[] buf = new char[thisLen + otherLen];
        this.getChars(0, thisLen, buf, 0);
        str.getChars(0, otherLen, buf, thisLen);
        return new String(buf, 0, thisLen + otherLen);
    }

    public String replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            int len = this.length();
            int i = -1;
            while (++i < len && NativeUnsafe.charAt(this, i) != oldChar) {
            }
            if (i < len) {
                char[] buf = new char[len];
                for (int j = 0; j < i; ++j) {
                    buf[j] = NativeUnsafe.charAt(this, j);
                }
                while (i < len) {
                    char c = NativeUnsafe.charAt(this, i);
                    buf[i] = c == oldChar ? newChar : c;
                    ++i;
                }
                return new String(buf, 0, len);
            }
        }
        return this;
    }

    public String toLowerCase() {
        int len = this.length();
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = Character.toLowerCase(NativeUnsafe.charAt(this, i));
        }
        return new String(buf, 0, len);
    }

    public String toUpperCase() {
        int len = this.length();
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = Character.toUpperCase(NativeUnsafe.charAt(this, i));
        }
        return new String(buf, 0, len);
    }

    public String trim() {
        int st;
        int len = this.length();
        for (st = 0; st < len && NativeUnsafe.charAt(this, st) <= ' '; ++st) {
        }
        while (st < len && NativeUnsafe.charAt(this, len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < this.length() ? this.substring(st, len) : this;
    }

    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        int len = this.length();
        char[] result = new char[len];
        this.getChars(0, len, result, 0);
        return result;
    }

    public static String valueOf(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static String valueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] data = new char[]{c};
        return new String(data, 0, 1);
    }

    public static String valueOf(int i) {
        return Integer.toString(i, 10);
    }

    public static String valueOf(long l) {
        return Long.toString(l, 10);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    final boolean isEightBit() {
        return GC.getKlass(this) == Klass.STRING_OF_BYTES;
    }

    static boolean isEightBitEnc(char[] chars, int offset, int count) {
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            if (chars[i] <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public String intern() {
        return Isolate.intern(this);
    }
}

