/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class StringBuffer {
    private char[] value;
    private int count;
    private byte encoding;
    private static final int IS_EIGHT_BIT = 0;
    private static final int IS_NOT_EIGHT_BIT = 1;
    private static final int UNKNOWN_ENCODING = 2;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int length) {
        this.value = new char[length];
    }

    public StringBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public synchronized void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        if (this.count < newLength) {
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = newLength;
        }
    }

    public synchronized char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public synchronized void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public synchronized void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (ch > '\u00ff') {
            this.encoding = (byte)(this.encoding | 1);
        }
        this.value[index] = ch;
    }

    public StringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public synchronized StringBuffer append(String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newcount;
        if (!str.isEightBit()) {
            this.encoding = (byte)(this.encoding | 1);
        }
        return this;
    }

    public synchronized StringBuffer append(char[] str) {
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count = newcount;
        if (this.encoding == 0 && !String.isEightBitEnc(str, 0, len)) {
            this.encoding = 1;
        }
        return this;
    }

    public synchronized StringBuffer append(char[] str, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newcount;
        if (this.encoding == 0 && !String.isEightBitEnc(str, 0, len)) {
            this.encoding = 1;
        }
        return this;
    }

    public StringBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public synchronized StringBuffer append(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
        if (c > '\u00ff') {
            this.encoding = (byte)(this.encoding | 1);
        }
        return this;
    }

    public StringBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public StringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public StringBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public StringBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public synchronized StringBuffer delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        if (this.encoding != 0) {
            this.encoding = (byte)2;
        }
        return this;
    }

    public synchronized StringBuffer deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        if (this.encoding != 0) {
            this.encoding = (byte)2;
        }
        return this;
    }

    public StringBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public synchronized StringBuffer insert(int offset, String str) {
        int len;
        int newcount;
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newcount;
        if (!str.isEightBit()) {
            this.encoding = (byte)(this.encoding | 1);
        }
        return this;
    }

    public synchronized StringBuffer insert(int offset, char[] str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        if (this.encoding == 0 && !String.isEightBitEnc(str, 0, len)) {
            this.encoding = 1;
        }
        this.count = newcount;
        return this;
    }

    public StringBuffer insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public synchronized StringBuffer insert(int offset, char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newcount;
        if (c > '\u00ff') {
            this.encoding = (byte)(this.encoding | 1);
        }
        return this;
    }

    public StringBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public StringBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public synchronized StringBuffer reverse() {
        int n = this.count - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
        }
        return this;
    }

    public String toString() {
        return new String(this);
    }

    final boolean isEightBit() {
        if (this.encoding == 0) {
            return true;
        }
        if (this.encoding == 1) {
            return false;
        }
        if (String.isEightBitEnc(this.value, 0, this.count)) {
            this.encoding = 0;
            return true;
        }
        this.encoding = 1;
        return false;
    }

    final char[] getValue() {
        return this.value;
    }
}

