/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.sun.squawk.GC;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.VM;
import com.sun.squawk.io.MulticastOutputStream;
import java.io.PrintStream;

public final class System {
    public static final PrintStream out = System.getOutput(false);
    public static final PrintStream err = System.getOutput(true);

    private System() {
    }

    private static PrintStream getOutput(boolean err) {
        MulticastOutputStream os;
        String url = System.getProperty(err ? "java.lang.System.err" : "java.lang.System.out");
        if (url == null) {
            url = err ? "debug:err" : "debug:";
        }
        Isolate isolate = VM.getCurrentIsolate();
        if (err) {
            isolate.addErr(url);
            os = isolate.stderr;
        } else {
            isolate.addOut(url);
            os = isolate.stdout;
        }
        return new PrintStream(os);
    }

    public static long currentTimeMillis() {
        return VM.getTimeMillis();
    }

    public static void arraycopy(Object src, int srcPos, Object dst, int dstPos, int length) {
        boolean primitive;
        if (src == null || dst == null) {
            throw new NullPointerException();
        }
        Klass srcClass = GC.getKlass(src);
        Klass dstClass = GC.getKlass(dst);
        if (!srcClass.isArray() || !dstClass.isArray()) {
            throw new ArrayStoreException();
        }
        Klass srcComponentType = srcClass.getComponentType();
        Klass dstComponentType = dstClass.getComponentType();
        boolean bl = primitive = srcComponentType.isPrimitive() || dstComponentType.isPrimitive() || srcComponentType.isSquawkPrimitive() || dstComponentType.isSquawkPrimitive();
        if (primitive && srcComponentType != dstComponentType) {
            throw new ArrayStoreException(srcComponentType.getName() + " != " + dstComponentType.getName());
        }
        int srcEnd = length + srcPos;
        int dstEnd = length + dstPos;
        if (length < 0 || srcPos < 0 || dstPos < 0 || length > 0 && (srcEnd < 0 || dstEnd < 0) || srcEnd > GC.getArrayLength(src) || dstEnd > GC.getArrayLength(dst)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (length > 0) {
            if (!primitive) {
                if (!dstComponentType.isAssignableFrom(srcComponentType)) {
                    Object[] srcArray = (Object[])src;
                    Object[] dstArray = (Object[])dst;
                    for (int i = 0; i < length; ++i) {
                        Object item = srcArray[srcPos + i];
                        if (item != null && !dstComponentType.isAssignableFrom(GC.getKlass(item))) {
                            throw new ArrayStoreException();
                        }
                        dstArray[dstPos + i] = item;
                    }
                } else {
                    VM.arraycopyObject0(src, srcPos, dst, dstPos, length);
                }
            } else {
                VM.arraycopyPrimitive0(src, srcPos, dst, dstPos, length, srcComponentType.getDataSize());
            }
        }
    }

    public static int identityHashCode(Object x) {
        return x == null ? 0 : GC.getHashCode(x);
    }

    public static String getProperty(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.equals("")) {
            throw new IllegalArgumentException();
        }
        if (key.equals("microedition.configuration")) {
            return "CLDC-1.1";
        }
        if (key.equals("microedition.encoding")) {
            return "ISO8859_1";
        }
        if (key.equals("microedition.locale")) {
            return "en-US";
        }
        if (key.equals("microedition.platform")) {
            return "j2me";
        }
        if (key.equals("microedition.profiles")) {
            return "IMP-1.0";
        }
        if (key.equals("awtcore.classbase")) {
            return "awtcore.impl.squawk";
        }
        if (key.equals("javax.microedition.io.Connector.protocolpath")) {
            return "com.sun.squawk.io";
        }
        if (key.equals("file.separator")) {
            return "" + VM.getFileSeparatorChar();
        }
        if (key.equals("path.separator")) {
            return "" + VM.getPathSeparatorChar();
        }
        if (VM.getCurrentIsolate() == null) {
            return null;
        }
        String value = VM.getCurrentIsolate().getProperty(key);
        return value;
    }

    public static void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }
}

