/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import com.sun.squawk.io.ConnectionBase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static String host;
    private static String classRoot;
    private static final String NO_CLASS_FOUND = "NO PROTOCOL CLASS";
    private static final Hashtable protocolTable;

    private Connector() {
    }

    public static Connection open(String name) throws IOException {
        return Connector.open(name, 3);
    }

    public static Connection open(String name, int mode) throws IOException {
        return Connector.open(name, mode, false);
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Null URI");
        }
        int colon = name.indexOf(58);
        if (colon < 1) {
            throw new IllegalArgumentException("no ':' in URI");
        }
        String protocol = name.substring(0, colon);
        Connection result = Connector.openPrim(protocol, protocol, name = name.substring(colon + 1), mode, timeouts, host, classRoot);
        if (result == null) {
            result = host.equals("j2me") ? Connector.openPrim(protocol, protocol, name, mode, timeouts, "j2me", "com.sun.midp.io") : Connector.openPrim(protocol, protocol, name, mode, timeouts, "j2me", classRoot);
            if (result == null) {
                // empty if block
            }
            if (result == null) {
                throw new ConnectionNotFoundException("The '" + protocol + "' protocol does not exist");
            }
        }
        return result;
    }

    private static Connection openPrim(String protocolClassName, String protocolName, String name, int mode, boolean timeouts, String platform, String packageRoot) throws IOException {
        try {
            String fullclassname = packageRoot + "." + platform + "." + protocolClassName + ".Protocol";
            Class clazz = null;
            if (protocolTable == null) {
                try {
                    clazz = Class.forName(fullclassname);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            } else {
                Object classOrNot = protocolTable.get(fullclassname);
                if (classOrNot == null) {
                    try {
                        clazz = Class.forName(fullclassname);
                        protocolTable.put(fullclassname, clazz);
                    }
                    catch (ClassNotFoundException e) {
                        protocolTable.put(fullclassname, NO_CLASS_FOUND);
                        return null;
                    }
                } else {
                    if (classOrNot == NO_CLASS_FOUND) {
                        return null;
                    }
                    clazz = (Class)classOrNot;
                }
            }
            ConnectionBase con = (ConnectionBase)clazz.newInstance();
            return con.open(protocolName, name, mode, timeouts);
        }
        catch (InstantiationException x) {
            throw new IOException(x.toString());
        }
        catch (IllegalAccessException x) {
            throw new IOException(x.toString());
        }
        catch (ClassCastException x) {
            throw new IOException(x.toString());
        }
    }

    public static InputStream openInputStream(String name) throws IOException {
        return Connector.openDataInputStream(name);
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        return Connector.openDataOutputStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataInputStream openDataInputStream(String name) throws IOException {
        InputConnection con = null;
        try {
            con = (InputConnection)Connector.open(name, 1);
        }
        catch (ClassCastException e) {
            throw new IOException(e.toString());
        }
        try {
            DataInputStream dataInputStream = con.openDataInputStream();
            return dataInputStream;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        OutputConnection con = null;
        try {
            con = (OutputConnection)Connector.open(name, 2);
        }
        catch (ClassCastException e) {
            throw new IOException(e.toString());
        }
        try {
            DataOutputStream dataOutputStream = con.openDataOutputStream();
            return dataOutputStream;
        }
        finally {
            con.close();
        }
    }

    static {
        String propertyClassRoot;
        host = "j2me";
        classRoot = "com.sun.squawk.io";
        if (System.getProperty("microedition.configuration") == null) {
            host = "j2se";
        }
        if ((propertyClassRoot = System.getProperty("javax.microedition.io.Connector.protocolpath")) != null) {
            classRoot = propertyClassRoot;
        }
        protocolTable = new Hashtable();
    }
}

