/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.Packet;
import com.sun.squawk.debugger.ReplyPacket;
import com.sun.squawk.util.Arrays;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public final class JDWPConnection {
    private final StreamConnection conn;
    private final String url;
    private final DataOutputStream out;
    private final DataInputStream in;
    private StreamConnectionNotifier server;
    private final boolean isJDB;
    private String closedBy;

    public JDWPConnection(String url, byte[] handshake, boolean initiate, boolean isJDB, Runnable delayer) throws IOException {
        this.url = url;
        this.isJDB = isJDB;
        if (Log.info()) {
            Log.log("Establishing connection with " + url + "...");
        }
        try {
            Connection c = Connector.open((String)url);
            if (c instanceof StreamConnectionNotifier) {
                this.server = (StreamConnectionNotifier)c;
                try {
                    this.conn = this.server.acceptAndOpen();
                }
                catch (InterruptedIOException e) {
                    this.server.close();
                    throw e;
                }
            } else {
                this.conn = (StreamConnection)c;
            }
            this.in = this.conn.openDataInputStream();
            this.out = this.conn.openDataOutputStream();
            if (Log.info()) {
                Log.log("Connection with " + url + " established");
            }
        }
        catch (IOException e) {
            if (Log.info()) {
                Log.log("Failed to establish connection with " + url + ": " + e);
            }
            this.close();
            throw e;
        }
        if (delayer != null) {
            delayer.run();
        }
        byte[] buf = new byte[handshake.length];
        try {
            if (initiate) {
                this.out.write(handshake);
                this.out.flush();
                this.in.readFully(buf);
            } else {
                this.in.readFully(buf);
                this.out.write(handshake);
                this.out.flush();
            }
        }
        catch (IOException e) {
            if (Log.info()) {
                Log.log("Failed to deliver/receive handshake: " + e);
            }
            this.close();
            throw e;
        }
        if (!Arrays.equals((byte[])handshake, (byte[])buf)) {
            throw new IOException("handshake failed: " + new String(buf));
        }
    }

    public synchronized void close() {
        if (this.closedBy == null) {
            this.closedBy = Thread.currentThread().toString();
            if (Log.info()) {
                Log.log("Closing connection: " + this.url);
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
                if (this.in != null) {
                    this.in.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException e) {
                if (Log.info()) {
                    Log.log("IO error while closing connection: " + this.url);
                }
                e.printStackTrace();
            }
        }
    }

    private void checkOpen() throws ClosedException {
        if (this.closedBy != null) {
            throw new ClosedException(this.closedBy);
        }
    }

    Packet readPacket() throws IOException {
        DataInputStream dataInputStream = this.in;
        synchronized (dataInputStream) {
            try {
                Packet packet;
                int length = this.in.readInt();
                int id = this.in.readInt();
                byte flags = this.in.readByte();
                if (Log.verbose()) {
                    Log.log("readPacket: length: " + length + " id: " + id + " flags: " + flags);
                }
                int dataLength = length - 11;
                if ((flags & 0x80) == 0) {
                    byte set = (byte)this.in.readUnsignedByte();
                    byte command = (byte)this.in.readUnsignedByte();
                    try {
                        packet = new CommandPacket(id, dataLength, this.in, set, command, this.isJDB || (flags & 0x40) != 0);
                    }
                    catch (OutOfMemoryError e) {
                        throw new IOException("could not allocate memory to receive packet with length " + dataLength);
                    }
                } else {
                    short errorCode = this.in.readShort();
                    packet = new ReplyPacket(id, dataLength, this.in, errorCode);
                }
                if (Log.debug()) {
                    Log.log("");
                }
                return packet;
            }
            catch (IOException e) {
                this.checkOpen();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePacket(Packet packet) throws IOException {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.checkOpen();
            if (Log.debug()) {
                Log.log("");
            }
            packet.write(this.out);
            this.out.flush();
        }
    }

    public static class ClosedException
    extends IOException {
        ClosedException(String closedBy) {
            super("Closed by " + closedBy);
        }
    }
}

