/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.VM;
import java.io.IOException;
import java.io.PrintStream;
import javax.microedition.io.Connector;

public class Log {
    public static final int NONE = 0;
    public static final int INFO = 1;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int level = Log.configLevel();
    public static final PrintStream out = Log.configOut(level);

    private static int configLevel() {
        int newlevel = 0;
        String prop = System.getProperty("squawk.debugger.log.level");
        if (prop != null) {
            if (prop.equals("none")) {
                newlevel = 0;
            } else if (prop.equals("info")) {
                newlevel = 1;
            } else if (prop.equals("verbose")) {
                newlevel = 2;
            } else if (prop.equals("debug")) {
                newlevel = VM.isHosted() ? 3 : 3;
            } else {
                System.err.println("logging disabled - invalid log level in squawk.debugger.log.level system property: " + prop);
            }
        }
        return newlevel;
    }

    private static PrintStream configOut(int level) {
        PrintStream newout = System.out;
        if (level != 0) {
            System.err.println("logging level: " + Log.level);
            String prop = System.getProperty("squawk.debugger.log.url");
            if (prop != null) {
                try {
                    newout = new PrintStream(Connector.openOutputStream((String)prop));
                    System.err.println("logging to " + prop);
                }
                catch (IOException e) {
                    System.err.println("logging to System.out - exception while opening log stream: " + prop);
                    e.printStackTrace();
                }
            } else {
                System.err.println("logging to System.out");
            }
        }
        return newout;
    }

    public static boolean info() {
        return level >= 1;
    }

    public static boolean verbose() {
        return level >= 2;
    }

    public static boolean debug() {
        return VM.isHosted() && level >= 3;
    }

    public static void log(String msg) {
        if (out != null) {
            msg = "[Thread " + Thread.currentThread().getName() + "] " + msg;
            out.println(msg);
            out.flush();
        }
    }

    private Log() {
    }
}

