/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.VM;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.debugger.PacketOutputStream;
import com.sun.squawk.util.ByteArrayOutputStreamWithGetBytes;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Packet {
    public static final short FLAG_REPLY = 128;
    public static final short FLAG_NEEDS_REPLY = 64;
    private static int nextPacketID = VM.isHosted() ? Integer.MIN_VALUE : -2147483647;
    private final int id;
    private final byte[] data;
    private final ByteArrayOutputStreamWithGetBytes dataBuffer;
    private boolean createdInputStream;
    private boolean createdOutputStream;

    public Packet(int id) {
        this.id = id;
        this.dataBuffer = new ByteArrayOutputStreamWithGetBytes();
        this.data = null;
    }

    public Packet(int id, int dataLength, DataInputStream data) throws IOException {
        this.id = id;
        this.dataBuffer = null;
        this.data = new byte[dataLength];
        data.readFully(this.data);
    }

    public PacketInputStream getInputStream() {
        ByteArrayInputStream bais = this.data != null ? new ByteArrayInputStream(this.data) : new ByteArrayInputStream(this.dataBuffer.getBytes(), 0, this.dataBuffer.size());
        this.createdInputStream = true;
        return new PacketInputStream(new DataInputStream(bais));
    }

    public PacketOutputStream getOutputStream() {
        this.createdOutputStream = true;
        return new PacketOutputStream(new DataOutputStream((OutputStream)this.dataBuffer));
    }

    public final int getID() {
        return this.id;
    }

    static synchronized int allocateUniqueID() {
        return nextPacketID += 2;
    }

    public abstract String toString();

    protected void appendData(StringBuffer buf) {
    }

    public abstract int getFlags();

    protected abstract void writeFields(DataOutputStream var1) throws IOException;

    public final int getSize() {
        return 11 + (this.dataBuffer != null ? this.dataBuffer.size() : this.data.length);
    }

    public final void write(DataOutputStream dos) throws IOException {
        byte[] data;
        int dataLength;
        if (this.dataBuffer != null) {
            this.dataBuffer.close();
            dataLength = this.dataBuffer.size();
            data = this.dataBuffer.getBytes();
        } else {
            dataLength = this.data.length;
            data = this.data;
        }
        int length = dataLength + 11;
        int flags = this.getFlags();
        dos.writeInt(length);
        dos.writeInt(this.id);
        dos.write(flags);
        if (Log.verbose()) {
            Log.log("Packet.write: length: " + length + " id: " + this.id + " flags: " + flags);
        }
        this.writeFields(dos);
        dos.write(data, 0, dataLength);
        dos.flush();
    }
}

