/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.DataOutputUTF8Encoder;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class PacketOutputStream {
    private final DataOutputStream dos;

    public PacketOutputStream(DataOutputStream dis) {
        this.dos = dis;
    }

    public void writeByte(int value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[byte]     " + s + "=" + value);
        }
        this.dos.writeByte(value);
    }

    public void writeBoolean(boolean value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[boolean]  " + s + "=" + value);
        }
        this.dos.writeBoolean(value);
    }

    public void writeChar(char value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[string]   " + s + "=" + value);
        }
        this.dos.writeChar(value);
    }

    public void writeShort(short value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[short]    " + s + "=" + value);
        }
        this.dos.writeShort(value);
    }

    public void writeInt(int value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[int]      " + s + "=" + value);
        }
        this.dos.writeInt(value);
    }

    public void writeLong(long value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[long]     " + s + "=" + value);
        }
        this.dos.writeLong(value);
    }

    public void writeFloat(float value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[float]    " + s + "=" + (int)value);
        }
        this.dos.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[double]   " + s + "=" + (long)value);
        }
        this.dos.writeLong(Double.doubleToLongBits(value));
    }

    public void writeString(String value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[string]   " + s + "=" + value);
        }
        DataOutputUTF8Encoder.writeUTF((String)value, (DataOutput)this.dos, (boolean)false);
    }

    public void writeObjectID(DataType.ObjectID value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[object]   " + s + "=" + value);
        }
        this.dos.writeInt(value.id);
    }

    public void writeReferenceTypeID(DataType.ReferenceTypeID value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[type]     " + s + "=" + value);
        }
        this.dos.writeInt(value.id);
    }

    public void writeTaggedObjectID(DataType.TaggedObjectID value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[t-object] " + s + "=" + value);
        }
        this.dos.writeByte(value.tag);
        this.dos.writeInt(value.id);
    }

    public void writeMethodID(DataType.MethodID value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[method]   " + s + "=" + value);
        }
        this.dos.writeInt(value.id);
    }

    public void writeFieldID(DataType.FieldID value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[field]    " + s + "=" + value);
        }
        this.writeReferenceTypeID(value.definingClass, "defining class");
        this.dos.writeInt(value.encoding);
    }

    public void writeFrameID(DataType.FrameID value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[frame]    " + s + "=" + value);
        }
        this.writeObjectID(value.threadID, null);
        this.dos.writeInt(value.frame);
    }

    public void writeLocation(DataType.Location value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[location] " + s + "=" + value);
        }
        this.dos.writeByte(value.tag);
        this.writeReferenceTypeID(value.definingClass, null);
        this.writeMethodID(value.method, null);
        this.dos.writeLong(value.offset);
    }

    public void writeNullLocation(String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[location]  " + s + "=null");
        }
        this.dos.writeByte(1);
        this.writeReferenceTypeID(DataType.ReferenceTypeID.NULL, null);
        this.dos.writeInt(0);
        this.dos.writeLong(0L);
    }

    public void writePrimitive(byte tag, long value, String s) throws IOException {
        if (s != null && Log.verbose()) {
            Log.log("out[t-prim]:  " + s + "=" + value);
        }
        this.dos.writeByte(tag);
        switch (tag) {
            case 86: {
                break;
            }
            case 66: 
            case 90: {
                this.dos.writeByte((byte)value);
                break;
            }
            case 67: 
            case 83: {
                this.dos.writeShort((short)value);
                break;
            }
            case 70: 
            case 73: {
                this.dos.writeInt((int)value);
                break;
            }
            case 68: 
            case 74: {
                this.dos.writeLong(value);
                break;
            }
            default: {
                Assert.shouldNotReachHere((String)"PacketOutputStream.java", (int)235);
            }
        }
    }

    public void copyValue(int tag, PacketInputStream in) throws IOException {
        switch (tag) {
            case 66: 
            case 90: {
                this.writeByte(in.readByte("value"), "value");
                break;
            }
            case 67: 
            case 83: {
                this.writeShort(in.readShort("value"), "value");
                break;
            }
            case 70: 
            case 73: {
                this.writeInt(in.readInt("value"), "value");
                break;
            }
            case 68: 
            case 74: {
                this.writeLong(in.readLong("value"), "value");
                break;
            }
            case 76: 
            case 91: 
            case 99: 
            case 115: 
            case 116: {
                this.writeObjectID(in.readObjectID("value"), "value");
                break;
            }
            default: {
                Assert.shouldNotReachHere((String)"PacketOutputStream.java", (int)274);
            }
        }
    }

    public void copyTaggedValue(PacketInputStream in) throws IOException {
        byte tag = in.readByte("tag");
        this.writeByte(tag, "tag");
        this.copyValue(tag, in);
    }

    public void close(String s) throws IOException {
        this.dos.close();
    }
}

