/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sda;

import com.sun.squawk.DebuggerSupport;
import com.sun.squawk.ExecutionPoint;
import com.sun.squawk.GC;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.Offset;
import com.sun.squawk.VMThread;
import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.JDWP;
import com.sun.squawk.debugger.JDWPListener;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.ReplyPacket;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.debugger.sda.SDA;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntHashtable;
import java.io.IOException;
import java.util.Enumeration;

public final class SDPListener
extends JDWPListener {
    private final SDA sda;
    private final IntHashtable commandSets = new IntHashtable();
    private boolean dispose;

    public SDPListener(SDA debugger) {
        this.sda = debugger;
        this.commandSets.put(1, (Object)new VirtualMachine());
        this.commandSets.put(2, (Object)new ReferenceType());
        this.commandSets.put(9, (Object)new ObjectReference());
        this.commandSets.put(3, (Object)new ClassType());
        this.commandSets.put(15, (Object)new EventRequest());
        this.commandSets.put(16, (Object)new StackFrame());
        this.commandSets.put(10, (Object)new StringReference());
        this.commandSets.put(11, (Object)new ThreadReference());
        this.commandSets.put(13, (Object)new ArrayReference());
        this.commandSets.put(17, (Object)new ClassObjectReference());
        this.commandSets.put(128, (Object)new SquawkVM());
    }

    public synchronized void processCommand(CommandPacket command) throws IOException {
        SDACommandSet handler = (SDACommandSet)this.commandSets.get(command.set());
        if (handler == null || !handler.handle(this, this.sda, command)) {
            ReplyPacket reply = command.createReply(113);
            this.sendReply(reply);
        }
    }

    public String sourceName() {
        return "SDP";
    }

    static void checkThreadSuspendedState(VMThread thread) throws SDWPException {
        if (!thread.isAlive()) {
            throw new SDWPException(10, "Thread must be alive.");
        }
        if (thread.getDebuggerSuspendCount() <= 0) {
            throw new SDWPException(13, "Thread must be suspended");
        }
    }

    private void accessCheck(Klass klass, DataType.FieldID fieldID, boolean mustBeStatic) throws SDWPException {
        Klass fieldKlass = this.sda.getClassForID(fieldID.definingClass, 25);
        if (!fieldKlass.isAssignableFrom(klass)) {
            throw new SDWPException(25, fieldID + " is not a field of the given class or object. Given class: " + klass + " field class: " + fieldKlass);
        }
        if (mustBeStatic != fieldID.isStatic()) {
            throw new SDWPException(25, mustBeStatic ? "field ID denotes an instance field" : "field ID denotes a static field");
        }
    }

    private void nullCheck(Object obj) throws SDWPException {
        if (obj == null) {
            throw new SDWPException(20, "object is null");
        }
    }

    private void typeCheck(Object value, Klass type) throws SDWPException {
        Klass valueKlass;
        if (value != null && !type.isAssignableFrom(valueKlass = GC.getKlass((Object)value))) {
            throw new SDWPException(113, "value is not compaptible with type " + valueKlass);
        }
    }

    private static Klass getTagKlass(int tag) {
        switch (tag) {
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 115: 
            case 116: {
                return Klass.OBJECT;
            }
            case 66: 
            case 67: 
            case 70: 
            case 73: 
            case 83: 
            case 90: {
                return Klass.INT;
            }
            case 68: 
            case 74: {
                return Klass.LONG;
            }
        }
        Assert.always((boolean)false, (String)("Unknown slot type tag: " + tag), (String)"SDPListener.java", (int)797);
        return null;
    }

    private static byte getTagForSelectedSlot(int slot, int[] slots, byte[] tags) {
        for (int i = 0; i != slots.length; ++i) {
            if (slots[i] != slot) continue;
            return tags[i];
        }
        return -1;
    }

    static Klass[] getSpecificTypeMap(Klass[] defaults, int parameterCount, int[] slots, byte[] tags) {
        int i;
        Klass[] result = new Klass[defaults.length];
        for (i = 0; i < defaults.length; ++i) {
            result[i] = defaults[i];
        }
        for (i = 0; i < defaults.length; ++i) {
            byte tag = SDPListener.getTagForSelectedSlot(i, slots, tags);
            if (tag == -1) continue;
            result[i] = SDPListener.getTagKlass(tag);
            if (!result[i].isDoubleWord()) continue;
            if (i <= parameterCount) {
                Assert.always((result[i + 1] == defaults[i + 1] ? 1 : 0) != 0, (String)("result[i + 1] : " + result[i + 1] + " defaults[i + 1]: " + defaults[i + 1]), (String)"SDPListener.java", (int)829);
                result[i + 1] = Klass.LONG2;
                continue;
            }
            Assert.always((result[i - 1] == defaults[i - 1] ? 1 : 0) != 0, (String)"SDPListener.java", (int)832);
            Assert.always((SDPListener.getTagForSelectedSlot(i - 1, slots, tags) == -1 ? 1 : 0) != 0, (String)("prev tag = " + SDPListener.getTagForSelectedSlot(i - 1, slots, tags)), (String)"SDPListener.java", (int)833);
            result[i - 1] = Klass.LONG2;
        }
        return result;
    }

    final class SquawkVM
    extends SDACommandSet {
        SquawkVM() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            switch (this.command.command()) {
                case 3: {
                    this.AllThreads();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void AllThreads() throws SDWPException, IOException {
            this.sda.writeThreadState(this.out);
        }
    }

    final class ClassObjectReference
    extends SDACommandSet {
        ClassObjectReference() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            switch (this.command.command()) {
                case 1: {
                    this.ReflectedType();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void ReflectedType() throws SDWPException, IOException {
            DataType.ObjectID id = this.in.readObjectID("classObject");
            Klass klass = this.sda.getObjectManager().getClassForID(id);
            if (klass.isInternalType()) {
                throw new SDWPException(20, " don't worry about these internal classes");
            }
            if (Log.verbose()) {
                Log.log("    classObject refers to " + klass);
            }
            DataType.ReferenceTypeID classID = this.sda.getIDForClass(klass);
            this.out.writeByte(JDWP.getTypeTag(klass), "refTypeTag");
            this.out.writeReferenceTypeID(classID, "typeID");
        }
    }

    final class ArrayReference
    extends SDACommandSet {
        ArrayReference() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            DataType.ObjectID arrayID = this.in.readObjectID("arrayObject");
            Object array = this.sda.getObjectManager().getObjectForID(arrayID);
            SDPListener.this.nullCheck(array);
            Klass arrayKlass = GC.getKlass((Object)array);
            Klass compType = arrayKlass.getComponentType();
            if (!arrayKlass.isArray()) {
                throw new SDWPException(508, "object ID does not denote an array: " + arrayID);
            }
            int length = GC.getArrayLength((Object)array);
            switch (this.command.command()) {
                case 1: {
                    this.Length(length);
                    break;
                }
                case 2: {
                    this.GetValues(array, compType, length);
                    break;
                }
                case 3: {
                    this.SetValues(array, compType, length);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void GetValues(Object array, Klass compType, int len) throws SDWPException, IOException {
            int count;
            int start = this.in.readInt("firstIndex");
            if (start + (count = this.in.readInt("length")) > len) {
                throw new SDWPException(504, "ArrayReference_GetValues: count + start  is too large " + (start + count));
            }
            byte tag = JDWP.getTag(compType);
            this.out.writeByte(tag, "arrayregion:tag");
            this.out.writeInt(count, "arrayregion:length");
            for (int i = 0; i < count; ++i) {
                this.getDataValue(array, start + i, tag, false, "arrayregion:value");
            }
        }

        private void SetValues(Object array, Klass compType, int len) throws SDWPException, IOException {
            int count;
            int start = this.in.readInt("firstIndex");
            if (start + (count = this.in.readInt("length")) > len) {
                throw new SDWPException(504, "ArrayReference_SetValues: count + start  is too large " + (start + count));
            }
            byte tag = JDWP.getTag(compType);
            for (int i = 0; i < count; ++i) {
                this.setDataValue(array, start + i, tag, compType, "arrayregion:value");
            }
        }

        private void Length(int len) throws IOException {
            this.out.writeInt(len, "arrayLength");
        }
    }

    final class ThreadReference
    extends SDACommandSet {
        private VMThread thread;
        private ExecutionPoint from;

        ThreadReference() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            DataType.ObjectID threadID = this.in.readObjectID("thread");
            this.thread = this.sda.getObjectManager().getThreadForID(threadID);
            SDPListener.this.nullCheck(this.thread);
            this.from = this.thread.getEventExecutionPoint();
            switch (this.command.command()) {
                case 2: {
                    this.Suspend();
                    break;
                }
                case 3: {
                    this.Resume();
                    break;
                }
                case 6: {
                    this.Frames();
                    break;
                }
                case 7: {
                    this.FrameCount();
                    break;
                }
                case 12: {
                    this.SuspendCount();
                    break;
                }
                case 8: 
                case 9: {
                    this.unimplemented();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void SuspendCount() throws IOException {
            this.out.writeInt(this.thread.getDebuggerSuspendCount(), "suspendCount");
        }

        private void Suspend() {
            this.sda.suspendThreads(this.thread);
        }

        private void Resume() {
            this.sda.resumeThreads(this.thread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void FrameCount() throws IOException, SDWPException {
            SDPListener.checkThreadSuspendedState(this.thread);
            try {
                this.thread.suspendForDebugger();
                int count = DebuggerSupport.countStackFrames(this.thread, this.from);
                this.out.writeInt(count, "frameCount");
            }
            finally {
                this.thread.resumeForDebugger(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void Frames() throws SDWPException, IOException {
            SDPListener.checkThreadSuspendedState(this.thread);
            try {
                this.thread.suspendForDebugger();
                this.frames0();
            }
            finally {
                this.thread.resumeForDebugger(false);
            }
        }

        private void frames0() throws SDWPException, IOException {
            int endFrame;
            final int startFrame = this.in.readInt("startFrame");
            int length = this.in.readInt("length");
            int totalFrames = DebuggerSupport.countStackFrames(this.thread, this.from);
            int availFrames = totalFrames - startFrame;
            int n = endFrame = length == -1 ? availFrames : startFrame + length;
            if (startFrame < 0 || endFrame <= startFrame || endFrame > totalFrames) {
                throw new SDWPException(10, "'startFrame' or 'length' value is invalid. startFrame: " + startFrame + " endFrame: " + endFrame);
            }
            this.out.writeInt(endFrame - startFrame, "frames");
            DebuggerSupport.StackInspector inspector = new DebuggerSupport.StackInspector(this.thread, false){
                private Exception exception;

                public void inspectFrame(Object mp, Offset bciWord, int frame, Offset fpOffset) {
                    if (this.exception == null && startFrame <= frame && frame < endFrame) {
                        int bci = bciWord.toInt();
                        if (frame != 0 || DebuggerSupport.isAtExceptionBreakpoint(this.vmThread)) {
                            --bci;
                        }
                        Klass definingClass = DebuggerSupport.getDefiningClass(mp);
                        DataType.MethodID methodID = DebuggerSupport.getIDForMethodBody(definingClass, mp);
                        DataType.ReferenceTypeID definingClassID = ThreadReference.this.sda.getIDForClass(definingClass);
                        DataType.Location location = new DataType.Location(JDWP.getTypeTag(definingClass), definingClassID, methodID, bci);
                        if (Log.debug()) {
                            Log.log("    " + definingClass + "[mid=" + methodID + "]@" + bci);
                        }
                        try {
                            ThreadReference.this.out.writeFrameID(new DataType.FrameID(ThreadReference.this.sda.getObjectManager().getIDForObject(this.vmThread), frame), "frameID");
                            ThreadReference.this.out.writeLocation(location, "location");
                        }
                        catch (IOException e) {
                            this.exception = e;
                        }
                    }
                }

                public Object getResult() {
                    return this.exception;
                }
            };
            DebuggerSupport.inspectStack(inspector, this.from, -1);
            Object result = inspector.getResult();
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof SDWPException) {
                throw (SDWPException)result;
            }
        }
    }

    final class StringReference
    extends SDACommandSet {
        StringReference() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            switch (this.command.command()) {
                case 1: {
                    this.StringValue();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void StringValue() throws SDWPException, IOException {
            DataType.ObjectID id = this.in.readObjectID("stringObject");
            String string = this.sda.getObjectManager().getStringForID(id);
            SDPListener.this.nullCheck(string);
            this.out.writeString(string, "stringValue");
        }
    }

    final class StackFrame
    extends SDACommandSet {
        private VMThread thread;
        private ExecutionPoint from;
        private int frameNo;

        StackFrame() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean dispatch() throws IOException, SDWPException {
            DataType.ObjectID threadID = this.in.readObjectID("thread");
            this.thread = this.sda.getObjectManager().getThreadForID(threadID);
            this.from = this.thread.getEventExecutionPoint();
            DataType.FrameID frameID = this.in.readFrameID("frame");
            this.frameNo = frameID.frame;
            SDPListener.checkThreadSuspendedState(this.thread);
            if (!frameID.threadID.equals(threadID)) {
                throw new SDWPException(30, "frameID.thread [" + frameID.threadID + "] is inconsistent with threadID [" + threadID + "]");
            }
            if (this.frameNo < 0 || this.frameNo > DebuggerSupport.countStackFrames(this.thread, this.from)) {
                throw new SDWPException(30, "invalid frame number " + this.frameNo);
            }
            try {
                this.thread.suspendForDebugger();
                switch (this.command.command()) {
                    case 1: {
                        this.GetValues();
                        return true;
                    }
                    case 3: {
                        this.ThisObject();
                        return true;
                    }
                    case 2: {
                        this.SetValues();
                        return true;
                    }
                    default: {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            finally {
                this.thread.resumeForDebugger(false);
            }
        }

        private void ThisObject() throws SDWPException, IOException {
            DebuggerSupport.StackInspector inspector = new DebuggerSupport.StackInspector(this.thread, true){
                private Exception exception;
                private boolean foundThis;
                private boolean isStatic;

                public void inspectFrame(Object mp, Offset bci, int frame, Offset fpOffset) {
                    Klass definingClass = DebuggerSupport.getDefiningClass(mp);
                    DataType.MethodID methodID = DebuggerSupport.getIDForMethodBody(definingClass, mp);
                    this.isStatic = methodID.isStatic();
                }

                public void inspectSlot(boolean isParameter, int slot, Object value) {
                    if (!this.isStatic && isParameter && slot == 0) {
                        try {
                            StackFrame.this.sda.getObjectManager().writeTaggedObject(StackFrame.this.out, value, "objectThis");
                            this.foundThis = true;
                        }
                        catch (IOException e) {
                            this.exception = e;
                        }
                    }
                }

                public void postInspection() {
                    if (this.exception == null) {
                        if (this.isStatic) {
                            try {
                                StackFrame.this.sda.getObjectManager().writeTaggedObject(StackFrame.this.out, null, "objectThis");
                            }
                            catch (IOException e) {
                                this.exception = e;
                            }
                        } else {
                            Assert.always((boolean)this.foundThis, (String)"couldn't get 'this' for non-static method", (String)"SDPListener.java", (int)934);
                        }
                    }
                }

                public Object getResult() {
                    return this.exception;
                }
            };
            int inspectedFrames = DebuggerSupport.inspectStack(inspector, this.from, this.frameNo);
            Object result = inspector.getResult();
            if (inspectedFrames == 0) {
                throw new SDWPException(30, this.frameNo + " is an invalid frame number for thread " + this.thread);
            }
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof SDWPException) {
                throw (SDWPException)result;
            }
        }

        private void GetValues() throws SDWPException, IOException {
            DebuggerSupport.StackInspector inspector = new DebuggerSupport.StackInspector(this.thread, true){
                private Exception exception;
                private int slotCount;
                private int[] slots;
                private byte[] tags;

                public void inspectFrame(Object mp, Offset bci, int frame, Offset fpOffset) {
                    try {
                        this.slotCount = StackFrame.this.in.readInt("slots");
                        StackFrame.this.out.writeInt(this.slotCount, "values");
                        this.slots = new int[this.slotCount];
                        this.tags = new byte[this.slotCount];
                        for (int i = 0; i != this.slotCount; ++i) {
                            this.slots[i] = StackFrame.this.in.readInt("slot");
                            this.tags[i] = StackFrame.this.in.readByte("sigbyte");
                        }
                    }
                    catch (IOException e) {
                        this.exception = e;
                    }
                }

                public void inspectSlot(boolean isParameter, int slot, Object value) {
                    byte tag;
                    if (this.exception == null && (tag = SDPListener.getTagForSelectedSlot(slot, this.slots, this.tags)) != -1) {
                        if (!JDWP.isReferenceTag(tag)) {
                            this.exception = new SDWPException(35, "slot type is invalid for request");
                        } else {
                            try {
                                StackFrame.this.sda.getObjectManager().writeTaggedObject(StackFrame.this.out, value, "slotValue");
                                --this.slotCount;
                            }
                            catch (IOException e) {
                                this.exception = e;
                            }
                        }
                    }
                }

                public void inspectSlot(boolean isParameter, int slot, Klass type, long value) {
                    byte tag;
                    if (this.exception == null && (tag = SDPListener.getTagForSelectedSlot(slot, this.slots, this.tags)) != -1) {
                        if (JDWP.isReferenceTag(tag)) {
                            this.exception = new SDWPException(35, "slot type is invalid for request");
                        } else {
                            try {
                                StackFrame.this.out.writePrimitive(tag, value, "slotValue");
                                --this.slotCount;
                            }
                            catch (IOException e) {
                                this.exception = e;
                            }
                        }
                    }
                }

                public Klass[] getTypeMap(int thisFrame, Object mp, int parameterCount) {
                    Klass[] defaults = super.getTypeMap(thisFrame, mp, parameterCount);
                    if (StackFrame.this.frameNo == thisFrame) {
                        return SDPListener.getSpecificTypeMap(defaults, parameterCount, this.slots, this.tags);
                    }
                    return defaults;
                }

                public void postInspection() {
                    if (this.exception == null && this.slotCount != 0) {
                        this.exception = new SDWPException(35, "not all slots were matched");
                    }
                }

                public Object getResult() {
                    return this.exception;
                }
            };
            int inspectedFrames = DebuggerSupport.inspectStack(inspector, this.from, this.frameNo);
            Object result = inspector.getResult();
            if (inspectedFrames == 0) {
                throw new SDWPException(30, this.frameNo + " is an invalid frame number for thread " + this.thread);
            }
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof SDWPException) {
                throw (SDWPException)result;
            }
        }

        private void SetValues() throws SDWPException, IOException {
            DebuggerSupport.SlotSetter inspector = new DebuggerSupport.SlotSetter(this.thread){
                private Exception exception;
                private int slotCount;
                private int[] slots;
                private byte[] tags;
                private long[] primValues;
                private DataType.ObjectID[] objValues;
                private boolean lastValueValid;
                private long lastPrimValue;
                private Object lastObjValue;

                public void inspectFrame(Object mp, Offset bci, int frame, Offset fpOffset) {
                    try {
                        this.slotCount = StackFrame.this.in.readInt("slotValues");
                        this.slots = new int[this.slotCount];
                        this.tags = new byte[this.slotCount];
                        this.primValues = new long[this.slotCount];
                        this.objValues = new DataType.ObjectID[this.slotCount];
                        block9: for (int i = 0; i != this.slotCount; ++i) {
                            this.slots[i] = StackFrame.this.in.readInt("slot");
                            this.tags[i] = StackFrame.this.in.readByte("sigbyte");
                            switch (this.tags[i]) {
                                case 66: 
                                case 90: {
                                    this.primValues[i] = StackFrame.this.in.readByte("value");
                                    continue block9;
                                }
                                case 67: 
                                case 83: {
                                    this.primValues[i] = StackFrame.this.in.readShort("value");
                                    continue block9;
                                }
                                case 70: 
                                case 73: {
                                    this.primValues[i] = StackFrame.this.in.readInt("value");
                                    continue block9;
                                }
                                case 68: 
                                case 74: {
                                    this.primValues[i] = StackFrame.this.in.readLong("value");
                                    continue block9;
                                }
                                case 76: 
                                case 91: 
                                case 99: 
                                case 115: 
                                case 116: {
                                    this.objValues[i] = StackFrame.this.in.readObjectID("value");
                                    continue block9;
                                }
                                default: {
                                    Assert.shouldNotReachHere((String)"SDPListener.java", (int)1136);
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        this.exception = e;
                    }
                }

                private int getIndexForSelectedSlot(int slot) {
                    for (int i = 0; i != this.slots.length; ++i) {
                        if (this.slots[i] != slot) continue;
                        return i;
                    }
                    return -1;
                }

                public boolean shouldSetSlot(int slot, Klass type) {
                    int i;
                    this.lastValueValid = false;
                    if (this.exception == null && (i = this.getIndexForSelectedSlot(slot)) != -1) {
                        if (type.isPrimitive() == JDWP.isReferenceTag(this.tags[i])) {
                            this.exception = new SDWPException(35, "slot type is invalid for request");
                        } else {
                            try {
                                --this.slotCount;
                                if (JDWP.isReferenceTag(this.tags[i])) {
                                    Object value = StackFrame.this.sda.getObjectManager().getObjectForID(this.objValues[i]);
                                    SDPListener.this.typeCheck(value, type);
                                    this.lastObjValue = value;
                                    this.lastPrimValue = -559038803L;
                                } else {
                                    this.lastObjValue = null;
                                    this.lastPrimValue = this.primValues[i];
                                }
                                this.lastValueValid = true;
                                return true;
                            }
                            catch (SDWPException e) {
                                this.exception = e;
                            }
                        }
                    }
                    return false;
                }

                public Klass[] getTypeMap(int thisFrame, Object mp, int parameterCount) {
                    Klass[] defaults = super.getTypeMap(thisFrame, mp, parameterCount);
                    if (StackFrame.this.frameNo == thisFrame) {
                        return SDPListener.getSpecificTypeMap(defaults, parameterCount, this.slots, this.tags);
                    }
                    return defaults;
                }

                public long newPrimValue() {
                    Assert.always((boolean)this.lastValueValid, (String)"SDPListener.java", (int)1208);
                    return this.lastPrimValue;
                }

                public Object newObjValue() {
                    Assert.always((boolean)this.lastValueValid, (String)"SDPListener.java", (int)1216);
                    return this.lastObjValue;
                }

                public void postInspection() {
                    if (this.exception == null && this.slotCount != 0) {
                        this.exception = new SDWPException(35, "not all slots were matched");
                    }
                }

                public Object getResult() {
                    return this.exception;
                }
            };
            int inspectedFrames = DebuggerSupport.inspectStack(inspector, this.from, this.frameNo);
            Object result = inspector.getResult();
            if (inspectedFrames == 0) {
                throw new SDWPException(30, this.frameNo + " is an invalid frame number for thread " + this.thread);
            }
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof SDWPException) {
                throw (SDWPException)result;
            }
        }
    }

    final class EventRequest
    extends SDACommandSet {
        EventRequest() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            switch (this.command.command()) {
                case 1: {
                    this.Set();
                    break;
                }
                case 2: {
                    this.Clear();
                    break;
                }
                case 3: {
                    this.ClearAllBreakpoints();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void Set() throws SDWPException, IOException {
            int id = this.sda.getEventManager().registerEventRequest(this.in);
            this.out.writeInt(id, "requestID");
        }

        private void Clear() throws SDWPException, IOException {
            byte eventKind = this.in.readByte("eventKind");
            int requestID = this.in.readInt("requestID");
            if (requestID == 0) {
                if (Log.info()) {
                    Log.log("Events with ID of zero are reserved for automatic events, and can't be cleared. Fail without error.");
                }
                return;
            }
            this.sda.getEventManager().clear(eventKind, requestID);
        }

        private void ClearAllBreakpoints() throws SDWPException {
            this.sda.getEventManager().clear(2, 0);
        }
    }

    final class ObjectReference
    extends SDACommandSet {
        ObjectReference() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            DataType.ObjectID id = this.in.readObjectID("object");
            Object object = this.sda.getObjectManager().getObjectForID(id);
            SDPListener.this.nullCheck(object);
            switch (this.command.command()) {
                case 1: {
                    this.ReferenceType(object);
                    break;
                }
                case 9: {
                    this.IsCollected(object);
                    break;
                }
                case 2: {
                    this.GetValues(object);
                    break;
                }
                case 6: {
                    this.InvokeMethod(object);
                    break;
                }
                case 3: {
                    this.SetValues(object);
                    break;
                }
                case 7: 
                case 8: {
                    this.unimplemented();
                    break;
                }
                case 5: {
                    this.unimplemented();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void InvokeMethod(Object object) throws IOException {
            DataType.ObjectID threadID = this.in.readObjectID("thread");
            DataType.ReferenceTypeID classID = this.in.readReferenceTypeID("clazz");
            DataType.MethodID methodID = this.in.readMethodID("methodID");
            if (methodID.getOffset() == 8) {
                Object value = null;
                value = object instanceof String ? object : object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
                this.sda.getObjectManager().writeTaggedObject(this.out, value, "returnValue");
                this.sda.getObjectManager().writeTaggedObject(this.out, null, "exception");
            } else {
                this.unimplemented();
            }
        }

        private void IsCollected(Object object) throws IOException {
            boolean wasCollected = object == null;
            this.out.writeBoolean(wasCollected, "isCollected");
        }

        private void ReferenceType(Object object) throws IOException {
            Klass klass = GC.getKlass((Object)object);
            this.out.writeByte(JDWP.getTypeTag(klass), "refTypeTag");
            this.out.writeReferenceTypeID(this.sda.getIDForClass(klass), "typeID");
        }

        private void GetValues(Object object) throws SDWPException, IOException {
            int count = this.in.readInt("count");
            this.out.writeInt(count, "values");
            Klass klass = GC.getKlass((Object)object);
            for (int i = 0; i < count; ++i) {
                DataType.FieldID fieldID = this.in.readFieldID("fieldID");
                SDPListener.this.accessCheck(klass, fieldID, false);
                this.getDataValue(object, fieldID.getOffset(), fieldID.getTag(), true, "value");
            }
        }

        private void SetValues(Object object) throws SDWPException, IOException {
            if (!GC.inRam((Object)object)) {
                throw new SDWPException(20, "Can't change values in FLASH or ROM");
            }
            Klass klass = GC.getKlass((Object)object);
            int count = this.in.readInt("count");
            for (int i = 0; i < count; ++i) {
                DataType.FieldID fieldID = this.in.readFieldID("fieldID");
                SDPListener.this.accessCheck(klass, fieldID, false);
                DataType.ReferenceTypeID fieldTypeID = this.in.readReferenceTypeID("fieldType");
                Klass fieldTypeKlass = this.sda.getClassForID(fieldTypeID, 21);
                this.setDataValue(object, fieldID.getOffset(), fieldID.getTag(), fieldTypeKlass, "untagged value");
            }
        }
    }

    final class ClassType
    extends SDACommandSet {
        ClassType() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            DataType.ReferenceTypeID id = this.in.readReferenceTypeID("clazz");
            Klass klass = this.sda.getClassForID(id, 21);
            switch (this.command.command()) {
                case 2: {
                    this.SetValues(klass);
                    return true;
                }
                case 3: 
                case 4: {
                    this.unimplemented();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void SetValues(Klass klass) throws SDWPException, IOException {
            Isolate isolate = this.sda.getDebuggeeIsolate();
            int count = this.in.readInt("values");
            block7: for (int i = 0; i < count; ++i) {
                DataType.FieldID fieldID = this.in.readFieldID("fieldID");
                SDPListener.this.accessCheck(klass, fieldID, true);
                Klass definingClass = this.sda.getClassForID(fieldID.definingClass, 21);
                int offset = fieldID.getOffset();
                byte tag = fieldID.getTag();
                if (Log.verbose()) {
                    Log.log("    static field in " + klass + " of type " + (char)tag + " at offset " + offset);
                }
                DataType.ReferenceTypeID fieldTypeID = this.in.readReferenceTypeID("fieldType");
                Klass fieldTypeKlass = this.sda.getClassForID(fieldTypeID, 21);
                switch (tag) {
                    case 66: 
                    case 90: {
                        DebuggerSupport.setStaticInt(isolate, definingClass, offset, this.in.readByte("untagged value"));
                        continue block7;
                    }
                    case 67: 
                    case 83: {
                        DebuggerSupport.setStaticInt(isolate, definingClass, offset, this.in.readShort("untagged value"));
                        continue block7;
                    }
                    case 70: 
                    case 73: {
                        DebuggerSupport.setStaticInt(isolate, definingClass, offset, this.in.readInt("untagged value"));
                        continue block7;
                    }
                    case 68: 
                    case 74: {
                        DebuggerSupport.setStaticLong(isolate, definingClass, offset, this.in.readLong("untagged value"));
                        continue block7;
                    }
                    case 76: 
                    case 91: 
                    case 99: 
                    case 115: 
                    case 116: {
                        DataType.ObjectID valueID = this.in.readObjectID("untagged value");
                        Object value = this.sda.getObjectManager().getObjectForID(valueID);
                        SDPListener.this.typeCheck(value, fieldTypeKlass);
                        DebuggerSupport.setStaticOop(isolate, definingClass, offset, value);
                        continue block7;
                    }
                    default: {
                        Assert.shouldNotReachHere((String)"SDPListener.java", (int)568);
                    }
                }
            }
        }
    }

    final class ReferenceType
    extends SDACommandSet {
        ReferenceType() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            DataType.ReferenceTypeID typeID = this.in.readReferenceTypeID("refType");
            Klass refType = this.sda.getClassForID(typeID, 21);
            switch (this.command.command()) {
                case 1: {
                    this.Signature(refType);
                    break;
                }
                case 6: {
                    this.GetValues(refType);
                    break;
                }
                case 11: {
                    this.ClassObject(refType);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void ClassObject(Klass refType) throws IOException {
            this.out.writeObjectID(this.sda.getObjectManager().getIDForObject(refType), "classObject");
        }

        private void Signature(Klass klass) throws IOException {
            this.out.writeString(klass.getSignature(), "signature");
        }

        private void GetValues(Klass klass) throws SDWPException, IOException {
            Isolate isolate = this.sda.getDebuggeeIsolate();
            int count = this.in.readInt("fields");
            this.out.writeInt(count, "values");
            block5: for (int i = 0; i < count; ++i) {
                DataType.FieldID fieldID = this.in.readFieldID("fieldID");
                SDPListener.this.accessCheck(klass, fieldID, true);
                Klass definingClass = this.sda.getClassForID(fieldID.definingClass, 21);
                int offset = fieldID.getOffset();
                byte tag = fieldID.getTag();
                if (Log.debug()) {
                    Log.log("    static field in " + klass + " of type " + (char)tag + " at offset " + offset);
                }
                switch (tag) {
                    case 66: 
                    case 67: 
                    case 70: 
                    case 73: 
                    case 83: 
                    case 90: {
                        this.out.writePrimitive(tag, DebuggerSupport.getStaticInt(isolate, definingClass, offset), "1-word value");
                        continue block5;
                    }
                    case 68: 
                    case 74: {
                        this.out.writePrimitive(tag, DebuggerSupport.getStaticLong(isolate, definingClass, offset), "2-word value");
                        continue block5;
                    }
                    case 76: 
                    case 91: 
                    case 99: 
                    case 115: 
                    case 116: {
                        Object object = DebuggerSupport.getStaticOop(isolate, definingClass, offset);
                        this.sda.getObjectManager().writeTaggedObject(this.out, object, "object value");
                        continue block5;
                    }
                    default: {
                        Assert.shouldNotReachHere((String)"SDPListener.java", (int)475);
                    }
                }
            }
        }
    }

    final class VirtualMachine
    extends SDACommandSet {
        VirtualMachine() {
        }

        protected boolean dispatch() throws IOException {
            switch (this.command.command()) {
                case 8: {
                    this.Suspend();
                    break;
                }
                case 9: {
                    this.Resume();
                    break;
                }
                case 6: {
                    this.Dispose();
                    break;
                }
                case 11: {
                    this.CreateString();
                    break;
                }
                case 2: {
                    this.ClassesBySignature();
                    break;
                }
                case 10: 
                case 15: 
                case 16: {
                    this.unimplemented();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        protected void postDispatch() {
            if (SDPListener.this.dispose) {
                SDPListener.this.quit();
                this.sda.resumeIsolate(true);
            }
        }

        private void ClassesBySignature() throws IOException {
            String sig = this.in.readString("signature");
            Enumeration e = this.sda.getClasses();
            while (e.hasMoreElements()) {
                Klass klass = (Klass)e.nextElement();
                if (!klass.getSignature().equals(sig)) continue;
                this.out.writeInt(1, "classes");
                this.out.writeByte(JDWP.getTypeTag(klass), "refTypeTag");
                this.out.writeReferenceTypeID(this.sda.getIDForClass(klass), "typeID");
                this.out.writeInt(7, "status");
                return;
            }
            this.out.writeInt(0, "classes");
        }

        private void Resume() {
            this.sda.resumeThreads(null);
        }

        private void Suspend() {
            this.sda.suspendThreads(null);
        }

        private void Dispose() throws IOException {
            SDPListener.this.dispose = true;
        }

        private void CreateString() throws IOException {
            String s = this.in.readString("utf");
            this.out.writeObjectID(this.sda.getObjectManager().getIDForObject(s), "stringObject");
        }
    }

    abstract class SDACommandSet
    extends JDWPListener.CommandSet {
        SDA sda;

        SDACommandSet() {
        }

        public final boolean handle(JDWPListener listener, SDA sda, CommandPacket command) throws IOException {
            this.sda = sda;
            return this.handle(listener, command);
        }

        void getDataValue(Object base, int offset, int tag, boolean writeTag, String msg) throws IOException {
            switch (tag) {
                case 66: 
                case 90: {
                    if (writeTag) {
                        this.out.writeByte(tag, "tag");
                    }
                    this.out.writeByte((byte)NativeUnsafe.getByte((Object)base, (int)offset), msg);
                    break;
                }
                case 67: 
                case 83: {
                    if (writeTag) {
                        this.out.writeByte(tag, "tag");
                    }
                    this.out.writeShort((short)NativeUnsafe.getShort((Object)base, (int)offset), msg);
                    break;
                }
                case 70: 
                case 73: {
                    if (writeTag) {
                        this.out.writeByte(tag, "tag");
                    }
                    this.out.writeInt(NativeUnsafe.getInt((Object)base, (int)offset), msg);
                    break;
                }
                case 68: 
                case 74: {
                    if (writeTag) {
                        this.out.writeByte(tag, "tag");
                    }
                    this.out.writeLong(NativeUnsafe.getLongAtWord((Object)base, (int)offset), msg);
                    break;
                }
                case 76: 
                case 91: 
                case 99: 
                case 115: 
                case 116: {
                    Object elem = NativeUnsafe.getObject((Object)base, (int)offset);
                    this.sda.getObjectManager().writeTaggedObject(this.out, elem, msg);
                    break;
                }
                default: {
                    Assert.shouldNotReachHere((String)"SDPListener.java", (int)217);
                }
            }
        }

        void setDataValue(Object base, int offset, int tag, Klass locationKlass, String msg) throws IOException, SDWPException {
            switch (tag) {
                case 66: 
                case 90: {
                    NativeUnsafe.setByte((Object)base, (int)offset, (int)this.in.readByte(msg));
                    break;
                }
                case 67: 
                case 83: {
                    NativeUnsafe.setShort((Object)base, (int)offset, (int)this.in.readShort(msg));
                    break;
                }
                case 70: 
                case 73: {
                    NativeUnsafe.setInt((Object)base, (int)offset, (int)this.in.readInt(msg));
                    break;
                }
                case 68: 
                case 74: {
                    NativeUnsafe.setLong((Object)base, (int)offset, (long)this.in.readLong(msg));
                    break;
                }
                case 76: 
                case 91: 
                case 99: 
                case 115: 
                case 116: {
                    DataType.ObjectID valueID = this.in.readObjectID(msg);
                    Object value = this.sda.getObjectManager().getObjectForID(valueID);
                    SDPListener.this.typeCheck(value, locationKlass);
                    NativeUnsafe.setObject((Object)base, (int)offset, (Object)value);
                    break;
                }
                default: {
                    Assert.shouldNotReachHere((String)"SDPListener.java", (int)260);
                }
            }
        }
    }
}

