/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.tableviewer;

import edu.wpi.first.tableviewer.TableEntryData;
import edu.wpi.first.wpilibj.networktables.NetworkTableProvider;
import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.tables.ITable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.swing.outline.Outline;

public abstract class AbstractTreeNode
extends DefaultMutableTreeNode {
    protected ITable table;
    protected TableEntryData data;
    protected static DefaultTreeModel treeModel;
    protected static Outline outline;

    public static void setTreeModel(DefaultTreeModel model) {
        treeModel = model;
    }

    public static void setOutline(Outline outline) {
        AbstractTreeNode.outline = outline;
    }

    public AbstractTreeNode(NetworkTableNode node, String key, TableEntryData data) {
        super(data);
        this.data = data;
        if (treeModel != null) {
            treeModel.reload(this);
        }
        this.table = new NetworkTableProvider(node).getTable(key);
    }

    public final Object getValueFor(int index) {
        switch (index) {
            case 0: {
                return this.data.getValue();
            }
            case 1: {
                return this.data.getType();
            }
        }
        return null;
    }

    public TableEntryData getData() {
        return this.data;
    }

    public AbstractTreeNode get(String name) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            AbstractTreeNode node = (AbstractTreeNode)this.getChildAt(i);
            if (!node.getData().getKey().equals(name)) continue;
            return node;
        }
        return null;
    }

    @Override
    public abstract boolean isLeaf();

    @Override
    public abstract String toString();
}

