/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.tableviewer;

import edu.wpi.first.tableviewer.AbstractTreeNode;
import edu.wpi.first.tableviewer.TableEntryData;
import edu.wpi.first.tableviewer.dialog.AddArrayDialog;
import edu.wpi.first.tableviewer.dialog.AddBooleanDialog;
import edu.wpi.first.tableviewer.dialog.AddNumberDialog;
import edu.wpi.first.tableviewer.dialog.AddStringDialog;
import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class BranchNode
extends AbstractTreeNode {
    private final String name;

    public BranchNode(NetworkTableNode node, String key, String name) {
        super(node, key, new TableEntryData(name, null));
        this.name = name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public JPopupMenu getMenu(final TreePath path) {
        JPopupMenu popupMenu = new JPopupMenu("Add Items");
        JMenuItem addArrayItem = new JMenuItem("Add array");
        JMenuItem addBooleanItem = new JMenuItem("Add boolean");
        JMenuItem addNumberItem = new JMenuItem("Add number");
        JMenuItem addStringItem = new JMenuItem("Add string");
        addArrayItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AddArrayDialog(path, BranchNode.this.table).setVisible(true);
            }
        });
        addBooleanItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AddBooleanDialog(path, BranchNode.this.table).setVisible(true);
            }
        });
        addNumberItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AddNumberDialog(path, BranchNode.this.table).setVisible(true);
            }
        });
        addStringItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AddStringDialog(path, BranchNode.this.table).setVisible(true);
            }
        });
        popupMenu.add(addArrayItem);
        popupMenu.add(addBooleanItem);
        popupMenu.add(addNumberItem);
        popupMenu.add(addStringItem);
        return popupMenu;
    }
}

