/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.tableviewer;

import edu.wpi.first.tableviewer.AbstractTreeNode;
import edu.wpi.first.tableviewer.TableEntryData;
import edu.wpi.first.wpilibj.networktables.NetworkTableProvider;
import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import javax.swing.event.TableModelEvent;

public class LeafNode
extends AbstractTreeNode {
    public LeafNode(NetworkTableNode node, String key, TableEntryData data) {
        super(node, key, data);
        this.table = new NetworkTableProvider(node).getTable(key.substring(0, key.lastIndexOf(47)));
    }

    public void updateValue(Object newValue) {
        this.data.setValue(newValue);
        outline.tableChanged(new TableModelEvent(outline.getModel()));
    }

    public void setValue(Object newValue) {
        String v = newValue.toString();
        switch (this.data.getType().toString()) {
            case "Boolean": {
                this.table.putBoolean(this.data.getKey(), v.equalsIgnoreCase("true"));
                break;
            }
            case "Number": {
                try {
                    this.table.putNumber(this.data.getKey(), Double.parseDouble(v));
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid number " + v);
                }
                break;
            }
            case "String": {
                this.table.putString(this.data.getKey(), v);
                break;
            }
            default: {
                System.err.println("Cannot edit a value of type " + this.data.getType());
            }
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public String toString() {
        return this.data.getKey();
    }
}

