/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.tableviewer;

import edu.wpi.first.tableviewer.AbstractTreeNode;
import edu.wpi.first.tableviewer.BranchNode;
import edu.wpi.first.tableviewer.LeafNode;
import edu.wpi.first.tableviewer.NetworkTableRowModel;
import edu.wpi.first.tableviewer.TableEntryData;
import edu.wpi.first.tableviewer.dialog.AbstractAddDialog;
import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;

public class OutlineFrame
extends JFrame
implements ITableListener {
    private final Outline outline;
    private final BranchNode rootBranch;
    private final NetworkTableNode node;
    private final boolean showMetadata;
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());

    public OutlineFrame(String title, NetworkTableNode node, boolean showMetadata) {
        this.node = node;
        this.showMetadata = showMetadata;
        this.setTitle(title);
        this.setDefaultCloseOperation(3);
        this.rootBranch = new BranchNode(node, "", "Root");
        DefaultTreeModel outlineTreeModel = new DefaultTreeModel(this.rootBranch);
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel(outlineTreeModel, new NetworkTableRowModel(), true, "Key");
        this.outline = new Outline();
        this.outline.setModel(outlineModel);
        AbstractAddDialog.setOutline(this.outline);
        AbstractTreeNode.setOutline(this.outline);
        AbstractTreeNode.setTreeModel(outlineTreeModel);
        this.outline.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = OutlineFrame.this.outline.getClosestPathForLocation(e.getX(), e.getY());
                AbstractTreeNode node = (AbstractTreeNode)path.getLastPathComponent();
                if (e.getClickCount() != 2 && SwingUtilities.isRightMouseButton(e) && node instanceof BranchNode) {
                    ((BranchNode)node).getMenu(path).show(OutlineFrame.this.outline, e.getX(), e.getY());
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OutlineFrame.this.prefs.putInt("WindowX", OutlineFrame.this.getX());
                OutlineFrame.this.prefs.putInt("WindowY", OutlineFrame.this.getY());
                OutlineFrame.this.prefs.putInt("Width", OutlineFrame.this.getWidth());
                OutlineFrame.this.prefs.putInt("Height", OutlineFrame.this.getHeight());
            }

            @Override
            public void windowOpened(WindowEvent e) {
                OutlineFrame.this.setLocation(OutlineFrame.this.prefs.getInt("WindowX", 0), OutlineFrame.this.prefs.getInt("WindowY", 0));
                OutlineFrame.this.setSize(OutlineFrame.this.prefs.getInt("Width", 600), OutlineFrame.this.prefs.getInt("Height", 400));
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.outline);
        this.add((Component)scrollPane, "Center");
        node.addTableListener(this, true);
    }

    @Override
    public void valueChanged(ITable source, final String key, final Object value, boolean isNew) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OutlineFrame.this.getBranchesToEntry(key, value);
            }
        });
    }

    private void getBranchesToEntry(String fullKey, Object value) {
        CustomList<String> subTableNames = this.splitDiscardingEmpty(fullKey, "/");
        String key = "";
        AbstractTreeNode currentNode = this.rootBranch;
        for (String name : subTableNames) {
            BranchNode parentNode = currentNode;
            currentNode = currentNode.get(name);
            key = key + "/" + name;
            if (subTableNames.getLast() == name) {
                if (currentNode == null) {
                    currentNode = new LeafNode(this.node, key, new TableEntryData(name, value));
                    if (currentNode.data.isMetadata() && !this.showMetadata) {
                        parentNode.data.setType(TableEntryData.EntryType.getEntryType(currentNode.data.getValue().toString()));
                        continue;
                    }
                    parentNode.add(currentNode);
                    TreePath path = new TreePath(currentNode.getPath());
                    this.outline.expandPath(path);
                    continue;
                }
                ((LeafNode)currentNode).updateValue(value);
                continue;
            }
            if (currentNode != null) continue;
            currentNode = new BranchNode(this.node, key, name);
            parentNode.add(currentNode);
        }
    }

    private CustomList<String> splitDiscardingEmpty(String str, String separator) {
        CustomList<String> results = new CustomList<String>();
        for (String string : str.split(separator)) {
            if (string.length() <= 0) continue;
            results.add(string);
        }
        return results;
    }

    private class CustomList<E>
    extends ArrayList<E> {
        private CustomList() {
        }

        @Override
        public E getLast() {
            return this.get(this.size() - 1);
        }
    }
}

