/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.tableviewer;

import java.util.Arrays;
import java.util.HashMap;

public class TableEntryData {
    private String key;
    private Object value;
    private EntryType type;

    public TableEntryData(String key, Object value) {
        this.key = key;
        if (value != null) {
            this.value = value;
            this.type = this.typeFromValue(value);
            if (this.type.equals(EntryType.ARRAY)) {
                this.value = Arrays.toString((Object[])value);
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public EntryType getType() {
        return this.type;
    }

    public void setValue(Object newValue) {
        this.value = newValue;
        if (newValue instanceof Object[]) {
            this.value = Arrays.toString((Object[])newValue);
        }
    }

    public void setType(EntryType type) {
        this.type = type;
    }

    private EntryType typeFromValue(Object value) {
        String valueClassName = value.getClass().toString().substring(value.getClass().toString().lastIndexOf(".") + 1);
        if (this.isMetadata()) {
            return EntryType.METADATA;
        }
        switch (valueClassName.toLowerCase()) {
            case "boolean": {
                return EntryType.BOOLEAN;
            }
            case "double": {
                return EntryType.NUMBER;
            }
            case "string": {
                return EntryType.STRING;
            }
            case "object;": {
                return EntryType.ARRAY;
            }
        }
        return EntryType.UNSUPPORTED;
    }

    public boolean isMetadata() {
        return this.key.startsWith("~") && this.key.endsWith("~") && this.key.toUpperCase().equals(this.key);
    }

    public static final class EntryType {
        private static final HashMap<String, EntryType> ENTRY_TYPES = new HashMap();
        public static final EntryType ARRAY = new EntryType("Array");
        public static final EntryType BOOLEAN = new EntryType("Boolean");
        public static final EntryType METADATA = new EntryType("Metadata");
        public static final EntryType NUMBER = new EntryType("Number");
        public static final EntryType STRING = new EntryType("String");
        public static final EntryType UNSUPPORTED = new EntryType("Unsupported");
        private final String name;

        private EntryType(String name) {
            this.name = name;
            ENTRY_TYPES.put(name, this);
        }

        public static EntryType getEntryType(String name) {
            EntryType type = ENTRY_TYPES.get(name);
            if (type == null) {
                type = new EntryType(name);
            }
            return type;
        }

        public String toString() {
            return this.name;
        }
    }
}

