/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.tableviewer.dialog;

import edu.wpi.first.tableviewer.dialog.AbstractAddDialog;
import edu.wpi.first.wpilibj.networktables2.type.ArrayData;
import edu.wpi.first.wpilibj.networktables2.type.BooleanArray;
import edu.wpi.first.wpilibj.networktables2.type.NumberArray;
import edu.wpi.first.wpilibj.networktables2.type.StringArray;
import edu.wpi.first.wpilibj.tables.ITable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;

public class AddArrayDialog
extends AbstractAddDialog {
    private final DefaultCellEditor booleanEditor = new DefaultCellEditor(new JComboBox<String>(new String[]{"True", "False"}));
    private JButton addRowButton;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JLabel keyLabel;
    private JButton okayButton;
    private JButton removeRowButton;
    private JComboBox typeComboBox;
    private JLabel typeLabel;
    private JTable valueTable;

    public AddArrayDialog(TreePath path, ITable table) {
        super(path, table);
        this.setTitle("Add array");
        this.initComponents();
        this.setMinimumSize(this.getSize());
        this.valueTable.getColumnModel().getColumn(0).setCellEditor(this.booleanEditor);
    }

    private void initComponents() {
        this.keyLabel = new JLabel();
        this.keyField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.valueTable = new JTable();
        this.cancelButton = new JButton();
        this.okayButton = new JButton();
        this.removeRowButton = new JButton();
        this.addRowButton = new JButton();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.keyLabel.setFont(new Font("Trebuchet MS", 1, 12));
        this.keyLabel.setText("Array name");
        this.valueTable.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}, {null}}, new String[]{"Value"}){
            Class[] types;
            {
                this.types = new Class[]{String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.valueTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.valueTable);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddArrayDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okayButton.setText("OK");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddArrayDialog.this.okayButtonActionPerformed(evt);
            }
        });
        this.removeRowButton.setText("-");
        this.removeRowButton.setToolTipText("Remove the selected row");
        this.removeRowButton.setPreferredSize(new Dimension(20, 20));
        this.removeRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddArrayDialog.this.removeRowButtonActionPerformed(evt);
            }
        });
        this.addRowButton.setText("+");
        this.addRowButton.setPreferredSize(new Dimension(20, 20));
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddArrayDialog.this.addRowButtonActionPerformed(evt);
            }
        });
        this.typeLabel.setFont(new Font("Trebuchet MS", 1, 12));
        this.typeLabel.setText("Array type");
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Boolean", "Number", "String"}));
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddArrayDialog.this.typeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keyLabel).addComponent(this.typeLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keyField).addComponent(this.typeComboBox, 0, 175, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.okayButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addComponent(this.addRowButton, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeRowButton, -2, 40, -2))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyLabel).addComponent(this.keyField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeComboBox, -2, -1, -2)).addGap(13, 13, 13).addComponent(this.jScrollPane1, -1, 116, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addRowButton, -2, 25, -2).addComponent(this.removeRowButton, -2, 25, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okayButton)).addContainerGap()));
        this.pack();
    }

    private void addRowButtonActionPerformed(ActionEvent evt) {
        ((DefaultTableModel)this.valueTable.getModel()).insertRow(this.valueTable.getSelectedRow() + 1, (Object[])null);
    }

    private void removeRowButtonActionPerformed(ActionEvent evt) {
        try {
            ((DefaultTableModel)this.valueTable.getModel()).removeRow(this.valueTable.getSelectedRow());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ((DefaultTableModel)this.valueTable.getModel()).removeRow(this.valueTable.getModel().getRowCount() - 1);
        }
    }

    private void typeComboBoxActionPerformed(ActionEvent evt) {
        this.valueTable.clearSelection();
        switch (this.typeComboBox.getSelectedItem().toString()) {
            case "Boolean": {
                for (int i = 0; i < this.valueTable.getRowCount(); ++i) {
                    this.valueTable.setValueAt(null, i, 0);
                }
                this.valueTable.getColumnModel().getColumn(0).setCellEditor(this.booleanEditor);
                break;
            }
            default: {
                this.valueTable.getColumnModel().getColumn(0).setCellEditor(null);
            }
        }
    }

    @Override
    public void okayButtonActionPerformed(ActionEvent evt) {
        this.checkKey();
        try {
            String dataType = this.typeComboBox.getSelectedItem().toString();
            this.table.putValue(this.keyField.getText(), this.createArrayData(dataType));
            this.dispose();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    private ArrayData createArrayData(String arrayType) {
        ArrayData ad;
        switch (arrayType) {
            case "Boolean": {
                ad = new BooleanArray();
                for (int i = 0; i < this.valueTable.getRowCount(); ++i) {
                    Object data = this.valueTable.getValueAt(i, 0);
                    if (data == null) continue;
                    ((BooleanArray)ad).add(data.toString().equalsIgnoreCase("true"));
                }
                break;
            }
            case "Number": {
                ad = new NumberArray();
                for (int i = 0; i < this.valueTable.getRowCount(); ++i) {
                    Object data = this.valueTable.getValueAt(i, 0);
                    try {
                        if (data == null) continue;
                        Double d = Double.parseDouble(data.toString());
                        ((NumberArray)ad).add(d);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(this, "Invalid double value \"" + data + "\" in row " + (i + 1), "Invalid number", 0);
                        return null;
                    }
                }
                break;
            }
            case "String": {
                ad = new StringArray();
                for (int i = 0; i < this.valueTable.getRowCount(); ++i) {
                    Object data = this.valueTable.getValueAt(i, 0);
                    if (data == null) continue;
                    ((StringArray)ad).add(data.toString());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(arrayType + " is not a valid array type");
            }
        }
        return ad;
    }
}

